/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.bsp;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import com.google.gson.Gson;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.BspServers$;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.ClosableOutputStream;
import scala.meta.internal.metals.JdkSources$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.SocketConnection;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.internal.process.SystemProcess;
import scala.meta.internal.process.SystemProcess$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.Try$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\u000b\u0016\u0005yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011U\u0003!\u0011!Q\u0001\nYC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tA\u0002\u0011\t\u0011)A\u0006C\")q\r\u0001C\u0001Q\")Q\u000f\u0001C\u0001m\")!\u0010\u0001C\u0001w\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003_\u0001A\u0011BA\u0019\u000f\u001d\t9%\u0006E\u0001\u0003\u00132a\u0001F\u000b\t\u0002\u0005-\u0003BB4\u0012\t\u0003\ti\u0005C\u0004\u0002PE!\t!!\u0015\u0003\u0015\t\u001b\boU3sm\u0016\u00148O\u0003\u0002\u0017/\u0005\u0019!m\u001d9\u000b\u0005aI\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005iY\u0012\u0001B7fi\u0006T\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!C5\t1$\u0003\u0002#7\t1\u0011I\\=SK\u001a\fQ\"\\1j]^{'o[:qC\u000e,\u0007CA\u0013)\u001b\u00051#BA\u0014\u001a\u0003\tIw.\u0003\u0002*M\ta\u0011IY:pYV$X\rU1uQ\u000691\r[1sg\u0016$\bC\u0001\u00173\u001b\u0005i#B\u0001\u0016/\u0015\ty\u0003'A\u0002oS>T\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024[\t91\t[1sg\u0016$\u0018AB2mS\u0016tG\u000f\u0005\u00027{5\tqG\u0003\u00029s\u0005AA.\u00198hk\u0006<WM\u0003\u0002;w\u000591\r\\5f]R\u001c(B\u0001\u001f\u0018\u0003\u0019iW\r^1mg&\u0011ah\u000e\u0002\u0015\u001b\u0016$\u0018\r\\:MC:<W/Y4f\u00072LWM\u001c;\u0002\u0017\t,\u0018\u000e\u001c3DY&,g\u000e\u001e\t\u0003\u0003\nk\u0011aO\u0005\u0003\u0007n\u0012\u0011#T3uC2\u001c()^5mI\u000ec\u0017.\u001a8u\u0003\u0019!\u0018M\u00197fgB\u0011\u0011IR\u0005\u0003\u000fn\u0012a\u0001V1cY\u0016\u001c\u0018a\u00072ta\u001ecwNY1m\u0013:\u001cH/\u00197m\t&\u0014Xm\u0019;pe&,7\u000fE\u0002K%\u0012r!a\u0013)\u000f\u00051{U\"A'\u000b\u00059k\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\t\t6$A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&\u0001\u0002'jgRT!!U\u000e\u0002\r\r|gNZ5h!\t\tu+\u0003\u0002Yw\t\u0011R*\u001a;bYN\u001cVM\u001d<fe\u000e{gNZ5h\u0003))8/\u001a:D_:4\u0017n\u001a\t\u0004Amk\u0016B\u0001/\u001c\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002B=&\u0011ql\u000f\u0002\u0012+N,'oQ8oM&<WO]1uS>t\u0017AA3d!\t\u0011W-D\u0001d\u0015\t!7$\u0001\u0006d_:\u001cWO\u001d:f]RL!AZ2\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\nS6tw\u000e]9sgR$\"A\u001b7\u0011\u0005-\u0004Q\"A\u000b\t\u000b\u0001T\u00019A1\t\u000b\rR\u0001\u0019\u0001\u0013\t\u000b)R\u0001\u0019A\u0016\t\u000bQR\u0001\u0019A\u001b\t\u000b}R\u0001\u0019\u0001!\t\u000b\u0011S\u0001\u0019A#\t\u000b!S\u0001\u0019A%\t\u000bUS\u0001\u0019\u0001,\t\u000beS\u0001\u0019\u0001.\u0002\u000fI,7o\u001c7wKR\tq\u000f\u0005\u0002lq&\u0011\u00110\u0006\u0002\u0012\u0005N\u0004(+Z:pYZ,GMU3tk2$\u0018!\u00038foN+'O^3s)\u0015a\u0018QAA\u0005!\r\u0011Wp`\u0005\u0003}\u000e\u0014aAR;ukJ,\u0007cA!\u0002\u0002%\u0019\u00111A\u001e\u0003+\t+\u0018\u000e\u001c3TKJ4XM]\"p]:,7\r^5p]\"1\u0011q\u0001\u0007A\u0002\u0011\n\u0001\u0003\u001d:pU\u0016\u001cG\u000fR5sK\u000e$xN]=\t\u000f\u0005-A\u00021\u0001\u0002\u000e\u00059A-\u001a;bS2\u001c\b\u0003BA\b\u0003?i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0006EN\u0004HG\u001b\u0006\u00049\u0005]!\u0002BA\r\u00037\tA!\u001a9gY*\u0011\u0011QD\u0001\u0003G\"LA!!\t\u0002\u0012\t!\"i\u001d9D_:tWm\u0019;j_:$U\r^1jYN\fACZ5oI\u00063\u0018-\u001b7bE2,7+\u001a:wKJ\u001cHCAA\u0014!\u0011Q%+!\u0004\u0002\u001b\u0019Lg\u000e\u001a&t_:4\u0015\u000e\\3t)\rI\u0015Q\u0006\u0005\u0007\u0003\u000fq\u0001\u0019\u0001\u0013\u0002'\u0011Lw-Z:u'\u0016\u0014h/\u001a:EKR\f\u0017\u000e\\:\u0015\t\u0005M\u00121\t\t\u0005\u0003k\tiD\u0004\u0003\u00028\u0005e\u0002C\u0001'\u001c\u0013\r\tYdG\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0012\u0011\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005m2\u0004C\u0004\u0002F=\u0001\r!a\n\u0002\u0015\r\fg\u000eZ5eCR,7/\u0001\u0006CgB\u001cVM\u001d<feN\u0004\"a[\t\u0014\u0005EyBCAA%\u0003a9Gn\u001c2bY&s7\u000f^1mY\u0012K'/Z2u_JLWm]\u000b\u0002\u0013\u0002")
public final class BspServers {
    private final AbsolutePath mainWorkspace;
    private final Charset charset;
    private final MetalsLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final MetalsServerConfig config;
    private final Function0<UserConfiguration> userConfig;
    private final ExecutionContextExecutorService ec;

    public static List<AbsolutePath> globalInstallDirectories() {
        return BspServers$.MODULE$.globalInstallDirectories();
    }

    public BspResolvedResult resolve() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return ResolvedNone$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new ResolvedBspOne(head);
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & Serializable)name -> list.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$resolve$2(name, x$1))).map((Function1 & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails details = (BspConnectionDetails)some.value();
            return new ResolvedBspOne(details);
        }
        if (None$.MODULE$.equals(option)) {
            return new ResolvedMultiple(md5, list);
        }
        throw new MatchError((Object)option);
    }

    public Future<BuildServerConnection> newServer(AbsolutePath projectDirectory, BspConnectionDetails details) {
        return BuildServerConnection$.MODULE$.fromSockets(projectDirectory, this.buildClient, this.client, (Function0<Future<SocketConnection>>)(Function0 & Serializable)() -> this.newConnection$1(details, projectDirectory), this.tables.dismissedNotifications().ReconnectBsp(), this.config, details.getName(), BuildServerConnection$.MODULE$.fromSockets$default$8(), BuildServerConnection$.MODULE$.fromSockets$default$9(), this.ec);
    }

    public List<BspConnectionDetails> findAvailableServers() {
        List<AbsolutePath> jsonFiles = this.findJsonFiles(this.mainWorkspace);
        Gson gson = new Gson();
        return jsonFiles.map((Function1 & Serializable)candidate -> {
            String text = FileIO$.MODULE$.slurp(candidate, $this.charset);
            return new Tuple2(candidate, (Object)text);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                AbsolutePath candidate = (AbsolutePath)tuple2._1();
                String text = (String)tuple2._2();
                return ((List)Try$.MODULE$.apply((Function0 & Serializable)() -> (BspConnectionDetails)gson.fromJson(text, BspConnectionDetails.class)).fold((Function1 & Serializable)e -> {
                    scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(13).append("parse error: ").append(candidate).toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("findAvailableServers"), new Line(159), MDC$.MODULE$.global());
                    return Nil$.MODULE$;
                }, (Function1 & Serializable)details -> new .colon.colon(details, (List)Nil$.MODULE$))).map((Function1 & Serializable)details -> details);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<AbsolutePath> findJsonFiles(AbsolutePath projectDirectory) {
        Builder buf = package$.MODULE$.List().newBuilder();
        BspServers.visit$1(projectDirectory.resolve(".bsp"), buf);
        this.bspGlobalInstallDirectories.foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$resolve$2(String name$1, BspConnectionDetails x$1) {
        String string = x$1.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Future newConnection$1(BspConnectionDetails details$1, AbsolutePath projectDirectory$1) {
        List args = MetalsEnrichments$.MODULE$.ListHasAsScala(details$1.getArgv()).asScala().toList().map((Function1 & Serializable)arg -> {
            if (Properties$.MODULE$.isWin() && arg.contains("-Dsbt.script=") && !arg.contains("file://")) {
                String string = URIEncoderDecoder$.MODULE$.decode(arg);
                String string2 = arg;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return arg.replace("-Dsbt.script=", "-Dsbt.script=file://");
                }
            }
            return arg;
        });
        scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(19).append("Running BSP server ").append(args).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("newConnection"), new Line(93), MDC$.MODULE$.global());
        List x$1 = args;
        AbsolutePath x$22 = projectDirectory$1;
        boolean x$3 = false;
        Map x$4 = JdkSources$.MODULE$.defaultJavaHome(((UserConfiguration)this.userConfig.apply()).javaHome()).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JAVA_HOME"), (Object)x$2.toString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        None$ x$5 = None$.MODULE$;
        Some x$6 = new Some((Function1 & Serializable)l -> {
            scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(12).append("BSP server: ").append(l).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("proc"), new Line(103), MDC$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
        boolean x$7 = false;
        String x$8 = new StringBuilder(4).append("bsp-").append(details$1.getName()).toString();
        boolean x$9 = SystemProcess$.MODULE$.run$default$7();
        SystemProcess proc = SystemProcess$.MODULE$.run((List<String>)x$1, x$22, false, (Map<String, String>)x$4, (Option<Function1<String, BoxedUnit>>)x$5, (Option<Function1<String, BoxedUnit>>)x$6, x$9, false, x$8, (ExecutionContext)this.ec);
        ClosableOutputStream output = new ClosableOutputStream(proc.outputStream(), new StringBuilder(14).append(details$1.getName()).append(" output stream").toString());
        QuietInputStream input = new QuietInputStream(proc.inputStream(), new StringBuilder(13).append(details$1.getName()).append(" input stream").toString());
        Promise finished = Promise$.MODULE$.apply();
        MetalsEnrichments$.MODULE$.XtensionScalaFuture(proc.complete()).ignoreValue((ExecutionContext)this.ec).onComplete((Function1 & Serializable)res -> BoxesRunTime.boxToBoolean((boolean)finished.tryComplete(res)), (ExecutionContext)this.ec);
        return Future$.MODULE$.successful((Object)new SocketConnection(details$1.getName(), output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> proc.cancel()), (List)Nil$.MODULE$), (Promise<BoxedUnit>)finished));
    }

    public static final /* synthetic */ void $anonfun$findJsonFiles$1(Builder buf$1, AbsolutePath p) {
        String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(p).extension();
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            buf$1.$plus$eq((Object)p);
            return;
        }
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().foreach((Function1 & Serializable)p -> {
            BspServers.$anonfun$findJsonFiles$1(buf$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public BspServers(AbsolutePath mainWorkspace, Charset charset, MetalsLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, MetalsServerConfig config, Function0<UserConfiguration> userConfig, ExecutionContextExecutorService ec) {
        this.mainWorkspace = mainWorkspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.config = config;
        this.userConfig = userConfig;
        this.ec = ec;
    }
}

