/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import dev.dirs.ProjectDirectories;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class Trace$ {
    public static final Trace$ MODULE$ = new Trace$();
    private static final Option<AbsolutePath> globalDirectory = Try$.MODULE$.apply((Function0 & Serializable)() -> {
        ProjectDirectories projectDirectories = ProjectDirectories.from((String)"org", (String)"scalameta", (String)"metals");
        Path cacheDir = Paths.get(projectDirectories.cacheDir, new String[0]);
        if (cacheDir.isAbsolute()) {
            return new Some((Object)AbsolutePath$.MODULE$.apply(cacheDir, AbsolutePath$.MODULE$.workingDirectory()));
        }
        return None$.MODULE$;
    }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final AbsolutePath localDirectory = PathIO$.MODULE$.workingDirectory().resolve(".metals/");
    private static final AbsolutePath metalsLog = ((AbsolutePath)MODULE$.globalDirectory().getOrElse((Function0 & Serializable)() -> MODULE$.localDirectory())).resolve("metals.log");

    public Option<AbsolutePath> globalDirectory() {
        return globalDirectory;
    }

    private AbsolutePath localDirectory() {
        return localDirectory;
    }

    public AbsolutePath metalsLog() {
        return metalsLog;
    }

    public AbsolutePath protocolTracePath(String protocolName, AbsolutePath workspace) {
        String traceFilename = new StringBuilder(11).append(protocolName.toLowerCase()).append(".trace.json").toString();
        return workspace.resolve(traceFilename);
    }

    public AbsolutePath protocolTracePath$default$2() {
        return this.localDirectory();
    }

    public Option<PrintWriter> setupTracePrinter(String protocolName, AbsolutePath workspace) {
        AbsolutePath metalsDir;
        AbsolutePath absolutePath = metalsDir = workspace.resolve(".metals");
        List tracePaths = this.globalDirectory().toList().$colon$colon((Object)absolutePath).map((Function1 & Serializable)dir -> MODULE$.protocolTracePath(protocolName, (AbsolutePath)dir));
        return this.setupPrintWriter$1(tracePaths, protocolName, tracePaths);
    }

    public AbsolutePath setupTracePrinter$default$2() {
        return PathIO$.MODULE$.workingDirectory();
    }

    private final Option setupPrintWriter$1(List paths, String protocolName$1, List tracePaths$1) {
        List list;
        while (true) {
            List tail;
            boolean bl = false;
            .colon.colon colon2 = null;
            list = paths;
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                AbsolutePath head = (AbsolutePath)colon2.head();
                if (head.isFile()) {
                    package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(20).append("tracing is enabled: ").append(head).toString())}), new Pkg("scala.meta.internal.metals"), new FileName("Trace.scala"), new Name("setupPrintWriter"), new Line(76), MDC$.MODULE$.global());
                    OutputStream fos = Files.newOutputStream(head.toNIO(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    return new Some((Object)new PrintWriter(fos));
                }
            }
            if (!bl) break;
            paths = tail = colon2.next$access$1();
        }
        if (Nil$.MODULE$.equals(list)) {
            package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(116).append("tracing is disabled for protocol ").append(protocolName$1).append(", to enable tracing of incoming ").append("and outgoing JSON messages create an empty file at ").append(tracePaths$1.mkString(" or ")).toString())}), new Pkg("scala.meta.internal.metals"), new FileName("Trace.scala"), new Name("setupPrintWriter"), new Line(86), MDC$.MODULE$.global());
            return None$.MODULE$;
        }
        throw new MatchError((Object)list);
    }

    private Trace$() {
    }
}

