/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import ch.epfl.scala.bsp4j.JvmEnvironmentItem;
import ch.epfl.scala.bsp4j.ScalaMainClass;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.debug.ExtendedScalaMainClass;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Properties$;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class ExtendedScalaMainClass$
implements Serializable {
    public static final ExtendedScalaMainClass$ MODULE$ = new ExtendedScalaMainClass$();

    private String createCommand(AbsolutePath javaHome, List<String> classpath, List<String> jvmOptions, List<String> arguments, String mainClass, AbsolutePath workspace) {
        String jvmOptsString = jvmOptions.nonEmpty() ? jvmOptions.mkString("\"", "\" \"", "\"") : "";
        String classpathString = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.tempManifestJar(classpath, workspace)).getOrElse((Function0 & Serializable)() -> classpath.mkString(File.pathSeparator));
        String argumentsString = arguments.mkString(" ");
        String escapedJavaHome = new StringBuilder(0).append(((Object)javaHome.toNIO().getRoot()).toString()).append(MetalsEnrichments$.MODULE$.IteratorHasAsScala(javaHome.toNIO().iterator()).asScala().map((Function1 & Serializable)p -> new StringBuilder(2).append("\"").append(p).append("\"").toString()).mkString(File.separator)).toString();
        String safeJavaHome = Properties$.MODULE$.isWin() ? escapedJavaHome.replace("\\\"", "\\\\\"") : escapedJavaHome;
        return new StringBuilder(17).append(safeJavaHome).append(" ").append(jvmOptsString).append(" -classpath \"").append(classpathString).append("\" ").append(mainClass).append(" ").append(argumentsString).toString();
    }

    private String tempManifestJar(List<String> classpath, AbsolutePath workspace) {
        Object object;
        String classpathDigest = MD5$.MODULE$.compute(classpath.mkString());
        AbsolutePath manifestJar = workspace.resolve(Directories$.MODULE$.tmp()).resolve(new StringBuilder(14).append("classpath_").append(classpathDigest).append(".jar").toString());
        if (!MetalsEnrichments$.MODULE$.XtensionAbsolutePath(manifestJar).exists()) {
            MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(manifestJar).touch();
            manifestJar.toNIO().toFile().deleteOnExit();
            String classpathStr = classpath.map((Function1 & Serializable)path2 -> URIEncoderDecoder$.MODULE$.encode(Paths.get(path2, new String[0]).toUri().toString())).mkString(" ");
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpathStr);
            OutputStream out = Files.newOutputStream(manifestJar.toNIO(), new OpenOption[0]);
            object = Using$.MODULE$.resource((Object)new JarOutputStream(out, manifest), (Function1 & Serializable)x -> (JarOutputStream)Predef$.MODULE$.identity(x), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        } else {
            object = BoxedUnit.UNIT;
        }
        return manifestJar.toString();
    }

    public ExtendedScalaMainClass apply(ScalaMainClass main, JvmEnvironmentItem env, AbsolutePath javaHome, AbsolutePath workspace) {
        List jvmOpts = ((IterableOnceOps)((SeqOps)MetalsEnrichments$.MODULE$.ListHasAsScala(main.getJvmOptions()).asScala().$plus$plus((IterableOnce)MetalsEnrichments$.MODULE$.ListHasAsScala(env.getJvmOptions()).asScala())).distinct()).toList();
        List jvmEnvVariables = ((IterableOnceOps)MetalsEnrichments$.MODULE$.MapHasAsScala(env.getEnvironmentVariables()).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return new StringBuilder(1).append(key).append("=").append(value).toString();
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List mainEnvVariables = (List)Option$.MODULE$.apply((Object)main.getEnvironmentVariables()).map((Function1 & Serializable)x$1 -> MetalsEnrichments$.MODULE$.ListHasAsScala(x$1).asScala().toList()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        return this.apply(main.getClassName(), main.getArguments(), MetalsEnrichments$.MODULE$.SeqHasAsJava(jvmOpts).asJava(), MetalsEnrichments$.MODULE$.SeqHasAsJava((Seq)jvmEnvVariables.$plus$plus((IterableOnce)mainEnvVariables)).asJava(), this.createCommand(javaHome, (List<String>)((IterableOnceOps)MetalsEnrichments$.MODULE$.ListHasAsScala(env.getClasspath()).asScala().map((Function1 & Serializable)x$2 -> MetalsEnrichments$.MODULE$.XtensionString((String)x$2).toAbsolutePath().toString())).toList(), (List<String>)jvmOpts, (List<String>)MetalsEnrichments$.MODULE$.ListHasAsScala(main.getArguments()).asScala().toList(), main.getClassName(), workspace));
    }

    public ExtendedScalaMainClass apply(String string, java.util.List<String> arguments, java.util.List<String> jvmOptions, java.util.List<String> environmentVariables, String shellCommand) {
        return new ExtendedScalaMainClass(string, arguments, jvmOptions, environmentVariables, shellCommand);
    }

    public Option<Tuple5<String, java.util.List<String>, java.util.List<String>, java.util.List<String>, String>> unapply(ExtendedScalaMainClass x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.class(), x$0.arguments(), x$0.jvmOptions(), x$0.environmentVariables(), (Object)x$0.shellCommand()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExtendedScalaMainClass$.class);
    }

    private ExtendedScalaMainClass$() {
    }
}

