/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.common.hash.BloomFilter;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.openjdk.jol.info.GraphLayout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.CompressedPackageIndex;
import scala.meta.internal.mtags.OnDemandSymbolIndex;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class Memory$ {
    public static final Memory$ MODULE$ = new Memory$();
    private static final List<String> si = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"B", "K", "M", "G", "T", "P", "E", "Z", "Y"}));
    private static final String jolMagicFieldError = "try with -Djol.magicFieldOffset=true";

    private List<String> si() {
        return si;
    }

    public String approx(long bytes) {
        return this.loop$1(bytes, this.si());
    }

    private String format(long n) {
        return new DecimalFormat("#,###").format(n);
    }

    public Option<String> footprint(String source, Object value) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String string;
            GraphLayout layout = GraphLayout.parseInstance((Object[])new Object[]{value});
            long size = layout.totalSize();
            Object object = value;
            if (object instanceof OnDemandSymbolIndex) {
                OnDemandSymbolIndex onDemandSymbolIndex = (OnDemandSymbolIndex)object;
                long n = onDemandSymbolIndex.mtags().totalLinesOfScala();
                string = new StringBuilder(15).append(" (").append(MODULE$.format(n)).append(" lines Scala)").toString();
            } else if (object instanceof TrieMap) {
                TrieMap trieMap = (TrieMap)object;
                long elements = BoxesRunTime.unboxToLong((Object)trieMap.values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)Memory$.$anonfun$footprint$2(BoxesRunTime.unboxToLong((Object)x0$1), x1$1))));
                string = new StringBuilder(12).append(" (").append(MODULE$.format(elements)).append(" elements)").toString();
            } else {
                string = "";
            }
            String suffix = string;
            return new StringBuilder(7).append(source).append(" using ").append(MODULE$.approx(size)).append(suffix).toString();
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            Object object = throwable.getMessage().contains(this.jolMagicFieldError()) ? scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> MODULE$.errorMsg(source))}), new Pkg("scala.meta.internal.metals"), new FileName("Memory.scala"), new Name("footprint"), new Line(54), MDC$.MODULE$.instance()) : scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> throwable)}), new Pkg("scala.meta.internal.metals"), new FileName("Memory.scala"), new Name("footprint"), new Line(56), MDC$.MODULE$.instance());
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value2 = (String)success.value();
            return new Some((Object)value2);
        }
        throw new MatchError((Object)try_);
    }

    public void logMemory(List<Tuple2<String, Object>> objects) {
        Option option;
        while ((option = objects.headOption().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String source = (String)tuple2._1();
                Object value = tuple2._2();
                return MODULE$.footprint(source, value);
            }
            throw new MatchError((Object)tuple2);
        })) instanceof Some) {
            Some some = (Some)option;
            String footprint = (String)some.value();
            scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(8).append("memory: ").append(footprint).toString())}), new Pkg("scala.meta.internal.metals"), new FileName("Memory.scala"), new Name("logMemory"), new Line(75), MDC$.MODULE$.instance());
            objects = (List)objects.tail();
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
    }

    private String errorMsg(String source) {
        return new StringBuilder(221).append("org.openjdk.jol cannot compute memory footprint for ").append(source).append(". Try to run Metals server with -Djol.magicFieldOffset=true property See https://github.com/openjdk/jol/commit/5dafe85a1fca52342cb965e673513b76768ab945 for more details.").toString();
    }

    private final String jolMagicFieldError() {
        return jolMagicFieldError;
    }

    private final String loop$1(double value, List units) {
        while (!(value < 1024.0)) {
            units = (List)units.tail();
            value /= 1024.0;
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.3g%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value), units.head()}));
    }

    public static final /* synthetic */ long $anonfun$footprint$2(long x0$1, Object x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), x1$1);
        if (tuple2 != null) {
            long n = tuple2._1$mcJ$sp();
            Object b = tuple2._2();
            if (b instanceof BloomFilter) {
                BloomFilter bloomFilter = (BloomFilter)b;
                return n + bloomFilter.approximateElementCount();
            }
        }
        if (tuple2 != null) {
            long n = tuple2._1$mcJ$sp();
            Object c = tuple2._2();
            if (c instanceof CompressedPackageIndex) {
                CompressedPackageIndex compressedPackageIndex = (CompressedPackageIndex)c;
                return n + compressedPackageIndex.bloom().approximateElementCount();
            }
        }
        if (tuple2 != null) {
            long n = tuple2._1$mcJ$sp();
            return n + 1L;
        }
        throw new MatchError((Object)tuple2);
    }

    private Memory$() {
    }
}

