/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.ClientCommands;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientCommands$GotoLocation$;
import scala.meta.internal.metals.CommandHTMLFormat;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StacktraceAnalyzer$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\"\u0002$\u0001\t\u00039\u0005\"\u0002(\u0001\t\u0003y\u0005\"\u00025\u0001\t\u0003I\u0007\"B8\u0001\t\u0003\u0001\b\"\u0002@\u0001\t\u0013y\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u0019y\u0007\u0001\"\u0001\u0002>!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-uaBAK;!\u0005\u0011q\u0013\u0004\u00079uA\t!!'\t\r\u0019;B\u0011AAN\u0011%\tij\u0006b\u0001\n\u000b\ty\n\u0003\u0005\u0002.^\u0001\u000bQBAQ\u0011\u001d\tyk\u0006C\u0001\u0003c\u0013!c\u0015;bG.$(/Y2f\u0003:\fG.\u001f>fe*\u0011adH\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005\u0001\n\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\t\u001a\u0013\u0001B7fi\u0006T\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001q\u0005\u0005\u0002)S5\t1%\u0003\u0002+G\t1\u0011I\\=SK\u001a\f\u0011b^8sWN\u0004\u0018mY3\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\n\u0013AA5p\u0013\t\tdF\u0001\u0007BEN|G.\u001e;f!\u0006$\b.A\u0004ck\u001a4WM]:\u0011\u0005Q*T\"A\u000f\n\u0005Yj\"a\u0002\"vM\u001a,'o]\u0001\u0013I\u00164\u0017N\\5uS>t\u0007K]8wS\u0012,'\u000f\u0005\u00025s%\u0011!(\b\u0002\u0013\t\u00164\u0017N\\5uS>t\u0007K]8wS\u0012,'/A\u0003jG>t7\u000f\u0005\u00025{%\u0011a(\b\u0002\u0006\u0013\u000e|gn]\u0001\u0014G>lW.\u00198e\u0013:DE/\u001c7G_Jl\u0017\r\u001e\t\u0004Q\u0005\u001b\u0015B\u0001\"$\u0005\u0019y\u0005\u000f^5p]B\u0011A\u0007R\u0005\u0003\u000bv\u0011\u0011cQ8n[\u0006tG\r\u0013+N\u0019\u001a{'/\\1u\u0003\u0019a\u0014N\\5u}Q1\u0001*\u0013&L\u00196\u0003\"\u0001\u000e\u0001\t\u000b-2\u0001\u0019\u0001\u0017\t\u000bI2\u0001\u0019A\u001a\t\u000b]2\u0001\u0019\u0001\u001d\t\u000bm2\u0001\u0019\u0001\u001f\t\u000b}2\u0001\u0019\u0001!\u0002\u001d\u0005t\u0017\r\\={K\u000e{W.\\1oIR\u0011\u0001k\u0017\t\u0004Q\u0005\u000b\u0006C\u0001*Z\u001b\u0005\u0019&B\u0001+V\u0003\u0015a7\u000f\u001d\u001bk\u0015\t1v+A\u0004fG2L\u0007o]3\u000b\u0003a\u000b1a\u001c:h\u0013\tQ6K\u0001\u000bFq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3QCJ\fWn\u001d\u0005\u00069\u001e\u0001\r!X\u0001\u000bgR\f7m\u001b;sC\u000e,\u0007C\u00010f\u001d\ty6\r\u0005\u0002aG5\t\u0011M\u0003\u0002cK\u00051AH]8pizJ!\u0001Z\u0012\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003I\u000e\n\u0001#[:Ti\u0006\u001c7\u000e\u0016:bG\u00164\u0015\u000e\\3\u0015\u0005)l\u0007C\u0001\u0015l\u0013\ta7EA\u0004C_>dW-\u00198\t\u000b9D\u0001\u0019\u0001\u0017\u0002\tA\fG\u000f[\u0001\u0011gR\f7m\u001b;sC\u000e,G*\u001a8tKN$\"!]?\u0011\u0007I<(P\u0004\u0002tk:\u0011\u0001\r^\u0005\u0002I%\u0011aoI\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0018PA\u0002TKFT!A^\u0012\u0011\u0005I[\u0018B\u0001?T\u0005!\u0019u\u000eZ3MK:\u001c\b\"\u00028\n\u0001\u0004a\u0013A\u0005:fC\u0012\u001cF/Y2liJ\f7-\u001a$jY\u0016$B!!\u0001\u0002\nA!\u0001&QA\u0002!\u0011\u0011\u0018QA/\n\u0007\u0005\u001d\u0011P\u0001\u0003MSN$\b\"\u00028\u000b\u0001\u0004a\u0013AD:fiR{G*\u001b8f'R\f'\u000f\u001e\u000b\u0007\u0003\u001f\t)\"a\b\u0011\u0007!\n\t\"C\u0002\u0002\u0014\r\u0012A!\u00168ji\"9\u0011qC\u0006A\u0002\u0005e\u0011A\u00037j]\u0016tU/\u001c2feB\u0019\u0001&a\u0007\n\u0007\u0005u1EA\u0002J]RDq!!\t\f\u0001\u0004\t\u0019#A\u0002q_N\u00042AUA\u0013\u0013\r\t9c\u0015\u0002\t!>\u001c\u0018\u000e^5p]\u0006qBO]=HKRd\u0015N\\3Ok6\u0014WM\u001d$s_6\u001cF/Y2liJ\f7-\u001a\u000b\u0005\u0003[\tI\u0004\u0005\u0004\u00020\u0005U\u0012\u0011D\u0007\u0003\u0003cQ1!a\r$\u0003\u0011)H/\u001b7\n\t\u0005]\u0012\u0011\u0007\u0002\u0004)JL\bBBA\u001e\u0019\u0001\u0007Q,\u0001\u0003mS:,GcA9\u0002@!9\u0011\u0011I\u0007A\u0002\u0005\r\u0011aB2p]R,g\u000e^\u0001\u0015M&dW\rT8dCRLwN\u001c$s_6d\u0015N\\3\u0015\t\u0005\u001d\u0013q\n\t\u0005Q\u0005\u000bI\u0005E\u0002S\u0003\u0017J1!!\u0014T\u0005!aunY1uS>t\u0007BBA\u001e\u001d\u0001\u0007Q,\u0001\rnC.,wi\u001c;p\u0019>\u001c\u0017\r^5p]\u000e{G-\u001a'f]N$RA_A+\u00033Bq!a\u0016\u0010\u0001\u0004\tI%\u0001\u0005m_\u000e\fG/[8o\u0011\u001d\tYf\u0004a\u0001\u0003;\nQA]1oO\u0016\u00042AUA0\u0013\r\t\tg\u0015\u0002\u0006%\u0006tw-Z\u0001\u0012C:\fG.\u001f>f'R\f7m\u001b+sC\u000e,Gc\u0001)\u0002h!)A\f\u0005a\u0001;\u0006)R.Y6f\u000f>$xnQ8n[\u0006tG\rU1sC6\u001cHcA)\u0002n!9\u0011qK\tA\u0002\u0005%\u0013\u0001\u0007;ssN+G\u000fT5oK\u001a\u0013x.\\*uC\u000e\\GO]1dKR1\u0011\u0011JA:\u0003kBq!a\u0016\u0013\u0001\u0004\tI\u0005\u0003\u0004\u0002<I\u0001\r!X\u0001\u000fgfl'm\u001c7Ge>lG*\u001b8f)\u0011\tY(! \u0011\u0007!\nU\f\u0003\u0004\u0002<M\u0001\r!X\u0001\u0016[\u0006\\W\r\u0013;nY\u000e{W.\\1oIB\u000b'/Y7t)\u0015\t\u00161QAC\u0011\u0015aF\u00031\u0001^\u0011\u0019\t9\t\u0006a\u0001\u0007\u00061am\u001c:nCR\fAcZ8u_2{7-\u0019;j_:,6/\u001b8h+JLGcB/\u0002\u000e\u0006E\u00151\u0013\u0005\u0007\u0003\u001f+\u0002\u0019A/\u0002\u0007U\u0014\u0018\u000eC\u0004\u0002<U\u0001\r!!\u0007\t\r\u0005\u001dU\u00031\u0001D\u0003I\u0019F/Y2liJ\f7-Z!oC2L(0\u001a:\u0011\u0005Q:2CA\f()\t\t9*\u0001\u000bdCR,eMZ3diN\u001cF/Y2liJ\f7-Z\u000b\u0003\u0003C\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000b\t$\u0001\u0005nCR\u001c\u0007.\u001b8h\u0013\u0011\tY+!*\u0003\u000bI+w-\u001a=\u0002+\r\fG/\u00124gK\u000e$8o\u0015;bG.$(/Y2fA\u0005\u0001Bo\u001c+pa2,g/\u001a7Ts6\u0014w\u000e\u001c\u000b\u0005\u0003\u0007\t\u0019\f\u0003\u0004\u00026n\u0001\r!X\u0001\tgfl'm\u001c7J]\u0002")
public class StacktraceAnalyzer {
    private final AbsolutePath workspace;
    private final Buffers buffers;
    private final DefinitionProvider definitionProvider;
    private final Icons icons;
    private final Option<CommandHTMLFormat> commandInHtmlFormat;

    public static List<String> toToplevelSymbol(String symbolIn) {
        return StacktraceAnalyzer$.MODULE$.toToplevelSymbol(symbolIn);
    }

    public static Regex catEffectsStacktrace() {
        return StacktraceAnalyzer$.MODULE$.catEffectsStacktrace();
    }

    public Option<ExecuteCommandParams> analyzeCommand(String stacktrace) {
        return this.analyzeStackTrace(stacktrace);
    }

    public boolean isStackTraceFile(AbsolutePath path2) {
        AbsolutePath absolutePath = path2;
        AbsolutePath absolutePath2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
        return !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null);
    }

    public Seq<CodeLens> stacktraceLenses(AbsolutePath path2) {
        return (Seq)this.readStacktraceFile(path2).map((Function1 & Serializable)content -> this.stacktraceLenses((List<String>)content)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    private Option<List<String>> readStacktraceFile(AbsolutePath path2) {
        return this.buffers.get(path2).map((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$1), '\n')).toList());
    }

    private void setToLineStart(int lineNumber, Position pos) {
        pos.setLine(lineNumber);
        pos.setCharacter(0);
    }

    private Try<Object> tryGetLineNumberFromStacktrace(String line) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(line.substring(line.indexOf(":") + 1, line.indexOf(")")))) - 1);
    }

    public Seq<CodeLens> stacktraceLenses(List<String> content) {
        return ((Seq)((IterableOps)content.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$3(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int row = tuple2._2$mcI$sp();
                return this.fileLocationFromLine(line).map((Function1 & Serializable)location -> {
                    Range range = new Range(new Position(row, 0), new Position(row, 0));
                    return new Tuple2(location, (Object)range);
                }).map((Function1 & Serializable)x$2 -> {
                    Tuple2 tuple2 = x$2;
                    if (tuple2 != null) {
                        Location location = (Location)tuple2._1();
                        Range range = (Range)tuple2._2();
                        return this.makeGotoLocationCodeLens(location, range);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    public Option<Location> fileLocationFromLine(String line) {
        return this.symbolFromLine(line).flatMap((Function1 & Serializable)symbol -> StacktraceAnalyzer$.MODULE$.toToplevelSymbol((String)symbol).collectFirst(Function$.MODULE$.unlift((Function1 & Serializable)s -> this.findLocationForSymbol$1((String)s))).map((Function1 & Serializable)location -> this.trySetLineFromStacktrace((Location)location, line)));
    }

    private CodeLens makeGotoLocationCodeLens(Location location, Range range) {
        Command command = ServerCommands$.MODULE$.GotoPosition().toLsp(location);
        command.setTitle(new StringBuilder(5).append(this.icons.findsuper()).append(" open").toString());
        return new CodeLens(range, command, null);
    }

    private Option<ExecuteCommandParams> analyzeStackTrace(String stacktrace) {
        Option<CommandHTMLFormat> option = this.commandInHtmlFormat;
        if (option instanceof Some) {
            Some some = (Some)option;
            CommandHTMLFormat format = (CommandHTMLFormat)some.value();
            return new Some((Object)this.makeHtmlCommandParams(stacktrace, format));
        }
        if (None$.MODULE$.equals(option)) {
            AbsolutePath path2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
            File pathFile = path2.toFile();
            String pathStr = pathFile.toString();
            pathFile.createNewFile();
            try (FileWriter fw = new FileWriter(pathStr);){
                fw.write(new StringBuilder(6).append("/*\n").append(stacktrace).append("\n*/").toString());
            }
            Position fileStartPos = new Position(0, 0);
            Range range = new Range(fileStartPos, fileStartPos);
            Location stackTraceLocation = new Location(path2.toURI().toString(), range);
            return new Some((Object)this.makeGotoCommandParams(stackTraceLocation));
        }
        throw new MatchError(option);
    }

    private ExecuteCommandParams makeGotoCommandParams(Location location) {
        return ClientCommands$GotoLocation$.MODULE$.toExecuteCommandParams(new ClientCommands.WindowLocation(location.getUri(), location.getRange(), true));
    }

    private Location trySetLineFromStacktrace(Location location, String line) {
        Try<Object> lineNumberOpt = this.tryGetLineNumberFromStacktrace(line);
        lineNumberOpt.foreach((Function1)(JFunction1.mcVI.sp & Serializable)lineNumber -> {
            this.setToLineStart(lineNumber, location.getRange().getStart());
            this.setToLineStart(lineNumber, location.getRange().getEnd());
        });
        return location;
    }

    private Option<String> symbolFromLine(String line) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Option option;
            String trimmed = line.substring(line.indexOf("at ") + 3, line.indexOf("("));
            String string = trimmed;
            if (string != null && !(option = StacktraceAnalyzer$.MODULE$.catEffectsStacktrace().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String symbol = (String)((LinearSeqOps)option.get()).apply(0);
                return symbol;
            }
            return trimmed;
        }).toOption();
    }

    private ExecuteCommandParams makeHtmlCommandParams(String stacktrace, CommandHTMLFormat format) {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h3";
        String x$2 = qual$1.element$default$2();
        Function1 & Serializable x$3 = (Function1 & Serializable)x$4 -> {
            x$4.text("Stacktrace");
            return BoxedUnit.UNIT;
        };
        String output = qual$1.element("h3", x$2, (Function1)x$3).call((Function1 & Serializable)builder -> {
            this.htmlStack$1(builder, stacktrace, format);
            return BoxedUnit.UNIT;
        }).render();
        return ClientCommands$.MODULE$.ShowStacktrace().toExecuteCommandParams(output);
    }

    private String gotoLocationUsingUri(String uri, int line, CommandHTMLFormat format) {
        Position pos = new Position(line, 0);
        return ClientCommands$GotoLocation$.MODULE$.toCommandLink(new ClientCommands.WindowLocation(uri, new Range(pos, pos), true), format);
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final Option findLocationForSymbol$1(String s) {
        return MetalsEnrichments$.MODULE$.ListHasAsScala(this.definitionProvider.fromSymbol(s, (Option<AbsolutePath>)None$.MODULE$)).asScala().headOption();
    }

    private final void htmlStack$1(HtmlBuilder builder, String stacktrace$1, CommandHTMLFormat format$1) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(stacktrace$1), '\n')), (Function1 & Serializable)line -> {
            Option<Location> option = this.fileLocationFromLine((String)line);
            if (option instanceof Some) {
                Some some = (Some)option;
                Location location = (Location)some.value();
                builder.text("at ").link(this.gotoLocationUsingUri(location.getUri(), location.getRange().getStart().getLine(), format$1), line.substring(line.indexOf("at ") + 3));
            } else if (None$.MODULE$.equals(option)) {
                builder.raw(line);
            } else {
                throw new MatchError(option);
            }
            return builder.raw("<br>");
        });
    }

    public StacktraceAnalyzer(AbsolutePath workspace, Buffers buffers, DefinitionProvider definitionProvider, Icons icons, Option<CommandHTMLFormat> commandInHtmlFormat) {
        this.workspace = workspace;
        this.buffers = buffers;
        this.definitionProvider = definitionProvider;
        this.icons = icons;
        this.commandInHtmlFormat = commandInHtmlFormat;
    }
}

