/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.bsp;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import com.google.gson.Gson;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.BspServers$;
import scala.meta.internal.bsp.ConnectionBspStatus;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.ClosableOutputStream;
import scala.meta.internal.metals.JdkSources$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.SocketConnection;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.internal.process.SystemProcess;
import scala.meta.internal.process.SystemProcess$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.Try$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\u000b\u0017\u0005}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tC\u0002\u0011\t\u0011)A\u0006E\")\u0001\u000e\u0001C\u0001S\")a\u000f\u0001C\u0005o\")1\u0010\u0001C\u0001y\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017:q!!\u0019\u0017\u0011\u0003\t\u0019G\u0002\u0004\u0016-!\u0005\u0011Q\r\u0005\u0007QJ!\t!a\u001a\t\u000f\u0005%$\u0003\"\u0001\u0002l\tQ!i\u001d9TKJ4XM]:\u000b\u0005]A\u0012a\u00012ta*\u0011\u0011DG\u0001\tS:$XM\u001d8bY*\u00111\u0004H\u0001\u0005[\u0016$\u0018MC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\u0012S\"\u0001\u000f\n\u0005\rb\"AB!osJ+g-A\u0007nC&twk\u001c:lgB\f7-\u001a\t\u0003M%j\u0011a\n\u0006\u0003Qi\t!![8\n\u0005):#\u0001D!cg>dW\u000f^3QCRD\u0017aB2iCJ\u001cX\r\u001e\t\u0003[Mj\u0011A\f\u0006\u0003W=R!\u0001M\u0019\u0002\u00079LwNC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qr#aB\"iCJ\u001cX\r^\u0001\u0007G2LWM\u001c;\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014\u0001\u00037b]\u001e,\u0018mZ3\u000b\u0005mb\u0014aB2mS\u0016tGo\u001d\u0006\u0003{a\ta!\\3uC2\u001c\u0018BA 9\u0005QiU\r^1mg2\u000bgnZ;bO\u0016\u001cE.[3oi\u0006Y!-^5mI\u000ec\u0017.\u001a8u!\t\u00115)D\u0001=\u0013\t!EHA\tNKR\fGn\u001d\"vS2$7\t\\5f]R\fa\u0001^1cY\u0016\u001c\bC\u0001\"H\u0013\tAEH\u0001\u0004UC\ndWm]\u0001\u001cEN\u0004x\t\\8cC2Len\u001d;bY2$\u0015N]3di>\u0014\u0018.Z:\u0011\u0007-\u001bVE\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011qJH\u0001\u0007yI|w\u000e\u001e \n\u0003uI!A\u0015\u000f\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002S9\u000511m\u001c8gS\u001e\u0004\"A\u0011-\n\u0005ec$AE'fi\u0006d7oU3sm\u0016\u00148i\u001c8gS\u001e\f!\"^:fe\u000e{gNZ5h!\r\tCLX\u0005\u0003;r\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\t{\u0016B\u00011=\u0005E)6/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u0003K\u000e\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002hI\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)%Qgn\u001c9reN$X\u000f\u0006\u0002l[B\u0011A\u000eA\u0007\u0002-!)\u0011M\u0003a\u0002E\")AE\u0003a\u0001K!)1F\u0003a\u0001Y!)QG\u0003a\u0001m!)\u0001I\u0003a\u0001\u0003\")QI\u0003a\u0001\r\")\u0011J\u0003a\u0001\u0015\")aK\u0003a\u0001/\")!L\u0003a\u00017\u0006\t2-^:u_6\u0004&o\u001c6fGR\u0014vn\u001c;\u0016\u0003a\u00042!I=&\u0013\tQHD\u0001\u0004PaRLwN\\\u0001\be\u0016\u001cx\u000e\u001c<f)\u0005i\bC\u00017\u007f\u0013\tyhCA\tCgB\u0014Vm]8mm\u0016$'+Z:vYR\f\u0011B\\3x'\u0016\u0014h/\u001a:\u0015\u0015\u0005\u0015\u0011\u0011CA\u000b\u00033\t\u0019\u0004E\u0003d\u0003\u000f\tY!C\u0002\u0002\n\u0011\u0014aAR;ukJ,\u0007c\u0001\"\u0002\u000e%\u0019\u0011q\u0002\u001f\u0003+\t+\u0018\u000e\u001c3TKJ4XM]\"p]:,7\r^5p]\"1\u00111C\u0007A\u0002\u0015\n\u0001\u0003\u001d:pU\u0016\u001cG\u000fR5sK\u000e$xN]=\t\r\u0005]Q\u00021\u0001&\u00031\u00117\u000f\u001d+sC\u000e,'k\\8u\u0011\u001d\tY\"\u0004a\u0001\u0003;\tq\u0001Z3uC&d7\u000f\u0005\u0003\u0002 \u0005=RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000b\t\u001c\b\u000f\u000e6\u000b\u0007u\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001B3qM2T!!!\f\u0002\u0005\rD\u0017\u0002BA\u0019\u0003C\u0011ACQ:q\u0007>tg.Z2uS>tG)\u001a;bS2\u001c\bbBA\u001b\u001b\u0001\u0007\u0011qG\u0001\rEN\u00048\u000b^1ukN|\u0005\u000f\u001e\t\u0005Ce\fI\u0004E\u0002m\u0003wI1!!\u0010\u0017\u0005M\u0019uN\u001c8fGRLwN\u001c\"taN#\u0018\r^;t\u0003Q1\u0017N\u001c3Bm\u0006LG.\u00192mKN+'O^3sgR\u0011\u00111\t\t\u0005\u0017N\u000bi\"A\u0007gS:$'j]8o\r&dWm\u001d\u000b\u0002\u0015\u0006\u0019B-[4fgR\u001cVM\u001d<fe\u0012+G/Y5mgR!\u0011QJA/!\u0011\ty%a\u0016\u000f\t\u0005E\u00131\u000b\t\u0003\u001brI1!!\u0016\u001d\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000b\u000f\t\u000f\u0005}\u0003\u00031\u0001\u0002D\u0005Q1-\u00198eS\u0012\fG/Z:\u0002\u0015\t\u001b\boU3sm\u0016\u00148\u000f\u0005\u0002m%M\u0011!\u0003\t\u000b\u0003\u0003G\n\u0001d\u001a7pE\u0006d\u0017J\\:uC2dG)\u001b:fGR|'/[3t+\u0005Q\u0005")
public final class BspServers {
    private final AbsolutePath mainWorkspace;
    private final Charset charset;
    private final MetalsLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final MetalsServerConfig config;
    private final Function0<UserConfiguration> userConfig;
    private final ExecutionContextExecutorService ec;

    public static List<AbsolutePath> globalInstallDirectories() {
        return BspServers$.MODULE$.globalInstallDirectories();
    }

    private Option<AbsolutePath> customProjectRoot() {
        return ((UserConfiguration)this.userConfig.apply()).getCustomProjectRoot(this.mainWorkspace);
    }

    public BspResolvedResult resolve() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return ResolvedNone$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new ResolvedBspOne(head);
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & Serializable)name -> list.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$resolve$2(name, x$1))).map((Function1 & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails details = (BspConnectionDetails)some.value();
            return new ResolvedBspOne(details);
        }
        if (None$.MODULE$.equals(option)) {
            return new ResolvedMultiple(md5, list);
        }
        throw new MatchError((Object)option);
    }

    public Future<BuildServerConnection> newServer(AbsolutePath projectDirectory, AbsolutePath bspTraceRoot, BspConnectionDetails details, Option<ConnectionBspStatus> bspStatusOpt) {
        return BuildServerConnection$.MODULE$.fromSockets(projectDirectory, bspTraceRoot, this.buildClient, this.client, (Function0<Future<SocketConnection>>)(Function0 & Serializable)() -> this.newConnection$1(details, projectDirectory), this.tables.dismissedNotifications().ReconnectBsp(), this.tables.dismissedNotifications().RequestTimeout(), this.config, details.getName(), bspStatusOpt, BuildServerConnection$.MODULE$.fromSockets$default$11(), BuildServerConnection$.MODULE$.fromSockets$default$12(), this.ec);
    }

    public List<BspConnectionDetails> findAvailableServers() {
        List<AbsolutePath> jsonFiles = this.findJsonFiles();
        Gson gson = new Gson();
        return jsonFiles.map((Function1 & Serializable)candidate -> {
            String text = FileIO$.MODULE$.slurp(candidate, $this.charset);
            return new Tuple2(candidate, (Object)text);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                AbsolutePath candidate = (AbsolutePath)tuple2._1();
                String text = (String)tuple2._2();
                return ((List)Try$.MODULE$.apply((Function0 & Serializable)() -> (BspConnectionDetails)gson.fromJson(text, BspConnectionDetails.class)).fold((Function1 & Serializable)e -> {
                    scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(13).append("parse error: ").append(candidate).toString()), LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("findAvailableServers"), new Line(166), MDC$.MODULE$.instance());
                    return Nil$.MODULE$;
                }, (Function1 & Serializable)details -> new .colon.colon(details, (List)Nil$.MODULE$))).map((Function1 & Serializable)details -> details);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<AbsolutePath> findJsonFiles() {
        Builder buf = package$.MODULE$.List().newBuilder();
        BspServers.visit$1(this.mainWorkspace.resolve(".bsp"), buf);
        this.customProjectRoot().map((Function1 & Serializable)x$4 -> x$4.resolve(".bsp")).foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        this.bspGlobalInstallDirectories.foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$resolve$2(String name$1, BspConnectionDetails x$1) {
        String string = x$1.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Future newConnection$1(BspConnectionDetails details$1, AbsolutePath projectDirectory$1) {
        List args = MetalsEnrichments$.MODULE$.ListHasAsScala(details$1.getArgv()).asScala().toList().map((Function1 & Serializable)arg -> {
            if (Properties$.MODULE$.isWin() && arg.contains("-Dsbt.script=") && !arg.contains("file://")) {
                String string = URIEncoderDecoder$.MODULE$.decode(arg);
                String string2 = arg;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return arg.replace("-Dsbt.script=", "-Dsbt.script=file://");
                }
            }
            return arg;
        });
        scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(19).append("Running BSP server ").append(args).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("newConnection"), new Line(97), MDC$.MODULE$.instance());
        List x$1 = args;
        AbsolutePath x$22 = projectDirectory$1;
        boolean x$3 = false;
        Map x$4 = JdkSources$.MODULE$.defaultJavaHome(((UserConfiguration)this.userConfig.apply()).javaHome()).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JAVA_HOME"), (Object)x$2.toString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        None$ x$5 = None$.MODULE$;
        Some x$6 = new Some((Function1 & Serializable)l -> {
            scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(12).append("BSP server: ").append(l).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("proc"), new Line(107), MDC$.MODULE$.instance());
            return BoxedUnit.UNIT;
        });
        boolean x$7 = false;
        String x$8 = new StringBuilder(4).append("bsp-").append(details$1.getName()).toString();
        boolean x$9 = SystemProcess$.MODULE$.run$default$7();
        SystemProcess proc = SystemProcess$.MODULE$.run((List<String>)x$1, x$22, false, (Map<String, String>)x$4, (Option<Function1<String, BoxedUnit>>)x$5, (Option<Function1<String, BoxedUnit>>)x$6, x$9, false, x$8, (ExecutionContext)this.ec);
        ClosableOutputStream output = new ClosableOutputStream(proc.outputStream(), new StringBuilder(14).append(details$1.getName()).append(" output stream").toString());
        QuietInputStream input = new QuietInputStream(proc.inputStream(), new StringBuilder(13).append(details$1.getName()).append(" input stream").toString());
        Promise finished = Promise$.MODULE$.apply();
        MetalsEnrichments$.MODULE$.XtensionScalaFuture(proc.complete()).ignoreValue((ExecutionContext)this.ec).onComplete((Function1 & Serializable)res -> BoxesRunTime.boxToBoolean((boolean)finished.tryComplete(res)), (ExecutionContext)this.ec);
        return Future$.MODULE$.successful((Object)new SocketConnection(details$1.getName(), output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> proc.cancel()), (List)Nil$.MODULE$), (Promise<BoxedUnit>)finished));
    }

    public static final /* synthetic */ void $anonfun$findJsonFiles$1(Builder buf$1, AbsolutePath p) {
        String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(p).extension();
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            buf$1.$plus$eq((Object)p);
            return;
        }
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().foreach((Function1 & Serializable)p -> {
            BspServers.$anonfun$findJsonFiles$1(buf$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public BspServers(AbsolutePath mainWorkspace, Charset charset, MetalsLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, MetalsServerConfig config, Function0<UserConfiguration> userConfig, ExecutionContextExecutorService ec) {
        this.mainWorkspace = mainWorkspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.config = config;
        this.userConfig = userConfig;
        this.ec = ec;
    }
}

