/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import coursierapi.Dependency;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.services.LanguageClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.builds.BazelBuildTool;
import scala.meta.internal.builds.ShellRunner;
import scala.meta.internal.builds.WorkspaceLoadedStatus;
import scala.meta.internal.builds.WorkspaceLoadedStatus$Cancelled$;
import scala.meta.internal.builds.WorkspaceLoadedStatus$Dismissed$;
import scala.meta.internal.builds.WorkspaceLoadedStatus$Installed$;
import scala.meta.internal.builds.WorkspaceLoadedStatus$Rejected$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.Messages$;
import scala.meta.internal.metals.Messages$ImportBuild$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.process.ExitCodes$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class BazelBuildTool$
implements Serializable {
    public static final BazelBuildTool$ MODULE$ = new BazelBuildTool$();
    private static final String name = "bazel";
    private static final String bspName = "bazelbsp";
    private static final String version = "3.1.0-20240207-7439f14-NIGHTLY";
    private static final String mainClass = "org.jetbrains.bsp.bazel.install.Install";
    private static final Dependency dependency = Dependency.of((String)"org.jetbrains.bsp", (String)"bazel-bsp", (String)MODULE$.version());

    public String name() {
        return name;
    }

    public String bspName() {
        return bspName;
    }

    public String version() {
        return version;
    }

    public String mainClass() {
        return mainClass;
    }

    public Dependency dependency() {
        return dependency;
    }

    private Option<AbsolutePath> hasProjectView(AbsolutePath dir) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BazelBuildTool$.$anonfun$hasProjectView$1(x$1)));
    }

    private Option<AbsolutePath> existingProjectView(AbsolutePath projectRoot) {
        return new .colon.colon((Object)projectRoot, (List)new .colon.colon((Object)projectRoot.resolve("ijwb"), (List)new .colon.colon((Object)projectRoot.resolve(".ijwb"), (List)Nil$.MODULE$))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory())).flatMap((Function1 & Serializable)dir -> MODULE$.hasProjectView((AbsolutePath)dir)).headOption();
    }

    public List<String> scala$meta$internal$builds$BazelBuildTool$$projectViewArgs(AbsolutePath projectRoot) {
        Option<AbsolutePath> option = this.existingProjectView(projectRoot);
        if (option instanceof Some) {
            Some some = (Some)option;
            AbsolutePath projectView = (AbsolutePath)some.value();
            return new .colon.colon((Object)"-p", (List)new .colon.colon((Object)projectView.toRelative(projectRoot).toString(), (List)Nil$.MODULE$));
        }
        if (None$.MODULE$.equals(option)) {
            return new .colon.colon((Object)"-t", (List)new .colon.colon((Object)"//...", (List)new .colon.colon((Object)"-enabled-rules", (List)new .colon.colon((Object)"io_bazel_rules_scala", (List)new .colon.colon((Object)"rules_java", (List)new .colon.colon((Object)"rules_jvm", (List)Nil$.MODULE$))))));
        }
        throw new MatchError(option);
    }

    public Future<WorkspaceLoadedStatus> writeBazelConfig(ShellRunner shellRunner, AbsolutePath projectDirectory, Option<String> javaHome, ExecutionContext ec) {
        return this.run$1(shellRunner, projectDirectory, javaHome).flatMap((Function1 & Serializable)code -> BazelBuildTool$.$anonfun$writeBazelConfig$1(this, shellRunner, projectDirectory, javaHome, BoxesRunTime.unboxToInt((Object)code)), ec).map((Function1 & Serializable)x0$1 -> BazelBuildTool$.$anonfun$writeBazelConfig$3(BoxesRunTime.unboxToInt((Object)x0$1)), ec);
    }

    public Future<WorkspaceLoadedStatus> maybeWriteBazelConfig(ShellRunner shellRunner, AbsolutePath projectDirectory, LanguageClient languageClient, Tables tables, Option<String> javaHome, boolean forceImport, ExecutionContext ec) {
        DismissedNotifications.Notification notification = tables.dismissedNotifications().ImportChanges();
        if (forceImport) {
            return this.writeBazelConfig(shellRunner, projectDirectory, javaHome, ec);
        }
        if (!notification.isDismissed()) {
            return MetalsEnrichments$.MODULE$.XtensionJavaFuture(languageClient.showMessageRequest(Messages$ImportBuild$.MODULE$.params("Bazel"))).asScala().flatMap((Function1 & Serializable)x0$1 -> {
                MessageActionItem messageActionItem;
                MessageActionItem messageActionItem2 = messageActionItem = x0$1;
                MessageActionItem messageActionItem3 = Messages$.MODULE$.dontShowAgain();
                if (!(messageActionItem2 != null ? !messageActionItem2.equals(messageActionItem3) : messageActionItem3 != null)) {
                    notification.dismissForever();
                    return Future$.MODULE$.successful((Object)WorkspaceLoadedStatus$Rejected$.MODULE$);
                }
                MessageActionItem messageActionItem4 = messageActionItem;
                MessageActionItem messageActionItem5 = Messages$ImportBuild$.MODULE$.yes();
                if (!(messageActionItem4 != null ? !messageActionItem4.equals(messageActionItem5) : messageActionItem5 != null)) {
                    return MODULE$.writeBazelConfig(shellRunner, projectDirectory, javaHome, ec);
                }
                notification.dismiss(2L, TimeUnit.MINUTES);
                return Future$.MODULE$.successful((Object)WorkspaceLoadedStatus$Rejected$.MODULE$);
            }, ec);
        }
        package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(34).append("skipping build import with status ").append(WorkspaceLoadedStatus$Dismissed$.MODULE$).toString())}), new Pkg("scala.meta.internal.builds"), new FileName("BazelBuildTool.scala"), new Name("maybeWriteBazelConfig"), new Line(170), MDC$.MODULE$.instance());
        return Future$.MODULE$.successful((Object)WorkspaceLoadedStatus$Dismissed$.MODULE$);
    }

    public boolean maybeWriteBazelConfig$default$6() {
        return false;
    }

    public boolean isBazelRelatedPath(AbsolutePath workspace, AbsolutePath path2) {
        return path2.toNIO().startsWith(workspace.toNIO()) && MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path2).isBazelRelatedPath() && !MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path2).isInBazelBspDirectory(workspace);
    }

    public BazelBuildTool apply(Function0<UserConfiguration> userConfig, AbsolutePath projectRoot) {
        return new BazelBuildTool(userConfig, projectRoot);
    }

    public Option<Tuple2<Function0<UserConfiguration>, AbsolutePath>> unapply(BazelBuildTool x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.userConfig(), (Object)x$0.projectRoot()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BazelBuildTool$.class);
    }

    public static final /* synthetic */ boolean $anonfun$hasProjectView$1(AbsolutePath x$1) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(x$1).filename().endsWith(".bazelproject");
    }

    private final Future run$1(ShellRunner shellRunner$1, AbsolutePath projectDirectory$1, Option javaHome$1) {
        return shellRunner$1.runJava(this.dependency(), this.mainClass(), projectDirectory$1, this.scala$meta$internal$builds$BazelBuildTool$$projectViewArgs(projectDirectory$1), (Option<String>)javaHome$1, false, shellRunner$1.runJava$default$7(), shellRunner$1.runJava$default$8(), shellRunner$1.runJava$default$9(), shellRunner$1.runJava$default$10());
    }

    public static final /* synthetic */ Future $anonfun$writeBazelConfig$1(BazelBuildTool$ $this, ShellRunner shellRunner$1, AbsolutePath projectDirectory$1, Option javaHome$1, int code) {
        package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(41).append("Generate Bazel-BSP process returned code ").append(code).toString())}), new Pkg("scala.meta.internal.builds"), new FileName("BazelBuildTool.scala"), new Name("writeBazelConfig"), new Line(128), MDC$.MODULE$.instance());
        if (code != 0) {
            return $this.run$1(shellRunner$1, projectDirectory$1, javaHome$1);
        }
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ WorkspaceLoadedStatus $anonfun$writeBazelConfig$3(int x0$1) {
        int n = x0$1;
        if (ExitCodes$.MODULE$.Success() == n) {
            return WorkspaceLoadedStatus$Installed$.MODULE$;
        }
        if (ExitCodes$.MODULE$.Cancel() == n) {
            return WorkspaceLoadedStatus$Cancelled$.MODULE$;
        }
        package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Failed to write Bazel-BSP config to .bsp")}), new Pkg("scala.meta.internal.builds"), new FileName("BazelBuildTool.scala"), new Name("writeBazelConfig"), new Line(136), MDC$.MODULE$.instance());
        return new WorkspaceLoadedStatus.Failed(n);
    }

    private BazelBuildTool$() {
    }
}

