/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.bsp;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.BspServers$;
import scala.meta.internal.bsp.ConnectionBspStatus;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.ClosableOutputStream;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.JdkSources$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.SocketConnection;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.internal.process.SystemProcess;
import scala.meta.internal.process.SystemProcess$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\f\u0018\u0005\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011]\u0003!\u0011!Q\u0001\naC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0006G\")\u0011\u000e\u0001C\u0001U\")q\u000f\u0001C\u0005q\")A\u0010\u0001C\u0001{\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b:q!a\u0019\u0018\u0011\u0003\t)G\u0002\u0004\u0017/!\u0005\u0011q\r\u0005\u0007SJ!\t!!\u001b\t\u000f\u0005-$\u0003\"\u0001\u0002n!9\u0011q\u000e\n\u0005\u0002\u0005E$A\u0003\"taN+'O^3sg*\u0011\u0001$G\u0001\u0004EN\u0004(B\u0001\u000e\u001c\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000f\u001e\u0003\u0011iW\r^1\u000b\u0003y\tQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001CA\u0011!eI\u0007\u0002;%\u0011A%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u001b5\f\u0017N\\,pe.\u001c\b/Y2f!\t9#&D\u0001)\u0015\tI3$\u0001\u0002j_&\u00111\u0006\u000b\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f[\u0001\bG\"\f'o]3u!\tqC'D\u00010\u0015\ta\u0003G\u0003\u00022e\u0005\u0019a.[8\u000b\u0003M\nAA[1wC&\u0011Qg\f\u0002\b\u0007\"\f'o]3u\u0003\u0019\u0019G.[3oiB\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\tY\u0006tw-^1hK*\u0011A(P\u0001\bG2LWM\u001c;t\u0015\tq\u0014$\u0001\u0004nKR\fGn]\u0005\u0003\u0001f\u0012A#T3uC2\u001cH*\u00198hk\u0006<Wm\u00117jK:$\u0018a\u00032vS2$7\t\\5f]R\u0004\"a\u0011#\u000e\u0003uJ!!R\u001f\u0003#5+G/\u00197t\u0005VLG\u000eZ\"mS\u0016tG/\u0001\u0004uC\ndWm\u001d\t\u0003\u0007\"K!!S\u001f\u0003\rQ\u000b'\r\\3t\u0003m\u00117\u000f]$m_\n\fG.\u00138ti\u0006dG\u000eR5sK\u000e$xN]5fgB\u0019A\n\u0016\u0014\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001) \u0003\u0019a$o\\8u}%\ta$\u0003\u0002T;\u00059\u0001/Y2lC\u001e,\u0017BA+W\u0005\u0011a\u0015n\u001d;\u000b\u0005Mk\u0012AB2p]\u001aLw\r\u0005\u0002D3&\u0011!,\u0010\u0002\u0013\u001b\u0016$\u0018\r\\:TKJ4XM]\"p]\u001aLw-\u0001\u0006vg\u0016\u00148i\u001c8gS\u001e\u00042AI/`\u0013\tqVDA\u0005Gk:\u001cG/[8oaA\u00111\tY\u0005\u0003Cv\u0012\u0011#V:fe\u000e{gNZ5hkJ\fG/[8o\u0003\t)7\r\u0005\u0002eO6\tQM\u0003\u0002g;\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005!,'aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\u00061A(\u001b8jiz\"\u0012b[8qcJ\u001cH/\u001e<\u0015\u00051t\u0007CA7\u0001\u001b\u00059\u0002\"\u00022\u000b\u0001\b\u0019\u0007\"B\u0013\u000b\u0001\u00041\u0003\"\u0002\u0017\u000b\u0001\u0004i\u0003\"\u0002\u001c\u000b\u0001\u00049\u0004\"B!\u000b\u0001\u0004\u0011\u0005\"\u0002$\u000b\u0001\u00049\u0005\"\u0002&\u000b\u0001\u0004Y\u0005\"B,\u000b\u0001\u0004A\u0006\"B.\u000b\u0001\u0004a\u0016!E2vgR|W\u000e\u0015:pU\u0016\u001cGOU8piV\t\u0011\u0010E\u0002#u\u001aJ!a_\u000f\u0003\r=\u0003H/[8o\u0003\u001d\u0011Xm]8mm\u0016$\u0012A \t\u0003[~L1!!\u0001\u0018\u0005E\u00115\u000f\u001d*fg>dg/\u001a3SKN,H\u000e^\u0001\n]\u0016<8+\u001a:wKJ$\"\"a\u0002\u0002\u0014\u0005]\u00111DA\u001b!\u0015!\u0017\u0011BA\u0007\u0013\r\tY!\u001a\u0002\u0007\rV$XO]3\u0011\u0007\r\u000by!C\u0002\u0002\u0012u\u0012QCQ;jY\u0012\u001cVM\u001d<fe\u000e{gN\\3di&|g\u000e\u0003\u0004\u0002\u00165\u0001\rAJ\u0001\u0011aJ|'.Z2u\t&\u0014Xm\u0019;pefDa!!\u0007\u000e\u0001\u00041\u0013\u0001\u00042taR\u0013\u0018mY3S_>$\bbBA\u000f\u001b\u0001\u0007\u0011qD\u0001\bI\u0016$\u0018-\u001b7t!\u0011\t\t#!\r\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\tQAY:qi)T1AHA\u0015\u0015\u0011\tY#!\f\u0002\t\u0015\u0004h\r\u001c\u0006\u0003\u0003_\t!a\u00195\n\t\u0005M\u00121\u0005\u0002\u0015\u0005N\u00048i\u001c8oK\u000e$\u0018n\u001c8EKR\f\u0017\u000e\\:\t\u000f\u0005]R\u00021\u0001\u0002:\u0005a!m\u001d9Ti\u0006$Xo](qiB!!E_A\u001e!\ri\u0017QH\u0005\u0004\u0003\u007f9\"aE\"p]:,7\r^5p]\n\u001b\bo\u0015;biV\u001c\u0018\u0001\u00064j]\u0012\fe/Y5mC\ndWmU3sm\u0016\u00148\u000f\u0006\u0002\u0002FA!A\nVA\u0010\u000351\u0017N\u001c3Kg>tg)\u001b7fgR\t1*A\neS\u001e,7\u000f^*feZ,'\u000fR3uC&d7\u000f\u0006\u0003\u0002P\u0005}\u0003\u0003BA)\u00033rA!a\u0015\u0002VA\u0011a*H\u0005\u0004\u0003/j\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twMC\u0002\u0002XuAq!!\u0019\u0011\u0001\u0004\t)%\u0001\u0006dC:$\u0017\u000eZ1uKN\f!BQ:q'\u0016\u0014h/\u001a:t!\ti'c\u0005\u0002\u0013CQ\u0011\u0011QM\u0001\u0019O2|'-\u00197J]N$\u0018\r\u001c7ESJ,7\r^8sS\u0016\u001cX#A&\u0002\u001fI,\u0017\rZ%o\u0005N\u00048i\u001c8gS\u001e$b!a\u001d\u0002v\u0005e\u0004\u0003\u0002\u0012{\u0003?Aa!a\u001e\u0016\u0001\u00041\u0013\u0001\u00029bi\"DQ\u0001L\u000bA\u00025\u0002")
public final class BspServers {
    private final AbsolutePath mainWorkspace;
    private final Charset charset;
    private final MetalsLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final MetalsServerConfig config;
    private final Function0<UserConfiguration> userConfig;
    private final ExecutionContextExecutorService ec;

    public static Option<BspConnectionDetails> readInBspConfig(AbsolutePath path2, Charset charset) {
        return BspServers$.MODULE$.readInBspConfig(path2, charset);
    }

    public static List<AbsolutePath> globalInstallDirectories() {
        return BspServers$.MODULE$.globalInstallDirectories();
    }

    private Option<AbsolutePath> customProjectRoot() {
        return ((UserConfiguration)this.userConfig.apply()).getCustomProjectRoot(this.mainWorkspace);
    }

    public BspResolvedResult resolve() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return ResolvedNone$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new ResolvedBspOne(head);
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & Serializable)name -> list.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$resolve$2(name, x$1))).map((Function1 & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails details = (BspConnectionDetails)some.value();
            return new ResolvedBspOne(details);
        }
        if (None$.MODULE$.equals(option)) {
            return new ResolvedMultiple(md5, list);
        }
        throw new MatchError((Object)option);
    }

    public Future<BuildServerConnection> newServer(AbsolutePath projectDirectory, AbsolutePath bspTraceRoot, BspConnectionDetails details, Option<ConnectionBspStatus> bspStatusOpt) {
        return BuildServerConnection$.MODULE$.fromSockets(projectDirectory, bspTraceRoot, this.buildClient, this.client, (Function0<Future<SocketConnection>>)(Function0 & Serializable)() -> this.newConnection$1(details, projectDirectory), this.tables.dismissedNotifications().ReconnectBsp(), this.tables.dismissedNotifications().RequestTimeout(), this.config, details.getName(), bspStatusOpt, BuildServerConnection$.MODULE$.fromSockets$default$11(), BuildServerConnection$.MODULE$.fromSockets$default$12(), this.ec);
    }

    public List<BspConnectionDetails> findAvailableServers() {
        return this.findJsonFiles().flatMap((Function1 & Serializable)x$2 -> BspServers$.MODULE$.readInBspConfig((AbsolutePath)x$2, $this.charset));
    }

    private List<AbsolutePath> findJsonFiles() {
        Builder buf = package$.MODULE$.List().newBuilder();
        BspServers.visit$1(this.mainWorkspace.resolve(Directories$.MODULE$.bsp()), buf);
        this.customProjectRoot().map((Function1 & Serializable)x$3 -> x$3.resolve(Directories$.MODULE$.bsp())).foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        this.bspGlobalInstallDirectories.foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$resolve$2(String name$1, BspConnectionDetails x$1) {
        String string = x$1.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Future newConnection$1(BspConnectionDetails details$1, AbsolutePath projectDirectory$1) {
        List args = MetalsEnrichments$.MODULE$.ListHasAsScala(details$1.getArgv()).asScala().toList().map((Function1 & Serializable)arg -> {
            if (Properties$.MODULE$.isWin() && arg.contains("-Dsbt.script=") && !arg.contains("file://")) {
                String string = URIEncoderDecoder$.MODULE$.decode(arg);
                String string2 = arg;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return arg.replace("-Dsbt.script=", "-Dsbt.script=file://");
                }
            }
            return arg;
        });
        scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(19).append("Running BSP server ").append(args).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("newConnection"), new Line(99), MDC$.MODULE$.instance());
        List x$1 = args;
        AbsolutePath x$2 = projectDirectory$1;
        boolean x$3 = false;
        Map x$4 = JdkSources$.MODULE$.envVariables(((UserConfiguration)this.userConfig.apply()).javaHome());
        None$ x$5 = None$.MODULE$;
        Some x$6 = new Some((Function1 & Serializable)l -> {
            scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> new StringBuilder(12).append("BSP server: ").append(l).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("proc"), new Line(106), MDC$.MODULE$.instance());
            return BoxedUnit.UNIT;
        });
        boolean x$7 = false;
        String x$8 = new StringBuilder(4).append("bsp-").append(details$1.getName()).toString();
        boolean x$9 = SystemProcess$.MODULE$.run$default$7();
        SystemProcess proc = SystemProcess$.MODULE$.run((List<String>)x$1, x$2, false, (Map<String, String>)x$4, (Option<Function1<String, BoxedUnit>>)x$5, (Option<Function1<String, BoxedUnit>>)x$6, x$9, false, x$8, (ExecutionContext)this.ec);
        ClosableOutputStream output = new ClosableOutputStream(proc.outputStream(), new StringBuilder(14).append(details$1.getName()).append(" output stream").toString());
        QuietInputStream input = new QuietInputStream(proc.inputStream(), new StringBuilder(13).append(details$1.getName()).append(" input stream").toString());
        Promise finished = Promise$.MODULE$.apply();
        MetalsEnrichments$.MODULE$.XtensionScalaFuture(proc.complete()).ignoreValue((ExecutionContext)this.ec).onComplete((Function1 & Serializable)res -> BoxesRunTime.boxToBoolean((boolean)finished.tryComplete(res)), (ExecutionContext)this.ec);
        return Future$.MODULE$.successful((Object)new SocketConnection(details$1.getName(), output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> proc.cancel()), (List)Nil$.MODULE$), (Promise<BoxedUnit>)finished));
    }

    public static final /* synthetic */ void $anonfun$findJsonFiles$1(Builder buf$1, AbsolutePath p) {
        String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(p).extension();
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            buf$1.$plus$eq((Object)p);
            return;
        }
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().foreach((Function1 & Serializable)p -> {
            BspServers.$anonfun$findJsonFiles$1(buf$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public BspServers(AbsolutePath mainWorkspace, Charset charset, MetalsLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, MetalsServerConfig config, Function0<UserConfiguration> userConfig, ExecutionContextExecutorService ec) {
        this.mainWorkspace = mainWorkspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.config = config;
        this.userConfig = userConfig;
        this.ec = ec;
    }
}

