/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.OverriddenSymbol;
import scala.meta.internal.mtags.ResolvedOverriddenSymbol;
import scala.meta.internal.mtags.UnresolvedOverriddenSymbol;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0007\u000f\u0005]A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006#\u0002!\tA\u0015\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006I\u0002!\t!\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006m\u0002!Ia\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\u0011ABS1s)>\u0004H*\u001a<fYNT!a\u0004\t\u0002\r5,G/\u00197t\u0015\t\t\"#\u0001\u0005j]R,'O\\1m\u0015\t\u0019B#\u0001\u0003nKR\f'\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011\u0001F\u0005\u00037Q\u0011a!\u00118z%\u00164\u0017\u0001B2p]:\u00042!\u0007\u0010!\u0013\tyBCA\u0005Gk:\u001cG/[8oaA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0004gFd'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012!bQ8o]\u0016\u001cG/[8o\u0003\u0019a\u0014N\\5u}Q\u0011!\u0006\f\t\u0003W\u0001i\u0011A\u0004\u0005\u00069\t\u0001\r!H\u0001\rO\u0016$Hk\u001c9MKZ,Gn\u001d\u000b\u0003_=\u00032!\u0007\u00193\u0013\t\tDC\u0001\u0004PaRLwN\u001c\t\u0004gmrdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t9d#\u0001\u0004=e>|GOP\u0005\u0002+%\u0011!\bF\u0001\ba\u0006\u001c7.Y4f\u0013\taTH\u0001\u0003MSN$(B\u0001\u001e\u0015!\u0011Ir(Q%\n\u0005\u0001#\"A\u0002+va2,'\u0007\u0005\u0002C\r:\u00111\t\u0012\t\u0003kQI!!\u0012\u000b\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bR\u0001\"AS'\u000e\u0003-S!\u0001\u0014\n\u0002\u0005%|\u0017B\u0001(L\u00051\t%m]8mkR,\u0007+\u0019;i\u0011\u0015\u00016\u00011\u0001J\u0003\rQ\u0017M]\u0001\u0011O\u0016$H+\u001f9f\u0011&,'/\u0019:dQf$\"a\u00150\u0011\u0007e\u0001D\u000bE\u00024wU\u0003R!\u0007,J\u0003bK!a\u0016\u000b\u0003\rQ+\b\u000f\\34!\tIF,D\u0001[\u0015\tY\u0006#A\u0003ni\u0006<7/\u0003\u0002^5\n\u0001rJ^3se&$G-\u001a8Ts6\u0014w\u000e\u001c\u0005\u0006!\u0012\u0001\r!S\u0001\u0007i>\u0004\u0016\r\u001e5\u0015\u0007%\u000b'\rC\u0003Q\u000b\u0001\u0007\u0011\nC\u0003d\u000b\u0001\u0007\u0011)\u0001\u0003qCRD\u0017A\u00059vi*\u000b'/\u00138eKbLgnZ%oM>$BAZ5kYB\u0011\u0011dZ\u0005\u0003QR\u00111!\u00138u\u0011\u0015\u0019g\u00011\u0001J\u0011\u0015Yg\u00011\u00013\u0003%!x\u000e\u001d7fm\u0016d7\u000fC\u0003n\r\u0001\u0007A+\u0001\busB,w\f[5fe\u0006\u00148\r[=\u0002)\u0005$G\rV=qK\"KWM]1sG\"L\u0018J\u001c4p)\r1\u0007/\u001d\u0005\u0006G\u001e\u0001\r!\u0013\u0005\u0006[\u001e\u0001\r\u0001V\u0001\raV$Hk\u001c9mKZ,Gn\u001d\u000b\u0004MR,\b\"\u0002)\t\u0001\u00041\u0007\"B6\t\u0001\u0004\u0011\u0014\u0001\u00069viRK\b/\u001a%jKJ\f'o\u00195z\u0013:4w\u000eF\u0002gqfDQ\u0001U\u0005A\u0002\u0019DQ!\\\u0005A\u0002Q\u000ba\u0003Z3mKR,gj\u001c;Vg\u0016$Gk\u001c9MKZ,Gn\u001d\u000b\u0003MrDQ! \u0006A\u0002y\f\u0011\"^:fIB\u000bG\u000f[:\u0011\u0007ey\u0018*C\u0002\u0002\u0002Q\u0011Q!\u0011:sCf\f\u0001b\u00197fCJ\fE\u000e\u001c\u000b\u0003\u0003\u000f\u00012!GA\u0005\u0013\r\tY\u0001\u0006\u0002\u0005+:LG/\u0001\u0007hKRlE)\u000e#jO\u0016\u001cH\u000fF\u0002B\u0003#AQa\u0019\u0007A\u0002%\u0003")
public final class JarTopLevels {
    private final Function0<Connection> conn;

    public Option<List<Tuple2<String, AbsolutePath>>> getTopLevels(AbsolutePath jar) {
        Option option;
        try {
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n            |from indexed_jar ij\n            |left join toplevel_symbol ts\n            |on ij.id=ts.jar\n            |where ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                x$1.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null) {
                    String symbol = rs.getString(1);
                    AbsolutePath path2 = this.toPath(jar, rs.getString(2));
                    return toplevels.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)path2));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$2 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTopLevels"), new Line(55), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public Option<List<Tuple3<AbsolutePath, String, OverriddenSymbol>>> getTypeHierarchy(AbsolutePath jar) {
        Option option;
        try {
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select th.symbol, th.parent_name, th.path, th.is_resolved\n            |from indexed_jar ij\n            |left join type_hierarchy th\n            |on ij.id=th.jar\n            |where ij.type_hierarchy_indexed=true and ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$3 -> {
                x$3.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null && rs.getString(4) != null) {
                    String symbol = rs.getString(1);
                    String parentName = rs.getString(2);
                    AbsolutePath path2 = this.toPath(jar, rs.getString(3));
                    boolean isResolved = rs.getBoolean(4);
                    ResolvedOverriddenSymbol overridden = isResolved ? new ResolvedOverriddenSymbol(parentName) : new UnresolvedOverriddenSymbol(parentName);
                    return toplevels.$plus$eq((Object)new Tuple3((Object)path2, (Object)symbol, (Object)overridden));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$4 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTypeHierarchy"), new Line(90), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    private AbsolutePath toPath(AbsolutePath jar, String path2) {
        return MetalsEnrichments$.MODULE$.XtensionString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("jar:"), jar.toNIO().toUri().toString())), "!")), path2)).toAbsolutePath();
    }

    public int putJarIndexingInfo(AbsolutePath path2, List<Tuple2<String, AbsolutePath>> toplevels, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        int n;
        if (toplevels.isEmpty() && type_hierarchy.isEmpty()) {
            return 0;
        }
        try (Statement jarStmt = null;){
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5, type_hierarchy_indexed) values (?, ?)", 1);
            jarStmt.setString(1, this.getMD5Digest(path2));
            jarStmt.setBoolean(2, true);
            jarStmt.executeUpdate();
            ResultSet rs = jarStmt.getGeneratedKeys();
            rs.next();
            n = rs.getInt("id");
        }
        int jar = n;
        return this.putToplevels(jar, toplevels) + this.putTypeHierarchyInfo(jar, type_hierarchy);
    }

    public int addTypeHierarchyInfo(AbsolutePath path2, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        int n;
        try (Statement jarStmt = null;){
            String digest = this.getMD5Digest(path2);
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("update indexed_jar set type_hierarchy_indexed = true where (md5) = (?)");
            jarStmt.setString(1, digest);
            jarStmt.executeUpdate();
            n = BoxesRunTime.unboxToInt((Object)JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select id\n              |from indexed_jar\n              |where md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$5 -> {
                x$5.setString(1, digest);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.getInt(1))).head());
        }
        int jar = n;
        return this.putTypeHierarchyInfo(jar, type_hierarchy);
    }

    public int putToplevels(int jar, List<Tuple2<String, AbsolutePath>> toplevels) {
        if (toplevels.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
                toplevels.foreach((Function1 & Serializable)x0$1 -> {
                    JarTopLevels.$anonfun$putToplevels$1(symbolStmt, jar, x0$1);
                    return BoxedUnit.UNIT;
                });
                n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    private int putTypeHierarchyInfo(int jar, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        if (type_hierarchy.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into type_hierarchy (symbol, parent_name, path, jar, is_resolved) values (?, ?, ?, ?, ?)");
                type_hierarchy.foreach((Function1 & Serializable)x0$1 -> {
                    JarTopLevels.$anonfun$putTypeHierarchyInfo$1(symbolStmt, jar, x0$1);
                    return BoxedUnit.UNIT;
                });
                n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])usedPaths), (Function1 & Serializable)path2 -> this.getMD5Digest((AbsolutePath)path2), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> "'" + x$7 + "'", ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update("delete from indexed_jar where md5 not in (" + md5s + ")", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$8 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$8);
            return BoxedUnit.UNIT;
        });
    }

    public void clearAll() {
        PreparedStatement statement1 = ((Connection)this.conn.apply()).prepareStatement("truncate table toplevel_symbol");
        statement1.execute();
        PreparedStatement statement2 = ((Connection)this.conn.apply()).prepareStatement("truncate table type_hierarchy");
        statement2.execute();
        PreparedStatement statement3 = ((Connection)this.conn.apply()).prepareStatement("delete from indexed_jar");
        statement3.execute();
    }

    public String getMD5Digest(AbsolutePath path2) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path2.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(path2.toString() + ":" + attributes.lastModifiedTime().toMillis() + ":" + attributes.size());
    }

    public static final /* synthetic */ void $anonfun$putToplevels$1(ObjectRef symbolStmt$1, int jar$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String symbol = (String)tuple2._1();
            AbsolutePath source = (AbsolutePath)tuple2._2();
            ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
            ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
            ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$3);
            ((PreparedStatement)symbolStmt$1.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$putTypeHierarchyInfo$1(ObjectRef symbolStmt$2, int jar$4, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple3._1();
            String symbol = (String)tuple3._2();
            OverriddenSymbol overridden = (OverriddenSymbol)tuple3._3();
            ((PreparedStatement)symbolStmt$2.elem).setString(1, symbol);
            OverriddenSymbol overriddenSymbol = overridden;
            if (overriddenSymbol instanceof ResolvedOverriddenSymbol) {
                ResolvedOverriddenSymbol resolvedOverriddenSymbol = (ResolvedOverriddenSymbol)overriddenSymbol;
                String name = resolvedOverriddenSymbol.symbol();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setInt(3, 0);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, true);
            } else if (overriddenSymbol instanceof UnresolvedOverriddenSymbol) {
                UnresolvedOverriddenSymbol unresolvedOverriddenSymbol = (UnresolvedOverriddenSymbol)overriddenSymbol;
                String name = unresolvedOverriddenSymbol.name();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, false);
            } else {
                throw new MatchError((Object)overriddenSymbol);
            }
            ((PreparedStatement)symbolStmt$2.elem).setString(3, path2.toString());
            ((PreparedStatement)symbolStmt$2.elem).setInt(4, jar$4);
            ((PreparedStatement)symbolStmt$2.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$8) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
    }
}

