/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.builds.BuildTools;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.JavaTarget;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ScalaTarget;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.internal.metals.StatusBar;
import scala.meta.internal.metals.clients.language.MetalsStatusParams;
import scala.meta.internal.metals.clients.language.MetalsStatusParams$;
import scala.meta.internal.metals.logging.MetalsLogger$;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005a3AAC\u0006\u0003)!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!)\u0003A!A!\u0002\u00131\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0002\t/\u0006\u0014h.\u001b8hg*\u0011A\"D\u0001\u0007[\u0016$\u0018\r\\:\u000b\u00059y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005A\t\u0012\u0001B7fi\u0006T\u0011AE\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u0017/5\t\u0011#\u0003\u0002\u0019#\t1\u0011I\\=SK\u001a\f\u0011b^8sWN\u0004\u0018mY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uy\u0011AA5p\u0013\tyBD\u0001\u0007BEN|G.\u001e;f!\u0006$\b.\u0001\u0007ck&dG\rV1sO\u0016$8\u000f\u0005\u0002#G5\t1\"\u0003\u0002%\u0017\ta!)^5mIR\u000b'oZ3ug\u0006I1\u000f^1ukN\u0014\u0015M\u001d\t\u0003E\u001dJ!\u0001K\u0006\u0003\u0013M#\u0018\r^;t\u0005\u0006\u0014\u0018!B5d_:\u001c\bC\u0001\u0012,\u0013\ta3BA\u0003JG>t7/\u0001\u0006ck&dG\rV8pYN\u0004\"a\f\u001a\u000e\u0003AR!!M\u0007\u0002\r\t,\u0018\u000e\u001c3t\u0013\t\u0019\u0004G\u0001\u0006Ck&dG\rV8pYN\f1\"[:D_6\u0004\u0018\u000e\\5oOB!aC\u000e\u001dD\u0013\t9\u0014CA\u0005Gk:\u001cG/[8ocA\u0011\u0011(Q\u0007\u0002u)\u00111\bP\u0001\u0006EN\u0004HG\u001b\u0006\u0003%uR!AP \u0002\t\u0015\u0004h\r\u001c\u0006\u0002\u0001\u0006\u00111\r[\u0005\u0003\u0005j\u0012QCQ;jY\u0012$\u0016M]4fi&#WM\u001c;jM&,'\u000f\u0005\u0002\u0017\t&\u0011Q)\u0005\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q9\u0001*\u0013&L\u00196s\u0005C\u0001\u0012\u0001\u0011\u0015Ir\u00011\u0001\u001b\u0011\u0015\u0001s\u00011\u0001\"\u0011\u0015)s\u00011\u0001'\u0011\u0015Is\u00011\u0001+\u0011\u0015is\u00011\u0001/\u0011\u0015!t\u00011\u00016\u00031qwnU3nC:$\u0018n\u00193c)\t\tF\u000b\u0005\u0002\u0017%&\u00111+\u0005\u0002\u0005+:LG\u000fC\u0003V\u0011\u0001\u0007!$\u0001\u0003qCRD\u0017a\u00038p\u0005VLG\u000e\u001a+p_2$\u0012!\u0015")
public final class Warnings {
    private final AbsolutePath workspace;
    private final BuildTargets buildTargets;
    private final StatusBar statusBar;
    private final Icons icons;
    private final BuildTools buildTools;
    private final Function1<BuildTargetIdentifier, Object> isCompiling;

    public void noSemanticdb(AbsolutePath path2) {
        if (this.buildTools.isEmpty()) {
            this.noBuildTool();
            return;
        }
        Option<BuildTargetIdentifier> option = this.buildTargets.inverseSources(path2);
        if (None$.MODULE$.equals(option)) {
            MetalsLogger$.MODULE$.silentInTests().warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.doesntWorkBecause$1(path2) + " it doesn't belong to a build target.")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noSemanticdb"), new Line(110), MDC$.MODULE$.instance());
            this.statusBar.addMessage(this.icons.alert() + "No build target");
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            BuildTargetIdentifier buildTarget = (BuildTargetIdentifier)some.value();
            String targetName = (String)this.buildTargets.info(buildTarget).map((Function1 & Serializable)x$1 -> x$1.getDisplayName()).getOrElse((Function0 & Serializable)() -> "Unknown");
            if (BoxesRunTime.unboxToBoolean((Object)this.isCompiling.apply((Object)buildTarget))) {
                String tryAgain = "Wait until compilation is finished and try again";
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.doesntWorkBecause$1(path2) + " the build target " + targetName + " is being compiled. " + tryAgain + ".")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noSemanticdb"), new Line(122), MDC$.MODULE$.instance());
                this.statusBar.addMessage(this.icons.info() + tryAgain);
                return;
            }
            this.reportSemanticDB$1(buildTarget, targetName, path2);
            return;
        }
        throw new MatchError(option);
    }

    public void noBuildTool() {
        Object object;
        List<String> tools = this.buildTools.all();
        if (tools.isEmpty()) {
            object = package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "no build tool detected in workspace '" + $this.workspace + "'. The most common cause for this problem is that the editor was opened in the wrong working directory, for example if you use sbt then the workspace directory should contain build.sbt. ")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noBuildTool"), new Line(133), MDC$.MODULE$.instance());
        } else {
            String what = tools.length() == 1 ? "build tool " + tools.head() + " is" : "build tools " + tools.mkString(", ") + " are";
            object = package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "the " + what + " not supported by Metals, please open an issue if you would like to contribute to improve the situation.")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noBuildTool"), new Line(145), MDC$.MODULE$.instance());
        }
        String x$1 = this.icons.alert() + "No build tool";
        String x$2 = ClientCommands$.MODULE$.ToggleLogs().id();
        String x$3 = MetalsStatusParams$.MODULE$.apply$default$2();
        Boolean x$4 = MetalsStatusParams$.MODULE$.apply$default$3();
        Boolean x$5 = MetalsStatusParams$.MODULE$.apply$default$4();
        String x$6 = MetalsStatusParams$.MODULE$.apply$default$5();
        String x$7 = MetalsStatusParams$.MODULE$.apply$default$7();
        String x$8 = MetalsStatusParams$.MODULE$.apply$default$8();
        this.statusBar.addMessage(new MetalsStatusParams(x$1, x$3, x$4, x$5, x$6, x$2, x$7, x$8));
    }

    private static final String doesntWorkBecause$1(AbsolutePath path$1) {
        return "code navigation does not work for the file '" + path$1 + "' because";
    }

    private static final String pluginNotEnabled$1(String language, String targetName$1, AbsolutePath path$1) {
        return Warnings.doesntWorkBecause$1(path$1) + " the " + language + " SemanticDB compiler plugin is not enabled for the build target " + targetName$1 + ".";
    }

    private static final String missingCompilerOption$1(String language, String option, String targetName$1, AbsolutePath path$1) {
        return Warnings.doesntWorkBecause$1(path$1) + " the build target " + targetName$1 + " is missing the " + language + " compiler option " + option + ". To fix this problems, update the build settings to include this compiler option.";
    }

    private final void buildMisconfiguration$1() {
        String x$1 = this.icons.alert() + "Build misconfiguration";
        String x$2 = ClientCommands$.MODULE$.RunDoctor().id();
        String x$3 = MetalsStatusParams$.MODULE$.apply$default$2();
        Boolean x$4 = MetalsStatusParams$.MODULE$.apply$default$3();
        Boolean x$5 = MetalsStatusParams$.MODULE$.apply$default$4();
        String x$6 = MetalsStatusParams$.MODULE$.apply$default$5();
        String x$7 = MetalsStatusParams$.MODULE$.apply$default$7();
        String x$8 = MetalsStatusParams$.MODULE$.apply$default$8();
        this.statusBar.addMessage(new MetalsStatusParams(x$1, x$3, x$4, x$5, x$6, x$2, x$7, x$8));
    }

    private final void reportSemanticDB$1(BuildTargetIdentifier buildTarget, String targetName, AbsolutePath path$1) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isJavaFilename()) {
            Option<JavaTarget> option = this.buildTargets.javaTarget(buildTarget);
            if (None$.MODULE$.equals(option)) {
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.pluginNotEnabled$1("Java", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(54), MDC$.MODULE$.instance());
                this.buildMisconfiguration$1();
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                JavaTarget target = (JavaTarget)some.value();
                if (!target.isSemanticdbEnabled()) {
                    MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.pluginNotEnabled$1("Java", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(58), MDC$.MODULE$.instance());
                    this.buildMisconfiguration$1();
                    return;
                }
                if (!target.isSourcerootDeclared()) {
                    String option2 = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(this.workspace).javaSourcerootOption();
                    MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.missingCompilerOption$1("Java", option2, targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(62), MDC$.MODULE$.instance());
                    this.buildMisconfiguration$1();
                    return;
                }
                return;
            }
            throw new MatchError(option);
        }
        Option<ScalaTarget> option = this.buildTargets.scalaTarget(buildTarget);
        if (None$.MODULE$.equals(option)) {
            MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.pluginNotEnabled$1("Scala", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(69), MDC$.MODULE$.instance());
            this.buildMisconfiguration$1();
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            ScalaTarget target = (ScalaTarget)some.value();
            if (!target.isSemanticdbEnabled()) {
                if (ScalaVersions$.MODULE$.isSupportedAtReleaseMomentScalaVersion(target.scalaVersion())) {
                    MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.pluginNotEnabled$1("Scala", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(74), MDC$.MODULE$.instance());
                    this.buildMisconfiguration$1();
                    return;
                }
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.doesntWorkBecause$1(path$1) + " the Scala version " + target.scalaVersion() + " is not supported. To fix this problem, change the Scala version to " + ScalaVersions$.MODULE$.isLatestScalaVersion().mkString(" or ") + ".")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(77), MDC$.MODULE$.instance());
                this.statusBar.addMessage(this.icons.alert() + "Unsupported Scala " + target.scalaVersion());
                return;
            }
            if (!target.isSourcerootDeclared()) {
                String option3 = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(this.workspace).scalaSourcerootOption();
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.missingCompilerOption$1("Scala", option3, targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(87), MDC$.MODULE$.instance());
                this.buildMisconfiguration$1();
                return;
            }
            if (!MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isSbt() && !MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isWorksheet()) {
                AbsolutePath targetRoot = target.targetroot();
                AbsolutePath targetfile = targetRoot.resolve(SemanticdbClasspath$.MODULE$.fromScalaOrJava(path$1.toRelative(this.workspace)));
                BoxedUnit cfr_ignored_0 = (BoxedUnit)MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> Warnings.doesntWorkBecause$1(path$1) + " the SemanticDB file '" + targetfile + "' doesn't exist. There can be many reasons for this error. ")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(97), MDC$.MODULE$.instance());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public Warnings(AbsolutePath workspace, BuildTargets buildTargets, StatusBar statusBar, Icons icons, BuildTools buildTools, Function1<BuildTargetIdentifier, Object> isCompiling) {
        this.workspace = workspace;
        this.buildTargets = buildTargets;
        this.statusBar = statusBar;
        this.icons = icons;
        this.buildTools = buildTools;
        this.isCompiling = isCompiling;
    }
}

