/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import com.google.gson.JsonElement;
import java.io.Serializable;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugNotificationMessage;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugRequestMessage;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugResponseMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.debug.DapJsonParser$;
import scala.reflect.ClassTag;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Try;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class DebugProtocol$ {
    public static final DebugProtocol$ MODULE$ = new DebugProtocol$();
    private static final int FirstMessageId = 1;
    private static final String serverName = "dap-server";
    private static final String clientName = "dap-client";

    public int FirstMessageId() {
        return FirstMessageId;
    }

    public String serverName() {
        return serverName;
    }

    public String clientName() {
        return clientName;
    }

    public Source copy(Source original) {
        Source source = new Source();
        source.setAdapterData(original.getAdapterData());
        source.setChecksums(original.getChecksums());
        source.setName(original.getName());
        source.setOrigin(original.getOrigin());
        source.setPath(original.getPath());
        source.setPresentationHint(original.getPresentationHint());
        source.setSourceReference(original.getSourceReference());
        source.setSources(original.getSources());
        return source;
    }

    public RequestMessage syntheticRequest(SetBreakpointsArguments args) {
        DebugRequestMessage request = new DebugRequestMessage();
        request.setMethod("setBreakpoints");
        request.setParams((Object)DapJsonParser$.MODULE$.XtensionSerializableToJson(args).toJson());
        return request;
    }

    public ResponseMessage syntheticResponse(RequestMessage request, SetBreakpointsResponse args) {
        DebugResponseMessage response = new DebugResponseMessage();
        response.setId(request.getId());
        response.setMethod(request.getMethod());
        response.setResult((Object)DapJsonParser$.MODULE$.XtensionSerializableToJson(args).toJson());
        return response;
    }

    public DebugNotificationMessage stacktraceOutputResponse(OutputEventArguments output, Location location) {
        Source source = new Source();
        source.setName(MetalsEnrichments$.MODULE$.XtensionAbsolutePath(MetalsEnrichments$.MODULE$.XtensionString(location.getUri()).toAbsolutePath()).filename());
        source.setPath(location.getUri());
        output.setLine(Predef$.MODULE$.int2Integer(location.getRange().getStart().getLine() + 1));
        output.setSource(source);
        DebugNotificationMessage response = new DebugNotificationMessage();
        response.setMethod("output");
        response.setParams((Object)DapJsonParser$.MODULE$.XtensionSerializableToJson(output).toJson());
        return response;
    }

    public ResponseMessage syntheticFailure(DebugResponseMessage request, String cause) {
        ResponseError error = new ResponseError(ResponseErrorCode.InternalError, cause, null);
        DebugResponseMessage response = new DebugResponseMessage();
        response.setId(request.getId());
        response.setMethod(request.getMethod());
        response.setError(error);
        return response;
    }

    public <A> Option<A> parseResponse(ResponseMessage response, ClassTag<A> evidence$1) {
        return this.parse(response.getResult(), evidence$1).toOption();
    }

    public <A> Try<A> parse(Object params, ClassTag<A> evidence$2) {
        Object object = params;
        if (object instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)object;
            return DapJsonParser$.MODULE$.XtensionSerializedAsJson(jsonElement).as(evidence$2);
        }
        package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "DAP error: " + params + " is not a json")}), new Pkg("scala.meta.internal.metals.debug"), new FileName("DebugProtocol.scala"), new Name("parse"), new Line(227), MDC$.MODULE$.instance());
        return new Failure((Throwable)new IllegalStateException(params + " is not a json"));
    }

    private DebugProtocol$() {
    }
}

