/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.metals.JarTopLevels$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.OverriddenSymbol;
import scala.meta.internal.mtags.ResolvedOverriddenSymbol;
import scala.meta.internal.mtags.UnresolvedOverriddenSymbol;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\t\u0012\u0005iA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006W\u0001!\t\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\u0006)\u0002!\t!\u0016\u0005\u0006E\u0002!\ta\u0019\u0005\u0006[\u0002!\tA\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\u0006k\u0002!IA\u001e\u0005\u0006s\u0002!\tA\u001f\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b9q!!\u0005\u0012\u0011\u0003\t\u0019B\u0002\u0004\u0011#!\u0005\u0011Q\u0003\u0005\u0007W5!\t!a\u0006\t\u000f\u0005eQ\u0002\"\u0001\u0002\u001c\ta!*\u0019:U_BdUM^3mg*\u0011!cE\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005Q)\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Y9\u0012\u0001B7fi\u0006T\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\tq#\u0003\u0002\u001f/\t1\u0011I\\=SK\u001a\fAaY8o]B\u0019A$I\u0012\n\u0005\t:\"!\u0003$v]\u000e$\u0018n\u001c81!\t!\u0013&D\u0001&\u0015\t1s%A\u0002tc2T\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\tis\u0006\u0005\u0002/\u00015\t\u0011\u0003C\u0003 \u0005\u0001\u0007\u0001%\u0001\u0007hKR$v\u000e\u001d'fm\u0016d7\u000f\u0006\u00023%B\u0019AdM\u001b\n\u0005Q:\"AB(qi&|g\u000eE\u00027}\u0005s!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005iJ\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\tit#A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0002%\u0001\u0002'jgRT!!P\f\u0011\tq\u0011E\tT\u0005\u0003\u0007^\u0011a\u0001V;qY\u0016\u0014\u0004CA#J\u001d\t1u\t\u0005\u00029/%\u0011\u0001jF\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002I/A\u0011Q\nU\u0007\u0002\u001d*\u0011q*F\u0001\u0003S>L!!\u0015(\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\t\u000bM\u001b\u0001\u0019\u0001'\u0002\u0007)\f'/\u0001\thKR$\u0016\u0010]3IS\u0016\u0014\u0018M]2isR\u0011a+\u0019\t\u00049M:\u0006c\u0001\u001c?1B)A$\u0017'E7&\u0011!l\u0006\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005q{V\"A/\u000b\u0005y\u001b\u0012!B7uC\u001e\u001c\u0018B\u00011^\u0005Aye/\u001a:sS\u0012$WM\\*z[\n|G\u000eC\u0003T\t\u0001\u0007A*\u0001\nqkRT\u0015M]%oI\u0016D\u0018N\\4J]\u001a|G\u0003\u00023hS.\u0004\"\u0001H3\n\u0005\u0019<\"aA%oi\")\u0001.\u0002a\u0001\u0019\u0006!\u0001/\u0019;i\u0011\u0015QW\u00011\u00016\u0003%!x\u000e\u001d7fm\u0016d7\u000fC\u0003m\u000b\u0001\u0007q+\u0001\busB,w\f[5fe\u0006\u00148\r[=\u0002)\u0005$G\rV=qK\"KWM]1sG\"L\u0018J\u001c4p)\r!w\u000e\u001d\u0005\u0006Q\u001a\u0001\r\u0001\u0014\u0005\u0006Y\u001a\u0001\raV\u0001\raV$Hk\u001c9mKZ,Gn\u001d\u000b\u0004IN$\b\"B*\b\u0001\u0004!\u0007\"\u00026\b\u0001\u0004)\u0014\u0001\u00069viRK\b/\u001a%jKJ\f'o\u00195z\u0013:4w\u000eF\u0002eobDQa\u0015\u0005A\u0002\u0011DQ\u0001\u001c\u0005A\u0002]\u000ba\u0003Z3mKR,gj\u001c;Vg\u0016$Gk\u001c9MKZ,Gn\u001d\u000b\u0003InDQ\u0001`\u0005A\u0002u\f\u0011\"^:fIB\u000bG\u000f[:\u0011\u0007qqH*\u0003\u0002\u0000/\t)\u0011I\u001d:bs\u0006A1\r\\3be\u0006cG\u000e\u0006\u0002\u0002\u0006A\u0019A$a\u0002\n\u0007\u0005%qC\u0001\u0003V]&$\u0018\u0001D4fi6#U\u0007R5hKN$Hc\u0001#\u0002\u0010!)\u0001n\u0003a\u0001\u0019\u0006a!*\u0019:U_BdUM^3mgB\u0011a&D\n\u0003\u001bm!\"!a\u0005\u0002\u001b\u001d,GOR5mKNK8\u000f^3n)\u0011\ti\"!\f\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005!a-\u001b7f\u0015\r\t9cJ\u0001\u0004]&|\u0017\u0002BA\u0016\u0003C\u0011!BR5mKNK8\u000f^3n\u0011\u0015\u0019v\u00021\u0001M\u0001")
public final class JarTopLevels {
    private final Function0<Connection> conn;

    public static FileSystem getFileSystem(AbsolutePath jar) {
        return JarTopLevels$.MODULE$.getFileSystem(jar);
    }

    public Option<List<Tuple2<String, AbsolutePath>>> getTopLevels(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n            |from indexed_jar ij\n            |left join toplevel_symbol ts\n            |on ij.id=ts.jar\n            |where ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                x$1.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null) {
                    String symbol = rs.getString(1);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(2), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    return toplevels.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)path2));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$2 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTopLevels"), new Line(59), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public Option<List<Tuple3<AbsolutePath, String, OverriddenSymbol>>> getTypeHierarchy(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select th.symbol, th.parent_name, th.path, th.is_resolved\n            |from indexed_jar ij\n            |left join type_hierarchy th\n            |on ij.id=th.jar\n            |where ij.type_hierarchy_indexed=true and ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$3 -> {
                x$3.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null && rs.getString(4) != null) {
                    String symbol = rs.getString(1);
                    String parentName = rs.getString(2);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(3), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    boolean isResolved = rs.getBoolean(4);
                    ResolvedOverriddenSymbol overridden = isResolved ? new ResolvedOverriddenSymbol(parentName) : new UnresolvedOverriddenSymbol(parentName);
                    return toplevels.$plus$eq((Object)new Tuple3((Object)path2, (Object)symbol, (Object)overridden));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$4 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTypeHierarchy"), new Line(95), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public int putJarIndexingInfo(AbsolutePath path2, List<Tuple2<String, AbsolutePath>> toplevels, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        int n;
        if (toplevels.isEmpty() && type_hierarchy.isEmpty()) {
            return 0;
        }
        try (Statement jarStmt = null;){
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5, type_hierarchy_indexed) values (?, ?)", 1);
            jarStmt.setString(1, this.getMD5Digest(path2));
            jarStmt.setBoolean(2, true);
            jarStmt.executeUpdate();
            ResultSet rs = jarStmt.getGeneratedKeys();
            rs.next();
            n = rs.getInt("id");
        }
        int jar = n;
        return this.putToplevels(jar, toplevels) + this.putTypeHierarchyInfo(jar, type_hierarchy);
    }

    public int addTypeHierarchyInfo(AbsolutePath path2, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        int n;
        try (Statement jarStmt = null;){
            String digest = this.getMD5Digest(path2);
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("update indexed_jar set type_hierarchy_indexed = true where (md5) = (?)");
            jarStmt.setString(1, digest);
            jarStmt.executeUpdate();
            n = BoxesRunTime.unboxToInt((Object)JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select id\n              |from indexed_jar\n              |where md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$5 -> {
                x$5.setString(1, digest);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.getInt(1))).head());
        }
        int jar = n;
        return this.putTypeHierarchyInfo(jar, type_hierarchy);
    }

    public int putToplevels(int jar, List<Tuple2<String, AbsolutePath>> toplevels) {
        if (toplevels.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
                toplevels.foreach((Function1 & Serializable)x0$1 -> {
                    JarTopLevels.$anonfun$putToplevels$1(symbolStmt, jar, x0$1);
                    return BoxedUnit.UNIT;
                });
                n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    private int putTypeHierarchyInfo(int jar, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        if (type_hierarchy.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into type_hierarchy (symbol, parent_name, path, jar, is_resolved) values (?, ?, ?, ?, ?)");
                type_hierarchy.foreach((Function1 & Serializable)x0$1 -> {
                    JarTopLevels.$anonfun$putTypeHierarchyInfo$1(symbolStmt, jar, x0$1);
                    return BoxedUnit.UNIT;
                });
                n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])usedPaths), (Function1 & Serializable)path2 -> this.getMD5Digest((AbsolutePath)path2), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> "'" + x$7 + "'", ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update("delete from indexed_jar where md5 not in (" + md5s + ")", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$8 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$8);
            return BoxedUnit.UNIT;
        });
    }

    public void clearAll() {
        PreparedStatement statement1 = ((Connection)this.conn.apply()).prepareStatement("truncate table toplevel_symbol");
        statement1.execute();
        PreparedStatement statement2 = ((Connection)this.conn.apply()).prepareStatement("truncate table type_hierarchy");
        statement2.execute();
        PreparedStatement statement3 = ((Connection)this.conn.apply()).prepareStatement("delete from indexed_jar");
        statement3.execute();
    }

    public String getMD5Digest(AbsolutePath path2) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path2.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(path2.toString() + ":" + attributes.lastModifiedTime().toMillis() + ":" + attributes.size());
    }

    public static final /* synthetic */ void $anonfun$putToplevels$1(ObjectRef symbolStmt$1, int jar$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String symbol = (String)tuple2._1();
            AbsolutePath source = (AbsolutePath)tuple2._2();
            ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
            ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
            ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$3);
            ((PreparedStatement)symbolStmt$1.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$putTypeHierarchyInfo$1(ObjectRef symbolStmt$2, int jar$4, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple3._1();
            String symbol = (String)tuple3._2();
            OverriddenSymbol overridden = (OverriddenSymbol)tuple3._3();
            ((PreparedStatement)symbolStmt$2.elem).setString(1, symbol);
            OverriddenSymbol overriddenSymbol = overridden;
            if (overriddenSymbol instanceof ResolvedOverriddenSymbol) {
                ResolvedOverriddenSymbol resolvedOverriddenSymbol = (ResolvedOverriddenSymbol)overriddenSymbol;
                String name = resolvedOverriddenSymbol.symbol();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setInt(3, 0);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, true);
            } else if (overriddenSymbol instanceof UnresolvedOverriddenSymbol) {
                UnresolvedOverriddenSymbol unresolvedOverriddenSymbol = (UnresolvedOverriddenSymbol)overriddenSymbol;
                String name = unresolvedOverriddenSymbol.name();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, false);
            } else {
                throw new MatchError((Object)overriddenSymbol);
            }
            ((PreparedStatement)symbolStmt$2.elem).setString(3, path2.toString());
            ((PreparedStatement)symbolStmt$2.elem).setInt(4, jar$4);
            ((PreparedStatement)symbolStmt$2.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$8) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
    }
}

