/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import coursier.Fetch;
import coursier.Fetch$;
import coursier.Repositories$;
import coursier.cache.ArtifactError;
import coursier.core.Classifier;
import coursier.core.Classifier$;
import coursier.core.Dependency;
import coursier.core.Dependency$;
import coursier.core.Module;
import coursier.core.Module$;
import coursier.error.CoursierError;
import coursier.maven.SbtMavenRepository;
import coursier.maven.SbtMavenRepository$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.metals.MetalsEnrichments;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.semver.SemVer;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class JarSourcesProvider$ {
    public static final JarSourcesProvider$ MODULE$ = new JarSourcesProvider$();
    private static final Regex sbtRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("sbt-(.*)"));
    private static final SbtMavenRepository sbtMaven = SbtMavenRepository$.MODULE$.apply(Repositories$.MODULE$.central());
    private static final SbtMavenRepository metalsPluginSnapshots = SbtMavenRepository$.MODULE$.apply(Repositories$.MODULE$.sonatype("public"));

    private Regex sbtRegex() {
        return sbtRegex;
    }

    public Future<Seq<String>> fetchSources(Seq<String> jars, ExecutionContext ec) {
        Tuple2 tuple2 = jars.partition((Function1 & Serializable)jar -> BoxesRunTime.boxToBoolean((boolean)JarSourcesProvider$.$anonfun$fetchSources$1(jar)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq haveSources = (Seq)tuple2._1();
        Seq toDownload = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)haveSources, (Object)toDownload);
        Seq haveSources2 = (Seq)tuple22._1();
        Seq toDownload2 = (Seq)tuple22._2();
        Seq dependencies = (Seq)((SeqOps)toDownload2.flatMap((Function1 & Serializable)jarPath -> {
            String pomPath = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(jarPath), ".jar") + ".pom";
            MetalsEnrichments.XtensionString qual$2 = MetalsEnrichments$.MODULE$.XtensionString(pomPath);
            ReportContext x$2 = qual$2.toAbsolutePathSafe$default$1();
            Option dependency = qual$2.toAbsolutePathSafe(x$2).withFilter((Function1 & Serializable)pom -> BoxesRunTime.boxToBoolean((boolean)JarSourcesProvider$.$anonfun$fetchSources$4(pom))).flatMap((Function1 & Serializable)pom -> MODULE$.getDependency((AbsolutePath)pom).map((Function1 & Serializable)dependency -> dependency));
            return dependency.orElse((Function0 & Serializable)() -> {
                MetalsEnrichments.XtensionString qual$3 = MetalsEnrichments$.MODULE$.XtensionString((String)jarPath);
                ReportContext x$3 = qual$3.toAbsolutePathSafe$default$1();
                return qual$3.toAbsolutePathSafe(x$3).flatMap((Function1 & Serializable)jar -> MODULE$.sbtFallback((AbsolutePath)jar));
            });
        })).distinct();
        Future fetchedSources = Future$.MODULE$.sequence((IterableOnce)dependencies.map((Function1 & Serializable)dep -> MODULE$.fetchDependencySources((Dependency)dep, ec).recover((PartialFunction)new Serializable((Dependency)dep){
            private static final long serialVersionUID = 0L;
            private final Dependency dep$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CoursierError) {
                    Some some;
                    Tuple2 tuple2;
                    CoursierError coursierError = (CoursierError)A1;
                    Option option = Option$.MODULE$.apply((Object)coursierError.getCause()).map((Function1 & Serializable)e -> new Tuple2(e, (Object)e.getCause()));
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Throwable e2 = (Throwable)tuple2._2();
                        if (tuple2._1() instanceof ArtifactError.DownloadError && e2 instanceof UnknownHostException) {
                            UnknownHostException unknownHostException = (UnknownHostException)e2;
                            throw unknownHostException;
                        }
                    }
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Could not fetch dependency sources for " + $this.dep$1 + ", error: " + coursierError)}), new Pkg("scala.meta.internal.metals"), new FileName("JarSourcesProvider.scala"), new Name("applyOrElse"), new Line(71), MDC$.MODULE$.instance());
                    return (B1)Nil$.MODULE$;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof CoursierError;
            }
            {
                this.dep$1 = dep$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable ), $anonfun$applyOrElse$2(scala.meta.internal.metals.JarSourcesProvider$$anonfun$$nestedInanonfun$fetchSources$9$1 coursier.error.CoursierError )}, serializedLambda);
            }
        }, ec)), BuildFrom$.MODULE$.buildFromIterableOps(), ec).recover((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x2;
                if (A12 instanceof TimeoutException) {
                    package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Timeout when fetching dependency sources.")}), new Pkg("scala.meta.internal.metals"), new FileName("JarSourcesProvider.scala"), new Name("applyOrElse"), new Line(81), MDC$.MODULE$.instance());
                    return (B1)Nil$.MODULE$;
                }
                if (A12 instanceof UnknownHostException) {
                    UnknownHostException unknownHostException = (UnknownHostException)A12;
                    package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Repository `" + unknownHostException.getMessage() + "` is not available.")}), new Pkg("scala.meta.internal.metals"), new FileName("JarSourcesProvider.scala"), new Name("applyOrElse"), new Line(84), MDC$.MODULE$.instance());
                    return (B1)Nil$.MODULE$;
                }
                if (A12 != null && NonFatal$.MODULE$.apply(A1 = A12)) {
                    package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Could not fetch dependency sources, error: " + A1 + ".")}), new Pkg("scala.meta.internal.metals"), new FileName("JarSourcesProvider.scala"), new Name("applyOrElse"), new Line(87), MDC$.MODULE$.instance());
                    return (B1)Nil$.MODULE$;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable;
                Throwable throwable2 = x2;
                if (throwable2 instanceof TimeoutException) {
                    return true;
                }
                if (throwable2 instanceof UnknownHostException) {
                    return true;
                }
                return throwable2 != null && NonFatal$.MODULE$.apply(throwable = throwable2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(java.net.UnknownHostException ), $anonfun$applyOrElse$5(java.lang.Throwable )}, serializedLambda);
            }
        }, ec).map((Function1 & Serializable)x$3 -> (Seq)((IterableOps)x$3.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$4 -> x$4.toUri().toString()), ec);
        Seq existingSources = (Seq)haveSources2.map((Function1 & Serializable)jar -> JarSourcesProvider$.sourcesPath$1(jar));
        return fetchedSources.map((Function1 & Serializable)x$5 -> (Seq)x$5.$plus$plus((IterableOnce)existingSources), ec);
    }

    private Option<Dependency> sbtFallback(AbsolutePath jar) {
        Option option;
        String filename = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MetalsEnrichments$.MODULE$.XtensionAbsolutePath(jar).filename()), ".jar");
        String string = filename;
        if (string != null && !(option = this.sbtRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String versionStr = (String)((LinearSeqOps)option.get()).apply(0);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> SemVer.Version$.MODULE$.fromString(versionStr));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SemVer.Version version = (SemVer.Version)success.value();
                String string2 = version.toString();
                String string3 = versionStr;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    Module module = Module$.MODULE$.apply("org.scala-sbt", "sbt", Predef$.MODULE$.Map().empty());
                    return new Some((Object)Dependency$.MODULE$.apply(module, versionStr));
                }
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private Option<Dependency> getDependency(AbsolutePath pom) {
        Elem xml = (Elem)XML$.MODULE$.loadFile(pom.toFile());
        String groupId = xml.$bslash("groupId").text();
        String version = xml.$bslash("version").text();
        String artifactId = xml.$bslash("artifactId").text();
        NodeSeq properties = xml.$bslash("properties");
        return Option$.MODULE$.when(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(groupId)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(version)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(artifactId)), (Function0 & Serializable)() -> {
            Map scalaVersion = Option$.MODULE$.option2Iterable(JarSourcesProvider$.getProperty$1("scalaVersion", properties)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map sbtVersion = Option$.MODULE$.option2Iterable(JarSourcesProvider$.getProperty$1("sbtVersion", properties)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map attributes = (Map)scalaVersion.$plus$plus((IterableOnce)sbtVersion);
            return Dependency$.MODULE$.apply(Module$.MODULE$.apply(groupId, artifactId, attributes), version);
        });
    }

    private SbtMavenRepository sbtMaven() {
        return sbtMaven;
    }

    private SbtMavenRepository metalsPluginSnapshots() {
        return metalsPluginSnapshots;
    }

    public Future<List<Path>> fetchDependencySources(Dependency dependency, ExecutionContext ec) {
        .colon.colon repositories = new .colon.colon((Object)Repositories$.MODULE$.central(), (List)new .colon.colon((Object)this.sbtMaven(), (List)new .colon.colon((Object)this.metalsPluginSnapshots(), (List)Nil$.MODULE$)));
        return MetalsEnrichments$.MODULE$.XtensionScalaFuture(Fetch.FetchTaskOps$.MODULE$.future$extension(Fetch$.MODULE$.FetchTaskOps(Fetch$.MODULE$.apply().addRepositories((Seq)repositories).withDependencies((Seq)new .colon.colon((Object)dependency, (List)Nil$.MODULE$)).addClassifiers((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Classifier[]{new Classifier(Classifier$.MODULE$.sources())}))), ec).map((Function1 & Serializable)x$8 -> ((IterableOnceOps)x$8.map((Function1 & Serializable)x$9 -> x$9.toPath())).toList(), ec)).withTimeout(1, TimeUnit.MINUTES, ec);
    }

    private static final String sourcesPath$1(String jar) {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(jar), ".jar") + "-sources.jar";
    }

    public static final /* synthetic */ boolean $anonfun$fetchSources$2(AbsolutePath x$1) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(x$1).exists();
    }

    public static final /* synthetic */ boolean $anonfun$fetchSources$1(String jar) {
        MetalsEnrichments.XtensionString qual$1 = MetalsEnrichments$.MODULE$.XtensionString(JarSourcesProvider$.sourcesPath$1(jar));
        ReportContext x$12 = qual$1.toAbsolutePathSafe$default$1();
        return qual$1.toAbsolutePathSafe(x$12).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JarSourcesProvider$.$anonfun$fetchSources$2(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$fetchSources$4(AbsolutePath pom) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(pom).exists();
    }

    private static final Option getProperty$1(String name, NodeSeq properties$1) {
        return ((IterableOnceOps)properties$1.map((Function1 & Serializable)node -> node.$bslash(name).text())).find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6)))).map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), x$7));
    }

    private JarSourcesProvider$() {
    }
}

