/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.builds.BuildTools;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.JavaTarget;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ScalaTarget;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StatusBar;
import scala.meta.internal.metals.Warnings;
import scala.meta.internal.metals.clients.language.MetalsStatusParams;
import scala.meta.internal.metals.clients.language.MetalsStatusParams$;
import scala.meta.internal.metals.logging.MetalsLogger$;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005m3AAC\u0006\u0003)!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006\u0013\u0002!\tA\u0013\u0005\u0006%\u0002!\ta\u0015\u0005\u00063\u0002!\tA\u0017\u0002\u0010!J|'.Z2u/\u0006\u0014h.\u001b8hg*\u0011A\"D\u0001\u0007[\u0016$\u0018\r\\:\u000b\u00059y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005A\t\u0012\u0001B7fi\u0006T\u0011AE\u0001\u0006g\u000e\fG.Y\u0002\u0001'\r\u0001Q#\u0007\t\u0003-]i\u0011!E\u0005\u00031E\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001c\u001b\u0005Y\u0011B\u0001\u000f\f\u0005!9\u0016M\u001d8j]\u001e\u001c\u0018!C<pe.\u001c\b/Y2f!\ty\"%D\u0001!\u0015\t\ts\"\u0001\u0002j_&\u00111\u0005\t\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f[\u0001\rEVLG\u000e\u001a+be\u001e,Go\u001d\t\u00035\u0019J!aJ\u0006\u0003\u0019\t+\u0018\u000e\u001c3UCJ<W\r^:\u0002\u0013M$\u0018\r^;t\u0005\u0006\u0014\bC\u0001\u000e+\u0013\tY3BA\u0005Ti\u0006$Xo\u001d\"be\u0006)\u0011nY8ogB\u0011!DL\u0005\u0003_-\u0011Q!S2p]N\f!BY;jY\u0012$vn\u001c7t!\t\u0011T'D\u00014\u0015\t!T\"\u0001\u0004ck&dGm]\u0005\u0003mM\u0012!BQ;jY\u0012$vn\u001c7t\u0003-I7oQ8na&d\u0017N\\4\u0011\tYI4HR\u0005\u0003uE\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005q\"U\"A\u001f\u000b\u0005yz\u0014!\u00022taRR'B\u0001\nA\u0015\t\t%)\u0001\u0003fa\u001ad'\"A\"\u0002\u0005\rD\u0017BA#>\u0005U\u0011U/\u001b7e)\u0006\u0014x-\u001a;JI\u0016tG/\u001b4jKJ\u0004\"AF$\n\u0005!\u000b\"a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f-cUJT(Q#B\u0011!\u0004\u0001\u0005\u0006;\u001d\u0001\rA\b\u0005\u0006I\u001d\u0001\r!\n\u0005\u0006Q\u001d\u0001\r!\u000b\u0005\u0006Y\u001d\u0001\r!\f\u0005\u0006a\u001d\u0001\r!\r\u0005\u0006o\u001d\u0001\r\u0001O\u0001\r]>\u001cV-\\1oi&\u001cGM\u0019\u000b\u0003)^\u0003\"AF+\n\u0005Y\u000b\"\u0001B+oSRDQ\u0001\u0017\u0005A\u0002y\tA\u0001]1uQ\u0006Yan\u001c\"vS2$Gk\\8m)\u0005!\u0006")
public final class ProjectWarnings
implements Warnings {
    private final AbsolutePath workspace;
    private final BuildTargets buildTargets;
    private final StatusBar statusBar;
    private final Icons icons;
    private final BuildTools buildTools;
    private final Function1<BuildTargetIdentifier, Object> isCompiling;

    @Override
    public void noSemanticdb(AbsolutePath path2) {
        if (this.buildTools.isEmpty()) {
            this.noBuildTool();
            return;
        }
        Option<BuildTargetIdentifier> option = this.buildTargets.inverseSources(path2);
        if (None$.MODULE$.equals(option)) {
            MetalsLogger$.MODULE$.silentInTests().warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.doesntWorkBecause$1(path2) + " it doesn't belong to a build target.")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noSemanticdb"), new Line(110), MDC$.MODULE$.instance());
            this.statusBar.addMessage(this.icons.alert() + "No build target");
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            BuildTargetIdentifier buildTarget = (BuildTargetIdentifier)some.value();
            String targetName = (String)this.buildTargets.info(buildTarget).map((Function1 & Serializable)x$1 -> x$1.getDisplayName()).getOrElse((Function0 & Serializable)() -> "Unknown");
            if (BoxesRunTime.unboxToBoolean((Object)this.isCompiling.apply((Object)buildTarget))) {
                String tryAgain = "Wait until compilation is finished and try again";
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.doesntWorkBecause$1(path2) + " the build target " + targetName + " is being compiled. " + tryAgain + ".")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noSemanticdb"), new Line(122), MDC$.MODULE$.instance());
                this.statusBar.addMessage(this.icons.info() + tryAgain);
                return;
            }
            this.reportSemanticDB$1(buildTarget, targetName, path2);
            return;
        }
        throw new MatchError(option);
    }

    public void noBuildTool() {
        List<String> tools = this.buildTools.all();
        if (tools.isEmpty()) {
            v0 = package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "no build tool detected in workspace '" + $this.workspace + "'. The most common cause for this problem is that the editor was opened in the wrong working directory, for example if you use sbt then the workspace directory should contain build.sbt. ")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noBuildTool"), new Line(133), MDC$.MODULE$.instance());
        } else {
            String what = tools.length() == 1 ? "build tool " + tools.head() + " is" : "build tools " + tools.mkString(", ") + " are";
            v0 = package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "the " + what + " not supported by Metals, please open an issue if you would like to contribute to improve the situation.")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noBuildTool"), new Line(145), MDC$.MODULE$.instance());
        }
        String x$1 = this.icons.alert() + "No build tool";
        String x$2 = ClientCommands$.MODULE$.ToggleLogs().id();
        String x$3 = MetalsStatusParams$.MODULE$.apply$default$2();
        Boolean x$4 = MetalsStatusParams$.MODULE$.apply$default$3();
        Boolean x$5 = MetalsStatusParams$.MODULE$.apply$default$4();
        String x$6 = MetalsStatusParams$.MODULE$.apply$default$5();
        String x$7 = MetalsStatusParams$.MODULE$.apply$default$7();
        String x$8 = MetalsStatusParams$.MODULE$.apply$default$8();
        this.statusBar.addMessage(new MetalsStatusParams(x$1, x$3, x$4, x$5, x$6, x$2, x$7, x$8));
    }

    private static final String doesntWorkBecause$1(AbsolutePath path$1) {
        return "code navigation does not work for the file '" + path$1 + "' because";
    }

    private static final String pluginNotEnabled$1(String language, String targetName$1, AbsolutePath path$1) {
        return ProjectWarnings.doesntWorkBecause$1(path$1) + " the " + language + " SemanticDB compiler plugin is not enabled for the build target " + targetName$1 + ".";
    }

    private static final String missingCompilerOption$1(String language, String option, String targetName$1, AbsolutePath path$1) {
        return ProjectWarnings.doesntWorkBecause$1(path$1) + " the build target " + targetName$1 + " is missing the " + language + " compiler option " + option + ". To fix this problems, update the build settings to include this compiler option.";
    }

    private final void buildMisconfiguration$1() {
        String x$1 = this.icons.alert() + "Build misconfiguration";
        String x$2 = ServerCommands$.MODULE$.RunDoctor().id();
        String x$3 = MetalsStatusParams$.MODULE$.apply$default$2();
        Boolean x$4 = MetalsStatusParams$.MODULE$.apply$default$3();
        Boolean x$5 = MetalsStatusParams$.MODULE$.apply$default$4();
        String x$6 = MetalsStatusParams$.MODULE$.apply$default$5();
        String x$7 = MetalsStatusParams$.MODULE$.apply$default$7();
        String x$8 = MetalsStatusParams$.MODULE$.apply$default$8();
        this.statusBar.addMessage(new MetalsStatusParams(x$1, x$3, x$4, x$5, x$6, x$2, x$7, x$8));
    }

    private final void reportSemanticDB$1(BuildTargetIdentifier buildTarget, String targetName, AbsolutePath path$1) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isJavaFilename()) {
            Option<JavaTarget> option = this.buildTargets.javaTarget(buildTarget);
            if (None$.MODULE$.equals(option)) {
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.pluginNotEnabled$1("Java", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(54), MDC$.MODULE$.instance());
                this.buildMisconfiguration$1();
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                JavaTarget target = (JavaTarget)some.value();
                if (!target.isSemanticdbEnabled()) {
                    MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.pluginNotEnabled$1("Java", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(58), MDC$.MODULE$.instance());
                    this.buildMisconfiguration$1();
                    return;
                }
                if (!target.isSourcerootDeclared()) {
                    String option2 = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(this.workspace).javaSourcerootOption();
                    MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.missingCompilerOption$1("Java", option2, targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(62), MDC$.MODULE$.instance());
                    this.buildMisconfiguration$1();
                    return;
                }
                return;
            }
            throw new MatchError(option);
        }
        Option<ScalaTarget> option = this.buildTargets.scalaTarget(buildTarget);
        if (None$.MODULE$.equals(option)) {
            MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.pluginNotEnabled$1("Scala", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(69), MDC$.MODULE$.instance());
            this.buildMisconfiguration$1();
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            ScalaTarget target = (ScalaTarget)some.value();
            if (!target.isSemanticdbEnabled()) {
                if (ScalaVersions$.MODULE$.isSupportedAtReleaseMomentScalaVersion(target.scalaVersion())) {
                    MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.pluginNotEnabled$1("Scala", targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(74), MDC$.MODULE$.instance());
                    this.buildMisconfiguration$1();
                    return;
                }
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.doesntWorkBecause$1(path$1) + " the Scala version " + target.scalaVersion() + " is not supported. To fix this problem, change the Scala version to " + ScalaVersions$.MODULE$.isLatestScalaVersion().mkString(" or ") + ".")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(77), MDC$.MODULE$.instance());
                this.statusBar.addMessage(this.icons.alert() + "Unsupported Scala " + target.scalaVersion());
                return;
            }
            if (!target.isSourcerootDeclared()) {
                String option3 = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(this.workspace).scalaSourcerootOption();
                MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.missingCompilerOption$1("Scala", option3, targetName, path$1))}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(87), MDC$.MODULE$.instance());
                this.buildMisconfiguration$1();
                return;
            }
            if (!MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isSbt() && !MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isWorksheet()) {
                AbsolutePath targetRoot = target.targetroot();
                AbsolutePath targetfile = targetRoot.resolve(SemanticdbClasspath$.MODULE$.fromScalaOrJava(path$1.toRelative(this.workspace)));
                BoxedUnit cfr_ignored_0 = (BoxedUnit)MetalsLogger$.MODULE$.silentInTests().error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> ProjectWarnings.doesntWorkBecause$1(path$1) + " the SemanticDB file '" + targetfile + "' doesn't exist. There can be many reasons for this error. ")}), new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(97), MDC$.MODULE$.instance());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public ProjectWarnings(AbsolutePath workspace, BuildTargets buildTargets, StatusBar statusBar, Icons icons, BuildTools buildTools, Function1<BuildTargetIdentifier, Object> isCompiling) {
        this.workspace = workspace;
        this.buildTargets = buildTargets;
        this.statusBar = statusBar;
        this.icons = icons;
        this.buildTools = buildTools;
        this.isCompiling = isCompiling;
    }
}

