/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import dev.dirs.ProjectDirectories;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.MetalsProjectDirectories$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class Trace$ {
    public static final Trace$ MODULE$ = new Trace$();
    private static final AbsolutePath localDirectory = PathIO$.MODULE$.workingDirectory().resolve(".metals/");

    public Option<AbsolutePath> globalDirectory(ExecutionContext ec) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Option<ProjectDirectories> projectDirectories = MetalsProjectDirectories$.MODULE$.from("org", "scalameta", "metals", true, ec);
            return projectDirectories.flatMap((Function1 & Serializable)dirs -> {
                Path cacheDir = Paths.get(dirs.cacheDir, new String[0]);
                if (cacheDir.isAbsolute()) {
                    return new Some((Object)AbsolutePath$.MODULE$.apply(cacheDir, AbsolutePath$.MODULE$.workingDirectory()));
                }
                return None$.MODULE$;
            });
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private AbsolutePath localDirectory() {
        return localDirectory;
    }

    public AbsolutePath metalsLog(ExecutionContext ec) {
        return ((AbsolutePath)this.globalDirectory(ec).getOrElse((Function0 & Serializable)() -> MODULE$.localDirectory())).resolve("metals.log");
    }

    public AbsolutePath protocolTracePath(String protocolName, AbsolutePath workspace) {
        String traceFilename = protocolName.toLowerCase() + ".trace.json";
        return workspace.resolve(traceFilename);
    }

    public AbsolutePath protocolTracePath$default$2() {
        return this.localDirectory();
    }

    public Option<PrintWriter> setupTracePrinter(String protocolName, AbsolutePath workspace, ExecutionContext ec) {
        AbsolutePath metalsDir;
        AbsolutePath absolutePath = metalsDir = workspace.resolve(".metals");
        List tracePaths = this.globalDirectory(ec).toList().$colon$colon((Object)absolutePath).map((Function1 & Serializable)dir -> MODULE$.protocolTracePath(protocolName, (AbsolutePath)dir));
        return this.setupPrintWriter$1(tracePaths, protocolName, tracePaths);
    }

    public AbsolutePath setupTracePrinter$default$2() {
        return PathIO$.MODULE$.workingDirectory();
    }

    private final Option setupPrintWriter$1(List paths, String protocolName$1, List tracePaths$1) {
        List list;
        while (true) {
            List tail;
            boolean bl = false;
            .colon.colon colon2 = null;
            list = paths;
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                AbsolutePath head = (AbsolutePath)colon2.head();
                if (head.isFile()) {
                    package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "tracing is enabled: " + head)}), new Pkg("scala.meta.internal.metals"), new FileName("Trace.scala"), new Name("setupPrintWriter"), new Line(82), MDC$.MODULE$.instance());
                    OutputStream fos = Files.newOutputStream(head.toNIO(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    return new Some((Object)new PrintWriter(fos));
                }
            }
            if (!bl) break;
            paths = tail = colon2.next$access$1();
        }
        if (Nil$.MODULE$.equals(list)) {
            package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "tracing is disabled for protocol " + protocolName$1 + ", to enable tracing of incoming and outgoing JSON messages create an empty file at " + tracePaths$1.mkString(" or "))}), new Pkg("scala.meta.internal.metals"), new FileName("Trace.scala"), new Name("setupPrintWriter"), new Line(92), MDC$.MODULE$.instance());
            return None$.MODULE$;
        }
        throw new MatchError((Object)list);
    }

    private Trace$() {
    }
}

