/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.bsp;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.bsp.BspServerState;
import scala.meta.internal.bsp.BspStatusState;
import scala.meta.internal.bsp.Connected;
import scala.meta.internal.bsp.ConnectionBspStatus$;
import scala.meta.internal.bsp.Disconnected$;
import scala.meta.internal.bsp.ErrorMessage;
import scala.meta.internal.bsp.NoResponse$;
import scala.meta.internal.metals.BspStatus;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.clients.language.MetalsStatusParams;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\u0010!\u0001%B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015a\u0003B\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001di\u0005A1A\u0005\n9CaA\u0018\u0001!\u0002\u0013y\u0005bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007a\u0002\u0001\u000b\u0011B1\t\u000bE\u0004A\u0011\u0001:\t\u000ba\u0004A\u0011A=\t\u000bi\u0004A\u0011A=\t\u000bm\u0004A\u0011\u0001?\t\r\u0005M\u0001\u0001\"\u0001z\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\n\u0001\t\u0013\t9\u0003C\u0005\u00028\u0001\t\n\u0011\"\u0003\u0002:!9\u0011q\n\u0001\u0005\n\u0005E\u0003\"CA-\u0001E\u0005I\u0011BA\u001d\u0011\u001d\tY\u0006\u0001C\u0005\u0003;:q!a\u001c!\u0011\u0003\t\tH\u0002\u0004 A!\u0005\u00111\u000f\u0005\u0007\tZ!\t!!\u001e\t\u000f\u0005]d\u0003\"\u0001\u0002z!I\u0011q\u0012\fC\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003'3\u0002\u0015!\u0003\u0002|!9\u0011Q\u0013\f\u0005\u0002\u0005]\u0005bBAO-\u0011\u0005\u0011q\u0014\u0005\n\u0003c3\"\u0019!C\u0005\u0003gC\u0001\"!.\u0017A\u0003%\u00111\u0016\u0002\u0014\u0007>tg.Z2uS>t'i\u001d9Ti\u0006$Xo\u001d\u0006\u0003C\t\n1AY:q\u0015\t\u0019C%\u0001\u0005j]R,'O\\1m\u0015\t)c%\u0001\u0003nKR\f'\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001A\u000b\t\u0003W1j\u0011AJ\u0005\u0003[\u0019\u0012a!\u00118z%\u00164\u0017!\u00032taN#\u0018\r^;t!\t\u00014'D\u00012\u0015\t\u0011$%\u0001\u0004nKR\fGn]\u0005\u0003iE\u0012\u0011BQ:q'R\fG/^:\u0002\u0015\u0019|G\u000eZ3s!\u0006$\b\u000e\u0005\u00028u5\t\u0001H\u0003\u0002:I\u0005\u0011\u0011n\\\u0005\u0003wa\u0012A\"\u00112t_2,H/\u001a)bi\"\fQ![2p]N\u0004\"\u0001\r \n\u0005}\n$!B%d_:\u001c\u0018A\u0001:d!\t\u0001$)\u0003\u0002Dc\ti!+\u001a9peR\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003\u0002$K\u00172#\"aR%\u0011\u0005!\u0003Q\"\u0001\u0011\t\u000b\u0001+\u00019A!\t\u000b9*\u0001\u0019A\u0018\t\u000bU*\u0001\u0019\u0001\u001c\t\u000bq*\u0001\u0019A\u001f\u0002\rM$\u0018\r^;t+\u0005y\u0005c\u0001)Z76\t\u0011K\u0003\u0002S'\u00061\u0011\r^8nS\u000eT!\u0001V+\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002W/\u0006!Q\u000f^5m\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW)\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"\u0001\u0013/\n\u0005u\u0003#A\u0004\"taN#\u0018\r^;t'R\fG/Z\u0001\bgR\fG/^:!\u0003Q\u0019WO\u001d:f]R\u001cVm]:j_:,%O]8sgV\t\u0011\rE\u0002Q3\n\u00042a\u00196n\u001d\t!\u0007\u000e\u0005\u0002fM5\taM\u0003\u0002hQ\u00051AH]8pizJ!!\u001b\u0014\u0002\rA\u0013X\rZ3g\u0013\tYGNA\u0002TKRT!!\u001b\u0014\u0011\u0005\rt\u0017BA8m\u0005\u0019\u0019FO]5oO\u0006)2-\u001e:sK:$8+Z:tS>tWI\u001d:peN\u0004\u0013!C2p]:,7\r^3e)\t\u0019h\u000f\u0005\u0002,i&\u0011QO\n\u0002\u0005+:LG\u000fC\u0003x\u0015\u0001\u0007Q.\u0001\u0006tKJ4XM\u001d(b[\u0016\f!B\\8SKN\u0004xN\\:f)\u0005\u0019\u0018\u0001\u00043jg\u000e|gN\\3di\u0016$\u0017!C:i_^,%O]8s)\r\u0019Xp \u0005\u0006}6\u0001\r!\\\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\t\t!\u0004a\u0001\u0003\u0007\tA\u0002]1uQR{'+\u001a9peR\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003gS2,'bAA\u0007/\u0006\u0019a.[8\n\t\u0005E\u0011q\u0001\u0002\u0005!\u0006$\b.A\bp]J+\u0007o\u001c:ugV\u0003H-\u0019;f\u0003]I7OQ;jY\u0012\u001cVM\u001d<feJ+7\u000f]8og&4X-\u0006\u0002\u0002\u001aA)1&a\u0007\u0002 %\u0019\u0011Q\u0004\u0014\u0003\r=\u0003H/[8o!\rY\u0013\u0011E\u0005\u0004\u0003G1#a\u0002\"p_2,\u0017M\\\u0001\fG\"\fgnZ3Ti\u0006$X\rF\u0003t\u0003S\t\u0019\u0004C\u0004\u0002,A\u0001\r!!\f\u0002\u00119,wo\u0015;bi\u0016\u00042\u0001SA\u0018\u0013\r\t\t\u0004\t\u0002\u000f\u0005N\u00048+\u001a:wKJ\u001cF/\u0019;f\u0011!\t)\u0004\u0005I\u0001\u0002\u0004\u0011\u0017\u0001D3se>\u0014(+\u001a9peR\u001c\u0018!F2iC:<Wm\u0015;bi\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003wQ3AYA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!C:i_^\u001cF/\u0019;f)\u0015\u0019\u00181KA,\u0011\u0019\t)F\u0005a\u00017\u0006Y1\u000f^1ukN\u001cF/\u0019;f\u0011!\t)D\u0005I\u0001\u0002\u0004\u0011\u0017aE:i_^\u001cF/\u0019;fI\u0011,g-Y;mi\u0012\u0012\u0014!F:z]\u000e<\u0016\u000e\u001e5SKB|'\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0005\u0003?\ni\u0007E\u0003\u0002b\u0005-T.\u0004\u0002\u0002d)!\u0011QMA4\u0003%IW.\\;uC\ndWMC\u0002\u0002j\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\rY\u00171\r\u0005\u0007\u0003k!\u0002\u0019\u00012\u0002'\r{gN\\3di&|gNQ:q'R\fG/^:\u0011\u0005!32C\u0001\f+)\t\t\t(A\bd_:tWm\u0019;fIB\u000b'/Y7t)\u0019\tY(a#\u0002\u000eB!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015\u0001\u00037b]\u001e,\u0018mZ3\u000b\u0007\u0005\u0015\u0015'A\u0004dY&,g\u000e^:\n\t\u0005%\u0015q\u0010\u0002\u0013\u001b\u0016$\u0018\r\\:Ti\u0006$Xo\u001d)be\u0006l7\u000fC\u0003x1\u0001\u0007Q\u000eC\u0003=1\u0001\u0007Q(\u0001\neSN\u001cwN\u001c8fGR,G\rU1sC6\u001cXCAA>\u0003M!\u0017n]2p]:,7\r^3e!\u0006\u0014\u0018-\\:!\u0003AqwNU3ta>t7/\u001a)be\u0006l7\u000f\u0006\u0004\u0002|\u0005e\u00151\u0014\u0005\u0006on\u0001\r!\u001c\u0005\u0006ym\u0001\r!P\u0001\u000fEN\u0004XI\u001d:peB\u000b'/Y7t))\tY(!)\u0002$\u0006\u0015\u0016q\u0015\u0005\u0006or\u0001\r!\u001c\u0005\u0006yq\u0001\r!\u0010\u0005\u0006}r\u0001\r!\u001c\u0005\b\u0003Sc\u0002\u0019AAV\u00031)'O]8sg:+XNY3s!\rY\u0013QV\u0005\u0004\u0003_3#aA%oi\u0006\u0011BkT(M)&\u0003v,T!Y?2+ej\u0012+I+\t\tY+A\nU\u001f>cE+\u0013)`\u001b\u0006Cv\fT#O\u000fRC\u0005\u0005")
public class ConnectionBspStatus {
    private final BspStatus bspStatus;
    private final AbsolutePath folderPath;
    private final Icons icons;
    private final ReportContext rc;
    private final AtomicReference<BspStatusState> status;
    private final AtomicReference<scala.collection.immutable.Set<String>> currentSessionErrors;

    public static MetalsStatusParams bspErrorParams(String serverName, Icons icons, String message, int errorsNumber) {
        return ConnectionBspStatus$.MODULE$.bspErrorParams(serverName, icons, message, errorsNumber);
    }

    public static MetalsStatusParams noResponseParams(String serverName, Icons icons) {
        return ConnectionBspStatus$.MODULE$.noResponseParams(serverName, icons);
    }

    public static MetalsStatusParams disconnectedParams() {
        return ConnectionBspStatus$.MODULE$.disconnectedParams();
    }

    public static MetalsStatusParams connectedParams(String serverName, Icons icons) {
        return ConnectionBspStatus$.MODULE$.connectedParams(serverName, icons);
    }

    private AtomicReference<BspStatusState> status() {
        return this.status;
    }

    private AtomicReference<scala.collection.immutable.Set<String>> currentSessionErrors() {
        return this.currentSessionErrors;
    }

    public void connected(String serverName) {
        this.changeState(new Connected(serverName), this.changeState$default$2());
    }

    public void noResponse() {
        package$.MODULE$.debug((Function0 & Serializable)() -> "server liveness monitor detected no response", new Pkg("scala.meta.internal.bsp"), new FileName("ConnectionBspStatus.scala"), new Name("noResponse"), new Line(31), MDC$.MODULE$.instance());
        this.changeState(NoResponse$.MODULE$, this.changeState$default$2());
    }

    public void disconnected() {
        this.currentSessionErrors().set((scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.changeState(Disconnected$.MODULE$, this.changeState$default$2());
    }

    public void showError(String message, Path pathToReport) {
        scala.collection.immutable.Set<String> updatedSet = this.currentSessionErrors().updateAndGet(x$1 -> (scala.collection.immutable.Set)x$1.$plus((Object)pathToReport.toUri().toString()));
        this.changeState(new ErrorMessage(message), updatedSet);
    }

    public void onReportsUpdate() {
        BspServerState bspServerState = this.status().get().currentState();
        if (bspServerState instanceof ErrorMessage) {
            this.showState(this.status().get(), this.showState$default$2());
            return;
        }
    }

    public Option<Object> isBuildServerResponsive() {
        BspServerState bspServerState = this.status().get().currentState();
        if (NoResponse$.MODULE$.equals(bspServerState)) {
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (Disconnected$.MODULE$.equals(bspServerState)) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private void changeState(BspServerState newState, scala.collection.immutable.Set<String> errorReports) {
        BspStatusState newServerState = this.status().updateAndGet(x$2 -> x$2.changeState(newState));
        if (newServerState.shouldShow()) {
            this.showState(newServerState, errorReports);
            return;
        }
    }

    private scala.collection.immutable.Set<String> changeState$default$2() {
        return this.currentSessionErrors().get();
    }

    private void showState(BspStatusState statusState, scala.collection.immutable.Set<String> errorReports) {
        MetalsStatusParams metalsStatusParams;
        BspServerState bspServerState = statusState.currentState();
        if (Disconnected$.MODULE$.equals(bspServerState)) {
            metalsStatusParams = ConnectionBspStatus$.MODULE$.disconnectedParams();
        } else if (NoResponse$.MODULE$.equals(bspServerState)) {
            metalsStatusParams = ConnectionBspStatus$.MODULE$.noResponseParams(statusState.serverName(), this.icons);
        } else if (bspServerState instanceof Connected) {
            Connected connected = (Connected)bspServerState;
            String serverName = connected.serverName();
            metalsStatusParams = ConnectionBspStatus$.MODULE$.connectedParams(serverName, this.icons);
        } else if (bspServerState instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)bspServerState;
            String message = errorMessage.message();
            scala.collection.immutable.Set<String> currentSessionReports = this.syncWithReportContext(errorReports);
            metalsStatusParams = currentSessionReports.isEmpty() ? ConnectionBspStatus$.MODULE$.connectedParams(statusState.serverName(), this.icons) : ConnectionBspStatus$.MODULE$.bspErrorParams(statusState.serverName(), this.icons, message, currentSessionReports.size());
        } else {
            throw new MatchError((Object)bspServerState);
        }
        MetalsStatusParams showParams = metalsStatusParams;
        this.bspStatus.status(this.folderPath, showParams);
    }

    private scala.collection.immutable.Set<String> showState$default$2() {
        return this.currentSessionErrors().get();
    }

    private scala.collection.immutable.Set<String> syncWithReportContext(scala.collection.immutable.Set<String> errorReports) {
        return (scala.collection.immutable.Set)errorReports.intersect((Set)this.rc.bloop().getReports().map((Function1 & Serializable)x$3 -> x$3.toPath().toUri().toString()).toSet());
    }

    public ConnectionBspStatus(BspStatus bspStatus, AbsolutePath folderPath, Icons icons, ReportContext rc) {
        this.bspStatus = bspStatus;
        this.folderPath = folderPath;
        this.icons = icons;
        this.rc = rc;
        this.status = new AtomicReference<BspStatusState>(new BspStatusState(Disconnected$.MODULE$, (Option<ErrorMessage>)None$.MODULE$, (Option<String>)None$.MODULE$, false));
        this.currentSessionErrors = new AtomicReference<Object>(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
    }
}

