/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.eclipse.lsp4j.ClientInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.ResolvedBloop$;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.GitHubIssueFolderInfo;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0005]3A\u0001C\u0005\u0001%!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!1\u0004A!A!\u0002\u00139\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002$\u0001\t\u00039\u0005\"\u0002)\u0001\t\u0013\t\u0006\"\u0002+\u0001\t\u0013)&\u0001G$ji\",(MT3x\u0013N\u001cX/Z+sY\u000e\u0013X-\u0019;pe*\u0011!bC\u0001\u0007[\u0016$\u0018\r\\:\u000b\u00051i\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00059y\u0011\u0001B7fi\u0006T\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\tq\"\u0003\u0002\u0017\u001f\t1\u0011I\\=SK\u001a\fabZ3u\r>dG-\u001a:t\u0013:4w\u000eE\u0002\u00153mI!AG\b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0001\u000f%O9\u0011QD\t\b\u0003=\u0005j\u0011a\b\u0006\u0003AE\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0005\rz\u0011a\u00029bG.\fw-Z\u0005\u0003K\u0019\u0012A\u0001T5ti*\u00111e\u0004\t\u0003Q%j\u0011!C\u0005\u0003U%\u0011QcR5u\u0011V\u0014\u0017j]:vK\u001a{G\u000eZ3s\u0013:4w.\u0001\u0006dY&,g\u000e^%oM>\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0005E\u0012\u0014aB3dY&\u00048/\u001a\u0006\u0002g\u0005\u0019qN]4\n\u0005Ur#AC\"mS\u0016tG/\u00138g_\u000691\r[1sg\u0016$\bC\u0001\u001d?\u001b\u0005I$B\u0001\u001c;\u0015\tYD(A\u0002oS>T\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u0002@s\t91\t[1sg\u0016$\u0018A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005C\u0001\u0015\u0001\u0011\u00159B\u00011\u0001\u0019\u0011\u0015YC\u00011\u0001-\u0011\u00151D\u00011\u00018\u0003!\u0011W/\u001b7e+JdG#\u0001%\u0011\u0005%keB\u0001&L!\tqr\"\u0003\u0002M\u001f\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\tau\"A\ttK2,7\r^3e\u0005VLG\u000e\u001a+p_2$\"\u0001\u0013*\t\u000bM3\u0001\u0019A\u000e\u0002\u0017\u0019|G\u000eZ3sg&sgm\\\u0001\u0014g\u0016dWm\u0019;fI\n+\u0018\u000e\u001c3TKJ4XM\u001d\u000b\u0003\u0011ZCQaU\u0004A\u0002m\u0001")
public class GithubNewIssueUrlCreator {
    private final Function0<List<GitHubIssueFolderInfo>> getFoldersInfo;
    private final ClientInfo clientInfo;
    private final Charset charset;

    public String buildUrl() {
        List foldersInfo = (List)this.getFoldersInfo.apply();
        String scalaVersions = ((List)this.getFoldersInfo.apply()).flatMap((Function1 & Serializable)x$1 -> x$1.buildTargets().allScala()).map((Function1 & Serializable)x$2 -> x$2.scalaVersion()).toSet().mkString("; ");
        String clientVersion = (String)Option$.MODULE$.apply((Object)this.clientInfo.getVersion()).map((Function1 & Serializable)v -> " v" + v).getOrElse((Function0 & Serializable)() -> "");
        String body = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<!--\n          |        Describe the bug ...\n          |\n          |        Reproduction steps\n          |          1. Go to ...\n          |          2. Click on ...\n          |          3. Scroll down to ...\n          |          4. See error\n          |-->\n          |\n          |### Expected behaviour:\n          |\n          |<!-- A clear and concise description of what you expected to happen. -->\n          |\n          |**Operating system:**\n          |" + Properties$.MODULE$.osName() + "\n          |\n          |**Java version:**\n          |" + Properties$.MODULE$.javaVersion() + "\n          |\n          |**Editor/extension:**\n          |" + this.clientInfo.getName() + clientVersion + "\n          |\n          |**Metals version:**\n          |" + BuildInfo$.MODULE$.metalsVersion() + "\n          |\n          |### Extra context or search terms:\n          |<!--\n          |        - Any other context about the problem\n          |        - Search terms to help others discover this\n          |-->\n          |\n          |### Workspace information:\n          | - **Scala versions:** " + scalaVersions + this.selectedBuildTool((List<GitHubIssueFolderInfo>)foldersInfo) + this.selectedBuildServer((List<GitHubIssueFolderInfo>)foldersInfo) + "\n          | - **All build tools in workspace:** " + foldersInfo.flatMap((Function1 & Serializable)x$3 -> x$3.buildTools().all()).mkString("; ") + "\n          |"));
        return "https://github.com/scalameta/metals/issues/new?body=" + URLEncoder.encode(body, this.charset);
    }

    private String selectedBuildTool(List<GitHubIssueFolderInfo> foldersInfo) {
        List buildTools = ((List)foldersInfo.map((Function1 & Serializable)x$4 -> (Option)x$4.selectedBuildTool().apply()).zipWithIndex()).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Option<String>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Option option = (Option)A1._1();
                    int ind = A1._2$mcI$sp();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String buildTool = (String)some.value();
                        return (B1)new Tuple2((Object)buildTool, (Object)BoxesRunTime.boxToInteger((int)ind));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Option<String>, Object> x1) {
                Option option;
                Tuple2<Option<String>, Object> tuple2 = x1;
                return tuple2 != null && (option = (Option)tuple2._1()) instanceof Some;
            }
        });
        if (buildTools.nonEmpty()) {
            String value = buildTools.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String buildTool = (String)tuple2._1();
                    int indx = tuple2._2$mcI$sp();
                    return indx + ". " + buildTool;
                }
                throw new MatchError((Object)tuple2);
            }).mkString("\n    ");
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n          | - **Build tools:** " + value));
        }
        return "";
    }

    private String selectedBuildServer(List<GitHubIssueFolderInfo> foldersInfo) {
        List buildServers = ((List)foldersInfo.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GitHubIssueFolderInfo info = (GitHubIssueFolderInfo)tuple2._1();
                int indx = tuple2._2$mcI$sp();
                String buildServer = (String)((Option)info.currentBuildServer().apply()).map((Function1 & Serializable)s -> s.main().name() + " v" + s.main().version()).getOrElse((Function0 & Serializable)() -> {
                    BspResolvedResult bspResolvedResult = (BspResolvedResult)info.calculateNewBuildServer().apply();
                    if (ResolvedBloop$.MODULE$.equals(bspResolvedResult)) {
                        return "Disconnected: Bloop";
                    }
                    if (bspResolvedResult instanceof ResolvedBspOne) {
                        ResolvedBspOne resolvedBspOne = (ResolvedBspOne)bspResolvedResult;
                        BspConnectionDetails details = resolvedBspOne.details();
                        return "Disconnected: " + details.getName();
                    }
                    if (bspResolvedResult instanceof ResolvedMultiple) {
                        ResolvedMultiple resolvedMultiple = (ResolvedMultiple)bspResolvedResult;
                        List<BspConnectionDetails> details = resolvedMultiple.details();
                        return "Disconnected: Multiple Found " + details.map((Function1 & Serializable)x$5 -> x$5.getName()).mkString("; ");
                    }
                    if (ResolvedNone$.MODULE$.equals(bspResolvedResult)) {
                        return "Disconnected: None Found";
                    }
                    throw new MatchError((Object)bspResolvedResult);
                });
                return indx + ". " + buildServer;
            }
            throw new MatchError((Object)tuple2);
        });
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n        | - **Build servers:**\n        |    " + buildServers.mkString("\n    ")));
    }

    public GithubNewIssueUrlCreator(Function0<List<GitHubIssueFolderInfo>> getFoldersInfo, ClientInfo clientInfo, Charset charset) {
        this.getFoldersInfo = getFoldersInfo;
        this.clientInfo = clientInfo;
        this.charset = charset;
    }
}

