/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.Serializable;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.metals.Compilers;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.HoverExtParams;
import scala.meta.internal.metals.HoverExtParams$;
import scala.meta.internal.metals.JsonParser;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.CancelToken;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\t\u0013\u0005mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003-!\u0006\u0003\u00051\u0001\t\u0005\t\u0015a\u00032\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015a\u0004\u0001\"\u0003^\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!!\b\u0001\t\u0013\ty\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u00024!A\u00111\t\u0001!\u0002\u0013\t)\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u0002H!A\u00111\n\u0001!\u0002\u0013\tI\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011\u0011\u0010\u0001\u0005\n\u0005m$\u0001G%oY\u0006L\b*\u001b8u%\u0016\u001cx\u000e\u001c<f!J|g/\u001b3fe*\u00111\u0003F\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005U1\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005]A\u0012\u0001B7fi\u0006T\u0011!G\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001e=5\t\u0001$\u0003\u0002 1\t1\u0011I\\=SK\u001a\f!\u0003Z3gS:LG/[8o!J|g/\u001b3feB\u0011!eI\u0007\u0002%%\u0011AE\u0005\u0002\u0013\t\u00164\u0017N\\5uS>t\u0007K]8wS\u0012,'/A\u0005d_6\u0004\u0018\u000e\\3sgB\u0011!eJ\u0005\u0003QI\u0011\u0011bQ8na&dWM]:\u0002\u0005\u0015\u001c\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0019\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003_1\u0012q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\t\u00118\r\u0005\u0002#e%\u00111G\u0005\u0002\u000e%\u0016\u0004xN\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\r1$h\u000f\u000b\u0004oaJ\u0004C\u0001\u0012\u0001\u0011\u0015IS\u0001q\u0001+\u0011\u0015\u0001T\u0001q\u00012\u0011\u0015\u0001S\u00011\u0001\"\u0011\u0015)S\u00011\u0001'\u0003\u001d\u0011Xm]8mm\u0016$BAP&N+B\u00191fP!\n\u0005\u0001c#A\u0002$viV\u0014X\r\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006)An\u001d95U*\u0011aiR\u0001\bK\u000ed\u0017\u000e]:f\u0015\u0005A\u0015aA8sO&\u0011!j\u0011\u0002\n\u0013:d\u0017-\u001f%j]RDQ\u0001\u0014\u0004A\u0002\u0005\u000b\u0011\"\u001b8mCfD\u0015N\u001c;\t\u000b93\u0001\u0019A(\u0002\tA\fG\u000f\u001b\t\u0003!Nk\u0011!\u0015\u0006\u0003%Z\t!![8\n\u0005Q\u000b&\u0001D!cg>dW\u000f^3QCRD\u0007\"\u0002,\u0007\u0001\u00049\u0016!\u0002;pW\u0016t\u0007C\u0001-\\\u001b\u0005I&B\u0001.\u0017\u0003\t\u00018-\u0003\u0002]3\nY1)\u00198dK2$vn[3o)\u001dqdlXA\u0002\u0003\u000bAQ\u0001T\u0004A\u0002\u0005CQ\u0001Y\u0004A\u0002\u0005\f!\u0002\\1cK2\u0004\u0016M\u001d;t!\r\u0011'.\u001c\b\u0003G\"t!\u0001Z4\u000e\u0003\u0015T!A\u001a\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA5\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\t1K7\u000f\u001e\u0006\u0003Sb\u0001B!\b8qg&\u0011q\u000e\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\t\u000b\u0018B\u0001:D\u0005IIe\u000e\\1z\u0011&tG\u000fT1cK2\u0004\u0016M\u001d;\u0011\t\t$hO`\u0005\u0003k2\u0014a!R5uQ\u0016\u0014\bCA<|\u001d\tA\u0018\u0010\u0005\u0002e1%\u0011!\u0010G\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{1A\u0011!i`\u0005\u0004\u0003\u0003\u0019%\u0001\u0003)pg&$\u0018n\u001c8\t\u000b9;\u0001\u0019A(\t\u000bY;\u0001\u0019A,\u0002!I,7o\u001c7wK2\u000b'-\u001a7QCJ$H\u0003CA\u0006\u0003\u001b\t\t\"a\u0007\u0011\u0007-z\u0004\u000f\u0003\u0004\u0002\u0010!\u0001\r\u0001]\u0001\nY\u0006\u0014W\r\u001c)beRDq!a\u0005\t\u0001\u0004\t)\"\u0001\u0005m_\u000e\fG/[8o!\r\u0011\u0015qC\u0005\u0004\u00033\u0019%\u0001\u0003'pG\u0006$\u0018n\u001c8\t\u000bYC\u0001\u0019A,\u0002\u001b\u001d,G\u000fT1cK2\u0004\u0016M\u001d;t)\u0011\t\t#a\f\u0011\u000b\u0005\r\u0012Q\u00069\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005-\u0002$\u0001\u0006d_2dWm\u0019;j_:L1a[A\u0013\u0011\u0015a\u0015\u00021\u0001B\u0003\u0019\u0019\u00180\u001c2pYV\u0011\u0011Q\u0007\t\u0006\u0003o\tiD\u001e\b\u0004E\u0005e\u0012bAA\u001e%\u0005Q!j]8o!\u0006\u00148/\u001a:\n\t\u0005}\u0012\u0011\t\u0002\u0003\u001f\u001aT1!a\u000f\u0013\u0003\u001d\u0019\u00180\u001c2pY\u0002\nQA]1oO\u0016,\"!!\u0013\u0011\u000b\u0005]\u0012Q\b@\u0002\rI\fgnZ3!\u0003%\u0001\u0018M]:f\t\u0006$\u0018\r\u0006\u0003\u0002R\u0005M\u0003c\u00012kg\"9\u0011Q\u000b\bA\u0002\u0005]\u0013\u0001\u00023bi\u0006\u0004B!!\u0017\u0002h5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0003hg>t'\u0002BA1\u0003G\naaZ8pO2,'BAA3\u0003\r\u0019w.\\\u0005\u0005\u0003S\nYFA\u0005Kg>t\u0017I\u001d:bs\u0006Iq-\u001a;Ts6\u0014w\u000e\u001c\u000b\u0007\u0003_\n)(a\u001e\u0011\u000bu\t\t(!\u0006\n\u0007\u0005M\u0004D\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003cy\u0001\u0019\u0001<\t\u000b9{\u0001\u0019A(\u0002\rI,\u0007o\u001c:u)!\ti(a!\u0002\u0006\u0006\u001d\u0005c\u0001\u0012\u0002\u0000%\u0019\u0011\u0011\u0011\n\u0003\rI+\u0007o\u001c:u\u0011\u0015a\u0005\u00031\u0001B\u0011\u0015q\u0005\u00031\u0001P\u0011\u001d\tI\t\u0005a\u0001\u0003\u0017\u000bQ!\u001a:s_J\u00042AYAG\u0013\r\ty\t\u001c\u0002\n)\"\u0014xn^1cY\u0016\u0004")
public final class InlayHintResolveProvider {
    private final DefinitionProvider definitionProvider;
    private final Compilers compilers;
    private final ExecutionContextExecutorService ec;
    private final ReportContext rc;
    private final JsonParser.Of<String> symbol;
    private final JsonParser.Of<Position> range;

    public Future<InlayHint> resolve(InlayHint inlayHint, AbsolutePath path2, CancelToken token) {
        Either either = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            JsonArray data = (JsonArray)inlayHint.getData();
            return (List)this.getLabelParts(inlayHint).zip(this.parseData(data));
        }).toEither();
        if (either instanceof Right) {
            Right right = (Right)either;
            List labelParts = (List)right.value();
            return this.resolve(inlayHint, (List<Tuple2<InlayHintLabelPart, Either<String, Position>>>)labelParts, path2, token);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable error = (Throwable)left.value();
            package$.MODULE$.warn((Function0 & Serializable)() -> "Failed to resolve inlay hint: " + error, new Pkg("scala.meta.internal.metals"), new FileName("InlayHintResolveProvider.scala"), new Name("resolve"), new Line(32), MDC$.MODULE$.instance());
            this.rc.unsanitized().create((Function0 & Serializable)() -> this.report(inlayHint, path2, error), true);
            return Future$.MODULE$.successful((Object)inlayHint);
        }
        throw new MatchError((Object)either);
    }

    private Future<InlayHint> resolve(InlayHint inlayHint, List<Tuple2<InlayHintLabelPart, Either<String, Position>>> labelParts2, AbsolutePath path2, CancelToken token) {
        List resolveLabelParts = labelParts2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InlayHintLabelPart labelPart = (InlayHintLabelPart)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String symbol = (String)left.value();
                    return (Future)this.getSymbol(symbol, path2).map((Function1 & Serializable)loc -> this.resolveLabelPart(labelPart, (Location)loc, token)).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)labelPart));
                }
            }
            if (tuple2 != null) {
                InlayHintLabelPart labelPart = (InlayHintLabelPart)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Position pos = (Position)right.value();
                    Location location = new Location(path2.toURI().toString(), new Range(pos, pos));
                    return this.resolveLabelPart(labelPart, location, token);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return Future$.MODULE$.sequence((IterableOnce)resolveLabelParts, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.ec).map((Function1 & Serializable)labelParts -> {
            inlayHint.setLabel(MetalsEnrichments$.MODULE$.SeqHasAsJava(labelParts).asJava());
            return inlayHint;
        }, (ExecutionContext)this.ec);
    }

    private Future<InlayHintLabelPart> resolveLabelPart(InlayHintLabelPart labelPart, Location location, CancelToken token) {
        labelPart.setCommand(ServerCommands$.MODULE$.GotoPosition().toLsp(location));
        HoverExtParams hoverParams = new HoverExtParams(new TextDocumentIdentifier(location.getUri()), location.getRange().getStart(), HoverExtParams$.MODULE$.apply$default$3());
        return this.compilers.hover(hoverParams, token).map((Function1 & Serializable)hover -> {
            hover.foreach((Function1 & Serializable)h -> {
                labelPart.setTooltip((MarkupContent)h.toLsp().getContents().getRight());
                return BoxedUnit.UNIT;
            });
            return labelPart;
        }, (ExecutionContext)this.ec);
    }

    private List<InlayHintLabelPart> getLabelParts(InlayHint inlayHint) {
        Either either = MetalsEnrichments$.MODULE$.XtensionJEitherCross(inlayHint.getLabel()).asScala();
        if (either instanceof Left) {
            Left left = (Left)either;
            String text = (String)left.value();
            InlayHintLabelPart label = new InlayHintLabelPart();
            label.setValue(text);
            return new .colon.colon((Object)label, (List)Nil$.MODULE$);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            java.util.List labelParts = (java.util.List)right.value();
            return MetalsEnrichments$.MODULE$.ListHasAsScala(labelParts).asScala().toList();
        }
        throw new MatchError((Object)either);
    }

    public JsonParser.Of<String> symbol() {
        return this.symbol;
    }

    public JsonParser.Of<Position> range() {
        return this.range;
    }

    private List<Either<String, Position>> parseData(JsonArray data) {
        return ((IterableOnceOps)MetalsEnrichments$.MODULE$.IterableHasAsScala(data).asScala().map((Function1 & Serializable)x0$1 -> {
            Option option;
            Option option2;
            JsonElement jsonElement = x0$1;
            if (jsonElement != null && !(option2 = this.range().Jsonized().unapply(jsonElement)).isEmpty()) {
                Position data = (Position)option2.get();
                return new Right((Object)data);
            }
            if (jsonElement != null && !(option = this.symbol().Jsonized().unapply(jsonElement)).isEmpty()) {
                String data = (String)option.get();
                return new Left((Object)data);
            }
            return new Left((Object)"");
        })).toList();
    }

    private Option<Location> getSymbol(String symbol, AbsolutePath path2) {
        return MetalsEnrichments$.MODULE$.ListHasAsScala(this.definitionProvider.fromSymbol(symbol, (Option<AbsolutePath>)new Some((Object)path2))).asScala().headOption();
    }

    private Report report(InlayHint inlayHint, AbsolutePath path2, Throwable error) {
        Position pos = inlayHint.getPosition();
        String x$1 = "inlayHint-resolve";
        String x$2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|pos: " + pos + "\n          |\n          |inlayHint: " + inlayHint + "\n          |"));
        String x$3 = "failed to resolve inlayHint in " + path2;
        Some x$4 = new Some((Object)(path2 + "::" + pos.getLine() + ":" + pos.getCharacter()));
        Some x$5 = new Some((Object)path2.toURI());
        Some x$6 = new Some((Object)error);
        return new Report("inlayHint-resolve", x$2, x$3, (Option)x$5, (Option)x$4, (Option)x$6);
    }

    public InlayHintResolveProvider(DefinitionProvider definitionProvider, Compilers compilers, ExecutionContextExecutorService ec, ReportContext rc) {
        this.definitionProvider = definitionProvider;
        this.compilers = compilers;
        this.ec = ec;
        this.rc = rc;
        this.symbol = new JsonParser.Of(ClassTag$.MODULE$.apply(String.class));
        this.range = new JsonParser.Of(ClassTag$.MODULE$.apply(Position.class));
    }
}

