/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.parsing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.lsp4j.FoldingRange;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.meta.internal.parsing.JavaFoldingRangeExtractor;
import scala.meta.internal.pc.JavaMetalsGlobal$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JavaFoldingRangeExtractor$ {
    public static final JavaFoldingRangeExtractor$ MODULE$ = new JavaFoldingRangeExtractor$();
    private static final int spanThreshold = 2;

    private int spanThreshold() {
        return spanThreshold;
    }

    private Option<Tuple2<Trees, CompilationUnitTree>> getTrees(String text, AbsolutePath path2) {
        JavacTask javacTask = JavaMetalsGlobal$.MODULE$.baseCompilationTask(text, path2.toURI());
        Iterable<? extends CompilationUnitTree> elems = javacTask.parse();
        javacTask.analyze();
        Trees trees = Trees.instance(javacTask);
        Iterator<? extends CompilationUnitTree> iter = elems.iterator();
        if (iter.hasNext()) {
            return new Some((Object)new Tuple2((Object)trees, (Object)iter.next()));
        }
        return None$.MODULE$;
    }

    private List<JavaFoldingRangeExtractor.Range> findComments(String text, List<JavaFoldingRangeExtractor.Range> exclusions) {
        return this.findComments$1((List)Nil$.MODULE$, 0, text, exclusions);
    }

    public List<FoldingRange> extract(String text, AbsolutePath path2, boolean foldOnlyLines) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<Trees, CompilationUnitTree>> option = this.getTrees(text, path2);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Trees trees = (Trees)tuple2._1();
            CompilationUnitTree root = (CompilationUnitTree)tuple2._2();
            SourcePositions sourcePositions = trees.getSourcePositions();
            JavaFoldingRangeExtractor.FoldScanner scanner = new JavaFoldingRangeExtractor.FoldScanner(root, sourcePositions, text);
            scanner.scan(root, BoxedUnit.UNIT);
            LineMap lineMap = root.getLineMap();
            List mergedImports = this.mergeRanges((List<FoldingRange>)scanner.imports().map((Function1 & Serializable)range -> range.toFoldingRange(lineMap))).toList();
            List<JavaFoldingRangeExtractor.Range> comments = this.findComments(text, scanner.strings());
            List list = mergedImports;
            List list2 = scanner.regions().map((Function1 & Serializable)range -> range.toFoldingRange(lineMap));
            List list3 = scanner.strings().map((Function1 & Serializable)range -> range.toFoldingRange(lineMap));
            List allRanges = comments.map((Function1 & Serializable)range -> range.toFoldingRange(lineMap)).$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list);
            List thresholdedRanges = allRanges.filter((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)JavaFoldingRangeExtractor$.$anonfun$extract$5(range)));
            if (foldOnlyLines) {
                return this.adjustForOverlap((List<FoldingRange>)thresholdedRanges);
            }
            return thresholdedRanges;
        }
        if (None$.MODULE$.equals(option)) {
            return Nil$.MODULE$;
        }
        throw new MatchError(option);
    }

    private List<FoldingRange> adjustForOverlap(List<FoldingRange> ranges) {
        Set startLines = ((IterableOnceOps)ranges.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getStartLine())).distinct()).toSet();
        return ranges.map((Function1 & Serializable)range -> {
            if (startLines.contains((Object)BoxesRunTime.boxToInteger((int)range.getEndLine())) && range.getEndLine() > range.getStartLine()) {
                FoldingRange adjustedRange = new FoldingRange(range.getStartLine(), range.getEndLine() - 1);
                adjustedRange.setStartCharacter(range.getStartCharacter());
                Integer endChar = adjustedRange.getStartLine() == adjustedRange.getEndLine() && Predef$.MODULE$.Integer2int(range.getStartCharacter()) > Predef$.MODULE$.Integer2int(range.getEndCharacter()) ? range.getStartCharacter() : range.getEndCharacter();
                adjustedRange.setEndCharacter(endChar);
                adjustedRange.setKind(range.getKind());
                return adjustedRange;
            }
            return range;
        });
    }

    private Option<FoldingRange> mergeRanges(List<FoldingRange> ranges) {
        if (ranges.isEmpty()) {
            return None$.MODULE$;
        }
        FoldingRange min = (FoldingRange)ranges.reduce((Function2 & Serializable)(a, b) -> JavaFoldingRangeExtractor$.minStart$1(a, b));
        FoldingRange max = (FoldingRange)ranges.reduce((Function2 & Serializable)(a, b) -> JavaFoldingRangeExtractor$.maxEnd$1(a, b));
        FoldingRange mergedRange = new FoldingRange(min.getStartLine(), max.getEndLine());
        mergedRange.setStartCharacter(min.getStartCharacter());
        mergedRange.setEndCharacter(max.getEndCharacter());
        mergedRange.setKind(min.getKind());
        return new Some((Object)mergedRange);
    }

    private final List findComments$1(List comments, int idx, String text$1, List exclusions$1) {
        int startIdx;
        while ((startIdx = text$1.indexOf("/*", idx)) != -1) {
            int newIdx;
            Tuple2 tuple2;
            if (exclusions$1.exists((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)range.contains(startIdx)))) {
                v0 = new Tuple2((Object)comments, (Object)BoxesRunTime.boxToInteger((int)(startIdx + 2)));
            } else {
                JavaFoldingRangeExtractor.Range range2;
                int endIdx = text$1.indexOf("*/", startIdx + 2);
                JavaFoldingRangeExtractor.Range range3 = range2 = new JavaFoldingRangeExtractor.Range(startIdx, (long)endIdx + 2L, "comment");
                v0 = tuple2 = new Tuple2((Object)comments.$colon$colon((Object)range3), (Object)BoxesRunTime.boxToInteger((int)(endIdx + 2)));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List newComments = (List)tuple2._1();
            int newIdx2 = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)newComments, (Object)BoxesRunTime.boxToInteger((int)newIdx2));
            List newComments2 = (List)tuple22._1();
            idx = newIdx = tuple22._2$mcI$sp();
            comments = newComments2;
        }
        return comments;
    }

    public static final /* synthetic */ boolean $anonfun$extract$5(FoldingRange range) {
        return range.getEndLine() - range.getStartLine() >= MODULE$.spanThreshold();
    }

    private static final FoldingRange minStart$1(FoldingRange a, FoldingRange b) {
        if (a.getStartLine() < b.getStartLine() || a.getStartLine() == b.getStartLine() && Predef$.MODULE$.Integer2int(a.getStartCharacter()) < Predef$.MODULE$.Integer2int(b.getStartCharacter())) {
            return a;
        }
        return b;
    }

    private static final FoldingRange maxEnd$1(FoldingRange a, FoldingRange b) {
        if (a.getEndLine() > b.getEndLine() || a.getEndLine() == b.getEndLine() && Predef$.MODULE$.Integer2int(a.getEndCharacter()) > Predef$.MODULE$.Integer2int(b.getEndCharacter())) {
            return a;
        }
        return b;
    }

    private JavaFoldingRangeExtractor$() {
    }
}

