/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.DebugSessionParams;
import ch.epfl.scala.bsp4j.ScalaMainClass;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.metals.DebugSession;
import scala.meta.internal.metals.JsonParser$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.config.RunType;
import scala.meta.internal.metals.debug.DebugProvider;
import scala.meta.internal.metals.debug.DiscoveryFailures;
import scala.meta.internal.metals.debug.DiscoveryFailures$NoRunOptionException$;
import scala.meta.internal.metals.debug.DotEnvFileParser;
import scala.meta.internal.metals.debug.DotEnvFileParser$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Try;

public final class DebugProvider$ {
    public static final DebugProvider$ MODULE$ = new DebugProvider$();
    private static final Set<Object> specialChars = Predef$.MODULE$.wrapString(".+*?^()[]{}|&$").toSet();

    public List<String> createEnvList(Map<String, String> env) {
        return ((IterableOnceOps)MetalsEnrichments$.MODULE$.MapHasAsScala(env).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return key + "=" + value;
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    public Future<List<String>> envFromFile(AbsolutePath workspace, Option<String> envFile, ExecutionContext ec) {
        return (Future)envFile.map((Function1 & Serializable)file -> {
            AbsolutePath path2 = AbsolutePath$.MODULE$.apply(file, workspace);
            return DotEnvFileParser$.MODULE$.parse(path2, ec).map((Function1 & Serializable)x$29 -> ((IterableOnceOps)x$29.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return key + "=" + value;
                }
                throw new MatchError((Object)tuple2);
            })).toList(), ec);
        }).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)package$.MODULE$.List().empty()));
    }

    public Future<DebugSessionParams> createMainParams(AbsolutePath workspace, ScalaMainClass main, BuildTargetIdentifier target, Option<java.util.List<String>> args, Option<java.util.List<String>> jvmOptions, List<String> env, Option<String> envFile, ExecutionContext ec) {
        main.setArguments((java.util.List)args.getOrElse((Function0 & Serializable)() -> Collections.emptyList()));
        main.setJvmOptions((java.util.List)jvmOptions.getOrElse((Function0 & Serializable)() -> Collections.emptyList()));
        return this.envFromFile(workspace, envFile, ec).map((Function1 & Serializable)envFromFile -> {
            List list = envFromFile;
            main.setEnvironmentVariables(MetalsEnrichments$.MODULE$.SeqHasAsJava(env.$colon$colon$colon(list)).asJava());
            DebugSessionParams params = new DebugSessionParams(Collections.singletonList(target));
            params.setDataKind("scala-main-class");
            params.setData((Object)JsonParser$.MODULE$.XtensionSerializableToJson(main).toJson());
            return params;
        }, ec);
    }

    public int scala$meta$internal$metals$debug$DebugProvider$$exceptionOrder(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof DotEnvFileParser.InvalidEnvFileException) {
            return 0;
        }
        if (DiscoveryFailures$NoRunOptionException$.MODULE$.equals(throwable)) {
            return 1;
        }
        if (throwable instanceof RunType.UnknownRunTypeException) {
            return 2;
        }
        if (throwable instanceof DiscoveryFailures.ClassNotFoundInBuildTargetException) {
            return 3;
        }
        if (throwable instanceof DiscoveryFailures.BuildTargetContainsNoMainException) {
            return 4;
        }
        if (throwable instanceof DiscoveryFailures.NoTestsFoundException) {
            return 5;
        }
        if (throwable instanceof DiscoveryFailures.BuildTargetNotFoundForPathException) {
            return 6;
        }
        if (throwable instanceof DiscoveryFailures.NoMainClassFoundException) {
            return 7;
        }
        if (throwable instanceof DiscoveryFailures.BuildTargetNotFoundException) {
            return 8;
        }
        return 9;
    }

    public Set<Object> specialChars() {
        return specialChars;
    }

    public String escapeTestName(String testName) {
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(testName), (Function1 & Serializable)x0$1 -> DebugProvider$.$anonfun$escapeTestName$1(BoxesRunTime.unboxToChar((Object)x0$1)));
    }

    public <A> Future<DebugSession> getResultFromSearches(List<DebugProvider.ClassSearch<A>> searches, ExecutionContext ec) {
        return this.scala$meta$internal$metals$debug$DebugProvider$$FindFirstDebugSession(Future$.MODULE$.sequence((IterableOnce)searches.map((Function1 & Serializable)x$33 -> x$33.searchResult()), BuildFrom$.MODULE$.buildFromIterableOps(), ec)).getFirstOrError(ec).recoverWith((PartialFunction)new Serializable(searches, ec){
            private static final long serialVersionUID = 0L;
            private final List searches$1;
            private final ExecutionContext ec$8;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)DebugProvider$.MODULE$.scala$meta$internal$metals$debug$DebugProvider$$FindFirstDebugSession(Future$.MODULE$.sequence((IterableOnce)this.searches$1.map((Function1 & Serializable)x$34 -> x$34.retrySearchResult()), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$8)).getFirstOrError(this.ec$8);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.searches$1 = searches$1;
                this.ec$8 = ec$8;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.meta.internal.metals.debug.DebugProvider$ClassSearch )}, serializedLambda);
            }
        }, ec);
    }

    public <A> DebugProvider.FindFirstDebugSession<A> scala$meta$internal$metals$debug$DebugProvider$$FindFirstDebugSession(Future<List<Tuple2<Try<A>, DebugProvider.ClassSearch<A>>>> from) {
        return new DebugProvider.FindFirstDebugSession<A>(from);
    }

    public static final /* synthetic */ String $anonfun$escapeTestName$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            default: 
        }
        if (MODULE$.specialChars().apply((Object)BoxesRunTime.boxToCharacter((char)c))) {
            return "\\" + c;
        }
        return String.valueOf(BoxesRunTime.boxToCharacter((char)c));
    }

    private DebugProvider$() {
    }
}

