/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals;

import coursierapi.Dependency;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.scalafmt.interfaces.Scalafmt;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.meta.internal.builds.BazelBuildTool$;
import scala.meta.internal.metals.BloopServers$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.Embedded$;
import scala.meta.internal.metals.FormattingProvider$;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.internal.metals.logging.MetalsLogger$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class DownloadDependencies$ {
    public static final DownloadDependencies$ MODULE$ = new DownloadDependencies$();
    private static final String metalsBinaryVersion = ScalaVersions$.MODULE$.scalaBinaryVersionFromFullVersion(BuildInfo$.MODULE$.scala213());

    private String metalsBinaryVersion() {
        return metalsBinaryVersion;
    }

    public void main(String[] args) {
        MetalsLogger$.MODULE$.updateDefaultFormat();
        Seq allPaths = (Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.downloadMdoc().$plus$plus(this.downloadScalafmt())).$plus$plus(this.downloadMtags())).$plus$plus(this.downloadSemanticDBScalac())).$plus$plus(this.downloadSemanticDBJavac())).$plus$plus(this.downloadScala())).$plus$plus(this.downloadBloop())).$plus$plus(this.downloadBazelBsp());
        ((IterableOnceOps)allPaths.distinct()).foreach((Function1 & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Path> downloadScala() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading scala library and sources", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScala"), new Line(47), MDC$.MODULE$.instance());
        return (Seq)((IterableOps)BuildInfo$.MODULE$.supportedScala2Versions().flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadScalaSources((String)scalaVersion))).$plus$plus((IterableOnce)BuildInfo$.MODULE$.supportedScala3Versions().flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadScala3Sources((String)scalaVersion)));
    }

    public Seq<Path> downloadMdoc() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading mdoc", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadMdoc"), new Line(56), MDC$.MODULE$.instance());
        return (Seq)BuildInfo$.MODULE$.supportedScala2Versions().flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadMdoc(ScalaVersions$.MODULE$.scalaBinaryVersionFromFullVersion((String)scalaVersion), (Option<String>)None$.MODULE$, Embedded$.MODULE$.downloadMdoc$default$3()));
    }

    public Seq<Path> downloadScalafmt() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading scalafmt", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScalafmt"), new Line(66), MDC$.MODULE$.instance());
        Scalafmt scalafmt = FormattingProvider$.MODULE$.newScalafmt();
        Path tmp = Files.createTempFile("scalafmt", "Foo.scala", new FileAttribute[0]);
        Path config = Files.createTempFile("scalafmt", ".scalafmt.conf", new FileAttribute[0]);
        Files.write(config, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|version = " + BuildInfo$.MODULE$.scalafmtVersion() + "\n          |runner.dialect = scala3")).getBytes(), new OpenOption[0]);
        scalafmt.format(config, tmp, "object Foo { }");
        Files.deleteIfExists(tmp);
        Files.deleteIfExists(config);
        return Embedded$.MODULE$.downloadDependency(Dependency.of((String)"org.scalameta", (String)("scalafmt-cli_" + this.metalsBinaryVersion()), (String)BuildInfo$.MODULE$.scalafmtVersion()), (Option<String>)new Some((Object)BuildInfo$.MODULE$.scala213()), Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    public Seq<Path> downloadMtags() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading mtags", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadMtags"), new Line(89), MDC$.MODULE$.instance());
        return (Seq)BuildInfo$.MODULE$.supportedScalaVersions().flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadMtags((String)scalaVersion, BuildInfo$.MODULE$.metalsVersion()));
    }

    public Seq<Path> downloadSemanticDBScalac() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading semanticdb-scalac", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadSemanticDBScalac"), new Line(96), MDC$.MODULE$.instance());
        return (Seq)BuildInfo$.MODULE$.supportedScala2Versions().flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadSemanticdbScalac((String)scalaVersion));
    }

    public Seq<Path> downloadSemanticDBJavac() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading semanticdb-javac", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadSemanticDBJavac"), new Line(103), MDC$.MODULE$.instance());
        return Embedded$.MODULE$.downloadSemanticdbJavac();
    }

    public Seq<Path> downloadBazelBsp() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading bazel-bsp", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadBazelBsp"), new Line(108), MDC$.MODULE$.instance());
        return Embedded$.MODULE$.downloadDependency(BazelBuildTool$.MODULE$.dependency(), (Option<String>)None$.MODULE$, Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    public Seq<Path> downloadBloop() {
        String version = BloopServers$.MODULE$.defaultBloopVersion();
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading Bloop " + version, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadBloop"), new Line(117), MDC$.MODULE$.instance());
        Either<Throwable, Seq<File>> either = BloopServers$.MODULE$.fetchBloop(version);
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable ex = (Throwable)left.value();
            throw new Exception("Could not pre-download Bloop " + version, ex);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq files = (Seq)right.value();
            return (Seq)files.map((Function1 & Serializable)x$1 -> x$1.toPath());
        }
        throw new MatchError(either);
    }

    private DownloadDependencies$() {
    }
}

