/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.h2.mvstore.MVStoreException;
import org.h2.tools.Upgrade;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.Tables$ConnectionState$Empty$;
import scala.meta.internal.metals.Tables$ConnectionState$InProgress$;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005%c!B\f\u0019\u0003\u0003\t\u0003\u0002\u0003\u0016\u0001\u0005\u0003%\u000b\u0011B\u0016\t\u0011Q\u0002!\u0011!Q\u0001\nUB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0005I\u0011\u0019!\u0007\u0001)A\u0005\u0013\"9Q\r\u0001b\u0001\n\u00131\u0007B\u00027\u0001A\u0003%q\rC\u0003n\u0001\u0011Ea\u000eC\u0003v\u0001\u0011Ea\u000fC\u0003{\u0001\u0011Ea\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0003~\u0001\u0011%A\u0010C\u0003\u007f\u0001\u0011EA\u0010C\u0003\u0000\u0001\u0011EA\u0010C\u0004\u0002\u0002\u0001!\t\"a\u0001\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u0012\u0001\t\u0003\t\tE\u0001\u000bIe\r{gN\\3di&|g\u000e\u0015:pm&$WM\u001d\u0006\u00033i\ta!\\3uC2\u001c(BA\u000e\u001d\u0003!Ig\u000e^3s]\u0006d'BA\u000f\u001f\u0003\u0011iW\r^1\u000b\u0003}\tQa]2bY\u0006\u001c\u0001aE\u0002\u0001E\u0019\u0002\"a\t\u0013\u000e\u0003yI!!\n\u0010\u0003\r\u0005s\u0017PU3g!\t9\u0003&D\u0001\u0019\u0013\tI\u0003D\u0001\u0006DC:\u001cW\r\\1cY\u0016\f\u0011\u0002Z5sK\u000e$xN]=\u0011\u0007\rbc&\u0003\u0002.=\tAAHY=oC6,g\b\u0005\u00020e5\t\u0001G\u0003\u000229\u0005\u0011\u0011n\\\u0005\u0003gA\u0012A\"\u00112t_2,H/\u001a)bi\"\fAA\\1nKB\u0011a'\u0010\b\u0003om\u0002\"\u0001\u000f\u0010\u000e\u0003eR!A\u000f\u0011\u0002\rq\u0012xn\u001c;?\u0013\tad$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f\u001f\u0003)i\u0017n\u001a:bi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r#UI\u0012\t\u0003O\u0001AaA\u000b\u0003\u0005\u0002\u0004Y\u0003\"\u0002\u001b\u0005\u0001\u0004)\u0004\"\u0002!\u0005\u0001\u0004)\u0014a\u0001:fMV\t\u0011\nE\u0002K'Vk\u0011a\u0013\u0006\u0003\u00196\u000ba!\u0019;p[&\u001c'B\u0001(P\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003!F\u000bA!\u001e;jY*\t!+\u0001\u0003kCZ\f\u0017B\u0001+L\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007C\u0001,b\u001d\t9vL\u0004\u0002Y=:\u0011\u0011,\u0018\b\u00035rs!\u0001O.\n\u0003}I!!\b\u0010\n\u0005ma\u0012BA\r\u001b\u0013\t\u0001\u0007$\u0001\u0004UC\ndWm]\u0005\u0003E\u000e\u0014qbQ8o]\u0016\u001cG/[8o'R\fG/\u001a\u0006\u0003Ab\tAA]3gA\u0005!Qo]3s+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016R\u0003\u0011a\u0017M\\4\n\u0005yJ\u0017!B;tKJ\u0004\u0013AC2p]:,7\r^5p]V\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s#\u0006\u00191/\u001d7\n\u0005Q\f(AC\"p]:,7\r^5p]\u0006aq\u000e\u001d;ESJ,7\r^8ssV\tq\u000fE\u0002$q:J!!\u001f\u0010\u0003\r=\u0003H/[8o\u00031!\u0017\r^1cCN,\u0007+\u0019;i\u0003\u001d\u0019wN\u001c8fGR$\u0012a\\\u0001\u000eiJL\u0018)\u001e;p'\u0016\u0014h/\u001a:\u0002\u001fQ\u0014\u0018PT8BkR|7+\u001a:wKJ\f!#\u001b8NK6|'/_\"p]:,7\r^5p]\u0006!\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:$2a\\A\u0003\u0011\u001d\t9\u0001\u0005a\u0001\u0003\u0013\tA\"[:BkR|7+\u001a:wKJ\u00042aIA\u0006\u0013\r\tiA\b\u0002\b\u0005>|G.Z1o\u0003\u0019!(/_+sYR\u0019q.a\u0005\t\r\u0005U\u0011\u00031\u00016\u0003\r)(\u000f\\\u0001\u0010kB<'/\u00193f\u0013\u001atU-\u001a3fIR!\u00111DA\u0011!\r\u0019\u0013QD\u0005\u0004\u0003?q\"\u0001B+oSRDa!!\u0006\u0013\u0001\u0004)\u0014\u0001E7jOJ\fG/Z(s%\u0016\u001cH/\u0019:u)\u0011\tY\"a\n\t\u000f\u0005%2\u00031\u0001\u0002,\u00051a\r\\=xCf\u0004B!!\f\u0002<5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0003d_J,'\u0002BA\u001b\u0003o\t\u0001B\u001a7zo\u0006LHM\u0019\u0006\u0003\u0003s\t1a\u001c:h\u0013\u0011\ti$a\f\u0003\r\u0019c\u0017p^1z\u00039!W\r\\3uK\u0012\u000bG/\u00192bg\u0016$\"!a\u0007\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR\u0011\u0011\u0011B\u0001\u0007G\u0006t7-\u001a7")
public abstract class H2ConnectionProvider
implements Cancelable {
    private final Function0<AbsolutePath> directory;
    private final String name;
    private final String migrations;
    private final AtomicReference<Tables.ConnectionState> ref;
    private final String user;

    public AtomicReference<Tables.ConnectionState> ref() {
        return this.ref;
    }

    private String user() {
        return this.user;
    }

    public Connection connection() {
        return this.connect();
    }

    public Option<AbsolutePath> optDirectory() {
        return Try$.MODULE$.apply(this.directory).toOption();
    }

    public Option<AbsolutePath> databasePath() {
        return this.optDirectory().map((Function1 & Serializable)x$1 -> x$1.resolve("metals.h2.db"));
    }

    public Connection connect() {
        Tables.ConnectionState connectionState = this.ref().get();
        if (Tables$ConnectionState$Empty$.MODULE$.equals(connectionState)) {
            Tables.ConnectionState connectionState2 = connectionState;
            if (this.ref().compareAndSet(connectionState2, Tables$ConnectionState$InProgress$.MODULE$)) {
                Connection conn = this.tryAutoServer();
                this.ref().set(new Tables.ConnectionState.Connected(conn));
                return conn;
            }
            return this.connect();
        }
        if (Tables$ConnectionState$InProgress$.MODULE$.equals(connectionState)) {
            Thread.sleep(100L);
            return this.connect();
        }
        if (connectionState instanceof Tables.ConnectionState.Connected) {
            Tables.ConnectionState.Connected connected = (Tables.ConnectionState.Connected)connectionState;
            Connection conn = connected.conn();
            return conn;
        }
        throw new MatchError((Object)connectionState);
    }

    private Connection tryAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                String message = "unable to setup persistent H2 database with AUTO_SERVER=true, falling back to AUTO_SERVER=false.";
                Throwable throwable4 = throwable2;
                if (throwable4 != null && InterruptException$.MODULE$.unapply(throwable4)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)package$.MODULE$.info((Function0 & Serializable)() -> message, new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("tryAutoServer"), new Line(69), MDC$.MODULE$.instance());
                } else {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("tryAutoServer"), new Line(71), MDC$.MODULE$.instance());
                }
                connection = this.tryNoAutoServer();
            }
            throw throwable;
        }
        return connection;
    }

    public Connection tryNoAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(false);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("tryNoAutoServer"), new Line(82), MDC$.MODULE$.instance());
                connection = this.inMemoryConnection();
            }
            throw throwable;
        }
        return connection;
    }

    public Connection inMemoryConnection() {
        return this.tryUrl("jdbc:h2:mem:" + this.name + ";DB_CLOSE_DELAY=-1");
    }

    public Connection persistentConnection(boolean isAutoServer) {
        String autoServer = isAutoServer ? ";AUTO_SERVER=TRUE" : "";
        AbsolutePath dbfile = ((AbsolutePath)this.directory.apply()).resolve("metals");
        AbsolutePath oldDbfile = ((AbsolutePath)this.directory.apply()).resolve("metals.h2.db");
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(oldDbfile).exists()) {
            package$.MODULE$.info((Function0 & Serializable)() -> "Deleting old database format " + oldDbfile, new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("persistentConnection"), new Line(99), MDC$.MODULE$.instance());
            MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(oldDbfile).delete();
        }
        Files.createDirectories(dbfile.toNIO().getParent(), new FileAttribute[0]);
        System.setProperty("h2.bindAddress", System.getProperty("h2.bindAddress", "127.0.0.1"));
        String url = "jdbc:h2:file:" + dbfile + autoServer;
        this.upgradeIfNeeded(url);
        return this.tryUrl(url);
    }

    private Connection tryUrl(String url) {
        Flyway flyway = Flyway.configure().dataSource(url, this.user(), null).locations(new String[]{"classpath:" + this.migrations}).cleanDisabled(false).load();
        this.migrateOrRestart(flyway);
        return DriverManager.getConnection(url, this.user(), null);
    }

    private void upgradeIfNeeded(String url) {
        int oldVersion = 214;
        String formatVersionChangedMessage = "The write format 2 is smaller than the supported format 3";
        try {
            DriverManager.getConnection(url, this.user(), null).close();
        }
        catch (Throwable throwable) {
            SQLException sQLException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SQLException && (sQLException = (SQLException)throwable2).getErrorCode() == 90048) {
                MVStoreException mVStoreException;
                Throwable throwable3 = sQLException.getCause();
                if (throwable3 instanceof MVStoreException && (mVStoreException = (MVStoreException)throwable3).getErrorCode() == 5 && mVStoreException.getMessage().startsWith(formatVersionChangedMessage)) {
                    BoxedUnit boxedUnit;
                    Properties info = new Properties();
                    info.put("user", this.user());
                    try {
                        boolean didUpgrade = Upgrade.upgrade((String)url, (Properties)info, (int)oldVersion);
                        if (didUpgrade) {
                            boxedUnit = (BoxedUnit)package$.MODULE$.info((Function0 & Serializable)() -> "Upgraded H2 database.", new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("upgradeIfNeeded"), new Line(143), MDC$.MODULE$.instance());
                        } else {
                            this.deleteDatabase();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    catch (Throwable throwable4) {
                        Option option;
                        Throwable throwable5 = throwable4;
                        if (throwable5 == null || (option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            throw throwable4;
                        }
                        this.deleteDatabase();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable3;
            }
            throw throwable;
        }
    }

    private void migrateOrRestart(Flyway flyway) {
        try {
            flyway.migrate();
        }
        catch (FlywayException flywayException) {
            package$.MODULE$.warn((Function0 & Serializable)() -> "resetting database: " + this.databasePath(), new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("migrateOrRestart"), new Line(161), MDC$.MODULE$.instance());
            flyway.clean();
            flyway.migrate();
        }
    }

    private void deleteDatabase() {
        this.optDirectory().foreach((Function1 & Serializable)directory -> {
            H2ConnectionProvider.$anonfun$deleteDatabase$1(directory);
            return BoxedUnit.UNIT;
        });
    }

    public boolean databaseExists() {
        return this.databasePath().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)H2ConnectionProvider.$anonfun$databaseExists$1(x$2)));
    }

    @Override
    public void cancel() {
        Tables.ConnectionState connectionState = this.ref().get();
        if (connectionState instanceof Tables.ConnectionState.Connected) {
            Tables.ConnectionState.Connected connected = (Tables.ConnectionState.Connected)connectionState;
            Connection conn = connected.conn();
            if (this.ref().compareAndSet(connected, Tables$ConnectionState$Empty$.MODULE$)) {
                conn.close();
                return;
            }
            return;
        }
        if (Tables$ConnectionState$InProgress$.MODULE$.equals(connectionState)) {
            Thread.sleep(100L);
            this.cancel();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$deleteDatabase$1(AbsolutePath directory) {
        AbsolutePath dbFile = directory.resolve("metals.mv.db");
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dbFile).exists()) {
            package$.MODULE$.warn((Function0 & Serializable)() -> "Deleting old database, due to failed database upgrade. Non-default build tool and build server choices will be lost.", new Pkg("scala.meta.internal.metals"), new FileName("H2ConnectionProvider.scala"), new Name("deleteDatabase"), new Line(171), MDC$.MODULE$.instance());
            MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(dbFile).delete();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$databaseExists$1(AbsolutePath x$2) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(x$2).exists();
    }

    public H2ConnectionProvider(Function0<AbsolutePath> directory, String name, String migrations) {
        this.directory = directory;
        this.name = name;
        this.migrations = migrations;
        this.ref = new AtomicReference<Tables$ConnectionState$Empty$>(Tables$ConnectionState$Empty$.MODULE$);
        this.user = "sa";
    }
}

