/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.gson.JsonElement;
import java.io.Serializable;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.metals.Compilers;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.HoverExtParams;
import scala.meta.internal.metals.HoverExtParams$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.pc.InlayHints$;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.CancelToken;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\u0007\u000e\u0005YA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tA\u0001\u0011\t\u0011)A\u0005C!AA\u0005\u0001B\u0001B\u0003-Q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015a\u0003-\u0011\u0015y\u0003\u0001\"\u00011\u0011\u00159\u0004\u0001\"\u00019\u0011\u00159\u0004\u0001\"\u0003Q\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u00026\u0001!I!a\u000e\u00031%sG.Y=IS:$(+Z:pYZ,\u0007K]8wS\u0012,'O\u0003\u0002\u000f\u001f\u00051Q.\u001a;bYNT!\u0001E\t\u0002\u0011%tG/\u001a:oC2T!AE\n\u0002\t5,G/\u0019\u0006\u0002)\u0005)1oY1mC\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\u0014\u0013\tQ2C\u0001\u0004B]f\u0014VMZ\u0001\u0013I\u00164\u0017N\\5uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001e=5\tQ\"\u0003\u0002 \u001b\t\u0011B)\u001a4j]&$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003%\u0019w.\u001c9jY\u0016\u00148\u000f\u0005\u0002\u001eE%\u00111%\u0004\u0002\n\u0007>l\u0007/\u001b7feN\f!!Z2\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u001a\u0012AC2p]\u000e,(O]3oi&\u0011!f\n\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0001:d!\tiR&\u0003\u0002/\u001b\ti!+\u001a9peR\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u00196mQ\u0019!g\r\u001b\u0011\u0005u\u0001\u0001\"\u0002\u0013\u0006\u0001\b)\u0003\"B\u0016\u0006\u0001\ba\u0003\"B\u000e\u0006\u0001\u0004a\u0002\"\u0002\u0011\u0006\u0001\u0004\t\u0013a\u0002:fg>dg/\u001a\u000b\u0004s\u0019C\u0005c\u0001\u0014;y%\u00111h\n\u0002\u0007\rV$XO]3\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015!\u00027taRR'BA!C\u0003\u001d)7\r\\5qg\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#?\u0005%Ie\u000e\\1z\u0011&tG\u000fC\u0003H\r\u0001\u0007A(A\u0005j]2\f\u0017\u0010S5oi\")\u0011J\u0002a\u0001\u0015\u0006)Ao\\6f]B\u00111JT\u0007\u0002\u0019*\u0011Q*E\u0001\u0003a\u000eL!a\u0014'\u0003\u0017\r\u000bgnY3m)>\\WM\u001c\u000b\u0006sE\u0013F\u000f \u0005\u0006\u000f\u001e\u0001\r\u0001\u0010\u0005\u0006'\u001e\u0001\r\u0001V\u0001\u000bY\u0006\u0014W\r\u001c)beR\u001c\bcA+^A:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033V\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005q\u001b\u0012a\u00029bG.\fw-Z\u0005\u0003=~\u0013A\u0001T5ti*\u0011Al\u0005\t\u00051\u0005\u001cg-\u0003\u0002c'\t1A+\u001e9mKJ\u0002\"!\u00103\n\u0005\u0015t$AE%oY\u0006L\b*\u001b8u\u0019\u0006\u0014W\r\u001c)beR\u0004B!V4jc&\u0011\u0001n\u0018\u0002\u0007\u000b&$\b.\u001a:\u0011\u0005)tgBA6m!\t96#\u0003\u0002n'\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti7\u0003\u0005\u0002>e&\u00111O\u0010\u0002\t!>\u001c\u0018\u000e^5p]\")Qo\u0002a\u0001m\u0006!\u0001/\u0019;i!\t9(0D\u0001y\u0015\tI\u0018#\u0001\u0002j_&\u00111\u0010\u001f\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u0005\u0006\u0013\u001e\u0001\rAS\u0001\u0011e\u0016\u001cx\u000e\u001c<f\u0019\u0006\u0014W\r\u001c)beR$ra`A\u0001\u0003\u000b\ty\u0001E\u0002'u\rDa!a\u0001\t\u0001\u0004\u0019\u0017!\u00037bE\u0016d\u0007+\u0019:u\u0011\u001d\t9\u0001\u0003a\u0001\u0003\u0013\t\u0001\u0002\\8dCRLwN\u001c\t\u0004{\u0005-\u0011bAA\u0007}\tAAj\\2bi&|g\u000eC\u0003J\u0011\u0001\u0007!*A\u0007hKRd\u0015MY3m!\u0006\u0014Ho\u001d\u000b\u0005\u0003+\t\u0019\u0003E\u0003\u0002\u0018\u0005\u00052-\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003%IW.\\;uC\ndWMC\u0002\u0002 M\t!bY8mY\u0016\u001cG/[8o\u0013\rq\u0016\u0011\u0004\u0005\u0006\u000f&\u0001\r\u0001P\u0001\nO\u0016$8+_7c_2$b!!\u000b\u00020\u0005M\u0002#\u0002\r\u0002,\u0005%\u0011bAA\u0017'\t1q\n\u001d;j_:Da!!\r\u000b\u0001\u0004I\u0017AB:z[\n|G\u000eC\u0003v\u0015\u0001\u0007a/\u0001\u0004sKB|'\u000f\u001e\u000b\u0007\u0003s\ty$!\u0011\u0011\u0007u\tY$C\u0002\u0002>5\u0011aAU3q_J$\b\"B$\f\u0001\u0004a\u0004bBA\"\u0017\u0001\u0007\u0011QI\u0001\u0006KJ\u0014xN\u001d\t\u0004+\u0006\u001d\u0013bAA%?\nIA\u000b\u001b:po\u0006\u0014G.\u001a")
public final class InlayHintResolveProvider {
    private final DefinitionProvider definitionProvider;
    private final Compilers compilers;
    private final ExecutionContextExecutorService ec;
    private final ReportContext rc;

    public Future<InlayHint> resolve(InlayHint inlayHint, CancelToken token) {
        Either either = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Some some;
            Object data;
            Option option = Option$.MODULE$.apply(inlayHint.getData());
            if (option instanceof Some && (data = (some = (Some)option).value()) instanceof JsonElement) {
                JsonElement jsonElement = (JsonElement)data;
                Tuple2 tuple2 = InlayHints$.MODULE$.fromData(jsonElement);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String uri = (String)tuple2._1();
                List labelParts = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)uri, (Object)labelParts);
                String uri2 = (String)tuple22._1();
                List labelParts2 = (List)tuple22._2();
                AbsolutePath path2 = MetalsEnrichments$.MODULE$.XtensionString(uri2).toAbsolutePath();
                return this.resolve(inlayHint, (List<Tuple2<InlayHintLabelPart, Either<String, Position>>>)((List)this.getLabelParts(inlayHint).zip((IterableOnce)labelParts2)), path2, token);
            }
            return Future$.MODULE$.successful((Object)inlayHint);
        }).toEither();
        if (either instanceof Right) {
            Right right = (Right)either;
            Future labelParts = (Future)right.value();
            return labelParts;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable error = (Throwable)left.value();
            package$.MODULE$.warn((Function0 & Serializable)() -> "Failed to resolve inlay hint: " + error, new Pkg("scala.meta.internal.metals"), new FileName("InlayHintResolveProvider.scala"), new Name("resolve"), new Line(44), MDC$.MODULE$.instance());
            this.rc.unsanitized().create((Function0 & Serializable)() -> this.report(inlayHint, error), true);
            return Future$.MODULE$.successful((Object)inlayHint);
        }
        throw new MatchError((Object)either);
    }

    private Future<InlayHint> resolve(InlayHint inlayHint, List<Tuple2<InlayHintLabelPart, Either<String, Position>>> labelParts2, AbsolutePath path2, CancelToken token) {
        List resolveLabelParts = labelParts2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InlayHintLabelPart labelPart = (InlayHintLabelPart)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String symbol = (String)left.value();
                    return (Future)this.getSymbol(symbol, path2).map((Function1 & Serializable)loc -> this.resolveLabelPart(labelPart, (Location)loc, token)).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)labelPart));
                }
            }
            if (tuple2 != null) {
                InlayHintLabelPart labelPart = (InlayHintLabelPart)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Position pos = (Position)right.value();
                    Location location = new Location(path2.toURI().toString(), new Range(pos, pos));
                    return this.resolveLabelPart(labelPart, location, token);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return Future$.MODULE$.sequence((IterableOnce)resolveLabelParts, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.ec).map((Function1 & Serializable)labelParts -> {
            inlayHint.setLabel(MetalsEnrichments$.MODULE$.SeqHasAsJava(labelParts).asJava());
            return inlayHint;
        }, (ExecutionContext)this.ec);
    }

    private Future<InlayHintLabelPart> resolveLabelPart(InlayHintLabelPart labelPart, Location location, CancelToken token) {
        labelPart.setCommand(ServerCommands$.MODULE$.GotoPosition().toLsp(location));
        HoverExtParams hoverParams = new HoverExtParams(new TextDocumentIdentifier(location.getUri()), location.getRange().getStart(), HoverExtParams$.MODULE$.apply$default$3());
        return this.compilers.hover(hoverParams, token).map((Function1 & Serializable)hover -> {
            hover.foreach((Function1 & Serializable)h -> {
                labelPart.setTooltip((MarkupContent)h.toLsp().getContents().getRight());
                return BoxedUnit.UNIT;
            });
            return labelPart;
        }, (ExecutionContext)this.ec);
    }

    private List<InlayHintLabelPart> getLabelParts(InlayHint inlayHint) {
        Either either = MetalsEnrichments$.MODULE$.XtensionJEitherCross(inlayHint.getLabel()).asScala();
        if (either instanceof Left) {
            Left left = (Left)either;
            String text = (String)left.value();
            InlayHintLabelPart label = new InlayHintLabelPart();
            label.setValue(text);
            return new .colon.colon((Object)label, (List)Nil$.MODULE$);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            java.util.List labelParts = (java.util.List)right.value();
            return MetalsEnrichments$.MODULE$.ListHasAsScala(labelParts).asScala().toList();
        }
        throw new MatchError((Object)either);
    }

    private Option<Location> getSymbol(String symbol, AbsolutePath path2) {
        return MetalsEnrichments$.MODULE$.ListHasAsScala(this.definitionProvider.fromSymbol(symbol, (Option<AbsolutePath>)new Some((Object)path2))).asScala().headOption();
    }

    private Report report(InlayHint inlayHint, Throwable error) {
        Position pos = inlayHint.getPosition();
        String x$1 = "inlayHint-resolve";
        String x$2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|pos: " + pos + "\n          |\n          |inlayHint: " + inlayHint + "\n          |"));
        String x$3 = "failed to resolve inlayHint";
        Some x$4 = new Some((Object)error);
        Option x$5 = Report$.MODULE$.apply$default$4();
        Option x$6 = Report$.MODULE$.apply$default$5();
        return new Report("inlayHint-resolve", x$2, "failed to resolve inlayHint", x$5, x$6, (Option)x$4);
    }

    public InlayHintResolveProvider(DefinitionProvider definitionProvider, Compilers compilers, ExecutionContextExecutorService ec, ReportContext rc) {
        this.definitionProvider = definitionProvider;
        this.compilers = compilers;
        this.ec = ec;
        this.rc = rc;
    }
}

