/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.doctor;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.lsp4j.ExecuteCommandParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.HtmlBuilder$;
import scala.meta.internal.metals.MetalsHttpServer;
import scala.meta.internal.metals.ParametrizedCommand;
import scala.meta.internal.metals.Urls$;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.metals.config.DoctorFormat;
import scala.meta.internal.metals.config.DoctorFormat$Html$;
import scala.meta.internal.metals.config.DoctorFormat$Json$;
import scala.meta.internal.metals.doctor.Doctor;
import scala.meta.internal.metals.doctor.DoctorFolderResults;
import scala.meta.internal.metals.doctor.DoctorHeader;
import scala.meta.internal.metals.doctor.DoctorResults;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;
import ujson.Obj;
import ujson.Value;
import ujson.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\u000e\u001c\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!)\u0006A!A!\u0002\u00131\u0006\"B-\u0001\t\u0003Q\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007_\u0002\u0001\u000b\u0011B2\t\u000bA\u0004A\u0011A9\t\u000b]\u0004A\u0011\u0001=\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0002\u0001\u0005\u0002\u0005%\u0001bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!a\u000e\u0001\t\u0013\t9\u0003C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!I\u00111\t\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002H!I\u00111\u000b\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002H!I\u0011q\u000b\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u00033\u0002\u0001\u0015!\u0003\u0002H!9\u00111\f\u0001\u0005\n\u0005\u0015#A\u0003%fC\u0012$un\u0019;pe*\u0011A$H\u0001\u0007I>\u001cGo\u001c:\u000b\u0005yy\u0012AB7fi\u0006d7O\u0003\u0002!C\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002#G\u0005!Q.\u001a;b\u0015\u0005!\u0013!B:dC2\f7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0015\u000e\u0003\rJ!AK\u0012\u0003\r\u0005s\u0017PU3g\u0003\u001d!wn\u0019;peN\u00042\u0001K\u00170\u0013\tq3EA\u0005Gk:\u001cG/[8oaA\u0019\u0001\u0007O\u001e\u000f\u0005E2dB\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b&\u0003\u0019a$o\\8u}%\tA%\u0003\u00028G\u00059\u0001/Y2lC\u001e,\u0017BA\u001d;\u0005\u0011a\u0015n\u001d;\u000b\u0005]\u001a\u0003C\u0001\u001f>\u001b\u0005Y\u0012B\u0001 \u001c\u0005\u0019!un\u0019;pe\u0006Q\u0001\u000e\u001e;q'\u0016\u0014h/\u001a:\u0011\u0007!j\u0013\tE\u0002)\u0005\u0012K!aQ\u0012\u0003\r=\u0003H/[8o!\t)e)D\u0001\u001e\u0013\t9UD\u0001\tNKR\fGn\u001d%uiB\u001cVM\u001d<fe\u0006a1\r\\5f]R\u001cuN\u001c4jOB\u0011QIS\u0005\u0003\u0017v\u00111c\u00117jK:$8i\u001c8gS\u001e,(/\u0019;j_:\fa\u0002\\1oOV\fw-Z\"mS\u0016tG\u000f\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006AA.\u00198hk\u0006<WM\u0003\u0002S;\u000591\r\\5f]R\u001c\u0018B\u0001+P\u0005QiU\r^1mg2\u000bgnZ;bO\u0016\u001cE.[3oi\u0006i\u0011n\u001d%uiB,e.\u00192mK\u0012\u0004\"\u0001K,\n\u0005a\u001b#a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\rmcVLX0a!\ta\u0004\u0001C\u0003,\r\u0001\u0007A\u0006C\u0003@\r\u0001\u0007\u0001\tC\u0003I\r\u0001\u0007\u0011\nC\u0003M\r\u0001\u0007Q\nC\u0003V\r\u0001\u0007a+A\u0005jgZK7/\u001b2mKV\t1\r\u0005\u0002e[6\tQM\u0003\u0002gO\u00061\u0011\r^8nS\u000eT!\u0001[5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002kW\u0006!Q\u000f^5m\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\3\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003)I7OV5tS\ndW\rI\u0001\u0016_:4\u0016n]5cS2LG/\u001f#jI\u000eC\u0017M\\4f)\t\u0011X\u000f\u0005\u0002)g&\u0011Ao\t\u0002\u0005+:LG\u000fC\u0003w\u0013\u0001\u0007a+\u0001\u0005oK^\u001cF/\u0019;f\u0003A\u0001(o\u001c2mK6\u001c\b\n^7m!\u0006<W\rF\u0002z\u0003\u0007\u0001\"A\u001f@\u000f\u0005md\bC\u0001\u001a$\u0013\ti8%\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~G!1\u0011Q\u0001\u0006A\u0002e\f1!\u001e:m\u0003A)\u00070Z2vi\u0016\u0014VO\u001c#pGR|'\u000fF\u0001s\u0003Q)\u00070Z2vi\u0016\u0014VM\u001a:fg\"$un\u0019;pe\u0006iQ\r_3dkR,Gi\\2u_J$RA]A\t\u00037Aq!a\u0005\u000e\u0001\u0004\t)\"A\u0007dY&,g\u000e^\"p[6\fg\u000e\u001a\t\u0005\u000b\u0006]\u00110C\u0002\u0002\u001au\u00111\u0003U1sC6,GO]5{K\u0012\u001cu.\\7b]\u0012Dq!!\b\u000e\u0001\u0004\ty\"\u0001\u0005p]N+'O^3s!\u0015A\u0013\u0011\u0005#s\u0013\r\t\u0019c\t\u0002\n\rVt7\r^5p]F\n\u0001CY;jY\u0012$\u0016M]4fiNDE/\u001c7\u0015\u0003e\f\u0011CY;jY\u0012$\u0016M]4fiN$\u0016M\u00197f)\r\u0011\u0018Q\u0006\u0005\b\u0003_y\u0001\u0019AA\u0019\u0003\u0011AG/\u001c7\u0011\u0007\u0015\u000b\u0019$C\u0002\u00026u\u00111\u0002\u0013;nY\n+\u0018\u000e\u001c3fe\u0006\u0001\"-^5mIR\u000b'oZ3ug*\u001bxN\\\u0001\u000bO\u0016$(\nZ6J]\u001a|GCAA\u001f!\rA#)_\u0001\u001cCJ,W*\u001e7uSBdWmV8sWN\u0004\u0018mY3G_2$WM]:\u0016\u0003Y\u000b1\u0002Z8di>\u0014H+\u001b;mKV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011QJ6\u0002\t1\fgnZ\u0005\u0004\u007f\u0006-\u0013\u0001\u00043pGR|'\u000fV5uY\u0016\u0004\u0013a\u00046eWZ+'o]5p]RKG\u000f\\3\u0002!)$7NV3sg&|g\u000eV5uY\u0016\u0004\u0013AE:feZ,'OV3sg&|g\u000eV5uY\u0016\f1c]3sm\u0016\u0014h+\u001a:tS>tG+\u001b;mK\u0002\naCY;jY\u0012$\u0016M]4fi\u0012+7o\u0019:jaRLwN\u001c")
public class HeadDoctor {
    private final Function0<List<Doctor>> doctors;
    private final Function0<Option<MetalsHttpServer>> httpServer;
    private final ClientConfiguration clientConfig;
    private final MetalsLanguageClient languageClient;
    private final boolean isHttpEnabled;
    private final AtomicBoolean isVisible;
    private final String doctorTitle;
    private final String jdkVersionTitle;
    private final String serverVersionTitle;

    private AtomicBoolean isVisible() {
        return this.isVisible;
    }

    public void onVisibilityDidChange(boolean newState) {
        this.isVisible().set(newState);
    }

    public String problemsHtmlPage(String url) {
        String livereload = Urls$.MODULE$.livereload(url);
        return HtmlBuilder$.MODULE$.apply().page(this.doctorTitle(), (List)new .colon.colon((Object)livereload, (List)new .colon.colon((Object)HtmlBuilder$.MODULE$.htmlCSS(), (List)Nil$.MODULE$)), "style='padding: .75rem; font-size: 10px'", (Function1 & Serializable)html -> {
            html.section("Build targets", (Function1 & Serializable)html -> {
                $this.buildTargetsTable(html);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }).render();
    }

    public void executeRunDoctor() {
        this.onVisibilityDidChange(true);
        this.executeDoctor(ClientCommands$.MODULE$.RunDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & Serializable)server -> {
            Urls$.MODULE$.openBrowser(server.address() + "/doctor");
            return BoxedUnit.UNIT;
        });
    }

    public void executeRefreshDoctor() {
        this.executeDoctor(ClientCommands$.MODULE$.ReloadDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & Serializable)server -> {
            server.reload();
            return BoxedUnit.UNIT;
        });
    }

    private void executeDoctor(ParametrizedCommand<String> clientCommand, Function1<MetalsHttpServer, BoxedUnit> onServer) {
        boolean shouldDisplay;
        boolean isVisibilityProvider = this.clientConfig.isDoctorVisibilityProvider();
        boolean bl = shouldDisplay = isVisibilityProvider && this.isVisible().get();
        if (shouldDisplay || !isVisibilityProvider) {
            if (this.clientConfig.isExecuteClientCommandProvider() && !this.clientConfig.isHttpEnabled()) {
                String string;
                DoctorFormat.DoctorFormat doctorFormat = this.clientConfig.doctorFormat();
                if (DoctorFormat$Json$.MODULE$.equals(doctorFormat)) {
                    string = this.buildTargetsJson();
                } else if (DoctorFormat$Html$.MODULE$.equals(doctorFormat)) {
                    string = this.buildTargetsHtml();
                } else {
                    throw new MatchError((Object)doctorFormat);
                }
                String output = string;
                ExecuteCommandParams params = clientCommand.toExecuteCommandParams(output);
                this.languageClient.metalsExecuteClientCommand(params);
                return;
            }
            boolean bl2 = false;
            Option option = null;
            Option option2 = (Option)this.httpServer.apply();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                MetalsHttpServer server = (MetalsHttpServer)some.value();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)onServer.apply((Object)server);
                return;
            }
            if (None$.MODULE$.equals(option2)) {
                bl2 = true;
                option = option2;
                if (!this.isHttpEnabled) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)scribe.package$.MODULE$.warn((Function0 & Serializable)() -> "Unable to run doctor. Make sure `isHttpEnabled` is set to `true`.", new Pkg("scala.meta.internal.metals.doctor"), new FileName("HeadDoctor.scala"), new Name("executeDoctor"), new Line(90), MDC$.MODULE$.instance());
                    return;
                }
            }
            if (bl2) {
                BoxedUnit cfr_ignored_2 = (BoxedUnit)scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Doctor was not yet started, check logs to make sure it's running", new Pkg("scala.meta.internal.metals.doctor"), new FileName("HeadDoctor.scala"), new Name("executeDoctor"), new Line(94), MDC$.MODULE$.instance());
                return;
            }
            throw new MatchError((Object)option2);
        }
    }

    private String buildTargetsHtml() {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$12 = "h1";
        String x$2 = qual$1.element$default$2();
        Function1 & Serializable x$3 = (Function1 & Serializable)x$1 -> {
            x$1.text(this.doctorTitle());
            return BoxedUnit.UNIT;
        };
        return qual$1.element("h1", x$2, (Function1)x$3).call((Function1 & Serializable)html -> {
            this.buildTargetsTable(html);
            return BoxedUnit.UNIT;
        }).render();
    }

    private void buildTargetsTable(HtmlBuilder html) {
        Option<String> jdkInfo = this.getJdkInfo();
        jdkInfo.foreach((Function1 & Serializable)jdkMsg -> html.element("p", html.element$default$2(), (Function1 & Serializable)builder -> {
            HeadDoctor.$anonfun$buildTargetsTable$2(this, jdkMsg, builder);
            return BoxedUnit.UNIT;
        }));
        html.element("p", html.element$default$2(), (Function1 & Serializable)builder -> {
            HeadDoctor.$anonfun$buildTargetsTable$3(this, builder);
            return BoxedUnit.UNIT;
        });
        html.element("p", html.element$default$2(), (Function1 & Serializable)x$2 -> {
            x$2.text(this.buildTargetDescription());
            return BoxedUnit.UNIT;
        });
        boolean includeWorkspaceFolderName = this.areMultipleWorkspaceFolders();
        ((List)this.doctors.apply()).foreach((Function1 & Serializable)x$3 -> {
            x$3.buildTargetsTable(html, includeWorkspaceFolderName);
            return BoxedUnit.UNIT;
        });
    }

    private String buildTargetsJson() {
        List results = ((List)this.doctors.apply()).map((Function1 & Serializable)x$4 -> x$4.buildTargetsJson());
        Option jdkInfo = this.getJdkInfo().map((Function1 & Serializable)info -> this.jdkVersionTitle() + info);
        String serverInfo = this.serverVersionTitle() + BuildInfo$.MODULE$.metalsVersion();
        DoctorHeader header = new DoctorHeader((Option<String>)jdkInfo, serverInfo, this.buildTargetDescription());
        Obj result = new DoctorResults(this.doctorTitle(), header, (List<DoctorFolderResults>)results).toJson();
        return package$.MODULE$.write((Value)result, package$.MODULE$.write$default$2(), package$.MODULE$.write$default$3(), package$.MODULE$.write$default$4());
    }

    private Option<String> getJdkInfo() {
        return Option$.MODULE$.apply((Object)System.getProperty("java.version")).flatMap((Function1 & Serializable)version -> Option$.MODULE$.apply((Object)System.getProperty("java.vendor")).flatMap((Function1 & Serializable)vendor -> Option$.MODULE$.apply((Object)System.getProperty("java.home")).map((Function1 & Serializable)home -> version + " from " + vendor + " located at " + home)));
    }

    private boolean areMultipleWorkspaceFolders() {
        return ((List)this.doctors.apply()).length() > 1;
    }

    private String doctorTitle() {
        return this.doctorTitle;
    }

    private String jdkVersionTitle() {
        return this.jdkVersionTitle;
    }

    private String serverVersionTitle() {
        return this.serverVersionTitle;
    }

    private String buildTargetDescription() {
        return "Below are listed the build targets " + (this.areMultipleWorkspaceFolders() ? "for each workspace folder. " : "for this workspace. ") + "One build target corresponds to one classpath. For example, normally one sbt project maps to two build targets: main and test.";
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$2(HeadDoctor $this, String jdkMsg$1, HtmlBuilder builder) {
        builder.bold($this.jdkVersionTitle());
        builder.text(jdkMsg$1);
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$3(HeadDoctor $this, HtmlBuilder builder) {
        builder.bold($this.serverVersionTitle());
        builder.text(BuildInfo$.MODULE$.metalsVersion());
    }

    public HeadDoctor(Function0<List<Doctor>> doctors, Function0<Option<MetalsHttpServer>> httpServer, ClientConfiguration clientConfig, MetalsLanguageClient languageClient, boolean isHttpEnabled) {
        this.doctors = doctors;
        this.httpServer = httpServer;
        this.clientConfig = clientConfig;
        this.languageClient = languageClient;
        this.isHttpEnabled = isHttpEnabled;
        this.isVisible = new AtomicBoolean(false);
        this.doctorTitle = "Metals Doctor";
        this.jdkVersionTitle = "Metals Java: ";
        this.serverVersionTitle = "Metals Server version: ";
    }
}

