/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals;

import java.io.Serializable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.semver.SemVer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005i3Q!\u0003\u0006\u0002\u0002EAQA\u0006\u0001\u0005\u0002]AqA\u0007\u0001C\u0002\u0013\r1\u0004\u0003\u0004#\u0001\u0001\u0006I\u0001\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006u\u0001!Ia\u000f\u0005\u0006\u0005\u0002!Ia\u0011\u0005\u0006\u0011\u00021\t\"\u0013\u0005\u0006/\u0002!I\u0001\u0017\u0002\u0017'V\u0004\bo\u001c:uK\u0012\u001c6-\u00197b-\u0016\u00148/[8og*\u00111\u0002D\u0001\u0007[\u0016$\u0018\r\\:\u000b\u00055q\u0011\u0001B7fi\u0006T\u0011aD\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\ta\"\u0003\u0002\u0016\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0006\u0002\u0005\u0015\u001cW#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011AC2p]\u000e,(O]3oi&\u0011\u0011E\b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u0003]\u0019X\u000f\u001d9peR,GMV3sg&|gn]*ue&tw\rF\u0002&aI\u0002\"AJ\u0017\u000f\u0005\u001dZ\u0003C\u0001\u0015\u000f\u001b\u0005I#B\u0001\u0016\u0011\u0003\u0019a$o\\8u}%\u0011AFD\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-\u001d!)\u0011\u0007\u0002a\u0001K\u00059a/\u001a:tS>t\u0007\"B\u001a\u0005\u0001\u0004!\u0014a\u0002;j[\u0016|W\u000f\u001e\t\u0003kaj\u0011A\u000e\u0006\u0003oy\t\u0001\u0002Z;sCRLwN\\\u0005\u0003sY\u0012aBR5oSR,G)\u001e:bi&|g.\u0001\tgS:$\u0017\t\u001c7TkB\u0004xN\u001d;fIR\u0019AhP!\u0011\u0007MiT%\u0003\u0002?\u001d\t1q\n\u001d;j_:DQ\u0001Q\u0003A\u0002\u0015\nQ\"\\3uC2\u001ch+\u001a:tS>t\u0007\"B\u001a\u0006\u0001\u0004!\u0014!E:vaB|'\u000f^3e\u0013:lU\r^1mgR!A\b\u0012$H\u0011\u0015)e\u00011\u0001&\u0003\r)(\u000f\u001c\u0005\u0006\u0001\u001a\u0001\r!\n\u0005\u0006g\u0019\u0001\r\u0001N\u0001\rM>\u0014X.\u0019;TS:<G.\u001a\u000b\u0004K)c\u0005\"B&\b\u0001\u0004)\u0013!B7bU>\u0014\b\"B'\b\u0001\u0004q\u0015\u0001\u0003<feNLwN\\:\u0011\u0007=#VE\u0004\u0002Q%:\u0011\u0001&U\u0005\u0002\u001f%\u00111KD\u0001\ba\u0006\u001c7.Y4f\u0013\t)fKA\u0002TKFT!a\u0015\b\u0002\u001d\u0019|'/\\1u-\u0016\u00148/[8ogR\u0011Q%\u0017\u0005\u0006\u001b\"\u0001\rA\u0014")
public abstract class SupportedScalaVersions {
    private final ExecutionContext ec = ExecutionContext$.MODULE$.global();

    public ExecutionContext ec() {
        return this.ec;
    }

    public String supportedVersionsString(String version, FiniteDuration timeout) {
        return (String)this.findAllSupported(version, timeout).getOrElse((Function0 & Serializable)() -> this.formatVersions(BuildInfo$.MODULE$.supportedScalaVersions()));
    }

    private Option<String> findAllSupported(String metalsVersion, FiniteDuration timeout) {
        String url = metalsVersion.contains("SNAPSHOT") ? "https://oss.sonatype.org/content/repositories/snapshots/org/scalameta/" : "https://repo1.maven.org/maven2/org/scalameta/";
        return this.supportedInMetals(url, metalsVersion, timeout);
    }

    private Option<String> supportedInMetals(String url, String metalsVersion, FiniteDuration timeout) {
        Some some;
        try {
            Predef$.MODULE$.println((Object)("Checking available versions on " + url + "\n"));
            Document allScalametaArtifacts = Jsoup.connect((String)url).get();
            Buffer allMdocs = (Buffer)scala.meta.internal.jdk.package$.MODULE$.CollectionConverters().ListHasAsScala((java.util.List)allScalametaArtifacts.select("a")).asScala().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)SupportedScalaVersions.$anonfun$supportedInMetals$1(a)));
            Iterator allSupportedScalaFut = allMdocs.iterator().map((Function1 & Serializable)mdocLink -> {
                if (mdocLink.text().contains("NIGHTLY")) {
                    return Future$.MODULE$.successful((Object)None$.MODULE$);
                }
                String link = mdocLink.attr("href");
                String mtagsLink = link.startsWith("http") ? link : url + link;
                return Future$.MODULE$.apply((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> Jsoup.connect((String)(mtagsLink + metalsVersion)).get()), this.ec()).map((Function1 & Serializable)x0$1 -> {
                    Try try_ = x0$1;
                    if (try_ instanceof Success) {
                        return new Some((Object)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(mdocLink.text()), "mtags_")), "/"));
                    }
                    if (try_ instanceof Failure) {
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)try_);
                }, this.ec());
            });
            Iterator allSupportedScala = ((Iterator)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)allSupportedScalaFut, BuildFrom$.MODULE$.buildFromIterator(), this.ec()), (Duration)timeout)).flatten(Predef$.MODULE$.$conforms());
            String template = this.formatVersions((Seq<String>)allSupportedScala.toList());
            some = new Some((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + template + "\n            |Scala 3 versions from 3.3.4 are automatically supported by Metals.\n            |\n            |Any older Scala versions will no longer get bugfixes, but should still\n            |work properly with newest Metals. \n            |")));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Could not check supported Scala versions, returning list available at release"), LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> throwable2)}), new Pkg("scala.meta.metals"), new FileName("SupportedScalaVersions.scala"), new Name("supportedInMetals"), new Line(93), MDC$.MODULE$.instance());
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public abstract String formatSingle(String var1, Seq<String> var2);

    private String formatVersions(Seq<String> versions) {
        return ((List)versions.toList().map((Function1 & Serializable)version -> SemVer.Version$.MODULE$.fromString(version)).groupBy((Function1 & Serializable)version -> {
            if (version.major() == 2) {
                return Integer.toString(version.major()) + "." + version.minor();
            }
            return Integer.toString(version.major());
        }).toList().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String major = (String)tuple2._1();
                List vers = (List)tuple2._2();
                return this.formatSingle(major, (Seq<String>)((List)vers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.patch()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$3 -> x$3.toString()));
            }
            throw new MatchError((Object)tuple2);
        }).mkString("");
    }

    public static final /* synthetic */ boolean $anonfun$supportedInMetals$1(Element a) {
        String name = a.text();
        return name.contains("mtags_");
    }
}

