/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.ReportFileName$;
import scala.meta.internal.metals.ReportLevel;
import scala.meta.internal.metals.Reporter;
import scala.meta.internal.metals.StdReportContext$;
import scala.meta.internal.metals.TimeFormatter$;
import scala.meta.internal.metals.utils.LimitedFilesManager;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.meta.pc.reports.Report;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\u000f\u001e\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005i!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!Y\u0006A!b\u0001\n\u0003b\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000by\u0003A\u0011A0\t\u000f\u0019\u0004!\u0019!C\u0005O\"1\u0001\u000f\u0001Q\u0001\n!Dq!\u001d\u0001C\u0002\u0013\u0005!\u000f\u0003\u0004t\u0001\u0001\u0006I\u0001\u000e\u0005\ti\u0002A)\u0019!C\u0005e\"9Q\u000f\u0001b\u0001\n\u00131\bBB?\u0001A\u0003%q\u000f\u0003\u0005\u007f\u0001!\u0015\r\u0011\"\u0003\u0000\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u0006\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005\"CAX\u0001E\u0005I\u0011AAY\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!a3\u0001\t\u0003\nYDA\u0006Ti\u0012\u0014V\r]8si\u0016\u0014(B\u0001\u0010 \u0003\u0019iW\r^1mg*\u0011\u0001%I\u0001\tS:$XM\u001d8bY*\u0011!eI\u0001\u0005[\u0016$\u0018MC\u0001%\u0003\u0015\u00198-\u00197b\u0007\u0001\u00192\u0001A\u00140!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003mC:<'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012aa\u00142kK\u000e$\bC\u0001\u00192\u001b\u0005i\u0012B\u0001\u001a\u001e\u0005!\u0011V\r]8si\u0016\u0014\u0018!C<pe.\u001c\b/Y2f!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003gS2,'BA\u001d,\u0003\rq\u0017n\\\u0005\u0003wY\u0012A\u0001U1uQ\u0006i\u0001/\u0019;i)>\u0014V\r]8siN\f!C]3t_24XMQ;jY\u0012$\u0016M]4fiB!q\b\u0011\"L\u001b\u0005\u0019\u0013BA!$\u0005%1UO\\2uS>t\u0017\u0007E\u0002@\u0007\u0016K!\u0001R\u0012\u0003\r=\u0003H/[8o!\t1\u0015*D\u0001H\u0015\tA5&A\u0002oKRL!AS$\u0003\u0007U\u0013\u0016\nE\u0002@\u00072\u0003\"!\u0014+\u000f\u00059\u0013\u0006CA($\u001b\u0005\u0001&BA)&\u0003\u0019a$o\\8u}%\u00111kI\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002TG\u0005)A.\u001a<fYB\u0011\u0001'W\u0005\u00035v\u00111BU3q_J$H*\u001a<fY\u0006!a.Y7f+\u0005a\u0015!\u00028b[\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004aC\n\u001cG-\u001a\t\u0003a\u0001AQaM\u0004A\u0002QBQ\u0001P\u0004A\u0002QBQ!P\u0004A\u0002yBQaV\u0004A\u0002aCQaW\u0004A\u00021\u000ba\u0001\\8hO\u0016\u0014X#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017a\u00027pO\u001eLgn\u001a\u0006\u0003[.\nA!\u001e;jY&\u0011qN\u001b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005yQ.Y=cKJ+\u0007o\u001c:ug\u0012K'/F\u00015\u0003Ai\u0017-\u001f2f%\u0016\u0004xN\u001d;t\t&\u0014\b%\u0001\u0006sKB|'\u000f^:ESJ\f1\u0003\\5nSR,GMR5mKNl\u0015M\\1hKJ,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003uv\tQ!\u001e;jYNL!\u0001`=\u0003'1KW.\u001b;fI\u001aKG.Z:NC:\fw-\u001a:\u0002)1LW.\u001b;fI\u001aKG.Z:NC:\fw-\u001a:!\u0003!)8/\u001a:I_6,WCAA\u0001!\u0011y4)a\u0001\u0011\u0007!\n)!\u0003\u0002VS\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\r\u0005$x.\\5d\u0015\r\t)\u0002\\\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\r\u0003\u001f\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013\u0001\u0003:fa>\u0014H/\u001a3\u0016\u0005\u0005\u0005\u0002CBA\u0007\u0003G\t9#\u0003\u0003\u0002&\u0005=!aD!u_6L7MU3gKJ,gnY3\u0011\r\u0005%\u00121\u0007'5\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!C5n[V$\u0018M\u00197f\u0015\r\t\tdI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001b\u0003W\u00111!T1q\u0003%\u0011X\r]8si\u0016$\u0007%A\u0005sK\u0006$\u0017J\\%egR\u0011\u0011Q\b\t\u0004\u007f\u0005}\u0012bAA!G\t!QK\\5u\u0003\u0019\u0019'/Z1uKR1\u0011qIA(\u0003_\u0002R!!\u0013\u0002LQj\u0011\u0001\\\u0005\u0004\u0003\u001bb'\u0001C(qi&|g.\u00197\t\u000f\u0005ES\u00031\u0001\u0002T\u0005QA.\u0019>z%\u0016\u0004xN\u001d;\u0011\r\u0005U\u00131LA0\u001b\t\t9FC\u0002\u0002Z1\f\u0001BZ;oGRLwN\\\u0005\u0005\u0003;\n9F\u0001\u0005TkB\u0004H.[3s!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nqA]3q_J$8OC\u0002\u0002j\u0005\n!\u0001]2\n\t\u00055\u00141\r\u0002\u0007%\u0016\u0004xN\u001d;\t\u000f\u0005ET\u00031\u0001\u0002t\u0005I\u0011N\u001a,fe\n|7/\u001a\t\u0004Q\u0005U\u0014bAA<S\t9!i\\8mK\u0006t\u0017\u0001C:b]&$\u0018N_3\u0015\u00071\u000bi\b\u0003\u0004\u0002\u0000Y\u0001\r\u0001T\u0001\u0005i\u0016DH/\u0001\u0006sKB|'\u000f\u001e)bi\"$2\u0001NAC\u0011\u001d\t9i\u0006a\u0001\u0003?\naA]3q_J$\u0018!E2mK\u0006tW\u000b](mIJ+\u0007o\u001c:ugR!\u0011QRAS!\u0019\ty)!'\u0002 :!\u0011\u0011SAK\u001d\ry\u00151S\u0005\u0002I%\u0019\u0011qS\u0012\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005]5\u0005E\u0002y\u0003CK1!a)z\u0005=!\u0016.\\3ti\u0006l\u0007/\u001a3GS2,\u0007\"CAT1A\u0005\t\u0019AAU\u0003Ai\u0017\r\u001f*fa>\u0014Ho\u001d(v[\n,'\u000fE\u0002@\u0003WK1!!,$\u0005\rIe\u000e^\u0001\u001cG2,\u0017M\\+q\u001f2$'+\u001a9peR\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M&\u0006BAU\u0003k[#!a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003\u001c\u0013AC1o]>$\u0018\r^5p]&!\u0011QYA^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bO\u0016$(+\u001a9peR\u001cHCAAG\u0003%!W\r\\3uK\u0006cG\u000e")
public class StdReporter
implements Reporter {
    private Path reportsDir;
    private Option<String> userHome;
    private final Path workspace;
    private final Function1<Option<URI>, Option<String>> resolveBuildTarget;
    private final ReportLevel level;
    private final String name;
    private final Logger logger;
    private final Path maybeReportsDir;
    private final LimitedFilesManager limitedFilesManager;
    private final AtomicBoolean initialized;
    private final AtomicReference<Map<String, Path>> reported;
    private volatile byte bitmap$0;

    @Override
    public String name() {
        return this.name;
    }

    private Logger logger() {
        return this.logger;
    }

    public Path maybeReportsDir() {
        return this.maybeReportsDir;
    }

    private Path reportsDir$lzycompute() {
        StdReporter stdReporter = this;
        synchronized (stdReporter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reportsDir = CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(this.maybeReportsDir()).createDirectories();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reportsDir;
    }

    private Path reportsDir() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.reportsDir$lzycompute();
        }
        return this.reportsDir;
    }

    private LimitedFilesManager limitedFilesManager() {
        return this.limitedFilesManager;
    }

    private Option<String> userHome$lzycompute() {
        StdReporter stdReporter = this;
        synchronized (stdReporter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.userHome = Option$.MODULE$.apply((Object)System.getProperty("user.home"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.userHome;
    }

    private Option<String> userHome() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.userHome$lzycompute();
        }
        return this.userHome;
    }

    private AtomicBoolean initialized() {
        return this.initialized;
    }

    private AtomicReference<Map<String, Path>> reported() {
        return this.reported;
    }

    public void readInIds() {
        Map reports = this.getReports().flatMap((Function1 & Serializable)report -> {
            Object object;
            try {
                java.util.List<String> lines = Files.readAllLines(report.file().toPath());
                if (lines.size() > 0) {
                    String string = lines.get(0);
                    switch (string == null ? 0 : string.hashCode()) {
                        default: 
                    }
                    object = string.startsWith(Report$.MODULE$.idPrefix()) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(string), Report$.MODULE$.idPrefix())), (Object)report.toPath())) : None$.MODULE$;
                } else {
                    object = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    object = None$.MODULE$;
                }
                throw throwable;
            }
            return object;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.reported().updateAndGet(x$5 -> (Map)x$5.$plus$plus((IterableOnce)reports));
    }

    public Optional<Path> create(Supplier<Report> lazyReport, Boolean ifVerbose) {
        if (Predef$.MODULE$.Boolean2boolean(ifVerbose) && !this.level.isVerbose()) {
            return Optional.empty();
        }
        return CommonMtagsEnrichments$.MODULE$.XtensionOptionScala(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Path pathToReport;
            block1: {
                if (this.initialized().compareAndSet(false, true)) {
                    this.readInIds();
                }
                Report report = (Report)lazyReport.get();
                Option sanitizedId = CommonMtagsEnrichments$.MODULE$.XtensionOptionalJava(report.id()).asScala().map((Function1 & Serializable)text -> this.sanitize((String)text));
                Path path2 = this.reportPath(report);
                Option optDuplicate = sanitizedId.map((Function1 & Serializable)id -> {
                    Map<String, Path> reportedMap = this.reported().getAndUpdate(map -> {
                        if (map.contains(id)) {
                            return map;
                        }
                        return (Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(id), (Object)path2));
                    });
                    return new Tuple2(id, reportedMap);
                }).flatMap((Function1 & Serializable)x$6 -> {
                    Tuple2 tuple2 = x$6;
                    if (tuple2 != null) {
                        String id = (String)tuple2._1();
                        Map reportedMap = (Map)tuple2._2();
                        return reportedMap.get((Object)id).map((Function1 & Serializable)duplicate -> duplicate);
                    }
                    throw new MatchError((Object)tuple2);
                });
                pathToReport = (Path)optDuplicate.getOrElse((Function0 & Serializable)() -> {
                    CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path2).createDirectories();
                    CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path2).writeText(this.sanitize(report.fullText(true)));
                    return path2;
                });
                if (Predef$.MODULE$.Boolean2boolean(ifVerbose)) break block1;
                this.logger().warning(report.shortSummary() + " (full report at: " + pathToReport + ")");
            }
            return pathToReport;
        }).toOption()).asJava();
    }

    @Override
    public String sanitize(String text) {
        String textAfterWokspaceReplace = text.replace(((Object)this.workspace).toString(), StdReportContext$.MODULE$.WORKSPACE_STR());
        return (String)this.userHome().map((Function1 & Serializable)x$7 -> textAfterWokspaceReplace.replace((CharSequence)x$7, StdReportContext$.MODULE$.HOME_STR())).getOrElse((Function0 & Serializable)() -> textAfterWokspaceReplace);
    }

    private Path reportPath(Report report) {
        String date = TimeFormatter$.MODULE$.getDate();
        String time = TimeFormatter$.MODULE$.getTime();
        String buildTargetPart = (String)((Option)this.resolveBuildTarget.apply((Object)CommonMtagsEnrichments$.MODULE$.XtensionOptionalJava(report.path()).asScala())).map((Function1 & Serializable)x$8 -> StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("_("), x$8)), ")")).getOrElse((Function0 & Serializable)() -> "");
        String filename = "r_" + report.name() + buildTargetPart + "_" + time + ".md";
        return this.reportsDir().resolve(date).resolve(filename);
    }

    @Override
    public List<TimestampedFile> cleanUpOldReports(int maxReportsNumber) {
        return this.limitedFilesManager().deleteOld(maxReportsNumber);
    }

    @Override
    public int cleanUpOldReports$default$1() {
        return StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS();
    }

    @Override
    public List<TimestampedFile> getReports() {
        return this.limitedFilesManager().getAllFiles();
    }

    @Override
    public void deleteAll() {
        this.getReports().foreach((Function1 & Serializable)r -> {
            StdReporter.$anonfun$deleteAll$3(r);
            return BoxedUnit.UNIT;
        });
        this.limitedFilesManager().directoriesWithDate().foreach((Function1 & Serializable)d -> {
            StdReporter.$anonfun$deleteAll$4(d);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAll$3(TimestampedFile r) {
        Files.delete(r.toPath());
    }

    public static final /* synthetic */ void $anonfun$deleteAll$4(File d) {
        Files.delete(d.toPath());
    }

    public StdReporter(Path workspace, Path pathToReports, Function1<Option<URI>, Option<String>> resolveBuildTarget, ReportLevel level, String name) {
        this.workspace = workspace;
        this.resolveBuildTarget = resolveBuildTarget;
        this.level = level;
        this.name = name;
        Reporter.$init$(this);
        this.logger = Logger.getLogger(ReportContext.class.getName());
        this.maybeReportsDir = workspace.resolve(pathToReports).resolve(name);
        this.limitedFilesManager = new LimitedFilesManager(this.maybeReportsDir(), StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS(), ReportFileName$.MODULE$.pattern(), ".md");
        this.initialized = new AtomicBoolean(false);
        this.reported = new AtomicReference<Object>(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }
}

