/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.internal.metals.Classfile$;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.Messages$WorkspaceSymbolDependencies$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.SemanticdbDefinition;
import scala.meta.internal.metals.SemanticdbDefinition$;
import scala.meta.internal.metals.WorkspaceSearchVisitor$;
import scala.meta.internal.metals.WorkspaceSymbolQuery;
import scala.meta.internal.mtags.GlobalSymbolIndex;
import scala.meta.internal.mtags.Symbol;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.SymbolSearchVisitor;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001\u0002\u0010 \u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011\u0005\u0004!\u0011!Q\u0001\f\tDQ!\u001a\u0001\u0005\u0002\u0019Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA\u001d\u0005\b\u007f\u0002\u0011\r\u0011\"\u0003r\u0011\u001d\t\t\u0001\u0001Q\u0001\nID\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u000fAq!!\t\u0001\t\u0003\t\u0019\u0003C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0003C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002L!A\u0011Q\f\u0001!\u0002\u0013\ti\u0005C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBA]\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u0003\u0004A\u0011IAb\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f<\u0011\"!4 \u0003\u0003E\t!a4\u0007\u0011yy\u0012\u0011!E\u0001\u0003#Da!Z\u000e\u0005\u0002\u0005e\u0007\"CAn7E\u0005I\u0011AAo\u0005Y9vN]6ta\u0006\u001cWmU3be\u000eDg+[:ji>\u0014(B\u0001\u0011\"\u0003\u0019iW\r^1mg*\u0011!eI\u0001\tS:$XM\u001d8bY*\u0011A%J\u0001\u0005[\u0016$\u0018MC\u0001'\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0013A\u00019d\u0013\tq3FA\nTs6\u0014w\u000e\\*fCJ\u001c\u0007NV5tSR|'/A\u0005x_J\\7\u000f]1dKB\u0011\u0011\u0007N\u0007\u0002e)\u00111gI\u0001\u0003S>L!!\u000e\u001a\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\u000bE,XM]=\u0011\u0005aJT\"A\u0010\n\u0005iz\"\u0001F,pe.\u001c\b/Y2f'fl'm\u001c7Rk\u0016\u0014\u00180A\u0003u_.,g\u000e\u0005\u0002>\r6\taH\u0003\u0002@\u0001\u00069!n]8oeB\u001c'BA!C\u0003\u0015a7\u000f\u001d\u001bk\u0015\t\u0019E)A\u0004fG2L\u0007o]3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9eHA\u0007DC:\u001cW\r\\\"iK\u000e\\WM]\u0001\u0006S:$W\r\u001f\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u0006\nQ!\u001c;bONL!AT&\u0003#\u001dcwNY1m'fl'm\u001c7J]\u0012,\u00070A\ntCZ,7\t\\1tg\u001aKG.\u001a+p\t&\u001c8\u000e\u0005\u0002R%6\tQ%\u0003\u0002TK\t9!i\\8mK\u0006t\u0017A\u0004:fgVdGo\u0014:eKJLgn\u001a\t\u0004-z\u0003dBA,]\u001d\tA6,D\u0001Z\u0015\tQv%\u0001\u0004=e>|GOP\u0005\u0002M%\u0011Q,J\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006M\u0001\u0005Pe\u0012,'/\u001b8h\u0015\tiV%\u0001\u0002sGB\u0011\u0001hY\u0005\u0003I~\u0011QBU3q_J$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0004hU.dWN\\8\u0015\u0005!L\u0007C\u0001\u001d\u0001\u0011\u0015\t\u0007\u0002q\u0001c\u0011\u0015y\u0003\u00021\u00011\u0011\u00151\u0004\u00021\u00018\u0011\u0015Y\u0004\u00021\u0001=\u0011\u0015A\u0005\u00021\u0001J\u0011\u0015y\u0005\u00021\u0001Q\u0011\u001d!\u0006\u0002%AA\u0002U\u000bQB\u001a:p[^{'o[:qC\u000e,W#\u0001:\u0011\u0007MD(0D\u0001u\u0015\t)h/\u0001\u0003vi&d'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u0005mdX\"\u0001!\n\u0005u\u0004%!E*z[\n|G.\u00138g_Jl\u0017\r^5p]\u0006qaM]8n/>\u00148n\u001d9bG\u0016\u0004\u0013!\u00044s_6\u001cE.Y:ta\u0006$\b.\u0001\bge>l7\t\\1tgB\fG\u000f\u001b\u0011\u0002#\t,hMZ3sK\u0012\u001cE.Y:ta\u0006$\b.\u0006\u0002\u0002\bA!1\u000f_A\u0005!\u001d\t\u00161BA\b\u0003\u001fI1!!\u0004&\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011CA\r\u001d\u0011\t\u0019\"!\u0006\u0011\u0005a+\u0013bAA\fK\u00051\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u0006&\u0003I\u0011WO\u001a4fe\u0016$7\t\\1tgB\fG\u000f\u001b\u0011\u0002\u0015\u0005dGNU3tk2$8\u000f\u0006\u0002\u0002&A!a+a\n{\u0013\r\tI\u0003\u0019\u0002\u0004'\u0016\f\u0018\u0001\u00042z\u001d\u0006lW\rT3oORDWCAA\u0018%\u0019\t\t$a\u000e\u0002D\u00191\u00111G\t\u0001\u0003_\u0011A\u0002\u0010:fM&tW-\\3oiz\nQBY=OC6,G*\u001a8hi\"\u0004\u0003\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub/\u0001\u0003mC:<\u0017\u0002BA!\u0003w\u0011aa\u00142kK\u000e$\b\u0003B:\u0002FiL1!a\u0012u\u0005)\u0019u.\u001c9be\u0006$xN]\u0001\nSN4\u0016n]5uK\u0012,\"!!\u0014\u0011\u000b\u0005=\u0013\u0011\f\u0019\u000e\u0005\u0005E#\u0002BA*\u0003+\nq!\\;uC\ndWMC\u0002\u0002X\u0015\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY&!\u0015\u0003\u0007M+G/\u0001\u0006jgZK7/\u001b;fI\u0002\n!\u0002Z3gS:LG/[8o)!\t\u0019'a\u001d\u0002x\u0005m\u0004#B)\u0002f\u0005%\u0014bAA4K\t1q\n\u001d;j_:\u0004b!UA\u0006a\u0005-\u0004\u0003BA7\u0003_j\u0011aI\u0005\u0004\u0003c\u001a#a\u0002#jC2,7\r\u001e\u0005\b\u0003k\"\u0002\u0019AA\b\u0003\r\u00018n\u001a\u0005\b\u0003s\"\u0002\u0019AA\b\u0003!1\u0017\u000e\\3oC6,\u0007\"\u0002%\u0015\u0001\u0004I\u0015AE:i_VdGMV5tSR\u0004\u0016mY6bO\u0016$2\u0001UAA\u0011\u001d\t)(\u0006a\u0001\u0003\u001f\tAC^5tSR<vN]6ta\u0006\u001cWmU=nE>dGCCAD\u0003\u001b\u000b\t+!*\u00020B\u0019\u0011+!#\n\u0007\u0005-UEA\u0002J]RDq!a$\u0017\u0001\u0004\t\t*\u0001\u0003qCRD\u0007\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005M&dWMC\u0002\u0002\u001cZ\f1A\\5p\u0013\u0011\ty*!&\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003G3\u0002\u0019AA\b\u0003\u0019\u0019\u00180\u001c2pY\"9\u0011q\u0015\fA\u0002\u0005%\u0016\u0001B6j]\u0012\u00042a_AV\u0013\r\ti\u000b\u0011\u0002\u000b'fl'm\u001c7LS:$\u0007bBAY-\u0001\u0007\u00111W\u0001\u0006e\u0006tw-\u001a\t\u0004w\u0006U\u0016bAA\\\u0001\n)!+\u00198hK\u0006qa/[:ji\u000ec\u0017m]:gS2,GCBAD\u0003{\u000by\fC\u0004\u0002v]\u0001\r!a\u0004\t\u000f\u0005et\u00031\u0001\u0002\u0010\u0005Y\u0011n]\"b]\u000e,G\u000e\\3e)\u0005\u0001\u0016aD3ya\u0006tGm\u00117bgN4\u0017\u000e\\3\u0015\r\u0005\u001d\u0015\u0011ZAf\u0011\u001d\t)(\u0007a\u0001\u0003\u001fAq!!\u001f\u001a\u0001\u0004\ty!\u0001\fX_J\\7\u000f]1dKN+\u0017M]2i-&\u001c\u0018\u000e^8s!\tA4dE\u0002\u001c\u0003'\u00042!UAk\u0013\r\t9.\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005=\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002`*\u001aQ+!9,\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!<&\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\f9OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class WorkspaceSearchVisitor
extends SymbolSearchVisitor {
    private final AbsolutePath workspace;
    private final WorkspaceSymbolQuery query;
    private final CancelChecker token;
    private final GlobalSymbolIndex index;
    private final boolean saveClassFileToDisk;
    private final Ordering<AbsolutePath> resultOrdering;
    private final ReportContext rc;
    private final ArrayList<SymbolInformation> fromWorkspace;
    private final ArrayList<SymbolInformation> fromClasspath;
    private final ArrayList<Tuple2<String, String>> bufferedClasspath;
    private final Comparator<SymbolInformation> byNameLength;
    private final Set<AbsolutePath> isVisited;

    public static Ordering<AbsolutePath> $lessinit$greater$default$6() {
        return WorkspaceSearchVisitor$.MODULE$.$lessinit$greater$default$6();
    }

    private ArrayList<SymbolInformation> fromWorkspace() {
        return this.fromWorkspace;
    }

    private ArrayList<SymbolInformation> fromClasspath() {
        return this.fromClasspath;
    }

    private ArrayList<Tuple2<String, String>> bufferedClasspath() {
        return this.bufferedClasspath;
    }

    public Seq<SymbolInformation> allResults() {
        if (this.fromWorkspace().isEmpty()) {
            this.bufferedClasspath().forEach((Consumer<Tuple2<String, String>>)((Consumer<Tuple2>)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String pkg = (String)tuple2._1();
                    String name = (String)tuple2._2();
                    this.expandClassfile(pkg, name);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        this.fromWorkspace().sort(this.byNameLength());
        this.fromClasspath().sort(this.byNameLength());
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        result.addAll(this.fromWorkspace());
        result.addAll(this.fromClasspath());
        if (!this.bufferedClasspath().isEmpty() && this.fromClasspath().isEmpty()) {
            AbsolutePath dependencies = this.workspace.resolve(Directories$.MODULE$.workspaceSymbol());
            if (!dependencies.isFile()) {
                MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dependencies).writeText(Messages$WorkspaceSymbolDependencies$.MODULE$.title());
            }
            v0 = BoxesRunTime.boxToBoolean((boolean)result.add(new SymbolInformation(Messages$WorkspaceSymbolDependencies$.MODULE$.title(), SymbolKind.Event, new Location(dependencies.toURI().toString(), new Range(new Position(0, 0), new Position(0, 0))))));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return MetalsEnrichments$.MODULE$.ListHasAsScala(result).asScala().toSeq();
    }

    private Comparator<SymbolInformation> byNameLength() {
        return this.byNameLength;
    }

    private Set<AbsolutePath> isVisited() {
        return this.isVisited;
    }

    private Option<Tuple2<AbsolutePath, Dialect>> definition(String pkg, String filename, GlobalSymbolIndex index) {
        List list;
        String nme = Classfile$.MODULE$.name(filename);
        Symbol tpe = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor.Type(nme)));
        List forTpe = index.findFileForToplevel(tpe);
        if (forTpe.isEmpty()) {
            Symbol term = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor.Term(nme)));
            list = index.findFileForToplevel(term);
        } else {
            list = forTpe;
        }
        List defs = list;
        return ((LinearSeqOps)defs.sortBy((Function1 & Serializable)x$1 -> (AbsolutePath)x$1._1(), this.resultOrdering)).headOption();
    }

    public boolean shouldVisitPackage(String pkg) {
        return true;
    }

    public int visitWorkspaceSymbol(Path path2, String symbol, SymbolKind kind, Range range) {
        Tuple2 tuple2 = Scala.DescriptorParser$.MODULE$.apply(symbol);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Scala.Descriptor desc = (Scala.Descriptor)tuple2._1();
        String owner = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)desc, (Object)owner);
        Scala.Descriptor desc2 = (Scala.Descriptor)tuple22._1();
        String owner2 = (String)tuple22._2();
        this.fromWorkspace().add(new SymbolInformation(desc2.name().value(), kind, new Location(path2.toUri().toString(), range), owner2.replace('/', '.')));
        return 1;
    }

    public int visitClassfile(String pkg, String filename) {
        if (this.fromWorkspace().isEmpty() || this.query.isClasspath()) {
            return this.expandClassfile(pkg, filename);
        }
        this.bufferedClasspath().add((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pkg), (Object)filename));
        return 1;
    }

    public boolean isCancelled() {
        return MetalsEnrichments$.MODULE$.XtensionCancelChecker(this.token).isCancelled();
    }

    private int expandClassfile(String pkg, String filename) {
        BooleanRef isHit = BooleanRef.create((boolean)false);
        this.definition(pkg, filename, this.index).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)WorkspaceSearchVisitor.$anonfun$expandClassfile$1(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WorkspaceSearchVisitor.$anonfun$expandClassfile$2(this, x$3))).foreach((Function1 & Serializable)x$4 -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$3(this, isHit, x$4);
            return BoxedUnit.UNIT;
        });
        if (isHit.elem) {
            return 1;
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$expandClassfile$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$expandClassfile$2(WorkspaceSearchVisitor $this, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple2._1();
            return !$this.isVisited().apply((Object)path2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$4(WorkspaceSearchVisitor $this, AbsolutePath path$1, BooleanRef isHit$1, SemanticdbDefinition semanticDefn) {
        if (MetalsEnrichments$.MODULE$.XtensionWorkspaceSymbolQuery($this.query).matches(semanticDefn.info())) {
            AbsolutePath adjustedPath = $this.saveClassFileToDisk ? MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path$1).toFileOnDisk($this.workspace) : path$1;
            String uri = adjustedPath.toURI().toString();
            $this.fromClasspath().add(semanticDefn.toLsp(uri));
            isHit$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$3(WorkspaceSearchVisitor $this, BooleanRef isHit$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple2._1();
            Dialect dialect = (Dialect)tuple2._2();
            $this.isVisited().$plus$eq((Object)path2);
            Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path2).toInput();
            SemanticdbDefinition$.MODULE$.foreach(input, dialect, false, (Function1 & Serializable)semanticDefn -> {
                WorkspaceSearchVisitor.$anonfun$expandClassfile$4($this, path2, isHit$1, semanticDefn);
                return BoxedUnit.UNIT;
            }, (scala.meta.pc.reports.ReportContext)$this.rc);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public WorkspaceSearchVisitor(AbsolutePath workspace, WorkspaceSymbolQuery query, CancelChecker token, GlobalSymbolIndex index, boolean saveClassFileToDisk, Ordering<AbsolutePath> resultOrdering, ReportContext rc) {
        this.workspace = workspace;
        this.query = query;
        this.token = token;
        this.index = index;
        this.saveClassFileToDisk = saveClassFileToDisk;
        this.resultOrdering = resultOrdering;
        this.rc = rc;
        this.fromWorkspace = new ArrayList();
        this.fromClasspath = new ArrayList();
        this.bufferedClasspath = new ArrayList();
        this.byNameLength = new Comparator<SymbolInformation>(null){

            public Comparator<SymbolInformation> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<SymbolInformation> thenComparing(Comparator<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<SymbolInformation> thenComparingInt(ToIntFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<SymbolInformation> thenComparingLong(ToLongFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<SymbolInformation> thenComparingDouble(ToDoubleFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(SymbolInformation x, SymbolInformation y) {
                return Integer.compare(x.getName().length(), y.getName().length());
            }
        };
        this.isVisited = (Set)Set$.MODULE$.empty();
    }
}

