/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.doctor;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.lsp4j.ExecuteCommandParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.HtmlBuilder$;
import scala.meta.internal.metals.MetalsHttpServer;
import scala.meta.internal.metals.ParametrizedCommand;
import scala.meta.internal.metals.Urls$;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.metals.config.DoctorFormat;
import scala.meta.internal.metals.config.DoctorFormat$Html$;
import scala.meta.internal.metals.config.DoctorFormat$Json$;
import scala.meta.internal.metals.doctor.Doctor;
import scala.meta.internal.metals.doctor.DoctorFolderResults;
import scala.meta.internal.metals.doctor.DoctorHeader;
import scala.meta.internal.metals.doctor.DoctorResults;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;
import ujson.Obj;
import ujson.Value;
import ujson.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b1B1\t\u000b\u0011\u0004A\u0011A3\t\u000f9\u0004!\u0019!C\u0005_\"11\u0010\u0001Q\u0001\nADQ\u0001 \u0001\u0005\u0002uDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002\"!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0002bBA\u001f\u0001\u0011%\u0011q\b\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u001d\ty\u0005\u0001C\u0005\u0003\u007fAq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002X\u0001!I!!\u0017\t\u0013\u0005m\u0003A1A\u0005\n\u0005u\u0003\u0002CA5\u0001\u0001\u0006I!a\u0018\t\u0013\u0005-\u0004A1A\u0005\n\u0005u\u0003\u0002CA7\u0001\u0001\u0006I!a\u0018\t\u0013\u0005=\u0004A1A\u0005\n\u0005u\u0003\u0002CA9\u0001\u0001\u0006I!a\u0018\t\u000f\u0005M\u0004\u0001\"\u0003\u0002^\tQ\u0001*Z1e\t>\u001cGo\u001c:\u000b\u0005uq\u0012A\u00023pGR|'O\u0003\u0002 A\u00051Q.\u001a;bYNT!!\t\u0012\u0002\u0011%tG/\u001a:oC2T!a\t\u0013\u0002\t5,G/\u0019\u0006\u0002K\u0005)1oY1mC\u000e\u00011C\u0001\u0001)!\tI#&D\u0001%\u0013\tYCE\u0001\u0004B]f\u0014VMZ\u0001\bI>\u001cGo\u001c:t!\rIc\u0006M\u0005\u0003_\u0011\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0007EJDH\u0004\u00023o9\u00111GN\u0007\u0002i)\u0011QGJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!\u0001\u000f\u0013\u0002\u000fA\f7m[1hK&\u0011!h\u000f\u0002\u0005\u0019&\u001cHO\u0003\u00029IA\u0011QHP\u0007\u00029%\u0011q\b\b\u0002\u0007\t>\u001cGo\u001c:\u0002\u0015!$H\u000f]*feZ,'\u000fE\u0002*]\t\u00032a\u0011$I\u001b\u0005!%BA#%\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u000f\u0012\u0013aAR;ukJ,\u0007cA\u0015J\u0017&\u0011!\n\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051kU\"\u0001\u0010\n\u00059s\"\u0001E'fi\u0006d7\u000f\u0013;uaN+'O^3s\u00031\u0019G.[3oi\u000e{gNZ5h!\ta\u0015+\u0003\u0002S=\t\u00192\t\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006qA.\u00198hk\u0006<Wm\u00117jK:$\bCA+[\u001b\u00051&BA,Y\u0003!a\u0017M\\4vC\u001e,'BA-\u001f\u0003\u001d\u0019G.[3oiNL!a\u0017,\u0003)5+G/\u00197t\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\u00035I7\u000f\u0013;ua\u0016s\u0017M\u00197fIB\u0011\u0011FX\u0005\u0003?\u0012\u0012qAQ8pY\u0016\fg.\u0001\u0002fGB\u00111IY\u0005\u0003G\u0012\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u00191\u0017N[6m[R\u0011q\r\u001b\t\u0003{\u0001AQ\u0001Y\u0004A\u0004\u0005DQ\u0001L\u0004A\u00025BQ\u0001Q\u0004A\u0002\u0005CQaT\u0004A\u0002ACQaU\u0004A\u0002QCQ\u0001X\u0004A\u0002u\u000b\u0011\"[:WSNL'\r\\3\u0016\u0003A\u0004\"!]=\u000e\u0003IT!a\u001d;\u0002\r\u0005$x.\\5d\u0015\t)UO\u0003\u0002wo\u0006!Q\u000f^5m\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A\u001f:\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003)I7OV5tS\ndW\rI\u0001\u0016_:4\u0016n]5cS2LG/\u001f#jI\u000eC\u0017M\\4f)\rq\u00181\u0001\t\u0003S}L1!!\u0001%\u0005\u0011)f.\u001b;\t\r\u0005\u0015!\u00021\u0001^\u0003!qWm^*uCR,\u0017\u0001\u00059s_\ndW-\\:Ii6d\u0007+Y4f)\u0011\tY!a\u0007\u0011\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\t\u0002\u0005\u00024I%\u0019\u00111\u0003\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t9\"!\u0007\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0002\n\u0005\b\u0003;Y\u0001\u0019AA\u0006\u0003\r)(\u000f\\\u0001\u0011Kb,7-\u001e;f%VtGi\\2u_J$\u0012A`\u0001\u0015Kb,7-\u001e;f%\u00164'/Z:i\t>\u001cGo\u001c:\u0002\u001b\u0015DXmY;uK\u0012{7\r^8s)\u0015q\u0018\u0011FA\u001a\u0011\u001d\tYC\u0004a\u0001\u0003[\tQb\u00197jK:$8i\\7nC:$\u0007#\u0002'\u00020\u0005-\u0011bAA\u0019=\t\u0019\u0002+\u0019:b[\u0016$(/\u001b>fI\u000e{W.\\1oI\"9\u0011Q\u0007\bA\u0002\u0005]\u0012\u0001C8o'\u0016\u0014h/\u001a:\u0011\u000b%\nId\u0013@\n\u0007\u0005mBEA\u0005Gk:\u001cG/[8oc\u0005\u0001\"-^5mIR\u000b'oZ3ug\"#X\u000e\u001c\u000b\u0003\u0003\u0017\t\u0011CY;jY\u0012$\u0016M]4fiN$\u0016M\u00197f)\rq\u0018Q\t\u0005\b\u0003\u000f\u0002\u0002\u0019AA%\u0003\u0011AG/\u001c7\u0011\u00071\u000bY%C\u0002\u0002Ny\u00111\u0002\u0013;nY\n+\u0018\u000e\u001c3fe\u0006\u0001\"-^5mIR\u000b'oZ3ug*\u001bxN\\\u0001\u000bO\u0016$(\nZ6J]\u001a|GCAA+!\u0011I\u0013*a\u0003\u00027\u0005\u0014X-T;mi&\u0004H.Z,pe.\u001c\b/Y2f\r>dG-\u001a:t+\u0005i\u0016a\u00033pGR|'\u000fV5uY\u0016,\"!a\u0018\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001ax\u0003\u0011a\u0017M\\4\n\t\u0005]\u00111M\u0001\rI>\u001cGo\u001c:USRdW\rI\u0001\u0010U\u0012\\g+\u001a:tS>tG+\u001b;mK\u0006\u0001\"\u000eZ6WKJ\u001c\u0018n\u001c8USRdW\rI\u0001\u0013g\u0016\u0014h/\u001a:WKJ\u001c\u0018n\u001c8USRdW-A\ntKJ4XM\u001d,feNLwN\u001c+ji2,\u0007%\u0001\fck&dG\rV1sO\u0016$H)Z:de&\u0004H/[8o\u0001")
public class HeadDoctor {
    private final Function0<List<Doctor>> doctors;
    private final Function0<Future<Option<MetalsHttpServer>>> httpServer;
    private final ClientConfiguration clientConfig;
    private final MetalsLanguageClient languageClient;
    private final boolean isHttpEnabled;
    private final ExecutionContext ec;
    private final AtomicBoolean isVisible;
    private final String doctorTitle;
    private final String jdkVersionTitle;
    private final String serverVersionTitle;

    private AtomicBoolean isVisible() {
        return this.isVisible;
    }

    public void onVisibilityDidChange(boolean newState) {
        this.isVisible().set(newState);
    }

    public String problemsHtmlPage(String url) {
        String livereload = Urls$.MODULE$.livereload(url);
        return HtmlBuilder$.MODULE$.apply().page(this.doctorTitle(), (List)new .colon.colon((Object)livereload, (List)new .colon.colon((Object)HtmlBuilder$.MODULE$.htmlCSS(), (List)Nil$.MODULE$)), "style='padding: .75rem; font-size: 10px'", (Function1 & Serializable)html -> {
            html.section("Build targets", (Function1 & Serializable)html -> {
                $this.buildTargetsTable(html);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }).render();
    }

    public void executeRunDoctor() {
        this.onVisibilityDidChange(true);
        this.executeDoctor(ClientCommands$.MODULE$.RunDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & Serializable)server -> {
            Urls$.MODULE$.openBrowser(server.address() + "/doctor");
            return BoxedUnit.UNIT;
        });
    }

    public void executeRefreshDoctor() {
        this.executeDoctor(ClientCommands$.MODULE$.ReloadDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & Serializable)server -> {
            server.reload();
            return BoxedUnit.UNIT;
        });
    }

    private void executeDoctor(ParametrizedCommand<String> clientCommand, Function1<MetalsHttpServer, BoxedUnit> onServer) {
        boolean shouldDisplay;
        boolean isVisibilityProvider = this.clientConfig.isDoctorVisibilityProvider();
        boolean bl = shouldDisplay = isVisibilityProvider && this.isVisible().get();
        if (shouldDisplay || !isVisibilityProvider) {
            if (this.clientConfig.isExecuteClientCommandProvider() && !this.clientConfig.isHttpEnabled()) {
                String string;
                DoctorFormat.DoctorFormat doctorFormat = this.clientConfig.doctorFormat();
                if (DoctorFormat$Json$.MODULE$.equals(doctorFormat)) {
                    string = this.buildTargetsJson();
                } else if (DoctorFormat$Html$.MODULE$.equals(doctorFormat)) {
                    string = this.buildTargetsHtml();
                } else {
                    throw new MatchError((Object)doctorFormat);
                }
                String output = string;
                ExecuteCommandParams params = clientCommand.toExecuteCommandParams(output);
                this.languageClient.metalsExecuteClientCommand(params);
                return;
            }
            ((Future)this.httpServer.apply()).map((Function1 & Serializable)x0$1 -> {
                HeadDoctor.$anonfun$executeDoctor$1(this, onServer, x0$1);
                return BoxedUnit.UNIT;
            }, this.ec);
            return;
        }
    }

    private String buildTargetsHtml() {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$12 = "h1";
        String x$2 = qual$1.element$default$2();
        Function1 & Serializable x$3 = (Function1 & Serializable)x$1 -> {
            x$1.text(this.doctorTitle());
            return BoxedUnit.UNIT;
        };
        return qual$1.element("h1", x$2, (Function1)x$3).call((Function1 & Serializable)html -> {
            this.buildTargetsTable(html);
            return BoxedUnit.UNIT;
        }).render();
    }

    private void buildTargetsTable(HtmlBuilder html) {
        Option<String> jdkInfo = this.getJdkInfo();
        jdkInfo.foreach((Function1 & Serializable)jdkMsg -> html.element("p", html.element$default$2(), (Function1 & Serializable)builder -> {
            HeadDoctor.$anonfun$buildTargetsTable$2(this, jdkMsg, builder);
            return BoxedUnit.UNIT;
        }));
        html.element("p", html.element$default$2(), (Function1 & Serializable)builder -> {
            HeadDoctor.$anonfun$buildTargetsTable$3(this, builder);
            return BoxedUnit.UNIT;
        });
        html.element("p", html.element$default$2(), (Function1 & Serializable)x$2 -> {
            x$2.text(this.buildTargetDescription());
            return BoxedUnit.UNIT;
        });
        boolean includeWorkspaceFolderName = this.areMultipleWorkspaceFolders();
        ((List)this.doctors.apply()).foreach((Function1 & Serializable)x$3 -> {
            x$3.buildTargetsTable(html, includeWorkspaceFolderName);
            return BoxedUnit.UNIT;
        });
    }

    private String buildTargetsJson() {
        List results = ((List)this.doctors.apply()).map((Function1 & Serializable)x$4 -> x$4.buildTargetsJson());
        Option jdkInfo = this.getJdkInfo().map((Function1 & Serializable)info -> this.jdkVersionTitle() + info);
        String serverInfo = this.serverVersionTitle() + BuildInfo$.MODULE$.metalsVersion();
        DoctorHeader header = new DoctorHeader((Option<String>)jdkInfo, serverInfo, this.buildTargetDescription());
        Obj result = new DoctorResults(this.doctorTitle(), header, (List<DoctorFolderResults>)results).toJson();
        return package$.MODULE$.write((Value)result, package$.MODULE$.write$default$2(), package$.MODULE$.write$default$3(), package$.MODULE$.write$default$4());
    }

    private Option<String> getJdkInfo() {
        return Option$.MODULE$.apply((Object)System.getProperty("java.version")).flatMap((Function1 & Serializable)version -> Option$.MODULE$.apply((Object)System.getProperty("java.vendor")).flatMap((Function1 & Serializable)vendor -> Option$.MODULE$.apply((Object)System.getProperty("java.home")).map((Function1 & Serializable)home -> version + " from " + vendor + " located at " + home)));
    }

    private boolean areMultipleWorkspaceFolders() {
        return ((List)this.doctors.apply()).length() > 1;
    }

    private String doctorTitle() {
        return this.doctorTitle;
    }

    private String jdkVersionTitle() {
        return this.jdkVersionTitle;
    }

    private String serverVersionTitle() {
        return this.serverVersionTitle;
    }

    private String buildTargetDescription() {
        return "Below are listed the build targets " + (this.areMultipleWorkspaceFolders() ? "for each workspace folder. " : "for this workspace. ") + "One build target corresponds to one classpath. For example, normally one sbt project maps to two build targets: main and test.";
    }

    public static final /* synthetic */ void $anonfun$executeDoctor$1(HeadDoctor $this, Function1 onServer$1, Option x0$1) {
        boolean bl = false;
        Option option = null;
        Option option2 = x0$1;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            MetalsHttpServer server = (MetalsHttpServer)some.value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)onServer$1.apply((Object)server);
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            bl = true;
            option = option2;
            if (!$this.isHttpEnabled) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)scribe.package$.MODULE$.warn((Function0 & Serializable)() -> "Unable to run doctor. Make sure `isHttpEnabled` is set to `true`.", new Pkg("scala.meta.internal.metals.doctor"), new FileName("HeadDoctor.scala"), new Name("executeDoctor"), new Line(94), MDC$.MODULE$.instance());
                return;
            }
        }
        if (bl) {
            BoxedUnit cfr_ignored_2 = (BoxedUnit)scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Doctor was not yet started, check logs to make sure it's running", new Pkg("scala.meta.internal.metals.doctor"), new FileName("HeadDoctor.scala"), new Name("executeDoctor"), new Line(98), MDC$.MODULE$.instance());
            return;
        }
        throw new MatchError((Object)option2);
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$2(HeadDoctor $this, String jdkMsg$1, HtmlBuilder builder) {
        builder.bold($this.jdkVersionTitle());
        builder.text(jdkMsg$1);
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$3(HeadDoctor $this, HtmlBuilder builder) {
        builder.bold($this.serverVersionTitle());
        builder.text(BuildInfo$.MODULE$.metalsVersion());
    }

    public HeadDoctor(Function0<List<Doctor>> doctors, Function0<Future<Option<MetalsHttpServer>>> httpServer, ClientConfiguration clientConfig, MetalsLanguageClient languageClient, boolean isHttpEnabled, ExecutionContext ec) {
        this.doctors = doctors;
        this.httpServer = httpServer;
        this.clientConfig = clientConfig;
        this.languageClient = languageClient;
        this.isHttpEnabled = isHttpEnabled;
        this.ec = ec;
        this.isVisible = new AtomicBoolean(false);
        this.doctorTitle = "Metals Doctor";
        this.jdkVersionTitle = "Metals Java: ";
        this.serverVersionTitle = "Metals Server version: ";
    }
}

