/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.undertow.Undertow;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import reactor.core.publisher.Mono;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.bsp.BuildChange;
import scala.meta.internal.bsp.BuildChange$Failed$;
import scala.meta.internal.bsp.BuildChange$None$;
import scala.meta.internal.bsp.BuildChange$Reconnected$;
import scala.meta.internal.bsp.BuildChange$Reloaded$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Compilations;
import scala.meta.internal.metals.ConnectionProvider;
import scala.meta.internal.metals.Diagnostics;
import scala.meta.internal.metals.JsonParser$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MutableCancelable;
import scala.meta.internal.metals.mcp.Editor;
import scala.meta.internal.metals.mcp.Editor$;
import scala.meta.internal.metals.mcp.IncorrectArgumentTypeException;
import scala.meta.internal.metals.mcp.McpConfig$;
import scala.meta.internal.metals.mcp.McpPrinter$;
import scala.meta.internal.metals.mcp.McpQueryEngine;
import scala.meta.internal.metals.mcp.McpTestRunner;
import scala.meta.internal.metals.mcp.MissingArgumentException;
import scala.meta.internal.metals.mcp.MissingFileInFocusException$;
import scala.meta.internal.metals.mcp.SymbolDocumentationSearchResult;
import scala.meta.internal.metals.mcp.SymbolInspectResult;
import scala.meta.internal.metals.mcp.SymbolSearchResult;
import scala.meta.internal.metals.mcp.SymbolType;
import scala.meta.internal.metals.mcp.SymbolType$;
import scala.meta.internal.metals.mcp.SymbolUsage;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\t%f\u0001B\u00181\u0001mB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tg\u0002\u0011\t\u0011)A\u0005Q\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0006\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0003\u0001\u0005\u0003\u0005\u000b1BA\u0007\u0011\u001d\tI\u0002\u0001C\u0001\u00037A\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005U\u0003\u0001)A\u0005\u0003{Aq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002\u0014\u0002!I!!&\t\u0013\u0005u\u0005A1A\u0005\n\u0005}\u0005\u0002CAV\u0001\u0001\u0006I!!)\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011q\u0017\u0001\u0005B\u0005=\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003'\u0004A\u0011BA^\u0011\u001d\t)\u000e\u0001C\u0005\u0003wCq!a6\u0001\t\u0013\tY\fC\u0004\u0002Z\u0002!I!a/\t\u000f\u0005m\u0007\u0001\"\u0003\u0002<\"9\u0011Q\u001c\u0001\u0005\n\u0005m\u0006bBAp\u0001\u0011%\u00111\u0018\u0005\b\u0003C\u0004A\u0011BA^\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003K4aAa\u000b\u0001\u0003\t5\u0002B\u0003B\u0012A\t\u0015\r\u0011\"\u0001\u00032!Q!q\n\u0011\u0003\u0002\u0003\u0006IAa\r\t\u000f\u0005e\u0001\u0005\"\u0001\u0003R!9!\u0011\f\u0011\u0005\u0002\tm\u0003\"\u0003B0\u0001\u0005\u0005I1\u0001B1\r\u0019\u0011y\u0007A\u0001\u0003r!Q!1\u000f\u0014\u0003\u0006\u0004%\tA!\u001e\t\u0015\t]dE!A!\u0002\u0013\tY\u0010C\u0004\u0002\u001a\u0019\"\tA!\u001f\t\u000f\t}d\u0005\"\u0001\u0003\u0002\"9!1\u0011\u0014\u0005\u0002\t\u0015\u0005b\u0002BIM\u0011\u0005!1\u0013\u0005\b\u0005?3C\u0011\u0001BQ\u0011%\u0011\u0019\u000bAA\u0001\n\u0007\u0011)KA\bNKR\fGn]'daN+'O^3s\u0015\t\t$'A\u0002nGBT!a\r\u001b\u0002\r5,G/\u00197t\u0015\t)d'\u0001\u0005j]R,'O\\1m\u0015\t9\u0004(\u0001\u0003nKR\f'\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0019\u0001\u0001\u0010!\u0011\u0005urT\"\u0001\u001d\n\u0005}B$AB!osJ+g\r\u0005\u0002B\u00056\t!'\u0003\u0002De\tQ1)\u00198dK2\f'\r\\3\u0002\u0017E,XM]=F]\u001eLg.\u001a\t\u0003\r\u001ek\u0011\u0001M\u0005\u0003\u0011B\u0012a\"T2q#V,'/_#oO&tW-A\u0006qe>TWm\u0019;QCRD\u0007CA&O\u001b\u0005a%BA'7\u0003\tIw.\u0003\u0002P\u0019\na\u0011IY:pYV$X\rU1uQ\u0006a1m\\7qS2\fG/[8ogB\u0011\u0011IU\u0005\u0003'J\u0012AbQ8na&d\u0017\r^5p]N\fqBZ8dkN,G\rR8dk6,g\u000e\u001e\t\u0004{YC\u0016BA,9\u0005%1UO\\2uS>t\u0007\u0007E\u0002>3*K!A\u0017\u001d\u0003\r=\u0003H/[8o\u0003-!\u0017.Y4o_N$\u0018nY:\u0011\u0005\u0005k\u0016B\u000103\u0005-!\u0015.Y4o_N$\u0018nY:\u0002\u0019\t,\u0018\u000e\u001c3UCJ<W\r^:\u0011\u0005\u0005\u000b\u0017B\u000123\u00051\u0011U/\u001b7e)\u0006\u0014x-\u001a;t\u00035i7\r\u001d+fgR\u0014VO\u001c8feB\u0011a)Z\u0005\u0003MB\u0012Q\"T2q)\u0016\u001cHOU;o]\u0016\u0014\u0018AC3eSR|'OT1nKB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a\u001b\u001d\u000e\u00031T!!\u001c\u001e\u0002\rq\u0012xn\u001c;?\u0013\ty\u0007(\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA89\u0003-\u0001(o\u001c6fGRt\u0015-\\3\u0002\u001d1\fgnZ;bO\u0016\u001cE.[3oiB\u0011ao`\u0007\u0002o*\u0011\u00010_\u0001\tg\u0016\u0014h/[2fg*\u0011!p_\u0001\u0006YN\u0004HG\u001b\u0006\u0003yv\fq!Z2mSB\u001cXMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u00039(A\u0004'b]\u001e,\u0018mZ3DY&,g\u000e^\u0001\u0013G>tg.Z2uS>t\u0007K]8wS\u0012,'\u000fE\u0002B\u0003\u000fI1!!\u00033\u0005I\u0019uN\u001c8fGRLwN\u001c)s_ZLG-\u001a:\u0002\u0005\u0015\u001c\u0007\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0001(\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0006\u0002\u0012\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005u\u00111EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9\u0004\u0006\u0003\u0002 \u0005\u0005\u0002C\u0001$\u0001\u0011\u001d\tY!\u0004a\u0002\u0003\u001bAQ\u0001R\u0007A\u0002\u0015CQ!S\u0007A\u0002)CQ\u0001U\u0007A\u0002ECQ\u0001V\u0007A\u0002UCQaW\u0007A\u0002qCQaX\u0007A\u0002\u0001DQaY\u0007A\u0002\u0011DQaZ\u0007A\u0002!DQa]\u0007A\u0002!DQ\u0001^\u0007A\u0002UDq!a\u0001\u000e\u0001\u0004\t)!\u0001\u0007pE*,7\r^'baB,'/\u0006\u0002\u0002>A!\u0011qHA)\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\t\u0005\u001d\u0013\u0011J\u0001\bU\u0006\u001c7n]8o\u0015\u0011\tY%!\u0014\u0002\u0013\u0019\f7\u000f^3sq6d'BAA(\u0003\r\u0019w.\\\u0005\u0005\u0003'\n\tE\u0001\u0007PE*,7\r^'baB,'/A\u0007pE*,7\r^'baB,'\u000fI\u0001\u000eGJ,\u0017\r^3D_:$XM\u001c;\u0015\t\u0005m\u0013q\u0012\t\u0007\u0003;\n9'a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\nA!\u001e;jY*\u0011\u0011QM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0005}#\u0001\u0002'jgR\u0004B!!\u001c\u0002\n:!\u0011qNAB\u001d\u0011\t\t(! \u000f\t\u0005M\u0014q\u000f\b\u0004W\u0006U\u0014\"A'\n\t\u0005e\u00141P\u0001\u0015[>$W\r\\2p]R,\u0007\u0010\u001e9s_R|7m\u001c7\u000b\u00035KA!a \u0002\u0002\u0006!1\u000f]3d\u0015\u0011\tI(a\u001f\n\t\u0005\u0015\u0015qQ\u0001\n\u001b\u000e\u00048k\u00195f[\u0006TA!a \u0002\u0002&!\u00111RAG\u0005\u001d\u0019uN\u001c;f]RTA!!\"\u0002\b\"1\u0011\u0011\u0013\tA\u0002!\fA\u0001^3yi\u0006Q1-\u00198dK2\f'\r\\3\u0016\u0005\u0005]\u0005cA!\u0002\u001a&\u0019\u00111\u0014\u001a\u0003#5+H/\u00192mK\u000e\u000bgnY3mC\ndW-A\u0006tg\u0016,e\u000e\u001a9pS:$XCAAQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&\u0002BAT\u0003G\nA\u0001\\1oO&\u0019\u0011/!*\u0002\u0019M\u001cX-\u00128ea>Lg\u000e\u001e\u0011\u0002\u0007I,h\u000e\u0006\u0002\u00022B\u0019Q(a-\n\u0007\u0005U\u0006H\u0001\u0003V]&$\u0018AB2b]\u000e,G.A\bj[B|'\u000f\u001e\"vS2$Gk\\8m)\t\ti\f\u0005\u0003\u0002@\u00065g\u0002BAa\u0003\u000ftA!!\u001d\u0002D&!\u0011QYAA\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011ZAf\u0003Ei5\r]*feZ,'OR3biV\u0014Xm\u001d\u0006\u0005\u0003\u000b\f\t)\u0003\u0003\u0002P\u0006E'AF!ts:\u001cGk\\8m'B,7-\u001b4jG\u0006$\u0018n\u001c8\u000b\t\u0005%\u00171Z\u0001\u0012GJ,\u0017\r^3D_6\u0004\u0018\u000e\\3U_>d\u0017!F2sK\u0006$XMR5mK\u000e{W\u000e]5mKR{w\u000e\\\u0001\u000fGJ,\u0017\r^3UKN$Hk\\8m\u0003Q\u0019'/Z1uK\u001ecwNY*fCJ\u001c\u0007\u000eV8pY\u0006I2M]3bi\u0016$\u0016\u0010]3e\u000f2|'mU3be\u000eDGk\\8m\u0003E\u0019'/Z1uK&s7\u000f]3diR{w\u000e\\\u0001\u0012GJ,\u0017\r^3HKR$unY:U_>d\u0017aE2sK\u0006$XmR3u+N\fw-Z:U_>d\u0017!E<ji\",%O]8s\u0011\u0006tG\r\\5oOR!\u0011q\u001dB\u0011!)\tI/a<\u0002t\u0006m(qA\u0007\u0003\u0003WTA!!<\u0002`\u0005Aa-\u001e8di&|g.\u0003\u0003\u0002r\u0006-(A\u0003\"j\rVt7\r^5p]B!\u0011Q_A|\u001b\t\tY-\u0003\u0003\u0002z\u0006-'AF'da\u0006\u001b\u0018P\\2TKJ4XM]#yG\"\fgnZ3\u0011\u000f\u0005u\u0013Q 5\u0003\u0002%!\u0011q`A0\u0005\ri\u0015\r\u001d\t\u0005\u0003G\u0013\u0019!\u0003\u0003\u0003\u0006\u0005\u0015&AB(cU\u0016\u001cG\u000f\u0005\u0004\u0003\n\t]!1D\u0007\u0003\u0005\u0017QAA!\u0004\u0003\u0010\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0005\u0005#\u0011\u0019\"\u0001\u0003d_J,'B\u0001B\u000b\u0003\u001d\u0011X-Y2u_JLAA!\u0007\u0003\f\t!Qj\u001c8p!\u0011\tiG!\b\n\t\t}\u0011Q\u0012\u0002\u000f\u0007\u0006dG\u000eV8pYJ+7/\u001e7u\u0011\u001d\u0011\u0019c\ba\u0001\u0005K\t\u0011A\u001a\t\n{\t\u001d\u00121_A~\u0005\u000fI1A!\u000b9\u0005%1UO\\2uS>t'G\u0001\bYi\u0016t7/[8o\rV$XO]3\u0016\t\t=\"QH\n\u0003Aq*\"Aa\r\u0011\r\u0005=!Q\u0007B\u001d\u0013\u0011\u00119$!\u0005\u0003\r\u0019+H/\u001e:f!\u0011\u0011YD!\u0010\r\u0001\u00119!q\b\u0011C\u0002\t\u0005#!\u0001+\u0012\t\t\r#\u0011\n\t\u0004{\t\u0015\u0013b\u0001B$q\t9aj\u001c;iS:<\u0007cA\u001f\u0003L%\u0019!Q\n\u001d\u0003\u0007\u0005s\u00170\u0001\u0002gAQ!!1\u000bB,!\u0015\u0011)\u0006\tB\u001d\u001b\u0005\u0001\u0001b\u0002B\u0012G\u0001\u0007!1G\u0001\u0007i>luN\\8\u0016\u0005\tu\u0003C\u0002B\u0005\u0005/\u0011I$\u0001\bYi\u0016t7/[8o\rV$XO]3\u0016\t\t\r$\u0011\u000e\u000b\u0005\u0005K\u0012Y\u0007E\u0003\u0003V\u0001\u00129\u0007\u0005\u0003\u0003<\t%Da\u0002B K\t\u0007!\u0011\t\u0005\b\u0005G)\u0003\u0019\u0001B7!\u0019\tyA!\u000e\u0003h\t\t\u0002\f^3og&|g.\u0011:hk6,g\u000e^:\u0014\u0005\u0019b\u0014!C1sOVlWM\u001c;t+\t\tY0\u0001\u0006be\u001e,X.\u001a8ug\u0002\"BAa\u001f\u0003~A\u0019!Q\u000b\u0014\t\u000f\tM\u0014\u00061\u0001\u0002|\u00069q-\u001a;Gc\u000etW#\u00015\u0002\u000b\u001d,G/Q:\u0016\t\t\u001d%1\u0012\u000b\u0005\u0005\u0013\u0013i\t\u0005\u0003\u0003<\t-Ea\u0002B W\t\u0007!\u0011\t\u0005\u0007\u0005\u001f[\u0003\u0019\u00015\u0002\u0007-,\u00170\u0001\u0005hKR|\u0005\u000f^!t+\u0011\u0011)Ja'\u0015\t\t]%Q\u0014\t\u0005{e\u0013I\n\u0005\u0003\u0003<\tmEa\u0002B Y\t\u0007!\u0011\t\u0005\u0007\u0005\u001fc\u0003\u0019\u00015\u0002\u001d\u001d,GOR5mK&sgi\\2vgV\t!*A\tYi\u0016t7/[8o\u0003J<W/\\3oiN$BAa\u001f\u0003(\"9!1\u000f\u0018A\u0002\u0005m\b")
public class MetalsMcpServer
implements Cancelable {
    private final McpQueryEngine queryEngine;
    public final AbsolutePath scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath;
    private final Compilations compilations;
    public final Function0<Option<AbsolutePath>> scala$meta$internal$metals$mcp$MetalsMcpServer$$focusedDocument;
    private final Diagnostics diagnostics;
    private final BuildTargets buildTargets;
    private final McpTestRunner mcpTestRunner;
    private final String editorName;
    private final String projectName;
    private final LanguageClient languageClient;
    private final ConnectionProvider connectionProvider;
    private final ExecutionContext ec;
    private final ObjectMapper scala$meta$internal$metals$mcp$MetalsMcpServer$$objectMapper;
    private final String scala$meta$internal$metals$mcp$MetalsMcpServer$$sseEndpoint;

    public ObjectMapper scala$meta$internal$metals$mcp$MetalsMcpServer$$objectMapper() {
        return this.scala$meta$internal$metals$mcp$MetalsMcpServer$$objectMapper;
    }

    private java.util.List<McpSchema.Content> createContent(String text) {
        return Arrays.asList((Object[])new McpSchema.Content[]{new McpSchema.TextContent(text)});
    }

    private MutableCancelable cancelable() {
        return new MutableCancelable();
    }

    public String scala$meta$internal$metals$mcp$MetalsMcpServer$$sseEndpoint() {
        return this.scala$meta$internal$metals$mcp$MetalsMcpServer$$sseEndpoint;
    }

    public void run() {
        HttpServletSseServerTransportProvider servlet = new HttpServletSseServerTransportProvider(this){
            private final /* synthetic */ MetalsMcpServer $outer;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                super.doGet(request, response);
                String pathInfo = request.getPathInfo();
                if (this.$outer.scala$meta$internal$metals$mcp$MetalsMcpServer$$sseEndpoint().equals(pathInfo)) {
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    Runnable pingTask = new Runnable(null, response, scheduler){
                        private final HttpServletResponse response$1;
                        private final ScheduledExecutorService scheduler$1;

                        public void run() {
                            try {
                                this.response$1.getWriter().write(": ping\n\n");
                                this.response$1.getWriter().flush();
                            }
                            catch (Exception exception) {
                                this.scheduler$1.shutdown();
                            }
                        }
                        {
                            this.response$1 = response$1;
                            this.scheduler$1 = scheduler$1;
                        }
                    };
                    scheduler.scheduleAtFixedRate(pingTask, 30L, 30L, TimeUnit.SECONDS);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scala$meta$internal$metals$mcp$MetalsMcpServer$$objectMapper(), "/", $outer.scala$meta$internal$metals$mcp$MetalsMcpServer$$sseEndpoint());
            }
        };
        McpSchema.ServerCapabilities capabilities = McpSchema.ServerCapabilities.builder().tools(Predef$.MODULE$.boolean2Boolean(true)).logging().build();
        McpAsyncServer asyncServer = McpServer.async((McpServerTransportProvider)servlet).serverInfo("scala-mcp-server", "0.1.0").capabilities(capabilities).build();
        this.cancelable().add(() -> asyncServer.close());
        asyncServer.addTool(this.createFileCompileTool()).subscribe();
        asyncServer.addTool(this.createCompileTool()).subscribe();
        asyncServer.addTool(this.createTestTool()).subscribe();
        asyncServer.addTool(this.createGlobSearchTool()).subscribe();
        asyncServer.addTool(this.createTypedGlobSearchTool()).subscribe();
        asyncServer.addTool(this.createInspectTool()).subscribe();
        asyncServer.addTool(this.createGetDocsTool()).subscribe();
        asyncServer.addTool(this.createGetUsagesTool()).subscribe();
        asyncServer.addTool(this.importBuildTool()).subscribe();
        asyncServer.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.INFO).logger("scala-mcp-server").data("Server initialized").build());
        DeploymentInfo servletDeployment = Servlets.deployment().setClassLoader(MetalsMcpServer.class.getClassLoader()).setContextPath("/").setDeploymentName("sse-server.war").addServlets(new ServletInfo[]{Servlets.servlet((String)"SseServlet", HttpServletSseServerTransportProvider.class, () -> new InstanceHandle<HttpServletSseServerTransportProvider>(null, servlet){
            private final HttpServletSseServerTransportProvider servlet$1;

            public HttpServletSseServerTransportProvider getInstance() {
                return this.servlet$1;
            }

            public void release() {
                this.servlet$1.close();
            }
            {
                this.servlet$1 = servlet$1;
            }
        }).setAsyncSupported(true).addMapping("/*")});
        ServletContainer manager = Servlets.defaultContainer();
        DeploymentManager deployment = manager.addDeployment(servletDeployment);
        deployment.deploy();
        Option editor = Editor$.MODULE$.allEditors().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetalsMcpServer.$anonfun$run$3(this, x$1)));
        Option configPort = editor.flatMap((Function1 & Serializable)e -> McpConfig$.MODULE$.readPort($this.scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath, $this.projectName, (Editor)e));
        Undertow undertowServer = Undertow.builder().addHttpListener(BoxesRunTime.unboxToInt((Object)configPort.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), "localhost").setHandler(deployment.start()).build();
        undertowServer.start();
        java.util.List listenerInfo = undertowServer.getListenerInfo();
        int port = ((InetSocketAddress)((Undertow.ListenerInfo)listenerInfo.get(0)).getAddress()).getPort();
        if (editor.isDefined() && !configPort.isDefined()) {
            McpConfig$.MODULE$.writeConfig(port, this.projectName, this.scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath, (Editor)editor.get());
        }
        this.languageClient.showMessage(new MessageParams(MessageType.Info, "Metals MCP server started on port: " + port + ". Refresh connection if needed."));
        package$.MODULE$.info((Function0 & Serializable)() -> "Metals MCP server started on port: " + port + ".", new Pkg("scala.meta.internal.metals.mcp"), new FileName("MetalsMcpServer.scala"), new Name("run"), new Line(204), MDC$.MODULE$.instance());
        this.cancelable().add(() -> undertowServer.stop());
    }

    @Override
    public void cancel() {
        this.cancelable().cancel();
    }

    private McpServerFeatures.AsyncToolSpecification importBuildTool() {
        String schema = "{\"type\": \"object\", \"properties\": { }}";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("import-build", "Import the build to IDE. Should be performed after any build changes, e.g. adding dependepcies or any changes in build.sbt.", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, x$2) -> this.XtensionFuture($this.connectionProvider.slowConnectToBuildServer(true).map((Function1 & Serializable)x0$1 -> {
            BuildChange buildChange = x0$1;
            if (BuildChange$None$.MODULE$.equals(buildChange)) {
                return new McpSchema.CallToolResult(this.createContent("No changes detected"), Predef$.MODULE$.boolean2Boolean(false));
            }
            if (BuildChange$Reconnected$.MODULE$.equals(buildChange)) {
                return new McpSchema.CallToolResult(this.createContent("Reconnected to build server"), Predef$.MODULE$.boolean2Boolean(false));
            }
            if (BuildChange$Reloaded$.MODULE$.equals(buildChange)) {
                return new McpSchema.CallToolResult(this.createContent("Build reloaded"), Predef$.MODULE$.boolean2Boolean(false));
            }
            if (BuildChange$Failed$.MODULE$.equals(buildChange)) {
                return new McpSchema.CallToolResult(this.createContent("Failed to reimport build."), Predef$.MODULE$.boolean2Boolean(false));
            }
            throw new MatchError((Object)buildChange);
        }, $this.ec)).toMono()));
    }

    private McpServerFeatures.AsyncToolSpecification createCompileTool() {
        String schema = "{\"type\": \"object\", \"properties\": { }}";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("compile-full", "Compile the whole Scalaproject", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, x$3) -> this.XtensionFuture($this.compilations.cascadeCompile($this.buildTargets.allBuildTargetIds()).map((Function1 & Serializable)x$4 -> {
            String content = ((IterableOnceOps)$this.diagnostics.allDiagnostics().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    AbsolutePath path2 = (AbsolutePath)tuple2._1();
                    Diagnostic diag = (Diagnostic)tuple2._2();
                    int startLine = diag.getRange().getStart().getLine();
                    int endLine = diag.getRange().getEnd().getLine();
                    return path2.toRelative($this.scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath) + " (" + startLine + "-" + endLine + "): " + diag.getMessage();
                }
                throw new MatchError((Object)tuple2);
            })).mkString("\n");
            return new McpSchema.CallToolResult(this.createContent(content), Predef$.MODULE$.boolean2Boolean(false));
        }, $this.ec)).toMono()));
    }

    private McpServerFeatures.AsyncToolSpecification createFileCompileTool() {
        String schema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n         |  \"type\": \"object\",\n         |  \"properties\": {\n         |    \"fileInFocus\": {\n         |      \"type\": \"string\",\n         |      \"description\": \"The file to compile, if empty we will try to detect file in focus\"\n         |    }\n         |  }\n         |}"));
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("compile-file", "Compile a chosenScala file", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            AbsolutePath path2 = this.XtensionArguments((Map<String, Object>)arguments).getFileInFocus();
            return this.XtensionFuture($this.compilations.compileFile(path2, $this.compilations.compileFile$default$2(), $this.compilations.compileFile$default$3()).map((Function1 & Serializable)x0$1 -> {
                Option option = x0$1;
                if (option instanceof Some) {
                    String result = ((IterableOnceOps)$this.diagnostics.forFile(path2).map((Function1 & Serializable)d -> {
                        int startLine = d.getRange().getStart().getLine();
                        int endLine = d.getRange().getEnd().getLine();
                        return "(" + startLine + "-" + endLine + "):\n" + d.getMessage();
                    })).mkString("\n");
                    return new McpSchema.CallToolResult(this.createContent(result), Predef$.MODULE$.boolean2Boolean(false));
                }
                if (None$.MODULE$.equals(option)) {
                    return new McpSchema.CallToolResult(this.createContent("Error: Incorrect file path: " + path2.toString()), Predef$.MODULE$.boolean2Boolean(true));
                }
                throw new MatchError((Object)option);
            }, $this.ec)).toMono();
        }));
    }

    private McpServerFeatures.AsyncToolSpecification createTestTool() {
        String schema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n         |  \"type\": \"object\",\n         |    \"properties\": {\n         |      \"testFile\": {\n         |        \"type\": \"string\",\n         |        \"description\": \"The file containing the test suite, if empty we will try to detect it\"\n         |      },\n         |      \"testClass\": {\n         |        \"type\": \"string\",\n         |        \"description\": \"Fully qualified name of the test class to run\"\n         |      },\n         |      \"verbose\": {\n         |        \"type\": \"boolean\",\n         |        \"description\": \"Print all output from the test suite, otherwise prints only errors and summary\",\n         |        \"default\": false\n         |      }\n         |    },\n         |    \"required\": [\"testClass\"]\n         |  }\n         |}"));
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("test", "Run Scala test suite", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            Future future;
            boolean printOnlyErrorsAndSummary;
            Option optPath;
            String testClass = (String)this.XtensionArguments((Map<String, Object>)arguments).getAs("testClass");
            Either<String, Future<String>> result = $this.mcpTestRunner.runTests(testClass, (Option<AbsolutePath>)(optPath = this.XtensionArguments((Map<String, Object>)arguments).getOptAs("testFile").map((Function1 & Serializable)path2 -> AbsolutePath$.MODULE$.apply(Path.of(path2, new String[0]), $this.scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath))), printOnlyErrorsAndSummary = BoxesRunTime.unboxToBoolean(this.XtensionArguments((Map<String, Object>)arguments).getAs("verbose")));
            Either<String, Future<String>> either = result;
            if (either instanceof Right) {
                Right right = (Right)either;
                Future value = (Future)right.value();
                future = value.map((Function1 & Serializable)content -> new McpSchema.CallToolResult(this.createContent((String)content), Predef$.MODULE$.boolean2Boolean(false)), $this.ec);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                future = Future$.MODULE$.successful((Object)new McpSchema.CallToolResult(this.createContent("Error: " + error), Predef$.MODULE$.boolean2Boolean(true)));
            } else {
                throw new MatchError(either);
            }
            return this.XtensionFuture(future).toMono();
        }));
    }

    private McpServerFeatures.AsyncToolSpecification createGlobSearchTool() {
        String schema = "\n      {\n        \"type\": \"object\",\n        \"properties\": {\n          \"query\": {\n            \"type\": \"string\",\n            \"description\": \"Substring of the symbol to search for\"\n          },\n          \"fileInFocus\": {\n            \"type\": \"string\",\n            \"description\": \"The current file in focus for context, if empty we will try to detect it\"\n          }\n        },\n        \"required\": [\"query\"]\n      }\n    ";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("glob-search", "Search for symbols using glob pattern", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            String query = (String)this.XtensionArguments((Map<String, Object>)arguments).getAs("query");
            AbsolutePath path2 = this.XtensionArguments((Map<String, Object>)arguments).getFileInFocus();
            return this.XtensionFuture($this.queryEngine.globSearch(query, (Set<SymbolType>)Predef$.MODULE$.Set().empty(), path2).map((Function1 & Serializable)result -> new McpSchema.CallToolResult(this.createContent(((IterableOnceOps)result.map((Function1 & Serializable)x$5 -> McpPrinter$.MODULE$.XtensionSearchResult((SymbolSearchResult)x$5).show())).mkString("\n")), Predef$.MODULE$.boolean2Boolean(false)), $this.ec)).toMono();
        }));
    }

    private McpServerFeatures.AsyncToolSpecification createTypedGlobSearchTool() {
        String schema = "\n      {\n        \"type\": \"object\",\n        \"properties\": {\n          \"query\": {\n            \"type\": \"string\",\n            \"description\": \"Substring of the symbol to search for\"\n          },\n          \"symbolType\": {\n            \"type\": \"array\",\n            \"items\": {\n              \"type\": \"string\",\n              \"enum\": [\"package\", \"class\", \"object\", \"function\", \"method\", \"trait\"]\n            },\n            \"description\": \"The type of symbol to search for\"\n          },\n          \"fileInFocus\": {\n            \"type\": \"string\",\n            \"description\": \"The current file in focus for context, if empty we will try to detect it\"\n          }\n        },\n        \"required\": [\"query\", \"symbolType\"]\n      }\n    ";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("typed-glob-search", "Search for symbols by type using glob pattern", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            String query = (String)this.XtensionArguments((Map<String, Object>)arguments).getAs("query");
            AbsolutePath path2 = this.XtensionArguments((Map<String, Object>)arguments).getFileInFocus();
            Set symbolTypes = ((IterableOnceOps)MetalsEnrichments$.MODULE$.ListHasAsScala((java.util.List)this.XtensionArguments((Map<String, Object>)arguments).getAs("symbolType")).asScala().flatMap((Function1 & Serializable)s -> SymbolType$.MODULE$.values().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetalsMcpServer.$anonfun$createTypedGlobSearchTool$3(s, x$6))))).toSet();
            return this.XtensionFuture($this.queryEngine.globSearch(query, (Set<SymbolType>)symbolTypes, path2).map((Function1 & Serializable)result -> new McpSchema.CallToolResult(this.createContent(((IterableOnceOps)result.map((Function1 & Serializable)x$7 -> McpPrinter$.MODULE$.XtensionSearchResult((SymbolSearchResult)x$7).show())).mkString("\n")), Predef$.MODULE$.boolean2Boolean(false)), $this.ec)).toMono();
        }));
    }

    private McpServerFeatures.AsyncToolSpecification createInspectTool() {
        String schema = "\n      {\n        \"type\": \"object\",\n        \"properties\": {\n          \"fqcn\": {\n            \"type\": \"string\",\n            \"description\": \"Fully qualified name of the symbol to inspect\"\n          },\n          \"fileInFocus\": {\n            \"type\": \"string\",\n            \"description\": \"The current file in focus for context, if empty we will try to detect it\"\n          }\n        },\n        \"required\": [\"fqcn\"]\n      }\n    ";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("inspect", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Inspect a chosen Scala symbol.\n           |For packages, objects and traits returns list of members.\n           |For classes returns list of members and constructors.\n           |For methods returns signatures of all overloaded methods.")), schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            String fqcn = this.XtensionArguments((Map<String, Object>)arguments).getFqcn();
            AbsolutePath path2 = this.XtensionArguments((Map<String, Object>)arguments).getFileInFocus();
            return this.XtensionFuture($this.queryEngine.inspect(fqcn, path2).map((Function1 & Serializable)result -> new McpSchema.CallToolResult(this.createContent(McpPrinter$.MODULE$.XtensionSymbolInspectResultList((List<SymbolInspectResult>)result).show()), Predef$.MODULE$.boolean2Boolean(false)), $this.ec)).toMono();
        }));
    }

    private McpServerFeatures.AsyncToolSpecification createGetDocsTool() {
        String schema = "\n      {\n        \"type\": \"object\",\n        \"properties\": {\n          \"fqcn\": {\n            \"type\": \"string\",\n            \"description\": \"Fully qualified name of the symbol to get documentation for\"\n          }\n        },\n        \"required\": [\"fqcn\"]\n      }\n    ";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("get-docs", "Get documentation for a chosen Scala symbol", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            String fqcn = this.XtensionArguments((Map<String, Object>)arguments).getFqcn();
            return this.XtensionFuture(Future$.MODULE$.apply((Function0 & Serializable)() -> {
                Option<SymbolDocumentationSearchResult> option = $this.queryEngine.getDocumentation(fqcn);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SymbolDocumentationSearchResult result = (SymbolDocumentationSearchResult)some.value();
                    return new McpSchema.CallToolResult(this.createContent(McpPrinter$.MODULE$.XtensionSymbolDocumentation(result).show()), Predef$.MODULE$.boolean2Boolean(false));
                }
                if (None$.MODULE$.equals(option)) {
                    return new McpSchema.CallToolResult(this.createContent("Error: Symbol not found"), Predef$.MODULE$.boolean2Boolean(false));
                }
                throw new MatchError(option);
            }, $this.ec)).toMono();
        }));
    }

    private McpServerFeatures.AsyncToolSpecification createGetUsagesTool() {
        String schema = "\n      {\n        \"type\": \"object\",\n        \"properties\": {\n          \"fqcn\": { \n            \"type\": \"string\",\n            \"description\": \"Fully qualified name of the symbol to get usages for\"\n          },\n          \"fileInFocus\": {\n            \"type\": \"string\",\n            \"description\": \"The current file in focus for context, if empty we will try to detect it\"\n          }\n        },\n        \"required\": [\"fqcn\"]\n      }\n    ";
        return new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool("get-usages", "Get usages for a chosen Scala symbol. Returns list of files with line numbers.", schema), this.withErrorHandling((Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>>)(Function2 & Serializable)(exchange, arguments) -> {
            String fqcn = this.XtensionArguments((Map<String, Object>)arguments).getFqcn();
            AbsolutePath path2 = this.XtensionArguments((Map<String, Object>)arguments).getFileInFocus();
            return this.XtensionFuture(Future$.MODULE$.apply((Function0 & Serializable)() -> {
                List<SymbolUsage> result = $this.queryEngine.getUsages(fqcn, path2);
                return new McpSchema.CallToolResult(this.createContent(McpPrinter$.MODULE$.XtensionSymbolUsageList(result).show($this.scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath)), Predef$.MODULE$.boolean2Boolean(false));
            }, $this.ec)).toMono();
        }));
    }

    private BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> withErrorHandling(Function2<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> f) {
        return (exchange, arguments) -> {
            Mono mono;
            try {
                mono = (Mono)f.apply(exchange, arguments);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    package$.MODULE$.warn((Function0 & Serializable)() -> "Error while processing request: " + throwable2.getMessage() + ", arguments: " + JsonParser$.MODULE$.XtensionSerializableToJson(arguments).toJson() + ", stacktrace:" + Predef$.MODULE$.wrapRefArray((Object[])throwable2.getStackTrace()).mkString("\n"), new Pkg("scala.meta.internal.metals.mcp"), new FileName("MetalsMcpServer.scala"), new Name("withErrorHandling"), new Line(567), MDC$.MODULE$.instance());
                    mono = Mono.just((Object)new McpSchema.CallToolResult(this.createContent("Error: " + throwable2.getMessage() + ", arguments: " + JsonParser$.MODULE$.XtensionSerializableToJson(arguments).toJson()), Predef$.MODULE$.boolean2Boolean(true)));
                }
                throw throwable;
            }
            return mono;
        };
    }

    public <T> XtensionFuture<T> XtensionFuture(Future<T> f) {
        return new XtensionFuture<T>(this, f);
    }

    public XtensionArguments XtensionArguments(Map<String, Object> arguments) {
        return new XtensionArguments(this, arguments);
    }

    public static final /* synthetic */ boolean $anonfun$run$3(MetalsMcpServer $this, Editor x$1) {
        String string = x$1.name();
        String string2 = $this.editorName;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createTypedGlobSearchTool$3(String s$1, SymbolType x$6) {
        String string = x$6.name();
        String string2 = s$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public MetalsMcpServer(McpQueryEngine queryEngine, AbsolutePath projectPath, Compilations compilations, Function0<Option<AbsolutePath>> focusedDocument, Diagnostics diagnostics, BuildTargets buildTargets, McpTestRunner mcpTestRunner, String editorName, String projectName, LanguageClient languageClient, ConnectionProvider connectionProvider, ExecutionContext ec) {
        this.queryEngine = queryEngine;
        this.scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath = projectPath;
        this.compilations = compilations;
        this.scala$meta$internal$metals$mcp$MetalsMcpServer$$focusedDocument = focusedDocument;
        this.diagnostics = diagnostics;
        this.buildTargets = buildTargets;
        this.mcpTestRunner = mcpTestRunner;
        this.editorName = editorName;
        this.projectName = projectName;
        this.languageClient = languageClient;
        this.connectionProvider = connectionProvider;
        this.ec = ec;
        this.scala$meta$internal$metals$mcp$MetalsMcpServer$$objectMapper = new ObjectMapper();
        this.scala$meta$internal$metals$mcp$MetalsMcpServer$$sseEndpoint = "/sse";
    }

    public class XtensionArguments {
        private final Map<String, Object> arguments;
        public final /* synthetic */ MetalsMcpServer $outer;

        public Map<String, Object> arguments() {
            return this.arguments;
        }

        public String getFqcn() {
            return StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString((String)this.getAs("fqcn")), "_empty_.");
        }

        public <T> T getAs(String key) {
            Object object = this.arguments().get(key);
            if (object == null) {
                throw new MissingArgumentException(key);
            }
            return (T)Try$.MODULE$.apply((Function0 & Serializable)() -> object).toOption().getOrElse((Function0 & Serializable)() -> {
                throw new IncorrectArgumentTypeException(key, object.getClass().getName());
            });
        }

        public <T> Option<T> getOptAs(String key) {
            Object object = this.arguments().get(key);
            if (object == null) {
                return None$.MODULE$;
            }
            return Try$.MODULE$.apply((Function0 & Serializable)() -> object).toOption().orElse((Function0 & Serializable)() -> {
                throw new IncorrectArgumentTypeException(key, object.getClass().getName());
            });
        }

        public AbsolutePath getFileInFocus() {
            return (AbsolutePath)this.getOptAs("fileInFocus").filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$8)))).map((Function1 & Serializable)path2 -> AbsolutePath$.MODULE$.apply(Path.of(path2, new String[0]), $this.scala$meta$internal$metals$mcp$MetalsMcpServer$XtensionArguments$$$outer().scala$meta$internal$metals$mcp$MetalsMcpServer$$projectPath)).orElse(this.scala$meta$internal$metals$mcp$MetalsMcpServer$XtensionArguments$$$outer().scala$meta$internal$metals$mcp$MetalsMcpServer$$focusedDocument).getOrElse((Function0 & Serializable)() -> {
                throw MissingFileInFocusException$.MODULE$;
            });
        }

        public /* synthetic */ MetalsMcpServer scala$meta$internal$metals$mcp$MetalsMcpServer$XtensionArguments$$$outer() {
            return this.$outer;
        }

        public XtensionArguments(MetalsMcpServer $outer, Map<String, Object> arguments) {
            this.arguments = arguments;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class XtensionFuture<T> {
        private final Future<T> f;
        public final /* synthetic */ MetalsMcpServer $outer;

        public Future<T> f() {
            return this.f;
        }

        public Mono<T> toMono() {
            return Mono.fromFuture(MetalsEnrichments$.MODULE$.XtensionScalaFuture(this.f()).asJava());
        }

        public /* synthetic */ MetalsMcpServer scala$meta$internal$metals$mcp$MetalsMcpServer$XtensionFuture$$$outer() {
            return this.$outer;
        }

        public XtensionFuture(MetalsMcpServer $outer, Future<T> f) {
            this.f = f;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

