/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.bsp;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.BspServers$;
import scala.meta.internal.bsp.ConnectionBspStatus;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.ClosableOutputStream;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.JdkSources$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.SocketConnection;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.metals.WorkDoneProgress;
import scala.meta.internal.metals.clients.language.ConfiguredLanguageClient;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.internal.process.SystemProcess;
import scala.meta.internal.process.SystemProcess$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\f\u0019\u0005\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"Aq\r\u0001B\u0001B\u0003-\u0001\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003~\u0001\u0011%a\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003/\u0002A\u0011BA-\u000f\u001d\ty\u0007\u0007E\u0001\u0003c2aa\u0006\r\t\u0002\u0005M\u0004B\u00028\u0014\t\u0003\t)\bC\u0004\u0002xM!\t!!\u001f\t\u000f\u0005\r5\u0003\"\u0001\u0002\u0006\nQ!i\u001d9TKJ4XM]:\u000b\u0005eQ\u0012a\u00012ta*\u00111\u0004H\u0001\tS:$XM\u001d8bY*\u0011QDH\u0001\u0005[\u0016$\u0018MC\u0001 \u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r\"S\"\u0001\u0010\n\u0005\u0015r\"AB!osJ+g-A\u0007nC&twk\u001c:lgB\f7-\u001a\t\u0003Q-j\u0011!\u000b\u0006\u0003Uq\t!![8\n\u00051J#\u0001D!cg>dW\u000f^3QCRD\u0017aB2iCJ\u001cX\r\u001e\t\u0003_Uj\u0011\u0001\r\u0006\u0003[ER!AM\u001a\u0002\u00079LwNC\u00015\u0003\u0011Q\u0017M^1\n\u0005Y\u0002$aB\"iCJ\u001cX\r^\u0001\u0007G2LWM\u001c;\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00037b]\u001e,\u0018mZ3\u000b\u0005ur\u0014aB2mS\u0016tGo\u001d\u0006\u0003\u007fi\ta!\\3uC2\u001c\u0018BA!;\u0005a\u0019uN\u001c4jOV\u0014X\r\u001a'b]\u001e,\u0018mZ3DY&,g\u000e^\u0001\fEVLG\u000eZ\"mS\u0016tG\u000f\u0005\u0002E\u000b6\ta(\u0003\u0002G}\t\tR*\u001a;bYN\u0014U/\u001b7e\u00072LWM\u001c;\u0002\rQ\f'\r\\3t!\t!\u0015*\u0003\u0002K}\t1A+\u00192mKN\f1DY:q\u000f2|'-\u00197J]N$\u0018\r\u001c7ESJ,7\r^8sS\u0016\u001c\bcA'VO9\u0011aj\u0015\b\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005Qs\u0012a\u00029bG.\fw-Z\u0005\u0003-^\u0013A\u0001T5ti*\u0011AKH\u0001\u0007G>tg-[4\u0011\u0005\u0011S\u0016BA.?\u0005IiU\r^1mgN+'O^3s\u0007>tg-[4\u0002\u0015U\u001cXM]\"p]\u001aLw\rE\u0002$=\u0002L!a\u0018\u0010\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001#b\u0013\t\u0011gHA\tVg\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\f\u0001c^8sW\u0012{g.\u001a)s_\u001e\u0014Xm]:\u0011\u0005\u0011+\u0017B\u00014?\u0005A9vN]6E_:,\u0007K]8he\u0016\u001c8/\u0001\u0002fGB\u0011\u0011\u000e\\\u0007\u0002U*\u00111NH\u0001\u000bG>t7-\u001e:sK:$\u0018BA7k\u0005})\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015A$XO^<ysj\\H\u0010\u0006\u0002rgB\u0011!\u000fA\u0007\u00021!)qm\u0003a\u0002Q\")ae\u0003a\u0001O!)Qf\u0003a\u0001]!)qg\u0003a\u0001q!)!i\u0003a\u0001\u0007\")qi\u0003a\u0001\u0011\")1j\u0003a\u0001\u0019\")\u0001l\u0003a\u00013\")Al\u0003a\u0001;\")1m\u0003a\u0001I\u0006\t2-^:u_6\u0004&o\u001c6fGR\u0014vn\u001c;\u0016\u0003}\u0004BaIA\u0001O%\u0019\u00111\u0001\u0010\u0003\r=\u0003H/[8o\u0003\u001d\u0011Xm]8mm\u0016$\"!!\u0003\u0011\u0007I\fY!C\u0002\u0002\u000ea\u0011\u0011CQ:q%\u0016\u001cx\u000e\u001c<fIJ+7/\u001e7u\u0003%qWm^*feZ,'\u000f\u0006\u0006\u0002\u0014\u0005}\u00111EA\u0014\u0003\u0003\u0002R![A\u000b\u00033I1!a\u0006k\u0005\u00191U\u000f^;sKB\u0019A)a\u0007\n\u0007\u0005uaHA\u000bCk&dGmU3sm\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8\t\r\u0005\u0005b\u00021\u0001(\u0003A\u0001(o\u001c6fGR$\u0015N]3di>\u0014\u0018\u0010\u0003\u0004\u0002&9\u0001\raJ\u0001\rEN\u0004HK]1dKJ{w\u000e\u001e\u0005\b\u0003Sq\u0001\u0019AA\u0016\u0003\u001d!W\r^1jYN\u0004B!!\f\u0002>5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0003cgB$$NC\u0002 \u0003kQA!a\u000e\u0002:\u0005!Q\r\u001d4m\u0015\t\tY$\u0001\u0002dQ&!\u0011qHA\u0018\u0005Q\u00115\u000f]\"p]:,7\r^5p]\u0012+G/Y5mg\"9\u00111\t\bA\u0002\u0005\u0015\u0013\u0001\u00042taN#\u0018\r^;t\u001fB$\b#B\u0012\u0002\u0002\u0005\u001d\u0003c\u0001:\u0002J%\u0019\u00111\n\r\u0003'\r{gN\\3di&|gNQ:q'R\fG/^:\u0002)\u0019Lg\u000eZ!wC&d\u0017M\u00197f'\u0016\u0014h/\u001a:t)\t\t\t\u0006\u0005\u0003N+\u0006-\u0012!\u00044j]\u0012T5o\u001c8GS2,7\u000fF\u0001M\u0003M!\u0017nZ3tiN+'O^3s\t\u0016$\u0018-\u001b7t)\u0011\tY&a\u001b\u0011\t\u0005u\u0013Q\r\b\u0005\u0003?\n\t\u0007\u0005\u0002P=%\u0019\u00111\r\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t9'!\u001b\u0003\rM#(/\u001b8h\u0015\r\t\u0019G\b\u0005\b\u0003[\n\u0002\u0019AA)\u0003)\u0019\u0017M\u001c3jI\u0006$Xm]\u0001\u000b\u0005N\u00048+\u001a:wKJ\u001c\bC\u0001:\u0014'\t\u0019\"\u0005\u0006\u0002\u0002r\u0005Ar\r\\8cC2Len\u001d;bY2$\u0015N]3di>\u0014\u0018.Z:\u0015\u00071\u000bY\b\u0003\u0004h+\u0001\u000f\u0011Q\u0010\t\u0004S\u0006}\u0014bAAAU\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0010e\u0016\fG-\u00138CgB\u001cuN\u001c4jOR1\u0011qQAE\u0003\u001b\u0003RaIA\u0001\u0003WAa!a#\u0017\u0001\u00049\u0013\u0001\u00029bi\"DQ!\f\fA\u00029\u0002")
public final class BspServers {
    private final AbsolutePath mainWorkspace;
    private final Charset charset;
    private final ConfiguredLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final MetalsServerConfig config;
    private final Function0<UserConfiguration> userConfig;
    private final WorkDoneProgress workDoneProgress;
    private final ExecutionContextExecutorService ec;

    public static Option<BspConnectionDetails> readInBspConfig(AbsolutePath path2, Charset charset) {
        return BspServers$.MODULE$.readInBspConfig(path2, charset);
    }

    public static List<AbsolutePath> globalInstallDirectories(ExecutionContext ec) {
        return BspServers$.MODULE$.globalInstallDirectories(ec);
    }

    private Option<AbsolutePath> customProjectRoot() {
        return ((UserConfiguration)this.userConfig.apply()).getCustomProjectRoot(this.mainWorkspace);
    }

    public BspResolvedResult resolve() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return ResolvedNone$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new ResolvedBspOne(head);
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & Serializable)name -> list.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$resolve$2(name, x$1))).map((Function1 & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails details = (BspConnectionDetails)some.value();
            return new ResolvedBspOne(details);
        }
        if (None$.MODULE$.equals(option)) {
            return new ResolvedMultiple(md5, list);
        }
        throw new MatchError((Object)option);
    }

    public Future<BuildServerConnection> newServer(AbsolutePath projectDirectory, AbsolutePath bspTraceRoot, BspConnectionDetails details, Option<ConnectionBspStatus> bspStatusOpt) {
        AbsolutePath x$1 = projectDirectory;
        AbsolutePath x$2 = bspTraceRoot;
        MetalsBuildClient x$3 = this.buildClient;
        ConfiguredLanguageClient x$4 = this.client;
        Function0 & Serializable x$5 = (Function0 & Serializable)() -> this.newConnection$1(details, projectDirectory);
        DismissedNotifications.Notification x$6 = this.tables.dismissedNotifications().ReconnectBsp();
        DismissedNotifications.Notification x$7 = this.tables.dismissedNotifications().RequestTimeout();
        MetalsServerConfig x$8 = this.config;
        UserConfiguration x$9 = (UserConfiguration)this.userConfig.apply();
        String x$10 = details.getName();
        Option<ConnectionBspStatus> x$11 = bspStatusOpt;
        WorkDoneProgress x$12 = this.workDoneProgress;
        int x$13 = BuildServerConnection$.MODULE$.fromSockets$default$12();
        Option<Object> x$14 = BuildServerConnection$.MODULE$.fromSockets$default$13();
        return BuildServerConnection$.MODULE$.fromSockets(x$1, x$2, x$3, x$4, (Function0<Future<SocketConnection>>)x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$13, x$14, x$12, this.ec);
    }

    public List<BspConnectionDetails> findAvailableServers() {
        return this.findJsonFiles().flatMap((Function1 & Serializable)x$2 -> BspServers$.MODULE$.readInBspConfig((AbsolutePath)x$2, $this.charset));
    }

    private List<AbsolutePath> findJsonFiles() {
        Builder buf = package$.MODULE$.List().newBuilder();
        BspServers.visit$1(this.mainWorkspace.resolve(Directories$.MODULE$.bsp()), buf);
        this.customProjectRoot().map((Function1 & Serializable)x$3 -> x$3.resolve(Directories$.MODULE$.bsp())).foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        this.bspGlobalInstallDirectories.foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$resolve$2(String name$1, BspConnectionDetails x$1) {
        String string = x$1.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Future newConnection$1(BspConnectionDetails details$1, AbsolutePath projectDirectory$1) {
        Map map;
        List args = MetalsEnrichments$.MODULE$.ListHasAsScala(details$1.getArgv()).asScala().toList().map((Function1 & Serializable)arg -> {
            if (Properties$.MODULE$.isWin() && arg.contains("-Dsbt.script=") && !arg.contains("file://")) {
                String string = URIEncoderDecoder$.MODULE$.decode(arg);
                String string2 = arg;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return arg.replace("-Dsbt.script=", "-Dsbt.script=file://");
                }
            }
            return arg;
        });
        if (scala.sys.package$.MODULE$.env().contains((Object)"JAVA_HOME") && details$1.getName().contains("bazel")) {
            Some some;
            Tuple2 tuple2;
            Option option = ((UserConfiguration)this.userConfig.apply()).javaHome().zip(scala.sys.package$.MODULE$.env().get((Object)"JAVA_HOME"));
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                String metalsHome = (String)tuple2._1();
                String envHome = (String)tuple2._2();
                String string = metalsHome;
                String string2 = envHome;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)scribe.package$.MODULE$.warn((Function0 & Serializable)() -> "JAVA_HOME set by Metals (" + metalsHome + ") would be different than the one set in the environment (" + envHome + "), which might cause Bazel to restart on shell, so Metals will not override it.", new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("variables"), new Line(109), MDC$.MODULE$.instance());
                }
            }
            map = Predef$.MODULE$.Map().empty();
        } else {
            map = JdkSources$.MODULE$.envVariables(((UserConfiguration)this.userConfig.apply()).javaHome());
        }
        Map variables = map;
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Running BSP server " + args, new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("newConnection"), new Line(117), MDC$.MODULE$.instance());
        List x$1 = args;
        AbsolutePath x$2 = projectDirectory$1;
        boolean x$3 = false;
        Map x$4 = (Map)variables.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SCALA_CLI_POWER"), (Object)"true"));
        None$ x$5 = None$.MODULE$;
        Some x$6 = new Some((Function1 & Serializable)l -> {
            scribe.package$.MODULE$.info((Function0 & Serializable)() -> "BSP server: " + l, new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("proc"), new Line(124), MDC$.MODULE$.instance());
            return BoxedUnit.UNIT;
        });
        boolean x$7 = false;
        String x$8 = "bsp-" + details$1.getName();
        boolean x$9 = SystemProcess$.MODULE$.run$default$7();
        SystemProcess proc = SystemProcess$.MODULE$.run((List<String>)x$1, x$2, false, (Map<String, String>)x$4, (Option<Function1<String, BoxedUnit>>)x$5, (Option<Function1<String, BoxedUnit>>)x$6, x$9, false, x$8, (ExecutionContext)this.ec);
        ClosableOutputStream output = new ClosableOutputStream(proc.outputStream(), details$1.getName() + " output stream");
        QuietInputStream input = new QuietInputStream(proc.inputStream(), details$1.getName() + " input stream");
        Promise finished = Promise$.MODULE$.apply();
        MetalsEnrichments$.MODULE$.XtensionScalaFuture(proc.complete()).ignoreValue((ExecutionContext)this.ec).onComplete((Function1 & Serializable)res -> BoxesRunTime.boxToBoolean((boolean)finished.tryComplete(res)), (ExecutionContext)this.ec);
        return Future$.MODULE$.successful((Object)new SocketConnection(details$1.getName(), output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> proc.cancel()), (List)Nil$.MODULE$), (Promise<BoxedUnit>)finished));
    }

    public static final /* synthetic */ void $anonfun$findJsonFiles$1(Builder buf$1, AbsolutePath p) {
        String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(p).extension();
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            buf$1.$plus$eq((Object)p);
            return;
        }
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().foreach((Function1 & Serializable)p -> {
            BspServers.$anonfun$findJsonFiles$1(buf$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public BspServers(AbsolutePath mainWorkspace, Charset charset, ConfiguredLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, MetalsServerConfig config, Function0<UserConfiguration> userConfig, WorkDoneProgress workDoneProgress, ExecutionContextExecutorService ec) {
        this.mainWorkspace = mainWorkspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.config = config;
        this.userConfig = userConfig;
        this.workDoneProgress = workDoneProgress;
        this.ec = ec;
    }
}

