/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import java.io.Serializable;
import java.nio.charset.Charset;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.debug.DotEnvFileParser;
import scala.meta.io.AbsolutePath;
import scala.util.matching.Regex;

public final class DotEnvFileParser$ {
    public static final DotEnvFileParser$ MODULE$ = new DotEnvFileParser$();
    private static final Regex LineRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?xms)\n        (?:^|\\A)           # start of line\n        \\s*                # leading whitespace\n        (?:export\\s+)?     # export (optional)\n        (                  # start variable name (captured)\n          [a-zA-Z_]          # single alphabetic or underscore character\n          [a-zA-Z0-9_]*    # zero or more alphnumeric, underscore\n        )                  # end variable name (captured)\n        (?:\\s*[=:]\\s*?)       # assignment with whitespace\n        (                  # start variable value (captured)\n          '(?:\\\\'|[^'])*'    # single quoted variable\n          |                  # or\n          \"(?:\\\\\"|[^\"])*\"    # double quoted variable\n          |                  # or\n          [^\\#\\r\\n]*         # unquoted variable\n        )                  # end variable value (captured)\n        \\s*                # trailing whitespace\n        (?:                # start trailing comment (optional)\n          \\#                 # begin comment\n          (?:(?!$).)*        # any character up to end-of-line\n        )?                 # end trailing comment (optional)\n        (?:$|\\z)           # end of line\n  "));

    public Regex LineRegex() {
        return LineRegex;
    }

    public Future<Map<String, String>> parse(AbsolutePath path2, ExecutionContext ec) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path2).exists() && path2.isFile() && path2.toFile().canRead()) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.parse(FileIO$.MODULE$.slurp(path2, Charset.defaultCharset())), ec);
        }
        return Future$.MODULE$.failed((Throwable)new DotEnvFileParser.InvalidEnvFileException(path2));
    }

    public Map<String, String> parse(String content) {
        return this.LineRegex().findAllMatchIn((CharSequence)content).map((Function1 & Serializable)x$1 -> {
            Option option;
            Regex.Match match = x$1;
            if (match != null && !(option = Regex.Groups$.MODULE$.unapplySeq(match)).isEmpty() && option.get() != null && ((SeqOps)option.get()).lengthCompare(2) == 0) {
                String k = (String)((SeqOps)option.get()).apply(0);
                String v = (String)((SeqOps)option.get()).apply(1);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)MODULE$.unescape(MODULE$.unquote(v)));
            }
            throw new MatchError((Object)match);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String unquote(String value) {
        String string = value.trim();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (this.startsEndsWith(string, "'")) {
            return this.trim(string).trim();
        }
        if (this.startsEndsWith(string, "\"")) {
            return this.trim(string).trim();
        }
        return string;
    }

    private boolean startsEndsWith(String s, String prefixSuffix) {
        return s.startsWith(prefixSuffix) && s.endsWith(prefixSuffix);
    }

    private String trim(String s) {
        if (s.length() > 1) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private String unescape(String s) {
        return s.replaceAll("\\\\([^$])", "$1");
    }

    private DotEnvFileParser$() {
    }
}

