/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.io.FileIO$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SbtOpts$ {
    public static final SbtOpts$ MODULE$ = new SbtOpts$();
    private static final String noShareOpts = "-Dsbt.global.base=project/.sbtboot -Dsbt.boot.directory=project/.boot -Dsbt.ivy.home=project/.ivy";
    private static final String noGlobalOpts = "-Dsbt.global.base=project/.sbtboot";
    private static final String debuggerOpts = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=";
    private static final Map<String, String> sbtToJdkOpts = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-sbt-boot"), (Object)"-Dsbt.boot.directory="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-sbt-dir"), (Object)"-Dsbt.global.base="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-ivy"), (Object)"-Dsbt.ivy.home="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-jvm-debug"), (Object)MODULE$.debuggerOpts())}));

    public List<String> fromWorkspaceOrEnv(AbsolutePath workspace) {
        AbsolutePath sbtOpts = workspace.resolve(".sbtopts");
        if (sbtOpts.isFile() && Files.isReadable(sbtOpts.toNIO())) {
            String text = FileIO$.MODULE$.slurp(sbtOpts, StandardCharsets.UTF_8);
            return this.process((List<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(text)).map((Function1 & Serializable)x$1 -> x$1.trim()).toList());
        }
        return this.fromEnvironment();
    }

    public List<String> fromEnvironment() {
        Option option = Option$.MODULE$.apply((Object)System.getenv("SBT_OPTS"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return this.process((List<String>)Predef$.MODULE$.wrapRefArray((Object[])value.split(" ")).toList());
        }
        if (None$.MODULE$.equals(option)) {
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private String noShareOpts() {
        return noShareOpts;
    }

    private String noGlobalOpts() {
        return noGlobalOpts;
    }

    private String debuggerOpts() {
        return debuggerOpts;
    }

    private Map<String, String> sbtToJdkOpts() {
        return sbtToJdkOpts;
    }

    private List<String> process(List<String> opts) {
        return opts.flatMap((Function1 & Serializable)opt -> {
            if (opt.startsWith("-no-share")) {
                return new Some((Object)MODULE$.noShareOpts());
            }
            if (opt.startsWith("-no-global")) {
                return new Some((Object)MODULE$.noGlobalOpts());
            }
            if (MODULE$.sbtToJdkOpts().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SbtOpts$.$anonfun$process$2(opt, x0$1)))) {
                return MODULE$.processOptWithArg((String)opt);
            }
            if (opt.contains(" ")) {
                return MODULE$.process((List<String>)Predef$.MODULE$.wrapRefArray((Object[])opt.split("\\s+")).toList());
            }
            if (opt.startsWith("-J")) {
                return new Some((Object)opt.substring(2));
            }
            if (opt.startsWith("-D")) {
                return new Some(opt);
            }
            return None$.MODULE$;
        });
    }

    private Option<String> processOptWithArg(String opt) {
        return this.sbtToJdkOpts().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SbtOpts$.$anonfun$processOptWithArg$1(opt, x0$1))).flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String x = (String)tuple2._2();
                String v = opt.replace(k, "").trim();
                if (v.isEmpty()) {
                    return None$.MODULE$;
                }
                return new Some((Object)(x + v));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$process$2(String opt$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return opt$1.startsWith(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$processOptWithArg$1(String opt$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return opt$2.startsWith(k);
        }
        throw new MatchError((Object)tuple2);
    }

    private SbtOpts$() {
    }
}

