/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.FileNameEncoderDecoder$;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportFileName$;
import scala.meta.internal.metals.ReportLevel;
import scala.meta.internal.metals.ReportTracker;
import scala.meta.internal.metals.Reporter;
import scala.meta.internal.metals.StdReportContext$;
import scala.meta.internal.metals.TimeFormatter$;
import scala.meta.internal.metals.utils.LimitedFilesManager;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.meta.pc.reports.Report;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001B\u000e\u001d\u0001\u0015B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tw\u0001\u0011\t\u0011)A\u0005g!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!b\u0001\n\u0003Z\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011u\u0003!\u0011!Q\u0001\nyCQA\u001b\u0001\u0005\u0002-Dqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004v\u0001\u0001\u0006Ia\r\u0005\tm\u0002A)\u0019!C\u0005i\"9q\u000f\u0001b\u0001\n\u0013A\bBB@\u0001A\u0003%\u0011\u0010\u0003\u0006\u0002\u0002\u0001A)\u0019!C\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003\u001fA\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005}\u0002\u0001)A\u0005\u0003SAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\n\u0003O\u0003\u0011\u0013!C\u0001\u0003SCq!a0\u0001\t\u0003\n\t\rC\u0004\u0002D\u0002!\t%a\u0011\u0003\u0017M#HMU3q_J$XM\u001d\u0006\u0003;y\ta!\\3uC2\u001c(BA\u0010!\u0003!Ig\u000e^3s]\u0006d'BA\u0011#\u0003\u0011iW\r^1\u000b\u0003\r\nQa]2bY\u0006\u001c\u0001aE\u0002\u0001M9\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004PE*,7\r\u001e\t\u0003_Aj\u0011\u0001H\u0005\u0003cq\u0011\u0001BU3q_J$XM]\u0001\no>\u00148n\u001d9bG\u0016\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\t\u0019LG.\u001a\u0006\u0003q)\n1A\\5p\u0013\tQTG\u0001\u0003QCRD\u0017!\u00049bi\"$vNU3q_J$8/\u0001\nsKN|GN^3Ck&dG\rV1sO\u0016$\b\u0003\u0002 @\u0003*k\u0011AI\u0005\u0003\u0001\n\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007y\u0012E)\u0003\u0002DE\t1q\n\u001d;j_:\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0016\u0002\u00079,G/\u0003\u0002J\r\n\u0019QKU%\u0011\u0007y\u00125\n\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\nj\u0011a\u0014\u0006\u0003!\u0012\na\u0001\u0010:p_Rt\u0014B\u0001*#\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0013\u0013!\u00027fm\u0016d\u0007CA\u0018Y\u0013\tIFDA\u0006SKB|'\u000f\u001e'fm\u0016d\u0017\u0001\u00028b[\u0016,\u0012aS\u0001\u0006]\u0006lW\rI\u0001\u000fe\u0016\u0004xN\u001d;Ue\u0006\u001c7.\u001a:t!\ryFm\u001a\b\u0003A\nt!AT1\n\u0003\rJ!a\u0019\u0012\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002dEA\u0011q\u0006[\u0005\u0003Sr\u0011QBU3q_J$HK]1dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0004m[:|\u0007/\u001d:\u0011\u0005=\u0002\u0001\"\u0002\u001a\t\u0001\u0004\u0019\u0004\"B\u001e\t\u0001\u0004\u0019\u0004\"\u0002\u001f\t\u0001\u0004i\u0004\"\u0002,\t\u0001\u00049\u0006\"\u0002.\t\u0001\u0004Y\u0005\"B/\t\u0001\u0004q\u0016aD7bs\n,'+\u001a9peR\u001cH)\u001b:\u0016\u0003M\n\u0001#\\1zE\u0016\u0014V\r]8siN$\u0015N\u001d\u0011\u0002\u0015I,\u0007o\u001c:ug\u0012K'/A\nmS6LG/\u001a3GS2,7/T1oC\u001e,'/F\u0001z!\tQX0D\u0001|\u0015\taH$A\u0003vi&d7/\u0003\u0002\u007fw\n\u0019B*[7ji\u0016$g)\u001b7fg6\u000bg.Y4fe\u0006!B.[7ji\u0016$g)\u001b7fg6\u000bg.Y4fe\u0002\n\u0001\"^:fe\"{W.Z\u000b\u0003\u0003\u000b\u0001BA\u0010\"\u0002\bA\u0019q%!\u0003\n\u0005QC\u0013aC5oSRL\u0017\r\\5{K\u0012,\"!a\u0004\u0011\t\u0005E\u0011qD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00051\u0011\r^8nS\u000eTA!!\u0007\u0002\u001c\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005u!&\u0001\u0003vi&d\u0017\u0002BA\u0011\u0003'\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013\u0001\u0003:fa>\u0014H/\u001a3\u0016\u0005\u0005%\u0002CBA\t\u0003W\ty#\u0003\u0003\u0002.\u0005M!aD!u_6L7MU3gKJ,gnY3\u0011\r\u0005E\u00121H&4\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C5n[V$\u0018M\u00197f\u0015\r\tIDI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001f\u0003g\u00111!T1q\u0003%\u0011X\r]8si\u0016$\u0007%A\u0005sK\u0006$\u0017J\\%egR\u0011\u0011Q\t\t\u0004}\u0005\u001d\u0013bAA%E\t!QK\\5u\u0003\u0019\u0019'/Z1uKR1\u0011qJA,\u0003o\u0002R!!\u0015\u0002TMj!!a\u0007\n\t\u0005U\u00131\u0004\u0002\t\u001fB$\u0018n\u001c8bY\"9\u0011\u0011\f\u000bA\u0002\u0005m\u0013A\u00037buf\u0014V\r]8siB1\u0011QLA2\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141D\u0001\tMVt7\r^5p]&!\u0011QMA0\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\be\u0016\u0004xN\u001d;t\u0015\r\t\t\bI\u0001\u0003a\u000eLA!!\u001e\u0002l\t1!+\u001a9peRDq!!\u001f\u0015\u0001\u0004\tY(A\u0005jMZ+'OY8tKB\u0019q%! \n\u0007\u0005}\u0004FA\u0004C_>dW-\u00198\u0002\u0011M\fg.\u001b;ju\u0016$2aSAC\u0011\u0019\t9)\u0006a\u0001\u0017\u0006!A/\u001a=u\u0003)\u0011X\r]8siB\u000bG\u000f\u001b\u000b\u0004g\u00055\u0005bBAH-\u0001\u0007\u0011qM\u0001\u0007e\u0016\u0004xN\u001d;\u0002#\rdW-\u00198Va>cGMU3q_J$8\u000f\u0006\u0003\u0002\u0016\u0006u\u0005\u0003B0e\u0003/\u00032A_AM\u0013\r\tYj\u001f\u0002\u0010)&lWm\u001d;b[B,GMR5mK\"I\u0011qT\f\u0011\u0002\u0003\u0007\u0011\u0011U\u0001\u0011[\u0006D(+\u001a9peR\u001ch*^7cKJ\u00042APAR\u0013\r\t)K\t\u0002\u0004\u0013:$\u0018aG2mK\u0006tW\u000b](mIJ+\u0007o\u001c:ug\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002,*\"\u0011\u0011UAWW\t\ty\u000b\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u0013Ut7\r[3dW\u0016$'bAA]E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00161\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC4fiJ+\u0007o\u001c:ugR\u0011\u0011QS\u0001\nI\u0016dW\r^3BY2\u0004")
public class StdReporter
implements Reporter {
    private Path reportsDir;
    private Option<String> userHome;
    private final Path workspace;
    private final Function1<Option<URI>, Option<String>> resolveBuildTarget;
    private final ReportLevel level;
    private final String name;
    private final List<ReportTracker> reportTrackers;
    private final Path maybeReportsDir;
    private final LimitedFilesManager limitedFilesManager;
    private final AtomicBoolean initialized;
    private final AtomicReference<Map<String, Path>> reported;
    private volatile byte bitmap$0;

    @Override
    public String name() {
        return this.name;
    }

    public Path maybeReportsDir() {
        return this.maybeReportsDir;
    }

    private Path reportsDir$lzycompute() {
        StdReporter stdReporter = this;
        synchronized (stdReporter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reportsDir = CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(this.maybeReportsDir()).createDirectories();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reportsDir;
    }

    private Path reportsDir() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.reportsDir$lzycompute();
        }
        return this.reportsDir;
    }

    private LimitedFilesManager limitedFilesManager() {
        return this.limitedFilesManager;
    }

    private Option<String> userHome$lzycompute() {
        StdReporter stdReporter = this;
        synchronized (stdReporter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.userHome = Option$.MODULE$.apply((Object)System.getProperty("user.home"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.userHome;
    }

    private Option<String> userHome() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.userHome$lzycompute();
        }
        return this.userHome;
    }

    private AtomicBoolean initialized() {
        return this.initialized;
    }

    private AtomicReference<Map<String, Path>> reported() {
        return this.reported;
    }

    public void readInIds() {
        Map reports = this.getReports().flatMap((Function1 & Serializable)report -> {
            Object object;
            try {
                java.util.List<String> lines = Files.readAllLines(report.file().toPath());
                if (lines.size() > 0) {
                    String string = lines.get(0);
                    switch (string == null ? 0 : string.hashCode()) {
                        default: 
                    }
                    object = string.startsWith(Report$.MODULE$.idPrefix()) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(string), Report$.MODULE$.idPrefix())), (Object)report.toPath())) : None$.MODULE$;
                } else {
                    object = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    object = None$.MODULE$;
                }
                throw throwable;
            }
            return object;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.reported().updateAndGet(x$5 -> (Map)x$5.$plus$plus((IterableOnce)reports));
    }

    public Optional<Path> create(Supplier<Report> lazyReport, Boolean ifVerbose) {
        if (Predef$.MODULE$.Boolean2boolean(ifVerbose) && !this.level.isVerbose()) {
            return Optional.empty();
        }
        return CommonMtagsEnrichments$.MODULE$.XtensionOptionScala(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (this.initialized().compareAndSet(false, true)) {
                this.readInIds();
            }
            Report report = (Report)lazyReport.get();
            Option sanitizedId = CommonMtagsEnrichments$.MODULE$.XtensionOptionalJava(report.id()).asScala().map((Function1 & Serializable)text -> this.sanitize((String)text));
            Path path2 = this.reportPath(report);
            Option optDuplicate = sanitizedId.map((Function1 & Serializable)id -> {
                Map<String, Path> reportedMap = this.reported().getAndUpdate(map -> {
                    if (map.contains(id)) {
                        return map;
                    }
                    return (Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(id), (Object)path2));
                });
                return new Tuple2(id, reportedMap);
            }).flatMap((Function1 & Serializable)x$6 -> {
                Tuple2 tuple2 = x$6;
                if (tuple2 != null) {
                    String id = (String)tuple2._1();
                    Map reportedMap = (Map)tuple2._2();
                    return reportedMap.get((Object)id).map((Function1 & Serializable)duplicate -> duplicate);
                }
                throw new MatchError((Object)tuple2);
            });
            Path pathToReport = (Path)optDuplicate.getOrElse((Function0 & Serializable)() -> {
                CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path2).createDirectories();
                CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path2).writeText(this.sanitize(report.fullText(true)));
                package$.MODULE$.info((Function0 & Serializable)() -> "Created report: " + report.path(), new Pkg("scala.meta.internal.metals"), new FileName("ReportContext.scala"), new Name("pathToReport"), new Line(166), MDC$.MODULE$.instance());
                $this.reportTrackers.foreach((Function1 & Serializable)x$7 -> {
                    x$7.reportCreated(report);
                    return BoxedUnit.UNIT;
                });
                return path2;
            });
            Object object = !Predef$.MODULE$.Boolean2boolean(ifVerbose) ? package$.MODULE$.info((Function0 & Serializable)() -> report.shortSummary() + " (full report at: \"" + pathToReport + "\")", new Pkg("scala.meta.internal.metals"), new FileName("ReportContext.scala"), new Name("create"), new Line(171), MDC$.MODULE$.instance()) : BoxedUnit.UNIT;
            return pathToReport;
        }).toOption()).asJava();
    }

    @Override
    public String sanitize(String text) {
        String textAfterWokspaceReplace = text.replace(((Object)this.workspace).toString(), StdReportContext$.MODULE$.WORKSPACE_STR());
        return (String)this.userHome().map((Function1 & Serializable)x$8 -> textAfterWokspaceReplace.replace((CharSequence)x$8, StdReportContext$.MODULE$.HOME_STR())).getOrElse((Function0 & Serializable)() -> textAfterWokspaceReplace);
    }

    private Path reportPath(Report report) {
        String date = TimeFormatter$.MODULE$.getDate();
        String time = TimeFormatter$.MODULE$.getTime();
        String buildTargetPart = (String)((Option)this.resolveBuildTarget.apply((Object)CommonMtagsEnrichments$.MODULE$.XtensionOptionalJava(report.path()).asScala())).map((Function1 & Serializable)args -> FileNameEncoderDecoder$.MODULE$.encode((String)args)).map((Function1 & Serializable)x$9 -> StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("_("), x$9)), ")")).getOrElse((Function0 & Serializable)() -> "");
        String filename = "r_" + report.name() + buildTargetPart + "_" + time + ".md";
        return this.reportsDir().resolve(date).resolve(filename);
    }

    @Override
    public List<TimestampedFile> cleanUpOldReports(int maxReportsNumber) {
        return this.limitedFilesManager().deleteOld(maxReportsNumber);
    }

    @Override
    public int cleanUpOldReports$default$1() {
        return StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS();
    }

    @Override
    public List<TimestampedFile> getReports() {
        return this.limitedFilesManager().getAllFiles();
    }

    @Override
    public void deleteAll() {
        this.getReports().foreach((Function1 & Serializable)r -> {
            StdReporter.$anonfun$deleteAll$3(r);
            return BoxedUnit.UNIT;
        });
        this.limitedFilesManager().directoriesWithDate().foreach((Function1 & Serializable)d -> {
            StdReporter.$anonfun$deleteAll$4(d);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAll$3(TimestampedFile r) {
        Files.delete(r.toPath());
    }

    public static final /* synthetic */ void $anonfun$deleteAll$4(File d) {
        Files.delete(d.toPath());
    }

    public StdReporter(Path workspace, Path pathToReports, Function1<Option<URI>, Option<String>> resolveBuildTarget, ReportLevel level, String name, List<ReportTracker> reportTrackers) {
        this.workspace = workspace;
        this.resolveBuildTarget = resolveBuildTarget;
        this.level = level;
        this.name = name;
        this.reportTrackers = reportTrackers;
        Reporter.$init$(this);
        this.maybeReportsDir = workspace.resolve(pathToReports).resolve(name);
        this.limitedFilesManager = new LimitedFilesManager(this.maybeReportsDir(), StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS(), ReportFileName$.MODULE$.pattern(), ".md");
        this.initialized = new AtomicBoolean(false);
        this.reported = new AtomicReference<Object>(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }
}

