/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.MetalsServerConfig$;
import scala.meta.internal.metals.TimeFormatter$;
import scala.meta.internal.metals.logging.LanguageClientLogger$;
import scala.meta.internal.metals.logging.MetalsLogger;
import scala.meta.internal.metals.logging.MetalsLogger$MetalsFilter$;
import scala.meta.internal.metals.logging.MutipleOutputsStream;
import scala.meta.internal.metals.utils.LimitedFilesManager;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.io.AbsolutePath;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scribe.Level;
import scribe.Level$;
import scribe.LogRecord;
import scribe.Logger;
import scribe.Logger$;
import scribe.LoggerSupport;
import scribe.file.FileWriter;
import scribe.file.FileWriter$;
import scribe.file.PathBuilder$;
import scribe.format.Formatter;
import scribe.format.package;
import scribe.handler.LogHandle;
import scribe.mdc.MDC;
import scribe.mdc.MDC$;
import scribe.output.format.OutputFormat;
import scribe.package$;
import scribe.writer.Writer;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MetalsLogger$ {
    public static final MetalsLogger$ MODULE$ = new MetalsLogger$();
    private static final Level level = MODULE$.logLevel(MetalsServerConfig$.MODULE$.default().loglevel());
    private static final RelativePath workspaceLogPath = RelativePath$.MODULE$.apply(".metals").resolve("metals.log");

    private Level logLevel(String level) {
        String string = level;
        switch (string == null ? 0 : string.hashCode()) {
            case 3237038: {
                if (!"info".equals(string)) break;
                return Level$.MODULE$.Info();
            }
            case 3641990: {
                if (!"warn".equals(string)) break;
                return Level$.MODULE$.Warn();
            }
            case 95458899: {
                if (!"debug".equals(string)) break;
                return Level$.MODULE$.Debug();
            }
            case 96784904: {
                if (!"error".equals(string)) break;
                return Level$.MODULE$.Error();
            }
            case 97203460: {
                if (!"fatal".equals(string)) break;
                return Level$.MODULE$.Fatal();
            }
            case 110620997: {
                if (!"trace".equals(string)) break;
                return Level$.MODULE$.Trace();
            }
        }
        return Level$.MODULE$.Info();
    }

    private Level level() {
        return level;
    }

    private RelativePath workspaceLogPath() {
        return workspaceLogPath;
    }

    public void updateDefaultFormat() {
        Logger qual$1 = Logger$.MODULE$.root().clearHandlers();
        Formatter x$1 = this.defaultFormat();
        Some x$2 = new Some((Object)this.level());
        .colon.colon x$3 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        Writer x$4 = qual$1.withHandler$default$2();
        OutputFormat x$5 = qual$1.withHandler$default$5();
        LogHandle x$6 = qual$1.withHandler$default$6();
        Logger qual$2 = qual$1.withHandler(x$1, x$4, (Option)x$2, (List)x$3, x$5, x$6);
        Option x$7 = qual$2.replace$default$1();
        qual$2.replace(x$7);
    }

    public void redirectSystemOut(AbsolutePath logfile) {
        this.redirectSystemOut((List<AbsolutePath>)new .colon.colon((Object)logfile, (List)Nil$.MODULE$));
    }

    public void redirectSystemOut(List<AbsolutePath> logfiles) {
        logfiles.foreach((Function1 & Serializable)logfile -> Files.createDirectories(logfile.toNIO().getParent(), new FileAttribute[0]));
        List logStreams = logfiles.map((Function1 & Serializable)logfile -> Files.newOutputStream(logfile.toNIO(), StandardOpenOption.APPEND, StandardOpenOption.CREATE));
        PrintStream out = new PrintStream(new MutipleOutputsStream((List<OutputStream>)logStreams));
        System.setOut(out);
        System.setErr(out);
        this.configureRootLogger(logfiles);
    }

    private void configureRootLogger(List<AbsolutePath> logfile2) {
        Logger qual$1 = (Logger)logfile2.foldLeft((Object)Logger$.MODULE$.root().clearModifiers().clearHandlers(), (Function2 & Serializable)(logger, logfile) -> {
            FileWriter x$1 = MODULE$.newFileWriter((AbsolutePath)logfile);
            Formatter x$2 = MODULE$.defaultFormat();
            Some x$3 = new Some((Object)MODULE$.level());
            .colon.colon x$4 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
            OutputFormat x$5 = logger.withHandler$default$5();
            LogHandle x$6 = logger.withHandler$default$6();
            return logger.withHandler(x$2, (Writer)x$1, (Option)x$3, (List)x$4, x$5, x$6);
        });
        LanguageClientLogger$ x$7 = LanguageClientLogger$.MODULE$;
        Formatter x$8 = this.defaultFormat();
        Some x$9 = new Some((Object)this.level());
        .colon.colon x$10 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        OutputFormat x$11 = qual$1.withHandler$default$5();
        LogHandle x$12 = qual$1.withHandler$default$6();
        Logger qual$2 = qual$1.withHandler(x$8, (Writer)x$7, (Option)x$9, (List)x$10, x$11, x$12);
        Option x$13 = qual$2.replace$default$1();
        qual$2.replace(x$13);
    }

    public void setupLspLogger(List<AbsolutePath> folders, boolean redirectSystemStreams, MetalsServerConfig config) {
        List newLogFiles = folders.map((Function1 & Serializable)x$1 -> MODULE$.backUpOldLogFileIfTooBig((AbsolutePath)x$1, config));
        package$.MODULE$.info((Function0 & Serializable)() -> "logging to files " + newLogFiles.mkString(","), new Pkg("scala.meta.internal.metals.logging"), new FileName("MetalsLogger.scala"), new Name("setupLspLogger"), new Line(124), MDC$.MODULE$.instance());
        if (redirectSystemStreams) {
            this.redirectSystemOut((List<AbsolutePath>)newLogFiles);
            return;
        }
        Logger qual$1 = Logger$.MODULE$.root().clearModifiers().clearHandlers();
        Formatter x$12 = this.defaultFormat();
        Some x$2 = new Some((Object)this.logLevel(config.loglevel()));
        .colon.colon x$3 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        Writer x$4 = qual$1.withHandler$default$2();
        OutputFormat x$5 = qual$1.withHandler$default$5();
        LogHandle x$6 = qual$1.withHandler$default$6();
        Logger qual$2 = qual$1.withHandler(x$12, x$4, (Option)x$2, (List)x$3, x$5, x$6);
        Option x$7 = qual$2.replace$default$1();
        qual$2.replace(x$7);
    }

    private AbsolutePath backupLogsDir(AbsolutePath workspaceFolder) {
        return workspaceFolder.resolve(".metals").resolve(".backup_logs");
    }

    public AbsolutePath backUpOldLogFileIfTooBig(AbsolutePath workspaceFolder, MetalsServerConfig config) {
        Object object;
        AbsolutePath logFilePath = workspaceFolder.resolve(this.workspaceLogPath());
        try {
            if (logFilePath.isFile() && Files.size(logFilePath.toNIO()) > config.maxLogFileSize()) {
                AbsolutePath backedUpLogFile = this.backupLogPath(workspaceFolder);
                MetalsEnrichments$.MODULE$.XtensionAbsolutePath(MetalsEnrichments$.MODULE$.XtensionAbsolutePath(backedUpLogFile).parent()).createDirectories();
                Files.move(logFilePath.toNIO(), backedUpLogFile.toNIO(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                object = this.limitKeptBackupLogs(workspaceFolder, config.maxLogBackups());
            } else {
                object = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                object = package$.MODULE$.warn((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|error while creating a backup for log file\n                        |" + throwable2 + "\n                        |")), new Pkg("scala.meta.internal.metals.logging"), new FileName("MetalsLogger.scala"), new Name("backUpOldLogFileIfTooBig"), new Line(166), MDC$.MODULE$.instance());
            }
            throw throwable;
        }
        return logFilePath;
    }

    private AbsolutePath backupLogPath(AbsolutePath wokspaceFolder) {
        String date = TimeFormatter$.MODULE$.getDate();
        String time = TimeFormatter$.MODULE$.getTime();
        String filename = "log_" + time;
        return this.backupLogsDir(wokspaceFolder).resolve(date).resolve(filename);
    }

    private List<TimestampedFile> limitKeptBackupLogs(AbsolutePath workspaceFolder, int limit) {
        AbsolutePath backupDir = this.backupLogsDir(workspaceFolder);
        LimitedFilesManager qual$1 = new LimitedFilesManager(backupDir.toNIO(), limit, StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("log_")), "");
        int x$1 = qual$1.deleteOld$default$1();
        return qual$1.deleteOld(x$1);
    }

    public FileWriter newFileWriter(AbsolutePath logfile) {
        return new FileWriter(PathBuilder$.MODULE$.static(logfile.toNIO()), FileWriter$.MODULE$.apply$default$2(), FileWriter$.MODULE$.apply$default$3(), FileWriter$.MODULE$.apply$default$4()).flushAlways();
    }

    public Formatter defaultFormat() {
        return package.FormatterInterpolator$.MODULE$.formatter$extension(scribe.format.package$.MODULE$.FormatterInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scribe.format.package$.MODULE$.date(), scribe.format.package$.MODULE$.levelPaddedRight(), scribe.format.package$.MODULE$.messages()}));
    }

    public LoggerSupport<BoxedUnit> silent() {
        return new LoggerSupport<BoxedUnit>(){

            public Object log(Level level, MDC mdc, Seq features, Pkg pkg, FileName fileName, Name name, Line line) {
                return LoggerSupport.log$((LoggerSupport)this, (Level)level, (MDC)mdc, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line);
            }

            public Object trace(Function0 message, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.trace$((LoggerSupport)this, (Function0)message, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object trace(Seq features, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.trace$((LoggerSupport)this, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object debug(Function0 message, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.debug$((LoggerSupport)this, (Function0)message, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object debug(Seq features, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.debug$((LoggerSupport)this, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object info(Function0 message, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.info$((LoggerSupport)this, (Function0)message, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object info(Seq features, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.info$((LoggerSupport)this, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object warn(Function0 message, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.warn$((LoggerSupport)this, (Function0)message, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object warn(Seq features, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.warn$((LoggerSupport)this, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object error(Function0 message, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.error$((LoggerSupport)this, (Function0)message, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object error(Seq features, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.error$((LoggerSupport)this, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object fatal(Function0 message, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.fatal$((LoggerSupport)this, (Function0)message, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object fatal(Seq features, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.fatal$((LoggerSupport)this, (Seq)features, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public <Return> Return elapsed(Function0<Return> f, MDC mdc) {
                return (Return)LoggerSupport.elapsed$((LoggerSupport)this, f, (MDC)mdc);
            }

            public <Return> Return apply(Seq<Tuple2<String, Object>> keyValues, Function0<Return> f) {
                return (Return)LoggerSupport.apply$((LoggerSupport)this, keyValues, f);
            }

            public void log(Function0<LogRecord> record) {
            }
            {
                LoggerSupport.$init$((LoggerSupport)this);
            }
        };
    }

    public LoggerSupport<BoxedUnit> default() {
        return Logger$.MODULE$.root();
    }

    public LoggerSupport<BoxedUnit> silentInTests() {
        if (MetalsServerConfig$.MODULE$.isTesting()) {
            return this.silent();
        }
        return this.default();
    }

    private MetalsLogger$() {
    }
}

