/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.meta.internal.bsp.BspSession;
import scala.meta.internal.bsp.ConnectionBspStatus;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.Tables;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005-4AAC\u0006\u0001)!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!i\u0003A!A!\u0002\u0013q\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b1\u0002\u001a\t\u000bU\u0002A\u0011\u0001\u001c\t\u000by\u0002A\u0011A \t\u000bA\u0003A\u0011A)\t\u000bU\u0003A\u0011\u0003,\t\u000ba\u0003A\u0011B-\u0003\u001f\t\u001b\b/\u0012:s_JD\u0015M\u001c3mKJT!\u0001D\u0007\u0002\r\t,\u0018\u000e\u001c3t\u0015\tqq\"\u0001\u0005j]R,'O\\1m\u0015\t\u0001\u0012#\u0001\u0003nKR\f'\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-]i\u0011!E\u0005\u00031E\u0011a!\u00118z%\u00164\u0017AD2veJ,g\u000e^*fgNLwN\u001c\t\u0004-mi\u0012B\u0001\u000f\u0012\u0005%1UO\\2uS>t\u0007\u0007E\u0002\u0017=\u0001J!aH\t\u0003\r=\u0003H/[8o!\t\tC%D\u0001#\u0015\t\u0019S\"A\u0002cgBL!!\n\u0012\u0003\u0015\t\u001b\boU3tg&|g.\u0001\u0004uC\ndWm\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0003U5\ta!\\3uC2\u001c\u0018B\u0001\u0017*\u0005\u0019!\u0016M\u00197fg\u0006I!m\u001d9Ti\u0006$Xo\u001d\t\u0003C=J!\u0001\r\u0012\u0003'\r{gN\\3di&|gNQ:q'R\fG/^:\u0002\u001bI,\u0007o\u001c:u\u0007>tG/\u001a=u!\tA3'\u0003\u00025S\ti!+\u001a9peR\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003B\u001c<yu\"\"\u0001\u000f\u001e\u0011\u0005e\u0002Q\"A\u0006\t\u000bE*\u00019\u0001\u001a\t\u000be)\u0001\u0019\u0001\u000e\t\u000b\u0019*\u0001\u0019A\u0014\t\u000b5*\u0001\u0019\u0001\u0018\u0002\u000f=tWI\u001d:peR\u0011\u0001i\u0011\t\u0003-\u0005K!AQ\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\t\u001a\u0001\r!R\u0001\b[\u0016\u001c8/Y4f!\t1UJ\u0004\u0002H\u0017B\u0011\u0001*E\u0007\u0002\u0013*\u0011!jE\u0001\u0007yI|w\u000e\u001e \n\u00051\u000b\u0012A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T\t\u0002%MDw.\u001e7e'\"|wOQ:q\u000bJ\u0014xN]\u000b\u0002%B\u0011acU\u0005\u0003)F\u0011qAQ8pY\u0016\fg.\u0001\u0005m_\u001e,%O]8s)\t\u0001u\u000bC\u0003E\u0011\u0001\u0007Q)\u0001\u0007de\u0016\fG/\u001a*fa>\u0014H\u000f\u0006\u0002[UB\u00191\f\u00192\u000e\u0003qS!!\u00180\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tGL\u0001\u0005PaRLwN\\1m!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003gS2,'BA4_\u0003\rq\u0017n\\\u0005\u0003S\u0012\u0014A\u0001U1uQ\")A)\u0003a\u0001\u000b\u0002")
public class BspErrorHandler {
    private final Function0<Option<BspSession>> currentSession;
    private final Tables tables;
    private final ConnectionBspStatus bspStatus;
    private final ReportContext reportContext;

    public void onError(String message) {
        if (this.shouldShowBspError()) {
            MetalsEnrichments$.MODULE$.XtensionOptionalJava(this.createReport(message)).asScala().withFilter((Function1 & Serializable)report -> BoxesRunTime.boxToBoolean((boolean)BspErrorHandler.$anonfun$onError$1(this, report))).foreach((Function1 & Serializable)report -> {
                this.bspStatus.showError(message, report);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.logError(message);
    }

    public boolean shouldShowBspError() {
        return ((Option)this.currentSession.apply()).exists((Function1 & Serializable)session -> BoxesRunTime.boxToBoolean((boolean)BspErrorHandler.$anonfun$shouldShowBspError$1(session)));
    }

    public void logError(String message) {
        package$.MODULE$.error((Function0 & Serializable)() -> message, new Pkg("scala.meta.internal.builds"), new FileName("BSPErrorHandler.scala"), new Name("logError"), new Line(33), MDC$.MODULE$.instance());
    }

    private Optional<Path> createReport(String message) {
        byte[] digest = MessageDigest.getInstance("MD5").digest(message.getBytes());
        String id = BaseEncoding.base64().encode(digest);
        String sanitized = this.reportContext.bloop().sanitize(message);
        return this.reportContext.bloop().create(() -> new Report(MetalsEnrichments$.MODULE$.XtensionText(sanitized).trimTo(20), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|### Bloop error:\n            |\n            |" + message)), MetalsEnrichments$.MODULE$.XtensionText(sanitized).trimTo(100), Optional.empty(), Optional.of(id), Report$.MODULE$.apply$default$6()));
    }

    public static final /* synthetic */ boolean $anonfun$onError$1(BspErrorHandler $this, Path report) {
        return !$this.tables.dismissedNotifications().BspErrors().isDismissed();
    }

    public static final /* synthetic */ boolean $anonfun$shouldShowBspError$1(BspSession session) {
        return session.main().isBloop() || session.main().isScalaCLI();
    }

    public BspErrorHandler(Function0<Option<BspSession>> currentSession, Tables tables, ConnectionBspStatus bspStatus, ReportContext reportContext) {
        this.currentSession = currentSession;
        this.tables = tables;
        this.bspStatus = bspStatus;
        this.reportContext = reportContext;
    }
}

