/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.metals.JarTopLevels$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.OverriddenSymbol;
import scala.meta.internal.mtags.ResolvedOverriddenSymbol;
import scala.meta.internal.mtags.ToplevelMember;
import scala.meta.internal.mtags.UnresolvedOverriddenSymbol;
import scala.meta.internal.semanticdb.Range;
import scala.meta.internal.semanticdb.SymbolInformation;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0006\r\u0001UA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006M\u0001!\ta\n\u0005\u0006W\u0001!\t\u0001\f\u0005\u0006+\u0002!\tA\u0016\u0005\u0006=\u0002!\tb\u0018\u0005\u0006I\u0002!\t\"\u001a\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006q\u0002!\t\"\u001f\u0005\u0006{\u0002!\tA \u0002\u0010\u0015\u0006\u0014\u0018J\u001c3fq&tw-\u00138g_*\u0011QBD\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005=\u0001\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005E\u0011\u0012\u0001B7fi\u0006T\u0011aE\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t!#\u0003\u0002\u001a%\t1\u0011I\\=SK\u001a\fAaY8o]B\u0019q\u0003\b\u0010\n\u0005u\u0011\"!\u0003$v]\u000e$\u0018n\u001c81!\tyB%D\u0001!\u0015\t\t#%A\u0002tc2T\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\tA#\u0006\u0005\u0002*\u00015\tA\u0002C\u0003\u001b\u0005\u0001\u00071$\u0001\thKR$\u0016\u0010]3IS\u0016\u0014\u0018M]2isR\u0011Qf\u0015\t\u0004/9\u0002\u0014BA\u0018\u0013\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011'\u000f\u001f\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b\u0015\u0003\u0019a$o\\8u}%\t1#\u0003\u00029%\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001e<\u0005\u0011a\u0015n\u001d;\u000b\u0005a\u0012\u0002#B\f>\u007f\u0015k\u0015B\u0001 \u0013\u0005\u0019!V\u000f\u001d7fgA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tE\u0001\u0003S>L!\u0001R!\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0011\u0005\u0019SeBA$I!\t\u0019$#\u0003\u0002J%\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tI%\u0003\u0005\u0002O#6\tqJ\u0003\u0002Q\u001d\u0005)Q\u000e^1hg&\u0011!k\u0014\u0002\u0011\u001fZ,'O]5eI\u0016t7+_7c_2DQ\u0001V\u0002A\u0002}\n1A[1s\u0003Q\tG\r\u001a+za\u0016D\u0015.\u001a:be\u000eD\u00170\u00138g_R\u0019qK\u0017/\u0011\u0005]A\u0016BA-\u0013\u0005\rIe\u000e\u001e\u0005\u00067\u0012\u0001\raP\u0001\u0005a\u0006$\b\u000eC\u0003^\t\u0001\u0007\u0001'\u0001\busB,w\f[5fe\u0006\u00148\r[=\u0002\u001d\u0005$Gm\u0014:Va\u0012\fG/\u001a&beR\u0019\u0001-\u00192\u0011\u0007]qs\u000bC\u0003\\\u000b\u0001\u0007q\bC\u0003d\u000b\u0001\u0007Q)\u0001\u0007j]\u0012,\u00070\u001a3GS\u0016dG-\u0001\u000bqkR$\u0016\u0010]3IS\u0016\u0014\u0018M]2is&sgm\u001c\u000b\u0004/\u001a<\u0007\"\u0002+\u0007\u0001\u00049\u0006\"B/\u0007\u0001\u0004\u0001\u0014AE4fiR{\u0007\u000f\\3wK2lU-\u001c2feN$\"A\u001b:\u0011\u0007]q3\u000e\u0005\u0003GY~r\u0017BA7M\u0005\ri\u0015\r\u001d\t\u0004cez\u0007C\u0001(q\u0013\t\txJ\u0001\bU_BdWM^3m\u001b\u0016l'-\u001a:\t\u000bQ;\u0001\u0019A \u0002-\u0005$G\rV8qY\u00164X\r\\'f[\n,'o]%oM>$2aV;w\u0011\u0015Y\u0006\u00021\u0001@\u0011\u00159\b\u00021\u0001l\u0003=!x\u000e\u001d7fm\u0016dW*Z7cKJ\u001c\u0018A\u00069viR{\u0007\u000f\\3wK2lU-\u001c2feNLeNZ8\u0015\u0007]S8\u0010C\u0003U\u0013\u0001\u0007q\u000bC\u0003}\u0013\u0001\u00071.A\tu_BdWM^3m\u001b\u0016l'-\u001a:NCB\fAbZ3u\u001b\u0012+D)[4fgR$\"!R@\t\u000bmS\u0001\u0019A ")
public class JarIndexingInfo {
    private final Function0<Connection> conn;

    public Option<List<Tuple3<AbsolutePath, String, OverriddenSymbol>>> getTypeHierarchy(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select th.symbol, th.parent_name, th.path, th.is_resolved\n            |from indexed_jar ij\n            |left join type_hierarchy th\n            |on ij.id=th.jar\n            |where ij.type_hierarchy_indexed=true and ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$7 -> {
                x$7.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null && rs.getString(4) != null) {
                    String symbol = rs.getString(1);
                    String parentName = rs.getString(2);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(3), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    boolean isResolved = rs.getBoolean(4);
                    ResolvedOverriddenSymbol overridden = isResolved ? new ResolvedOverriddenSymbol(parentName) : new UnresolvedOverriddenSymbol(parentName);
                    return toplevels.$plus$eq((Object)new Tuple3((Object)path2, (Object)symbol, (Object)overridden));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$8 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2, new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTypeHierarchy"), new Line(212), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public int addTypeHierarchyInfo(AbsolutePath path2, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        Option<Object> jar = this.addOrUpdateJar(path2, "type_hierarchy_indexed");
        return BoxesRunTime.unboxToInt((Object)jar.map((Function1)(JFunction1.mcII.sp & Serializable)x$9 -> this.putTypeHierarchyInfo(x$9, type_hierarchy)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public Option<Object> addOrUpdateJar(AbsolutePath path2, String indexedField) {
        String digest = this.getMD5Digest(path2);
        Option existingJar = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query("select id from indexed_jar where md5=?", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)stmt -> {
            stmt.setString(1, digest);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)rs -> BoxesRunTime.boxToInteger((int)rs.getInt(1))).headOption();
        Option option = existingJar;
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            int jarId = BoxesRunTime.unboxToInt((Object)some2.value());
            try (Statement updateStmt = null;){
                updateStmt = ((Connection)this.conn.apply()).prepareStatement("update indexed_jar set " + indexedField + " = true where id = ?");
                updateStmt.setInt(1, jarId);
                updateStmt.executeUpdate();
                some = new Some((Object)BoxesRunTime.boxToInteger((int)jarId));
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            Some some;
            try (Statement insertStmt = null;){
                try {
                    insertStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5, " + indexedField + ") values (?, ?)", 1);
                    insertStmt.setString(1, digest);
                    insertStmt.setBoolean(2, true);
                    insertStmt.executeUpdate();
                    ResultSet rs2 = insertStmt.getGeneratedKeys();
                    rs2.next();
                    some = new Some((Object)BoxesRunTime.boxToInteger((int)rs2.getInt("id")));
                }
                catch (JdbcSQLIntegrityConstraintViolationException e) {
                    scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("addOrUpdateJar"), new Line(270), MDC$.MODULE$.instance());
                    some = None$.MODULE$;
                }
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public int putTypeHierarchyInfo(int jar, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        if (type_hierarchy.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                try {
                    symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into type_hierarchy (symbol, parent_name, path, jar, is_resolved) values (?, ?, ?, ?, ?)");
                    type_hierarchy.foreach((Function1 & Serializable)x0$1 -> {
                        JarIndexingInfo.$anonfun$putTypeHierarchyInfo$1(symbolStmt, jar, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                catch (JdbcBatchUpdateException e) {
                    scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("putTypeHierarchyInfo"), new Line(308), MDC$.MODULE$.instance());
                    n = 0;
                }
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public Option<Map<AbsolutePath, List<ToplevelMember>>> getToplevelMembers(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevelMembers = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select tm.symbol, tm.start_line, tm.start_character, tm.end_line, tm.end_character, tm.path, tm.kind\n            |from indexed_jar ij\n            |left join toplevel_members tm\n            |on ij.id=tm.jar\n            |where ij.toplevel_members_indexed=true and ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$10 -> {
                x$10.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null) {
                    String symbol = rs.getString(1);
                    int startLine = rs.getInt(2);
                    int startChar = rs.getInt(3);
                    int endLine = rs.getInt(4);
                    int endChar = rs.getInt(5);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(6), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    SymbolInformation.Kind kind = SymbolInformation.Kind$.MODULE$.fromValue(rs.getInt(7));
                    Range range = new Range(startLine, startChar, endLine, endChar);
                    return toplevelMembers.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path2), (Object)new ToplevelMember(symbol, range, kind)));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$11 -> (Map)((IterableOps)toplevelMembers.result()).groupBy((Function1 & Serializable)x$12 -> (AbsolutePath)x$12._1()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    AbsolutePath path2 = (AbsolutePath)tuple2._1();
                    List toplevelMembers = (List)tuple2._2();
                    return new Tuple2((Object)path2, (Object)toplevelMembers.map((Function1 & Serializable)x$13 -> (ToplevelMember)x$13._2()));
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2, new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getToplevelMembers"), new Line(351), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public int addToplevelMembersInfo(AbsolutePath path2, Map<AbsolutePath, List<ToplevelMember>> toplevelMembers) {
        Option<Object> jar = this.addOrUpdateJar(path2, "toplevel_members_indexed");
        return BoxesRunTime.unboxToInt((Object)jar.map((Function1)(JFunction1.mcII.sp & Serializable)x$14 -> this.putToplevelMembersInfo(x$14, toplevelMembers)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public int putToplevelMembersInfo(int jar, Map<AbsolutePath, List<ToplevelMember>> toplevelMemberMap) {
        if (toplevelMemberMap.nonEmpty()) {
            int n;
            ObjectRef toplevelMemberStmt = ObjectRef.create(null);
            try {
                try {
                    toplevelMemberStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_members (symbol, start_line, start_character, end_line, end_character, path, kind, jar) values (?, ?, ?, ?, ?, ?, ?, ?)");
                    toplevelMemberMap.foreach((Function1 & Serializable)x0$1 -> {
                        JarIndexingInfo.$anonfun$putToplevelMembersInfo$1(toplevelMemberStmt, jar, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)toplevelMemberStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                catch (JdbcBatchUpdateException e) {
                    scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "failed to insert toplevel members"), LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("putToplevelMembersInfo"), new Line(395), MDC$.MODULE$.instance());
                    n = 0;
                }
                catch (JdbcSQLIntegrityConstraintViolationException e) {
                    scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "failed to insert toplevel members"), LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("putToplevelMembersInfo"), new Line(398), MDC$.MODULE$.instance());
                    n = 0;
                }
            }
            finally {
                if ((PreparedStatement)toplevelMemberStmt.elem != null) {
                    ((PreparedStatement)toplevelMemberStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public String getMD5Digest(AbsolutePath path2) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path2.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(path2.toString() + ":" + attributes.lastModifiedTime().toMillis() + ":" + attributes.size());
    }

    public static final /* synthetic */ void $anonfun$putTypeHierarchyInfo$1(ObjectRef symbolStmt$2, int jar$4, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple3._1();
            String symbol = (String)tuple3._2();
            OverriddenSymbol overridden = (OverriddenSymbol)tuple3._3();
            ((PreparedStatement)symbolStmt$2.elem).setString(1, symbol);
            OverriddenSymbol overriddenSymbol = overridden;
            if (overriddenSymbol instanceof ResolvedOverriddenSymbol) {
                ResolvedOverriddenSymbol resolvedOverriddenSymbol = (ResolvedOverriddenSymbol)overriddenSymbol;
                String name = resolvedOverriddenSymbol.symbol();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setInt(3, 0);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, true);
            } else if (overriddenSymbol instanceof UnresolvedOverriddenSymbol) {
                UnresolvedOverriddenSymbol unresolvedOverriddenSymbol = (UnresolvedOverriddenSymbol)overriddenSymbol;
                String name = unresolvedOverriddenSymbol.name();
                ((PreparedStatement)symbolStmt$2.elem).setString(2, name);
                ((PreparedStatement)symbolStmt$2.elem).setBoolean(5, false);
            } else {
                throw new MatchError((Object)overriddenSymbol);
            }
            ((PreparedStatement)symbolStmt$2.elem).setString(3, path2.toString());
            ((PreparedStatement)symbolStmt$2.elem).setInt(4, jar$4);
            ((PreparedStatement)symbolStmt$2.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$putToplevelMembersInfo$2(ObjectRef toplevelMemberStmt$1, AbsolutePath path$1, int jar$6, ToplevelMember toplevelMember) {
        ((PreparedStatement)toplevelMemberStmt$1.elem).setString(1, toplevelMember.symbol());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setInt(2, toplevelMember.range().startLine());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setInt(3, toplevelMember.range().startCharacter());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setInt(4, toplevelMember.range().endLine());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setInt(5, toplevelMember.range().endCharacter());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setString(6, path$1.toString());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setInt(7, toplevelMember.kind().value());
        ((PreparedStatement)toplevelMemberStmt$1.elem).setInt(8, jar$6);
        ((PreparedStatement)toplevelMemberStmt$1.elem).addBatch();
    }

    public static final /* synthetic */ void $anonfun$putToplevelMembersInfo$1(ObjectRef toplevelMemberStmt$1, int jar$6, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AbsolutePath path2 = (AbsolutePath)tuple2._1();
            List toplevelMembers = (List)tuple2._2();
            toplevelMembers.foreach((Function1 & Serializable)toplevelMember -> {
                JarIndexingInfo.$anonfun$putToplevelMembersInfo$2(toplevelMemberStmt$1, path2, jar$6, toplevelMember);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JarIndexingInfo(Function0<Connection> conn) {
        this.conn = conn;
    }
}

