/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import org.h2.jdbc.JdbcBatchUpdateException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.metals.JarIndexingInfo;
import scala.meta.internal.metals.JarTopLevels$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.mtags.OverriddenSymbol;
import scala.meta.internal.mtags.ToplevelMember;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\b\u0010\u0005aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006U\u0001!\ta\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006%\u0002!\ta\u0015\u0005\ba\u0002\t\n\u0011\"\u0001r\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\b\u000f\u0005\u0005r\u0002#\u0001\u0002$\u00191ab\u0004E\u0001\u0003KAaAK\u0006\u0005\u0002\u00055\u0002bBA\u0018\u0017\u0011\u0005\u0011\u0011\u0007\u0002\r\u0015\u0006\u0014Hk\u001c9MKZ,Gn\u001d\u0006\u0003!E\ta!\\3uC2\u001c(B\u0001\n\u0014\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000b\u0016\u0003\u0011iW\r^1\u000b\u0003Y\tQa]2bY\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!dG\u0007\u0002\u001f%\u0011Ad\u0004\u0002\u0010\u0015\u0006\u0014\u0018J\u001c3fq&tw-\u00138g_\u0006!1m\u001c8o!\ry\u0002EI\u0007\u0002+%\u0011\u0011%\u0006\u0002\n\rVt7\r^5p]B\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u0007M\fHNC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AC\"p]:,7\r^5p]\u00061A(\u001b8jiz\"\"\u0001L\u0017\u0011\u0005i\u0001\u0001\"B\u000f\u0003\u0001\u0004q\u0012\u0001D4fiR{\u0007\u000fT3wK2\u001cHC\u0001\u0019Q!\ry\u0012gM\u0005\u0003eU\u0011aa\u00149uS>t\u0007c\u0001\u001b=\u007f9\u0011QG\u000f\b\u0003mej\u0011a\u000e\u0006\u0003q]\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0005m*\u0012a\u00029bG.\fw-Z\u0005\u0003{y\u0012A\u0001T5ti*\u00111(\u0006\t\u0005?\u0001\u0013%*\u0003\u0002B+\t1A+\u001e9mKJ\u0002\"aQ$\u000f\u0005\u0011+\u0005C\u0001\u001c\u0016\u0013\t1U#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$\u0016!\tYe*D\u0001M\u0015\ti5#\u0001\u0002j_&\u0011q\n\u0014\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u0005\u0006#\u000e\u0001\rAS\u0001\u0004U\u0006\u0014\u0018A\u00059vi*\u000b'/\u00138eKbLgnZ%oM>$R\u0001V,Z7\u001e\u0004\"aH+\n\u0005Y+\"aA%oi\")\u0001\f\u0002a\u0001\u0015\u0006!\u0001/\u0019;i\u0011\u0015QF\u00011\u00014\u0003%!x\u000e\u001d7fm\u0016d7\u000fC\u0003]\t\u0001\u0007Q,\u0001\busB,w\f[5fe\u0006\u00148\r[=\u0011\u0007Qbd\fE\u0003 ?*\u0013\u0015-\u0003\u0002a+\t1A+\u001e9mKN\u0002\"AY3\u000e\u0003\rT!\u0001Z\t\u0002\u000b5$\u0018mZ:\n\u0005\u0019\u001c'\u0001E(wKJ\u0014\u0018\u000e\u001a3f]NKXNY8m\u0011\u001dAG\u0001%AA\u0002%\fq\u0002^8qY\u00164X\r\\'f[\n,'o\u001d\t\u0005\u0007*TE.\u0003\u0002l\u0013\n\u0019Q*\u00199\u0011\u0007QbT\u000e\u0005\u0002c]&\u0011qn\u0019\u0002\u000f)>\u0004H.\u001a<fY6+WNY3s\u0003q\u0001X\u000f\u001e&be&sG-\u001a=j]\u001eLeNZ8%I\u00164\u0017-\u001e7uIQ*\u0012A\u001d\u0016\u0003SN\\\u0013\u0001\u001e\t\u0003kjl\u0011A\u001e\u0006\u0003ob\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005e,\u0012AC1o]>$\u0018\r^5p]&\u00111P\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F1eIRK\b/\u001a%jKJ\f'o\u00195z\u0013:4w\u000eF\u0002U}~DQ\u0001\u0017\u0004A\u0002)CQ\u0001\u0018\u0004A\u0002u\u000bA\u0002];u)>\u0004H.\u001a<fYN$R\u0001VA\u0003\u0003\u000fAQ!U\u0004A\u0002QCQAW\u0004A\u0002M\na\u0003Z3mKR,gj\u001c;Vg\u0016$Gk\u001c9MKZ,Gn\u001d\u000b\u0004)\u00065\u0001bBA\b\u0011\u0001\u0007\u0011\u0011C\u0001\nkN,G\rU1uQN\u0004BaHA\n\u0015&\u0019\u0011QC\u000b\u0003\u000b\u0005\u0013(/Y=\u0002\u0011\rdW-\u0019:BY2$\"!a\u0007\u0011\u0007}\ti\"C\u0002\u0002 U\u0011A!\u00168ji\u0006a!*\u0019:U_BdUM^3mgB\u0011!dC\n\u0004\u0017\u0005\u001d\u0002cA\u0010\u0002*%\u0019\u00111F\u000b\u0003\r\u0005s\u0017PU3g)\t\t\u0019#A\u0007hKR4\u0015\u000e\\3TsN$X-\u001c\u000b\u0005\u0003g\t\u0019\u0005\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\t\u0019LG.\u001a\u0006\u0004\u0003{1\u0013a\u00018j_&!\u0011\u0011IA\u001c\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0006#6\u0001\rA\u0013")
public final class JarTopLevels
extends JarIndexingInfo {
    private final Function0<Connection> conn;

    public static FileSystem getFileSystem(AbsolutePath jar) {
        return JarTopLevels$.MODULE$.getFileSystem(jar);
    }

    public Option<List<Tuple2<String, AbsolutePath>>> getTopLevels(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n            |from indexed_jar ij\n            |left join toplevel_symbol ts\n            |on ij.id=ts.jar\n            |where ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                x$1.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null) {
                    String symbol = rs.getString(1);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(2), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    return toplevels.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)path2));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$2 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2, new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTopLevels"), new Line(64), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public int putJarIndexingInfo(AbsolutePath path2, List<Tuple2<String, AbsolutePath>> toplevels, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy, Map<AbsolutePath, List<ToplevelMember>> toplevelMembers) {
        if (toplevels.isEmpty() && type_hierarchy.isEmpty() && toplevelMembers.isEmpty()) {
            return 0;
        }
        this.addOrUpdateJar(path2, "type_hierarchy_indexed");
        Option<Object> jar2 = this.addOrUpdateJar(path2, "toplevel_members_indexed");
        return BoxesRunTime.unboxToInt((Object)jar2.map((Function1)(JFunction1.mcII.sp & Serializable)jar -> this.putToplevels(jar, toplevels) + this.putTypeHierarchyInfo(jar, type_hierarchy) + this.putToplevelMembersInfo(jar, toplevelMembers)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public Map<AbsolutePath, List<ToplevelMember>> putJarIndexingInfo$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public int addTypeHierarchyInfo(AbsolutePath path2, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        int n;
        try (Statement jarStmt = null;){
            String digest = this.getMD5Digest(path2);
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("update indexed_jar set type_hierarchy_indexed = true where (md5) = (?)");
            jarStmt.setString(1, digest);
            jarStmt.executeUpdate();
            n = BoxesRunTime.unboxToInt((Object)JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select id\n              |from indexed_jar\n              |where md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$3 -> {
                x$3.setString(1, digest);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.getInt(1))).head());
        }
        int jar = n;
        return this.putTypeHierarchyInfo(jar, type_hierarchy);
    }

    public int putToplevels(int jar, List<Tuple2<String, AbsolutePath>> toplevels) {
        if (toplevels.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                try {
                    symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
                    toplevels.foreach((Function1 & Serializable)x0$1 -> {
                        JarTopLevels.$anonfun$putToplevels$1(symbolStmt, jar, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                catch (JdbcBatchUpdateException e) {
                    scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("putToplevels"), new Line(146), MDC$.MODULE$.instance());
                    n = 0;
                }
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])usedPaths), (Function1 & Serializable)path2 -> this.getMD5Digest((AbsolutePath)path2), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$5 -> "'" + x$5 + "'", ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update("delete from indexed_jar where md5 not in (" + md5s + ")", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$6 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$6);
            return BoxedUnit.UNIT;
        });
    }

    public void clearAll() {
        PreparedStatement statement1 = ((Connection)this.conn.apply()).prepareStatement("truncate table toplevel_symbol");
        statement1.execute();
        PreparedStatement statement2 = ((Connection)this.conn.apply()).prepareStatement("truncate table type_hierarchy");
        statement2.execute();
        PreparedStatement statement3 = ((Connection)this.conn.apply()).prepareStatement("delete from indexed_jar");
        statement3.execute();
    }

    public static final /* synthetic */ void $anonfun$putToplevels$1(ObjectRef symbolStmt$1, int jar$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String symbol = (String)tuple2._1();
            AbsolutePath source = (AbsolutePath)tuple2._2();
            ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
            ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
            ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$2);
            ((PreparedStatement)symbolStmt$1.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$6) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
        super(conn);
    }
}

