/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.ClientCommands;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientCommands$GotoLocation$;
import scala.meta.internal.metals.CommandHTMLFormat;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StacktraceAnalyzer$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u0010 \u0001!B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u00026\u0001\t\u0003Y\u0007\"\u0002:\u0001\t\u0003\u0019\b\"B=\u0001\t\u0003Q\bbBA\t\u0001\u0011%\u00111\u0003\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAa!\u001f\u0001\u0005\u0002\u0005E\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002|\u0001!I!! \t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAI\u0001\u0011%\u00111\u0013\u0005\b\u00037\u0003A\u0011BAO\u000f\u001d\t9k\bE\u0001\u0003S3aAH\u0010\t\u0002\u0005-\u0006B\u0002%\u001a\t\u0003\ti\u000bC\u0005\u00020f\u0011\r\u0011\"\u0002\u00022\"A\u0011qX\r!\u0002\u001b\t\u0019\fC\u0004\u0002Bf!\t!a1\u0003%M#\u0018mY6ue\u0006\u001cW-\u00118bYfTXM\u001d\u0006\u0003A\u0005\na!\\3uC2\u001c(B\u0001\u0012$\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0013&\u0003\u0011iW\r^1\u000b\u0003\u0019\nQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001SA\u0011!fK\u0007\u0002K%\u0011A&\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0013]|'o[:qC\u000e,\u0007CA\u00183\u001b\u0005\u0001$BA\u0019$\u0003\tIw.\u0003\u00024a\ta\u0011IY:pYV$X\rU1uQ\u00069!-\u001e4gKJ\u001c\bC\u0001\u001c8\u001b\u0005y\u0012B\u0001\u001d \u0005\u001d\u0011UO\u001a4feN\f!\u0003Z3gS:LG/[8o!J|g/\u001b3feB\u0011agO\u0005\u0003y}\u0011!\u0003R3gS:LG/[8o!J|g/\u001b3fe\u0006)\u0011nY8ogB\u0011agP\u0005\u0003\u0001~\u0011Q!S2p]N\f1cY8n[\u0006tG-\u00138Ii6dgi\u001c:nCR\u00042AK\"F\u0013\t!UE\u0001\u0004PaRLwN\u001c\t\u0003m\u0019K!aR\u0010\u0003#\r{W.\\1oI\"#V\n\u0014$pe6\fG/\u0001\u0004=S:LGO\u0010\u000b\u0007\u0015.cUJT(\u0011\u0005Y\u0002\u0001\"B\u0017\u0007\u0001\u0004q\u0003\"\u0002\u001b\u0007\u0001\u0004)\u0004\"B\u001d\u0007\u0001\u0004Q\u0004\"B\u001f\u0007\u0001\u0004q\u0004\"B!\u0007\u0001\u0004\u0011\u0015AD1oC2L(0Z\"p[6\fg\u000e\u001a\u000b\u0003%v\u00032AK\"T!\t!6,D\u0001V\u0015\t1v+A\u0003mgB$$N\u0003\u0002Y3\u00069Qm\u00197jaN,'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]+\n!R\t_3dkR,7i\\7nC:$\u0007+\u0019:b[NDQAX\u0004A\u0002}\u000b!b\u001d;bG.$(/Y2f!\t\u0001wM\u0004\u0002bKB\u0011!-J\u0007\u0002G*\u0011AmJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019,\u0013A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u0013\u0002AI,7o\u001c7wKN#\u0018mY6ue\u0006\u001cW\rT8dCRLwN\\\"p[6\fg\u000e\u001a\u000b\u0003YB\u00042AK\"n!\t!f.\u0003\u0002p+\nAAj\\2bi&|g\u000eC\u0003r\u0011\u0001\u0007q,\u0001\bti\u0006\u001c7\u000e\u001e:bG\u0016d\u0015N\\3\u0002!%\u001c8\u000b^1dWR\u0013\u0018mY3GS2,GC\u0001;x!\tQS/\u0003\u0002wK\t9!i\\8mK\u0006t\u0007\"\u0002=\n\u0001\u0004q\u0013\u0001\u00029bi\"\f\u0001c\u001d;bG.$(/Y2f\u0019\u0016t7/Z:\u0015\u0007m\fy\u0001E\u0003}\u0003\u0007\tIA\u0004\u0002~\u007f:\u0011!M`\u0005\u0002M%\u0019\u0011\u0011A\u0013\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0003)\u0003c\u0001+\u0002\f%\u0019\u0011QB+\u0003\u0011\r{G-\u001a'f]NDQ\u0001\u001f\u0006A\u00029\n!C]3bIN#\u0018mY6ue\u0006\u001cWMR5mKR!\u0011QCA\u000f!\u0011Q3)a\u0006\u0011\tq\fIbX\u0005\u0005\u00037\t9A\u0001\u0003MSN$\b\"\u0002=\f\u0001\u0004q\u0013AD:fiR{G*\u001b8f'R\f'\u000f\u001e\u000b\u0007\u0003G\tI#a\r\u0011\u0007)\n)#C\u0002\u0002(\u0015\u0012A!\u00168ji\"9\u00111\u0006\u0007A\u0002\u00055\u0012A\u00037j]\u0016tU/\u001c2feB\u0019!&a\f\n\u0007\u0005EREA\u0002J]RDq!!\u000e\r\u0001\u0004\t9$A\u0002q_N\u00042\u0001VA\u001d\u0013\r\tY$\u0016\u0002\t!>\u001c\u0018\u000e^5p]\u0006qBO]=HKRd\u0015N\\3Ok6\u0014WM\u001d$s_6\u001cF/Y2liJ\f7-\u001a\u000b\u0005\u0003\u0003\ni\u0005\u0005\u0004\u0002D\u0005%\u0013QF\u0007\u0003\u0003\u000bR1!a\u0012&\u0003\u0011)H/\u001b7\n\t\u0005-\u0013Q\t\u0002\u0004)JL\bBBA(\u001b\u0001\u0007q,\u0001\u0003mS:,GcA>\u0002T!9\u0011Q\u000b\bA\u0002\u0005]\u0011aB2p]R,g\u000e^\u0001\u001eo>\u00148n\u001d9bG\u00164\u0015\u000e\\3M_\u000e\fG/[8o\rJ|W\u000eT5oKR\u0019A.a\u0017\t\r\u0005=s\u00021\u0001`\u0003Q1\u0017\u000e\\3M_\u000e\fG/[8o\rJ|W\u000eT5oKR\u0019A.!\u0019\t\r\u0005=\u0003\u00031\u0001`\u0003ai\u0017m[3H_R|Gj\\2bi&|gnQ8eK2+gn\u001d\u000b\u0007\u0003\u0013\t9'a\u001b\t\r\u0005%\u0014\u00031\u0001n\u0003!awnY1uS>t\u0007bBA7#\u0001\u0007\u0011qN\u0001\u0006e\u0006tw-\u001a\t\u0004)\u0006E\u0014bAA:+\n)!+\u00198hK\u0006\t\u0012M\\1msj,7\u000b^1dWR\u0013\u0018mY3\u0015\u0007I\u000bI\bC\u0003_%\u0001\u0007q,A\u000bnC.,wi\u001c;p\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u0015\u0007M\u000by\b\u0003\u0004\u0002jM\u0001\r!\\\u0001\u0019iJL8+\u001a;MS:,gI]8n'R\f7m\u001b;sC\u000e,G#B7\u0002\u0006\u0006\u001d\u0005BBA5)\u0001\u0007Q\u000e\u0003\u0004\u0002PQ\u0001\raX\u0001\u000fgfl'm\u001c7Ge>lG*\u001b8f)\u0011\ti)a$\u0011\u0007)\u001au\f\u0003\u0004\u0002PU\u0001\raX\u0001\u0016[\u0006\\W\r\u0013;nY\u000e{W.\\1oIB\u000b'/Y7t)\u0015\u0019\u0016QSAL\u0011\u0015qf\u00031\u0001`\u0011\u0019\tIJ\u0006a\u0001\u000b\u00061am\u001c:nCR\fAcZ8u_2{7-\u0019;j_:,6/\u001b8h+JLGcB0\u0002 \u0006\r\u0016Q\u0015\u0005\u0007\u0003C;\u0002\u0019A0\u0002\u0007U\u0014\u0018\u000eC\u0004\u0002P]\u0001\r!!\f\t\r\u0005eu\u00031\u0001F\u0003I\u0019F/Y2liJ\f7-Z!oC2L(0\u001a:\u0011\u0005YJ2CA\r*)\t\tI+\u0001\u000bdCR,eMZ3diN\u001cF/Y2liJ\f7-Z\u000b\u0003\u0003g\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000b)%\u0001\u0005nCR\u001c\u0007.\u001b8h\u0013\u0011\ti,a.\u0003\u000bI+w-\u001a=\u0002+\r\fG/\u00124gK\u000e$8o\u0015;bG.$(/Y2fA\u0005\u0001Bo\u001c+pa2,g/\u001a7Ts6\u0014w\u000e\u001c\u000b\u0005\u0003/\t)\r\u0003\u0004\u0002Hv\u0001\raX\u0001\tgfl'm\u001c7J]\u0002")
public class StacktraceAnalyzer {
    private final AbsolutePath workspace;
    private final Buffers buffers;
    private final DefinitionProvider definitionProvider;
    private final Icons icons;
    private final Option<CommandHTMLFormat> commandInHtmlFormat;

    public static List<String> toToplevelSymbol(String symbolIn) {
        return StacktraceAnalyzer$.MODULE$.toToplevelSymbol(symbolIn);
    }

    public static Regex catEffectsStacktrace() {
        return StacktraceAnalyzer$.MODULE$.catEffectsStacktrace();
    }

    public Option<ExecuteCommandParams> analyzeCommand(String stacktrace) {
        return this.analyzeStackTrace(stacktrace);
    }

    public Option<Location> resolveStacktraceLocationCommand(String stacktraceLine) {
        return this.workspaceFileLocationFromLine(stacktraceLine);
    }

    public boolean isStackTraceFile(AbsolutePath path2) {
        AbsolutePath absolutePath = path2;
        AbsolutePath absolutePath2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
        return !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null);
    }

    public Seq<CodeLens> stacktraceLenses(AbsolutePath path2) {
        return (Seq)this.readStacktraceFile(path2).map((Function1 & Serializable)content -> this.stacktraceLenses((List<String>)content)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    private Option<List<String>> readStacktraceFile(AbsolutePath path2) {
        return this.buffers.get(path2).map((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$1), '\n')).toList());
    }

    private void setToLineStart(int lineNumber, Position pos) {
        pos.setLine(lineNumber);
        pos.setCharacter(0);
    }

    private Try<Object> tryGetLineNumberFromStacktrace(String line) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(line.substring(line.indexOf(":") + 1, line.indexOf(")")))) - 1);
    }

    public Seq<CodeLens> stacktraceLenses(List<String> content) {
        return ((Seq)((IterableOps)content.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$3(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int row = tuple2._2$mcI$sp();
                return this.fileLocationFromLine(line).map((Function1 & Serializable)location -> {
                    Range range = new Range(new Position(row, 0), new Position(row, 0));
                    return new Tuple2(location, (Object)range);
                }).map((Function1 & Serializable)x$2 -> {
                    Tuple2 tuple2 = x$2;
                    if (tuple2 != null) {
                        Location location = (Location)tuple2._1();
                        Range range = (Range)tuple2._2();
                        return this.makeGotoLocationCodeLens(location, range);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    public Option<Location> workspaceFileLocationFromLine(String line) {
        return this.fileLocationFromLine(line).filter((Function1 & Serializable)location -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$workspaceFileLocationFromLine$1(this, location)));
    }

    public Option<Location> fileLocationFromLine(String line) {
        return this.symbolFromLine(line).flatMap((Function1 & Serializable)symbol -> StacktraceAnalyzer$.MODULE$.toToplevelSymbol((String)symbol).collectFirst(Function$.MODULE$.unlift((Function1 & Serializable)s -> this.findLocationForSymbol$1((String)s))).map((Function1 & Serializable)location -> this.trySetLineFromStacktrace((Location)location, line)));
    }

    private CodeLens makeGotoLocationCodeLens(Location location, Range range) {
        Command command = ServerCommands$.MODULE$.GotoPosition().toLsp(location);
        command.setTitle(this.icons.findsuper() + " open");
        return new CodeLens(range, command, null);
    }

    private Option<ExecuteCommandParams> analyzeStackTrace(String stacktrace) {
        Option<CommandHTMLFormat> option = this.commandInHtmlFormat;
        if (option instanceof Some) {
            Some some = (Some)option;
            CommandHTMLFormat format = (CommandHTMLFormat)some.value();
            return new Some((Object)this.makeHtmlCommandParams(stacktrace, format));
        }
        if (None$.MODULE$.equals(option)) {
            AbsolutePath path2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
            File pathFile = path2.toFile();
            String pathStr = pathFile.toString();
            pathFile.createNewFile();
            try (FileWriter fw = new FileWriter(pathStr);){
                fw.write("/*\n" + stacktrace + "\n*/");
            }
            Position fileStartPos = new Position(0, 0);
            Range range = new Range(fileStartPos, fileStartPos);
            Location stackTraceLocation = new Location(path2.toURI().toString(), range);
            return new Some((Object)this.makeGotoCommandParams(stackTraceLocation));
        }
        throw new MatchError(option);
    }

    private ExecuteCommandParams makeGotoCommandParams(Location location) {
        return ClientCommands$GotoLocation$.MODULE$.toExecuteCommandParams(new ClientCommands.WindowLocation(location.getUri(), location.getRange(), true));
    }

    private Location trySetLineFromStacktrace(Location location, String line) {
        Try<Object> lineNumberOpt = this.tryGetLineNumberFromStacktrace(line);
        lineNumberOpt.foreach((Function1)(JFunction1.mcVI.sp & Serializable)lineNumber -> {
            this.setToLineStart(lineNumber, location.getRange().getStart());
            this.setToLineStart(lineNumber, location.getRange().getEnd());
        });
        return location;
    }

    private Option<String> symbolFromLine(String line) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Option option;
            String trimmed = line.substring(line.indexOf("at ") + 3, line.indexOf("("));
            String string = trimmed;
            if (string != null && !(option = StacktraceAnalyzer$.MODULE$.catEffectsStacktrace().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String symbol = (String)((LinearSeqOps)option.get()).apply(0);
                return symbol;
            }
            return trimmed;
        }).toOption();
    }

    private ExecuteCommandParams makeHtmlCommandParams(String stacktrace, CommandHTMLFormat format) {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h3";
        String x$2 = qual$1.element$default$2();
        Function1 & Serializable x$3 = (Function1 & Serializable)x$4 -> {
            x$4.text("Stacktrace");
            return BoxedUnit.UNIT;
        };
        String output = qual$1.element("h3", x$2, (Function1)x$3).call((Function1 & Serializable)builder -> {
            this.htmlStack$1(builder, stacktrace, format);
            return BoxedUnit.UNIT;
        }).render();
        return ClientCommands$.MODULE$.ShowStacktrace().toExecuteCommandParams(output);
    }

    private String gotoLocationUsingUri(String uri, int line, CommandHTMLFormat format) {
        Position pos = new Position(line, 0);
        return ClientCommands$GotoLocation$.MODULE$.toCommandLink(new ClientCommands.WindowLocation(uri, new Range(pos, pos), true), format);
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$workspaceFileLocationFromLine$1(StacktraceAnalyzer $this, Location location) {
        AbsolutePath path2 = MetalsEnrichments$.MODULE$.XtensionString(location.getUri()).toAbsolutePath();
        return !MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path2).isJarFileSystem() && !MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path2).isInReadonlyDirectory($this.workspace);
    }

    private final Option findLocationForSymbol$1(String s) {
        return MetalsEnrichments$.MODULE$.ListHasAsScala(this.definitionProvider.fromSymbol(s, (Option<AbsolutePath>)None$.MODULE$)).asScala().headOption();
    }

    private final void htmlStack$1(HtmlBuilder builder, String stacktrace$1, CommandHTMLFormat format$1) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(stacktrace$1), '\n')), (Function1 & Serializable)line -> {
            Option<Location> option = this.fileLocationFromLine((String)line);
            if (option instanceof Some) {
                Some some = (Some)option;
                Location location = (Location)some.value();
                builder.text("at ").link(this.gotoLocationUsingUri(location.getUri(), location.getRange().getStart().getLine(), format$1), line.substring(line.indexOf("at ") + 3));
            } else if (None$.MODULE$.equals(option)) {
                builder.raw(line);
            } else {
                throw new MatchError(option);
            }
            return builder.raw("<br>");
        });
    }

    public StacktraceAnalyzer(AbsolutePath workspace, Buffers buffers, DefinitionProvider definitionProvider, Icons icons, Option<CommandHTMLFormat> commandInHtmlFormat) {
        this.workspace = workspace;
        this.buffers = buffers;
        this.definitionProvider = definitionProvider;
        this.icons = icons;
        this.commandInHtmlFormat = commandInHtmlFormat;
    }
}

