/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.metals.Compilers;
import scala.meta.internal.mtags.OnDemandSymbolIndex;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.pc.PcSymbolInformation;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\t\u0012\u0005qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001B\u0001B\u0003-\u0011\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004@\u0001\t\u0007I\u0011\u0002!\t\r\u0015\u0004\u0001\u0015!\u0003B\u0011\u001d1\u0007A1A\u0005\n\u001dDa\u0001\u001c\u0001!\u0002\u0013A\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007i\u0002\u0001\u000b\u0011B8\t\u000bU\u0004A\u0011\u0001<\t\u000bm\u0004A\u0011\u0002?\t\r}\u0004A\u0011BA\u0001\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!!\u0006\u0001\t\u0003\t9BA\u0006Ts6\u0014w\u000e\\\"bG\",'B\u0001\n\u0014\u0003\u0015!WMY;h\u0015\t!R#\u0001\u0004nKR\fGn\u001d\u0006\u0003-]\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00031e\tA!\\3uC*\t!$A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u0005I\u0012B\u0001\u0011\u001a\u0005\u0019\te.\u001f*fM\u0006I1m\\7qS2,'o\u001d\t\u0004=\r*\u0013B\u0001\u0013\u001a\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002'O5\t1#\u0003\u0002)'\tI1i\\7qS2,'o]\u0001\fgfl'm\u001c7J]\u0012,\u0007\u0010\u0005\u0002,]5\tAF\u0003\u0002.+\u0005)Q\u000e^1hg&\u0011q\u0006\f\u0002\u0014\u001f:$U-\\1oINKXNY8m\u0013:$W\r_\u0001\u0003K\u000e\u0004\"AM\u001b\u000e\u0003MR!\u0001N\r\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00027g\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ejd\b\u0006\u0002;yA\u00111\bA\u0007\u0002#!)\u0001\u0007\u0002a\u0002c!)\u0011\u0005\u0002a\u0001E!)\u0011\u0006\u0002a\u0001U\u0005y1/_7c_2LeNZ8DC\u000eDW-F\u0001B!\u0011\u0011e\tS*\u000e\u0003\rS!\u0001\u000e#\u000b\u0005\u0015K\u0012AC2pY2,7\r^5p]&\u0011qi\u0011\u0002\b)JLW-T1q!\tI\u0005K\u0004\u0002K\u001dB\u00111*G\u0007\u0002\u0019*\u0011QjG\u0001\u0007yI|w\u000e\u001e \n\u0005=K\u0012A\u0002)sK\u0012,g-\u0003\u0002R%\n11\u000b\u001e:j]\u001eT!aT\r\u0011\ty!fkX\u0005\u0003+f\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\u0010X3&\u0011\u0001,\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005ikV\"A.\u000b\u0005q+\u0012A\u00019d\u0013\tq6LA\nQGNKXNY8m\u0013:4wN]7bi&|g\u000e\u0005\u0002aG6\t\u0011M\u0003\u0002c/\u0005\u0011\u0011n\\\u0005\u0003I\u0006\u0014A\"\u00112t_2,H/\u001a)bi\"\f\u0001c]=nE>d\u0017J\u001c4p\u0007\u0006\u001c\u0007.\u001a\u0011\u0002+MLXNY8m\t\u00164\u0017N\\5uS>t7)Y2iKV\t\u0001\u000e\u0005\u0003C\r~K\u0007cA%k\u0011&\u00111N\u0015\u0002\u0004'\u0016$\u0018AF:z[\n|G\u000eR3gS:LG/[8o\u0007\u0006\u001c\u0007.\u001a\u0011\u00027A,g\u000eZ5oO\u000e{W\u000e]5mKJLeNZ8SKF,Xm\u001d;t+\u0005y\u0007\u0003\u0002\"GaF\u0004BA\b+`\u0011B\u0019!G\u001d,\n\u0005M\u001c$A\u0002$viV\u0014X-\u0001\u000fqK:$\u0017N\\4D_6\u0004\u0018\u000e\\3s\u0013:4wNU3rk\u0016\u001cHo\u001d\u0011\u0002'\u001d,GoQ1dQ\u0016$7+_7c_2LeNZ8\u0015\u0007E<\u0018\u0010C\u0003y\u0017\u0001\u0007q,\u0001\u0003qCRD\u0007\"\u0002>\f\u0001\u0004A\u0015AB:z[\n|G.A\fgKR\u001c\u0007.\u00118e\u0007\u0006\u001c\u0007.Z*z[\n|G.\u00138g_R\u0019\u0011/ @\t\u000bad\u0001\u0019A0\t\u000bid\u0001\u0019\u0001%\u0002+A\u0014xnY3tg\u000e{W\u000e]5mKJ\u0014Vm];miR9a+a\u0001\u0002\u0006\u0005\u001d\u0001\"\u0002>\u000e\u0001\u0004A\u0005\"\u0002=\u000e\u0001\u0004y\u0006BBA\u0005\u001b\u0001\u0007a+\u0001\bd_6\u0004\u0018\u000e\\3s%\u0016\u001cX\u000f\u001c;\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005=\u0001c\u0001\u0010\u0002\u0012%\u0019\u00111C\r\u0003\tUs\u0017\u000e^\u0001\u0015e\u0016lwN^3Ts6\u0014w\u000e\\:G_J\u0004\u0016\r\u001e5\u0015\t\u0005=\u0011\u0011\u0004\u0005\u0006q>\u0001\ra\u0018")
public final class SymbolCache {
    private final Function0<Compilers> compilers;
    private final OnDemandSymbolIndex symbolIndex;
    private final ExecutionContext ec;
    private final TrieMap<String, Tuple2<Option<PcSymbolInformation>, AbsolutePath>> symbolInfoCache;
    private final TrieMap<AbsolutePath, Set<String>> symbolDefinitionCache;
    private final TrieMap<Tuple2<AbsolutePath, String>, Future<Option<PcSymbolInformation>>> pendingCompilerInfoRequests;

    private TrieMap<String, Tuple2<Option<PcSymbolInformation>, AbsolutePath>> symbolInfoCache() {
        return this.symbolInfoCache;
    }

    private TrieMap<AbsolutePath, Set<String>> symbolDefinitionCache() {
        return this.symbolDefinitionCache;
    }

    private TrieMap<Tuple2<AbsolutePath, String>, Future<Option<PcSymbolInformation>>> pendingCompilerInfoRequests() {
        return this.pendingCompilerInfoRequests;
    }

    public Future<Option<PcSymbolInformation>> getCachedSymbolInfo(AbsolutePath path2, String symbol) {
        Some some;
        Tuple2 tuple2;
        Option option = this.symbolInfoCache().get((Object)symbol);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            AbsolutePath cachedPath;
            Option cachedSymbolInfo = (Option)tuple2._1();
            AbsolutePath absolutePath = cachedPath = (AbsolutePath)tuple2._2();
            AbsolutePath absolutePath2 = path2;
            if (!(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null)) {
                return Future$.MODULE$.successful((Object)cachedSymbolInfo);
            }
            return this.fetchAndCacheSymbolInfo(path2, symbol);
        }
        if (None$.MODULE$.equals(option)) {
            return this.fetchAndCacheSymbolInfo(path2, symbol);
        }
        throw new MatchError((Object)option);
    }

    private Future<Option<PcSymbolInformation>> fetchAndCacheSymbolInfo(AbsolutePath path2, String symbol) {
        Tuple2 requestKey = new Tuple2((Object)path2, (Object)symbol);
        return (Future)this.pendingCompilerInfoRequests().getOrElseUpdate((Object)requestKey, (Function0 & Serializable)() -> {
            Future compilerInfoFuture = ((Compilers)$this.compilers.apply()).info(path2, symbol).map((Function1 & Serializable)compilerResult -> this.processCompilerResult(symbol, path2, (Option<PcSymbolInformation>)compilerResult), $this.ec);
            this.pendingCompilerInfoRequests().put((Object)requestKey, (Object)compilerInfoFuture);
            compilerInfoFuture.onComplete((Function1 & Serializable)x$1 -> this.pendingCompilerInfoRequests().remove((Object)requestKey), $this.ec);
            return compilerInfoFuture;
        });
    }

    private Option<PcSymbolInformation> processCompilerResult(String symbol, AbsolutePath path2, Option<PcSymbolInformation> compilerResult) {
        Option option = this.symbolIndex.definition(Symbol$.MODULE$.apply(symbol));
        if (option instanceof Some) {
            Some some = (Some)option;
            SymbolDefinition definition2 = (SymbolDefinition)some.value();
            this.symbolInfoCache().put((Object)symbol, (Object)new Tuple2(compilerResult, (Object)definition2.path()));
            this.symbolDefinitionCache().updateWith((Object)definition2.path(), (Function1 & Serializable)existing -> new Some((Object)((SetOps)existing.getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$plus((Object)symbol)));
            return compilerResult;
        }
        if (None$.MODULE$.equals(option)) {
            this.symbolInfoCache().put((Object)symbol, (Object)new Tuple2(compilerResult, (Object)path2));
            return compilerResult;
        }
        throw new MatchError((Object)option);
    }

    public void clear() {
        this.symbolInfoCache().clear();
        this.symbolDefinitionCache().clear();
        this.pendingCompilerInfoRequests().clear();
    }

    public void removeSymbolsForPath(AbsolutePath path2) {
        Option option = this.symbolDefinitionCache().get((Object)path2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Set symbols = (Set)some.value();
            symbols.foreach((Function1 & Serializable)k -> this.symbolInfoCache().remove(k));
            this.symbolDefinitionCache().remove((Object)path2);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public SymbolCache(Function0<Compilers> compilers, OnDemandSymbolIndex symbolIndex, ExecutionContext ec) {
        this.compilers = compilers;
        this.symbolIndex = symbolIndex;
        this.ec = ec;
        this.symbolInfoCache = TrieMap$.MODULE$.empty();
        this.symbolDefinitionCache = TrieMap$.MODULE$.empty();
        this.pendingCompilerInfoRequests = TrieMap$.MODULE$.empty();
    }
}

