/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.mcp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.meta.internal.metals.JsonParser$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.mcp.Client;
import scala.meta.internal.metals.mcp.CursorEditor$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class McpConfig$ {
    public static final McpConfig$ MODULE$ = new McpConfig$();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public Gson gson() {
        return gson;
    }

    public void writeConfig(int port, String projectName, AbsolutePath projectPath, Client client) {
        String filename = (String)client.fileName().getOrElse((Function0 & Serializable)() -> "mcp.json");
        AbsolutePath configFile = projectPath.resolve(client.settingsPath() + filename);
        String serverName = (String)client.serverEntry().getOrElse((Function0 & Serializable)() -> projectName + "-metals");
        String config = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).exists() ? MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).readText() : "{ }";
        String newConfig = this.createConfig(config, port, serverName, client);
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).writeText(newConfig);
    }

    public Client writeConfig$default$4() {
        return CursorEditor$.MODULE$;
    }

    public void deleteConfig(AbsolutePath projectPath, String projectName, Client client) {
        AbsolutePath configFile = projectPath.resolve(client.settingsPath() + "mcp.json");
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).exists()) {
            String configContent = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).readText();
            Try<JsonObject> updatedConfig = this.removeMetalsEntry(configContent, projectName, client);
            Try<JsonObject> try_ = updatedConfig;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)package$.MODULE$.error((Function0 & Serializable)() -> "Error removing metals entry: " + exception, new Pkg("scala.meta.internal.metals.mcp"), new FileName("McpConfig.scala"), new Name("deleteConfig"), new Line(49), MDC$.MODULE$.instance());
                return;
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                JsonObject value = (JsonObject)success.value();
                if (this.isConfigEmpty(value, client)) {
                    MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(configFile).delete();
                    return;
                }
                MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).writeText(this.gson().toJson((JsonElement)value));
                return;
            }
            throw new MatchError(try_);
        }
    }

    private Try<JsonObject> removeMetalsEntry(String configInput, String projectName, Client client) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            JsonObject config = JsonParser.parseString((String)configInput).getAsJsonObject();
            if (config.has(client.serverField())) {
                String metalsKey;
                JsonObject mcpServers = config.getAsJsonObject(client.serverField());
                Object object = mcpServers.has(metalsKey = projectName + "-metals") ? mcpServers.remove(metalsKey) : BoxedUnit.UNIT;
                v1 = mcpServers.size() == 0 ? config.remove(client.serverField()) : BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
            return config;
        });
    }

    private boolean isConfigEmpty(JsonObject config, Client client) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> config.size() == 0 || config.has(client.serverField()) && config.getAsJsonObject(client.serverField()).size() == 0 && config.size() == 1).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public String createConfig(String inputConfig, int port, String serverEntry, Client editor) {
        JsonObject jsonObject;
        JsonObject config = JsonParser.parseString((String)inputConfig).getAsJsonObject();
        if (config.has(editor.serverField())) {
            jsonObject = config.getAsJsonObject(editor.serverField());
        } else {
            JsonObject newMcpServers = new JsonObject();
            config.add(editor.serverField(), (JsonElement)newMcpServers);
            jsonObject = newMcpServers;
        }
        JsonObject mcpServers = jsonObject;
        JsonObject serverConfig = new JsonObject();
        serverConfig.addProperty("url", "http://localhost:" + port + "/sse");
        editor.additionalProperties().foreach((Function1 & Serializable)x0$1 -> {
            McpConfig$.$anonfun$createConfig$1(serverConfig, x0$1);
            return BoxedUnit.UNIT;
        });
        mcpServers.add(serverEntry, (JsonElement)serverConfig);
        return this.gson().toJson((JsonElement)config);
    }

    public Client createConfig$default$4() {
        return CursorEditor$.MODULE$;
    }

    public Option<Object> readPort(AbsolutePath projectPath, String projectName, Client editor) {
        String filename = (String)editor.fileName().getOrElse((Function0 & Serializable)() -> "mcp.json");
        AbsolutePath configFile = projectPath.resolve(editor.settingsPath() + filename);
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).exists()) {
            return this.getPort(MetalsEnrichments$.MODULE$.XtensionAbsolutePath(configFile).readText(), projectName, editor);
        }
        return None$.MODULE$;
    }

    public Option<Object> getPort(String configInput, String projectName, Client editor) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> JsonParser.parseString((String)configInput).getAsJsonObject()).toOption().flatMap((Function1 & Serializable)config -> JsonParser$.MODULE$.XtensionSerializedAsOption((JsonObject)config).getObjectOption(editor.serverField()).flatMap((Function1 & Serializable)mcpServers -> JsonParser$.MODULE$.XtensionSerializedAsOption((JsonObject)mcpServers).getObjectOption((String)editor.serverEntry().getOrElse((Function0 & Serializable)() -> projectName + "-metals")).flatMap((Function1 & Serializable)serverConfig -> JsonParser$.MODULE$.XtensionSerializedAsOption((JsonObject)serverConfig).getStringOption("url").flatMap((Function1 & Serializable)url -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(url), "/sse").split(":")))))).toOption().map((Function1)(JFunction1.mcII.sp & Serializable)port -> port)))));
    }

    public Client getPort$default$3() {
        return CursorEditor$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$createConfig$1(JsonObject serverConfig$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            serverConfig$1.addProperty(key, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private McpConfig$() {
    }
}

