/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals;

import ch.epfl.scala.debugadapter.ScalaVersion;
import coursier.LocalRepositories$;
import coursier.ivy.Pattern;
import coursier.paths.CoursierPaths;
import coursierapi.Dependency;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.scalafmt.interfaces.Scalafmt;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.meta.internal.builds.BazelBuildTool$;
import scala.meta.internal.metals.BloopServers$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.Embedded$;
import scala.meta.internal.metals.FileDecoderProvider$;
import scala.meta.internal.metals.FormattingProvider$;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.internal.metals.debug.server.MetalsDebugToolsResolver;
import scala.meta.internal.metals.debug.server.testing.TestInternals$;
import scala.meta.internal.metals.logging.MetalsLogger$;
import scala.meta.internal.mtags.CoursierComplete;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalafix.interfaces.Scalafix;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class DownloadDependencies$ {
    public static final DownloadDependencies$ MODULE$ = new DownloadDependencies$();
    private static List<String> allSupportedScala3Versions;
    private static final String metalsBinaryVersion;
    private static final CoursierComplete complete;
    private static volatile boolean bitmap$0;

    static {
        metalsBinaryVersion = ScalaVersions$.MODULE$.scalaBinaryVersionFromFullVersion(BuildInfo$.MODULE$.scala213());
        complete = new CoursierComplete("3");
    }

    private String metalsBinaryVersion() {
        return metalsBinaryVersion;
    }

    private CoursierComplete complete() {
        return complete;
    }

    private List<String> allSupportedScala3Versions$lzycompute() {
        DownloadDependencies$ downloadDependencies$ = this;
        synchronized (downloadDependencies$) {
            if (!bitmap$0) {
                allSupportedScala3Versions = this.complete().complete("org.scala-lang:scala3-presentation-compiler_3:", this.complete().complete$default$2(), this.complete().complete$default$3()).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("RC"))).filter((Function1 & Serializable)version -> BoxesRunTime.boxToBoolean((boolean)DownloadDependencies$.$anonfun$allSupportedScala3Versions$2(version)));
                bitmap$0 = true;
            }
        }
        return allSupportedScala3Versions;
    }

    private List<String> allSupportedScala3Versions() {
        if (!bitmap$0) {
            return this.allSupportedScala3Versions$lzycompute();
        }
        return allSupportedScala3Versions;
    }

    public void main(String[] args) {
        Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])args);
        String x$1 = "--scala-versions";
        int x$22 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1);
        int n = ArrayOps$.MODULE$.indexOf$extension(qual$1, (Object)"--scala-versions", x$22);
        Function1 & Serializable filterVersions = switch (n) {
            case -1 -> (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DownloadDependencies$.$anonfun$main$1(x$2));
            default -> {
                Set versions = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])args), n + 1)), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DownloadDependencies$.$anonfun$main$2(x$3)))).toSet();
                Predef$.MODULE$.println((Object)("Filtering versions: " + versions.mkString(", ")));
                yield (Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)versions.apply((Object)s));
            }
        };
        MetalsLogger$.MODULE$.updateDefaultFormat();
        Seq allPaths = (Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.downloadMdoc((Function1<String, Object>)filterVersions).$plus$plus(this.downloadScalafmt())).$plus$plus(this.downloadMtags((Function1<String, Object>)filterVersions))).$plus$plus(this.downloadSemanticDBScalac((Function1<String, Object>)filterVersions))).$plus$plus(this.downloadSemanticDBJavac())).$plus$plus(this.downloadScala())).$plus$plus(this.downloadBloop())).$plus$plus(this.downloadBazelBsp())).$plus$plus(this.downloadCfr())).$plus$plus(this.downloadScala3PresentationCompiler((Function1<String, Object>)filterVersions))).$plus$plus(this.downloadAllScalafixVersions((Function1<String, Object>)filterVersions))).$plus$plus(this.downloadAllScalaDebugToolVersions((Function1<String, Object>)filterVersions))).$plus$plus(this.downloadTestAgent());
        Seq distinctFiles = (Seq)allPaths.distinct();
        Object qual$2 = Predef$.MODULE$.refArrayOps((Object[])args);
        String x$32 = "--copy-to";
        int x$4 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$2);
        int n2 = ArrayOps$.MODULE$.indexOf$extension(qual$2, (Object)"--copy-to", x$4);
        None$ copyToDest = switch (n2) {
            case -1 -> None$.MODULE$;
            default -> new Some((Object)args[n2 + 1]);
        };
        copyToDest.foreach((Function1 & Serializable)path2 -> {
            DownloadDependencies$.MODULE$.copyToDestination((Seq<Path>)distinctFiles, path2);
            return BoxedUnit.UNIT;
        });
        distinctFiles.foreach((Function1 & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
    }

    public void copyToDestination(Seq<Path> distinctFiles, String destinationString) {
        AbsolutePath destinationPath = AbsolutePath$.MODULE$.apply(Paths.get(destinationString, new String[0]).toAbsolutePath(), AbsolutePath$.MODULE$.workingDirectory());
        String ivyDirectoryPath = ((IterableOnceOps)((IterableOps)LocalRepositories$.MODULE$.ivy2Local().pattern().chunks().takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DownloadDependencies$.$anonfun$copyToDestination$1(x0$1)))).map((Function1 & Serializable)x$4 -> x$4.string())).mkString();
        AbsolutePath coursierCacheLocation = AbsolutePath$.MODULE$.apply(CoursierPaths.cacheDirectory().toPath(), AbsolutePath$.MODULE$.workingDirectory());
        AbsolutePath ivyDirectory = AbsolutePath$.MODULE$.apply(Paths.get(URI.create(ivyDirectoryPath)), AbsolutePath$.MODULE$.workingDirectory());
        Predef$.MODULE$.println((Object)("Copying artifacts to " + destinationPath));
        distinctFiles.foreach((Function1 & Serializable)p -> {
            RelativePath relativePath;
            if (p.startsWith(coursierCacheLocation.toNIO())) {
                relativePath = AbsolutePath$.MODULE$.apply(p, AbsolutePath$.MODULE$.workingDirectory()).toRelative(coursierCacheLocation);
            } else if (p.startsWith(ivyDirectory.toNIO())) {
                relativePath = AbsolutePath$.MODULE$.apply(p, AbsolutePath$.MODULE$.workingDirectory()).toRelative(ivyDirectory);
            } else {
                throw new Exception("Unexpected cache path: " + p);
            }
            RelativePath relative = relativePath;
            AbsolutePath target = destinationPath.resolve(relative);
            Object object = !Files.exists(target.toNIO().getParent(), new LinkOption[0]) ? Files.createDirectories(target.toNIO().getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
            if (Files.exists(target.toNIO(), new LinkOption[0])) {
                Predef$.MODULE$.println((Object)("Skipping " + p + ", already exists at " + target));
                return BoxedUnit.UNIT;
            }
            Predef$.MODULE$.println((Object)("Copied " + p + " to " + target));
            return Files.copy(p, target.toNIO(), new CopyOption[0]);
        });
    }

    public Seq<Path> downloadScala() {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading scala library and sources", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScala"), new Line(132), MDC$.MODULE$.instance());
        return (Seq)BuildInfo$.MODULE$.supportedScala2Versions().flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadScalaSources((String)scalaVersion));
    }

    public Seq<Path> downloadMdoc(Function1<String, Object> filterVersions) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading mdoc", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadMdoc"), new Line(139), MDC$.MODULE$.instance());
        return (Seq)((IterableOps)BuildInfo$.MODULE$.supportedScala2Versions().filter(filterVersions)).flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadMdoc(ScalaVersions$.MODULE$.scalaBinaryVersionFromFullVersion((String)scalaVersion), (Option<String>)None$.MODULE$, Embedded$.MODULE$.downloadMdoc$default$3()));
    }

    public Seq<Path> downloadScalafmt() {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading scalafmt", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScalafmt"), new Line(150), MDC$.MODULE$.instance());
        Scalafmt scalafmt = FormattingProvider$.MODULE$.newScalafmt();
        Path tmp = Files.createTempFile("scalafmt", "Foo.scala", new FileAttribute[0]);
        Path config = Files.createTempFile("scalafmt", ".scalafmt.conf", new FileAttribute[0]);
        Files.write(config, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|version = " + BuildInfo$.MODULE$.scalafmtVersion() + "\n          |runner.dialect = scala3")).getBytes(), new OpenOption[0]);
        scalafmt.format(config, tmp, "object Foo { }");
        Files.deleteIfExists(tmp);
        Files.deleteIfExists(config);
        return Embedded$.MODULE$.downloadDependency(Dependency.of((String)"org.scalameta", (String)("scalafmt-cli_" + this.metalsBinaryVersion()), (String)BuildInfo$.MODULE$.scalafmtVersion()), (Option<String>)new Some((Object)BuildInfo$.MODULE$.scala213()), Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    public Seq<Path> downloadMtags(Function1<String, Object> filterVersions) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading mtags", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadMtags"), new Line(173), MDC$.MODULE$.instance());
        return (Seq)((IterableOps)BuildInfo$.MODULE$.supportedScalaVersions().filter(filterVersions)).flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadMtags((String)scalaVersion, BuildInfo$.MODULE$.metalsVersion()));
    }

    public Seq<Path> downloadScala3PresentationCompiler(Function1<String, Object> filterVersions) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading Scala 3 presentation compiler", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScala3PresentationCompiler"), new Line(183), MDC$.MODULE$.instance());
        return this.allSupportedScala3Versions().filter(filterVersions).flatMap((Function1 & Serializable)scalaVersion -> (List)Embedded$.MODULE$.downloadScala3PresentationCompiler((String)scalaVersion).$plus$plus(Embedded$.MODULE$.downloadScala3Sources((String)scalaVersion)));
    }

    public Seq<Path> downloadSemanticDBScalac(Function1<String, Object> filterVersions) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading semanticdb-scalac", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadSemanticDBScalac"), new Line(192), MDC$.MODULE$.instance());
        return (Seq)((IterableOps)BuildInfo$.MODULE$.supportedScala2Versions().filter(filterVersions)).flatMap((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadSemanticdbScalac((String)scalaVersion));
    }

    public Seq<Path> downloadSemanticDBJavac() {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading semanticdb-javac", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadSemanticDBJavac"), new Line(200), MDC$.MODULE$.instance());
        return Embedded$.MODULE$.downloadSemanticdbJavac();
    }

    public Seq<Path> downloadBazelBsp() {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading bazel-bsp", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadBazelBsp"), new Line(205), MDC$.MODULE$.instance());
        return Embedded$.MODULE$.downloadDependency(BazelBuildTool$.MODULE$.dependency(), (Option<String>)None$.MODULE$, Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    public Seq<Path> downloadCfr() {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading cfr", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadCfr"), new Line(213), MDC$.MODULE$.instance());
        return Embedded$.MODULE$.downloadDependency(FileDecoderProvider$.MODULE$.cfrDependency(), Embedded$.MODULE$.downloadDependency$default$2(), Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    public Seq<Path> downloadAllScalafixVersions(Function1<String, Object> filterVersions) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading all Scalafix versions", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadAllScalafixVersions"), new Line(220), MDC$.MODULE$.instance());
        List allScalaVersions = ((List)this.allSupportedScala3Versions().$plus$plus(BuildInfo$.MODULE$.supportedScala2Versions())).filter(filterVersions);
        List allToDownload = ((List)allScalaVersions.map((Function1 & Serializable)x$5 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$5), '.')), 2)).mkString(".")).distinct()).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DownloadDependencies$.$anonfun$downloadAllScalafixVersions$3(x$6)));
        return allToDownload.flatMap((Function1 & Serializable)scalaMinorVersion -> Predef$.MODULE$.wrapRefArray((Object[])MODULE$.downloadScalafix((String)scalaMinorVersion)));
    }

    public Path[] downloadScalafix(String scalaMinorVersion) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading Scalafix for " + scalaMinorVersion, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScalafix"), new Line(233), MDC$.MODULE$.instance());
        ClassLoader classLoader = Scalafix.fetchAndClassloadInstance((String)scalaMinorVersion).getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            return (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs()), (Function1 & Serializable)x$7 -> x$7.toURI(), ClassTag$.MODULE$.apply(URI.class))), (Function1 & Serializable)x$8 -> Paths.get(x$8), ClassTag$.MODULE$.apply(Path.class));
        }
        throw new Exception("Unexpected classloader: " + classLoader);
    }

    public Seq<Path> downloadBloop() {
        String version = BloopServers$.MODULE$.defaultBloopVersion();
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading Bloop " + version, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadBloop"), new Line(247), MDC$.MODULE$.instance());
        Either<Throwable, Seq<File>> either = BloopServers$.MODULE$.fetchBloop(version);
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable ex = (Throwable)left.value();
            throw new Exception("Could not pre-download Bloop " + version, ex);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq files = (Seq)right.value();
            return (Seq)files.map((Function1 & Serializable)x$9 -> x$9.toPath());
        }
        throw new MatchError(either);
    }

    public Seq<Path> downloadAllScalaDebugToolVersions(Function1<String, Object> filterVersions) {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading all Scala debug tool versions", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadAllScalaDebugToolVersions"), new Line(258), MDC$.MODULE$.instance());
        MetalsDebugToolsResolver resolver = new MetalsDebugToolsResolver();
        return ((List)this.allSupportedScala3Versions().$plus$plus(BuildInfo$.MODULE$.supportedScala2Versions())).filter(filterVersions).flatMap((Function1 & Serializable)scalaVersion -> {
            .colon.colon noExpressionCompiler = new .colon.colon((Object)"3.6.0", (List)new .colon.colon((Object)"2.11.12", (List)Nil$.MODULE$));
            List expressionCompilerJars = !noExpressionCompiler.contains(scalaVersion) ? DownloadDependencies$.downloadExpressionCompiler$1(scalaVersion, resolver) : (Seq)package$.MODULE$.Seq().empty();
            List debugDecoderJars = scalaVersion.startsWith("3.") ? DownloadDependencies$.downloadDebugDecoderCompiler$1(scalaVersion, resolver) : (Seq)package$.MODULE$.Seq().empty();
            return (Seq)expressionCompilerJars.$plus$plus((IterableOnce)debugDecoderJars);
        });
    }

    public Seq<Path> downloadTestAgent() {
        scribe.package$.MODULE$.info((Function0 & Serializable)() -> "Downloading test-agent", new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadTestAgent"), new Line(289), MDC$.MODULE$.instance());
        return Embedded$.MODULE$.downloadDependency(TestInternals$.MODULE$.dependency(), Embedded$.MODULE$.downloadDependency$default$2(), Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$allSupportedScala3Versions$2(String version) {
        return !((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"3.5.0", "3.4.3", "3.4.2", "3.4.1", "3.4.0"}))).apply((Object)version);
    }

    public static final /* synthetic */ boolean $anonfun$main$1(String x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$main$2(String x$3) {
        return !x$3.startsWith("-");
    }

    public static final /* synthetic */ boolean $anonfun$copyToDestination$1(Pattern.Chunk x0$1) {
        Pattern.Chunk chunk = x0$1;
        return chunk instanceof Pattern.Chunk$.Const;
    }

    public static final /* synthetic */ boolean $anonfun$downloadAllScalafixVersions$3(String x$6) {
        String string = x$6;
        String string2 = "2.11";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final List downloadExpressionCompiler$1(String scalaVersion, MetalsDebugToolsResolver resolver$1) {
        return Embedded$.MODULE$.downloadDependency(resolver$1.expressionCompilerDependency(new ScalaVersion(scalaVersion)), (Option<String>)new Some((Object)scalaVersion), Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    private static final List downloadDebugDecoderCompiler$1(String scalaVersion, MetalsDebugToolsResolver resolver$1) {
        return Embedded$.MODULE$.downloadDependency(resolver$1.debugDecoderDependency(new ScalaVersion(scalaVersion)), (Option<String>)new Some((Object)scalaVersion), Embedded$.MODULE$.downloadDependency$default$3(), Embedded$.MODULE$.downloadDependency$default$4());
    }

    private DownloadDependencies$() {
    }
}

