/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals;

import java.io.Serializable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.semver.SemVer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u00114Qa\u0003\u0007\u0002\u0002MAQ\u0001\u0007\u0001\u0005\u0002eAq\u0001\b\u0001C\u0002\u0013\rQ\u0004\u0003\u0004%\u0001\u0001\u0006IAH\u0003\u0005K\u0001\u0001a%\u0002\u00032\u0001\u00011\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"\u0002&\u0001\t\u0013Y\u0005\"\u0002*\u0001\t\u0013\u0019\u0006\"\u0002-\u0001\r#I\u0006\"B1\u0001\t\u0013\u0011'AF*vaB|'\u000f^3e'\u000e\fG.\u0019,feNLwN\\:\u000b\u00055q\u0011AB7fi\u0006d7O\u0003\u0002\u0010!\u0005!Q.\u001a;b\u0015\u0005\t\u0012!B:dC2\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u0003AI!a\u0006\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\tA\"\u0001\u0002fGV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"!\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\r\u0002#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\r\t\u0002\u0012'V\u0004\bo\u001c:uK\u00124VM]:j_:\u001c\bCA\u0014/\u001d\tAC\u0006\u0005\u0002*!5\t!F\u0003\u0002,%\u00051AH]8pizJ!!\f\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[A\u0011!cU;qa>\u0014H/\u001a3BiJ+G.Z1tK\u000692/\u001e9q_J$X\r\u001a,feNLwN\\:TiJLgn\u001a\u000b\u0004i\u0001\u0013\u0005\u0003B\u001b;{}r!A\u000e\u001d\u000f\u0005%:\u0014\"A\t\n\u0005e\u0002\u0012a\u00029bG.\fw-Z\u0005\u0003wq\u0012a!R5uQ\u0016\u0014(BA\u001d\u0011!\tqT!D\u0001\u0001!\tqD\u0001C\u0003B\r\u0001\u0007a%A\u0004wKJ\u001c\u0018n\u001c8\t\u000b\r3\u0001\u0019\u0001#\u0002\u000fQLW.Z8viB\u0011Q\tS\u0007\u0002\r*\u0011q\tI\u0001\tIV\u0014\u0018\r^5p]&\u0011\u0011J\u0012\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003A1\u0017N\u001c3BY2\u001cV\u000f\u001d9peR,G\rF\u0002M\u001fF\u00032!F''\u0013\tq\u0005C\u0001\u0004PaRLwN\u001c\u0005\u0006!\u001e\u0001\rAJ\u0001\u000e[\u0016$\u0018\r\\:WKJ\u001c\u0018n\u001c8\t\u000b\r;\u0001\u0019\u0001#\u0002#M,\b\u000f]8si\u0016$\u0017J\\'fi\u0006d7\u000f\u0006\u0003M)Z;\u0006\"B+\t\u0001\u00041\u0013aA;sY\")\u0001\u000b\u0003a\u0001M!)1\t\u0003a\u0001\t\u0006aam\u001c:nCR\u001c\u0016N\\4mKR\u0019aE\u0017/\t\u000bmK\u0001\u0019\u0001\u0014\u0002\u000b5\f'n\u001c:\t\u000buK\u0001\u0019\u00010\u0002\u0011Y,'o]5p]N\u00042!N0'\u0013\t\u0001GHA\u0002TKF\faBZ8s[\u0006$h+\u001a:tS>t7\u000f\u0006\u0002'G\")QL\u0003a\u0001=\u0002")
public abstract class SupportedScalaVersions {
    private final ExecutionContext ec = ExecutionContext$.MODULE$.global();

    public ExecutionContext ec() {
        return this.ec;
    }

    public Either<String, String> supportedVersionsString(String version, FiniteDuration timeout) {
        Option<String> option = this.findAllSupported(version, timeout);
        if (None$.MODULE$.equals(option)) {
            return new Left((Object)this.formatVersions(BuildInfo$.MODULE$.supportedScalaVersions()));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return new Right((Object)value);
        }
        throw new MatchError(option);
    }

    private Option<String> findAllSupported(String metalsVersion, FiniteDuration timeout) {
        String url = metalsVersion.contains("SNAPSHOT") ? "https://central.sonatype.com/service/rest/repository/browse/maven-snapshots/org/scalameta/" : "https://repo1.maven.org/maven2/org/scalameta/";
        return this.supportedInMetals(url, metalsVersion, timeout);
    }

    private Option<String> supportedInMetals(String url, String metalsVersion, FiniteDuration timeout) {
        Some some;
        try {
            Predef$.MODULE$.println((Object)("Checking available versions on " + url + "\n"));
            Document allScalametaArtifacts = Jsoup.connect((String)url).get();
            Buffer allMdocs = (Buffer)scala.meta.internal.jdk.package$.MODULE$.CollectionConverters().ListHasAsScala((java.util.List)allScalametaArtifacts.select("a")).asScala().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)SupportedScalaVersions.$anonfun$supportedInMetals$1(a)));
            Iterator allSupportedScalaFut = allMdocs.iterator().map((Function1 & Serializable)mdocLink -> {
                if (mdocLink.text().contains("NIGHTLY")) {
                    return Future$.MODULE$.successful((Object)None$.MODULE$);
                }
                String link = mdocLink.attr("href");
                String mtagsLink = link.startsWith("http") ? link : url + link;
                return Future$.MODULE$.apply((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> Jsoup.connect((String)(mtagsLink + metalsVersion)).get()), this.ec()).map((Function1 & Serializable)x0$1 -> {
                    Try try_ = x0$1;
                    if (try_ instanceof Success) {
                        return new Some((Object)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(mdocLink.text()), "mtags_")), "/"));
                    }
                    if (try_ instanceof Failure) {
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)try_);
                }, this.ec());
            });
            Iterator allSupportedScala = ((Iterator)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)allSupportedScalaFut, BuildFrom$.MODULE$.buildFromIterator(), this.ec()), (Duration)timeout)).flatten(Predef$.MODULE$.$conforms());
            String template = this.formatVersions((Seq<String>)allSupportedScala.toList());
            some = new Some((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + template + "\n            |Scala 3 versions from 3.3.4 are automatically supported by Metals.\n            |\n            |Any older Scala versions will no longer get bugfixes, but should still\n            |work properly with newest Metals. \n            |")));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Could not check supported Scala versions, returning list available at release"), LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> throwable2)}), new Pkg("scala.meta.metals"), new FileName("SupportedScalaVersions.scala"), new Name("supportedInMetals"), new Line(103), MDC$.MODULE$.instance());
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public abstract String formatSingle(String var1, Seq<String> var2);

    private String formatVersions(Seq<String> versions) {
        return ((List)versions.toList().map((Function1 & Serializable)version -> SemVer.Version$.MODULE$.fromString(version)).groupBy((Function1 & Serializable)version -> {
            if (version.major() == 2) {
                return Integer.toString(version.major()) + "." + version.minor();
            }
            return Integer.toString(version.major());
        }).toList().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String major = (String)tuple2._1();
                List vers = (List)tuple2._2();
                return this.formatSingle(major, (Seq<String>)((List)vers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.patch()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$3 -> x$3.toString()));
            }
            throw new MatchError((Object)tuple2);
        }).mkString("");
    }

    public static final /* synthetic */ boolean $anonfun$supportedInMetals$1(Element a) {
        String name = a.text();
        return name.contains("mtags_");
    }
}

