/*
 * Decompiled with CFR 0.152.
 */
package moped.parsers;

import java.io.Serializable;
import moped.internal.diagnostics.DiagnosticException;
import moped.internal.transformers.HoconTransformer;
import moped.internal.transformers.JsonTransformer;
import moped.json.JsonElement;
import moped.json.Result;
import moped.json.Result$;
import moped.parsers.ConfigurationParser;
import moped.reporters.Diagnostic$;
import moped.reporters.Input;
import moped.reporters.NoPosition$;
import moped.reporters.Position;
import moped.reporters.RangePosition$;
import org.ekrich.config.ConfigException;
import org.ekrich.config.ConfigFactory$;
import org.ekrich.config.ConfigObject;
import org.ekrich.config.ConfigParseOptions;
import org.ekrich.config.ConfigParseOptions$;
import org.ekrich.config.ConfigValue;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.control.NonFatal$;

public final class HoconParser$
implements ConfigurationParser {
    public static HoconParser$ MODULE$;

    static {
        new HoconParser$();
    }

    public List<String> supportedFileExtensions() {
        return new .colon.colon((Object)"conf", (List)Nil$.MODULE$);
    }

    public Result<JsonElement> parse(Input input) {
        return Result$.MODULE$.fromUnsafe((Function0 & Serializable & scala.Serializable)() -> {
            JsonElement jsonElement;
            try {
                ConfigParseOptions options = ConfigParseOptions$.MODULE$.defaults().setOriginDescription(input.filename());
                ConfigObject root = ConfigFactory$.MODULE$.parseString(input.text(), options).resolve().root();
                jsonElement = (JsonElement)new HoconTransformer(input).transform((ConfigValue)root, new JsonTransformer(input));
            }
            catch (Throwable throwable) {
                ConfigException.Parse parse;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ConfigException.Parse && (parse = (ConfigException.Parse)throwable2).getMessage() != null && parse.origin() != null) {
                    NoPosition$ noPosition$;
                    if (parse.origin().lineNumber() < 0) {
                        noPosition$ = NoPosition$.MODULE$;
                    } else {
                        int line = parse.origin().lineNumber() - 1;
                        int offset = input.lineToOffset(line);
                        noPosition$ = RangePosition$.MODULE$.apply(input, offset, offset);
                    }
                    NoPosition$ pos = noPosition$;
                    String message = new StringOps(Predef$.MODULE$.augmentString(parse.getMessage())).stripPrefix(new StringBuilder(4).append(input.filename()).append(": ").append(parse.origin().lineNumber()).append(": ").toString());
                    throw new DiagnosticException(Diagnostic$.MODULE$.error(message, (Position)pos));
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw e;
                }
                throw throwable;
            }
            return jsonElement;
        });
    }

    private HoconParser$() {
        MODULE$ = this;
    }
}

