/*
 * Decompiled with CFR 0.152.
 */
package moped.testkit;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import moped.internal.console.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ResizableArray;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileLayout$ {
    public static FileLayout$ MODULE$;

    static {
        new FileLayout$();
    }

    public String asString(Path root, Function1<Path, Object> includePath, Charset charset) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return "";
        }
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(includePath, buf){
            private final Function1 includePath$1;
            private final ArrayBuffer buf$1;

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return !BoxesRunTime.unboxToBoolean((Object)this.includePath$1.apply((Object)dir)) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Object object = BoxesRunTime.unboxToBoolean((Object)this.includePath$1.apply((Object)file)) ? this.buf$1.$plus$eq((Object)file) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }
            {
                this.includePath$1 = includePath$1;
                this.buf$1 = buf$1;
            }
        });
        ((ResizableArray)buf.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            scala.collection.mutable.StringBuilder stringBuilder;
            String relpath = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(root.relativize((Path)file).iterator()).asScala()).mkString("/");
            out.append("/").append(relpath);
            if (Files.isSymbolicLink(file)) {
                stringBuilder = out.append(" -> ").append((Object)Files.readSymbolicLink(file));
            } else {
                String text = Utils$.MODULE$.readFile(file);
                stringBuilder = out.append("\n").append(text);
            }
            return out.append("\n");
        });
        return out.toString();
    }

    public Function1<Path, Object> asString$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileLayout$.$anonfun$asString$default$2$1(x$1));
    }

    public Charset asString$default$3() {
        return StandardCharsets.UTF_8;
    }

    public Map<String, String> mapFromString(String layout) {
        Map map;
        if (!layout.trim().isEmpty()) {
            String lines = layout.replace("\r\n", "\n");
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines.split("(?=\n/)"))).map((Function1 & Serializable & scala.Serializable)row -> {
                String contents;
                String path;
                block3: {
                    List list;
                    block2: {
                        list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(row)).stripPrefix("\n").split("\n", 2))).toList();
                        if (!(list instanceof .colon.colon)) break block2;
                        .colon.colon colon2 = (.colon.colon)list;
                        path = (String)colon2.head();
                        List list2 = colon2.tl$access$1();
                        if (!(list2 instanceof .colon.colon)) break block2;
                        .colon.colon colon3 = (.colon.colon)list2;
                        contents = (String)colon3.head();
                        List list3 = colon3.tl$access$1();
                        if (Nil$.MODULE$.equals(list3)) break block3;
                    }
                    throw new IllegalArgumentException(new StringBuilder(46).append("Unable to split argument info path/contents! \n").append(list).toString());
                }
                String withEndOfFileLine = contents.endsWith("\n") ? contents : new StringBuilder(1).append(contents).append("\n").toString();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(path)).stripPrefix("/")), (Object)withEndOfFileLine);
                return tuple2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Path fromString(String layout, Path root, Charset charset) {
        block0: {
            if (layout.trim().isEmpty()) break block0;
            this.mapFromString(layout).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String path = (String)tuple2._1();
                String contents = (String)tuple2._2();
                Path file = (Path)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).foldLeft((Object)root, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.resolve((String)x$3));
                Path parent = file.getParent();
                Object object = !Files.exists(parent, new LinkOption[0]) ? Files.createDirectories(parent, new FileAttribute[0]) : BoxedUnit.UNIT;
                Files.deleteIfExists(file);
                Path path2 = Files.write(file, contents.getBytes(charset), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                return path2;
            });
        }
        return root;
    }

    public Path fromString$default$2() {
        return Files.createTempDirectory("moped", new FileAttribute[0]);
    }

    public Charset fromString$default$3() {
        return StandardCharsets.UTF_8;
    }

    public static final /* synthetic */ boolean $anonfun$asString$default$2$1(Path x$1) {
        return true;
    }

    private FileLayout$() {
        MODULE$ = this;
    }
}

