/*
 * Decompiled with CFR 0.152.
 */
package moped.json;

import java.io.Serializable;
import moped.internal.diagnostics.TypeMismatchDiagnostic;
import moped.json.ErrorResult;
import moped.json.JsonArray;
import moped.json.JsonBoolean;
import moped.json.JsonElement;
import moped.json.JsonElement$;
import moped.json.JsonEncoder;
import moped.json.JsonEncoder$;
import moped.json.JsonMember;
import moped.json.JsonNull;
import moped.json.JsonNumber;
import moped.json.JsonObject;
import moped.json.JsonString;
import moped.json.JsonString$;
import moped.json.NoCursor;
import moped.json.Result;
import moped.json.ValueResult;
import moped.macros.ClassShaper;
import moped.macros.ParameterShape;
import moped.reporters.NoPosition$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class JsonSchema$ {
    public static final JsonSchema$ MODULE$ = new JsonSchema$();

    public <T> Result<JsonObject> generate(String title, String description2, Option<String> url, T t, JsonEncoder<T> evidence$1, ClassShaper<T> settings) {
        Result result;
        JsonElement jsonElement = JsonEncoder$.MODULE$.apply(evidence$1).encode(t);
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            result = new ValueResult<JsonObject>(this.generate(title, description2, url, jsonObject, settings));
        } else {
            result = new ErrorResult(new TypeMismatchDiagnostic("JsonObject", jsonElement.productPrefix(), NoPosition$.MODULE$, new NoCursor()));
        }
        return result;
    }

    public <T> JsonObject generate(String title, String description2, Option<String> url, JsonObject jsonObject, ClassShaper<T> settings) {
        JsonObject properties = JsonElement$.MODULE$.fromMembers((Seq<Tuple2<String, JsonElement>>)((List)settings.parametersFlat().zip(jsonObject.members())).map((Function1 & Serializable)x0$1 -> {
            JsonMember jsonMember;
            ParameterShape s;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    s = (ParameterShape)tuple2._1();
                    jsonMember = (JsonMember)tuple2._2();
                    if (jsonMember != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            JsonElement v = jsonMember.value();
            Tuple2<String, JsonObject> tuple2 = MODULE$.fromSetting(s, v);
            return tuple2;
        }));
        return JsonElement$.MODULE$.fromMembers((Seq<Tuple2<String, JsonElement>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$id"), url.map((Function1)JsonString$.MODULE$).getOrElse((Function0 & Serializable)() -> new JsonNull())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)new JsonString(title)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)new JsonString(description2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)new JsonString("object")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"properties"), (Object)properties)}));
    }

    private Tuple2<String, JsonObject> fromSetting(ParameterShape setting, JsonElement defaultValue) {
        JsonObject jsonObject;
        JsonObject obj = JsonElement$.MODULE$.fromMembers((Seq<Tuple2<String, JsonElement>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)new JsonString(setting.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), setting.description().map((Function1 & Serializable)desc -> new JsonString(desc.render(80))).getOrElse((Function0 & Serializable)() -> new JsonNull())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default"), (Object)defaultValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"required"), (Object)new JsonBoolean(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSchemaType(defaultValue))}));
        JsonElement jsonElement = defaultValue;
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject2 = (JsonObject)jsonElement;
            List<JsonMember> values = jsonObject2.members();
            JsonObject properties = JsonElement$.MODULE$.fromMembers((Seq<Tuple2<String, JsonElement>>)((Seq)setting.underlying().map((Function1 & Serializable)x$1 -> ((List)x$1.parametersFlat().zip((IterableOnce)values)).map((Function1 & Serializable)x0$1 -> {
                JsonMember jsonMember;
                ParameterShape s;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        s = (ParameterShape)tuple2._1();
                        jsonMember = (JsonMember)tuple2._2();
                        if (jsonMember != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                JsonElement v = jsonMember.value();
                Tuple2<String, JsonObject> tuple2 = MODULE$.fromSetting(s, v);
                return tuple2;
            })).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)));
            jsonObject = obj.$plus(new JsonMember(new JsonString("properties"), properties));
        } else {
            jsonObject = obj;
        }
        JsonObject withProperties = jsonObject;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)setting.name()), (Object)withProperties);
    }

    private JsonString toSchemaType(JsonElement conf) {
        String string;
        JsonElement jsonElement = conf;
        if (jsonElement instanceof JsonBoolean) {
            string = "boolean";
        } else if (jsonElement instanceof JsonNumber) {
            string = "number";
        } else if (jsonElement instanceof JsonArray) {
            string = "array";
        } else if (jsonElement instanceof JsonString) {
            string = "string";
        } else if (jsonElement instanceof JsonNull) {
            string = "null";
        } else if (jsonElement instanceof JsonObject) {
            string = "object";
        } else {
            throw new MatchError((Object)jsonElement);
        }
        return new JsonString(string);
    }

    private JsonSchema$() {
    }
}

