/*
 * Decompiled with CFR 0.152.
 */
package munit;

import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.DottyBugAssumptionViolatedException;
import munit.GenericAfterEach;
import munit.GenericBeforeEach;
import munit.GenericTest;
import munit.MUnitRunner$;
import munit.Suite;
import munit.Tag;
import munit.TestValues;
import munit.TestValues$;
import munit.internal.Compat$;
import munit.internal.PlatformCompat$;
import munit.internal.console.StackTraces$;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class MUnitRunner
extends Runner
implements Filterable {
    private final Class cls;
    private final Suite suite;
    private final Description suiteDescription;
    private volatile Filter filter;
    private final Map descriptions;
    private final Set testNames;

    public MUnitRunner(Class<? extends Suite> cls, Function0<Suite> newInstance) {
        this.cls = cls;
        this.suite = (Suite)newInstance.apply();
        this.suiteDescription = Description.createSuiteDescription(cls);
        this.filter = Filter.ALL;
        this.descriptions = (Map)Map$.MODULE$.empty();
        this.testNames = (Set)Set$.MODULE$.empty();
    }

    public Class<? extends Suite> cls() {
        return this.cls;
    }

    public MUnitRunner(Class<? extends Suite> cls) {
        this(MUnitRunner$.MODULE$.munit$MUnitRunner$$$ensureEligibleConstructor(cls), MUnitRunner.MUnitRunner$superArg$1(cls));
    }

    public Suite suite() {
        return this.suite;
    }

    public Map<GenericTest<Object>, Description> descriptions() {
        return this.descriptions;
    }

    public Set<String> testNames() {
        return this.testNames;
    }

    public void filter(Filter filter) {
        this.filter = filter;
    }

    public Description createTestDescription(GenericTest test) {
        return (Description)this.descriptions().getOrElseUpdate((Object)test, () -> this.createTestDescription$$anonfun$1(test));
    }

    /*
     * WARNING - void declaration
     */
    public Description getDescription() {
        void var1_1;
        Nil$ nil$;
        Description description = Description.createSuiteDescription(this.cls());
        try {
            Seq suiteTests = (Seq)StackTraces$.MODULE$.dropOutside(this::$anonfun$1);
            suiteTests.foreach((Function1)(JProcedure1 & Serializable)test -> {
                Description testDescription = this.createTestDescription((GenericTest)test);
                if (this.filter.shouldRun(testDescription)) {
                    description.addChild(testDescription);
                }
            });
            nil$ = BoxedUnit.UNIT;
        }
        catch (Throwable ex) {
            StackTraces$.MODULE$.trimStackTrace(ex);
            ex.printStackTrace();
            nil$ = package$.MODULE$.Nil();
        }
        return var1_1;
    }

    public void run(RunNotifier notifier) {
        notifier.fireTestSuiteStarted(this.suiteDescription);
        try {
            try {
                this.runAll(notifier);
            }
            catch (Throwable ex) {
                this.fireHiddenTest(notifier, "expected error running tests", ex);
            }
        }
        finally {
            notifier.fireTestSuiteFinished(this.suiteDescription);
        }
    }

    private boolean runHiddenTest(RunNotifier notifier, String name, Function0 thunk) {
        boolean bl;
        try {
            StackTraces$.MODULE$.dropOutside(thunk);
            bl = true;
        }
        catch (Throwable ex) {
            this.fireHiddenTest(notifier, name, ex);
            bl = false;
        }
        return bl;
    }

    private void fireHiddenTest(RunNotifier notifier, String name, Throwable ex) {
        Description description = Description.createTestDescription(this.cls(), (String)name);
        notifier.fireTestStarted(description);
        StackTraces$.MODULE$.trimStackTrace(ex);
        notifier.fireTestFailure(new Failure(this.suiteDescription, ex));
        notifier.fireTestFinished(description);
    }

    public boolean runBeforeAll(RunNotifier notifier) {
        return this.runHiddenTest(notifier, "beforeAll", (Function0)((JFunction0.mcV.sp & Serializable)this::runBeforeAll$$anonfun$1));
    }

    public boolean runAfterAll(RunNotifier notifier) {
        return this.runHiddenTest(notifier, "afterAll", (Function0)((JFunction0.mcV.sp & Serializable)this::runAfterAll$$anonfun$1));
    }

    public boolean runBeforeEach(RunNotifier notifier, GenericTest test) {
        return this.runHiddenTest(notifier, "beforeEach." + test.name(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.runBeforeEach$$anonfun$1(test)));
    }

    public boolean runAfterEach(RunNotifier notifier, GenericTest test) {
        return this.runHiddenTest(notifier, "afterEach." + test.name(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.runAfterEach$$anonfun$1(test)));
    }

    public void runTest(RunNotifier notifier, GenericTest test) {
        block16: {
            Description description = this.createTestDescription(test);
            if (!this.filter.shouldRun(description)) {
                return;
            }
            boolean isContinue = this.runBeforeEach(notifier, test);
            if (isContinue) {
                notifier.fireTestStarted(description);
                try {
                    try {
                        Object t = StackTraces$.MODULE$.dropOutside(test.body());
                        if (t instanceof TestValues.FlakyFailure) {
                            TestValues.FlakyFailure f = (TestValues.FlakyFailure)t;
                            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)f));
                            break block16;
                        }
                        Tag tag = TestValues$.MODULE$.Ignore();
                        Object t2 = t;
                        if (tag == null) {
                            if (t2 != null) {
                                break block16;
                            }
                        } else if (!((Object)tag).equals(t2)) break block16;
                        notifier.fireTestIgnored(description);
                    }
                    catch (DottyBugAssumptionViolatedException ex) {
                        StackTraces$.MODULE$.trimStackTrace(ex);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            StackTraces$.MODULE$.trimStackTrace(ex);
                            Failure failure = new Failure(description, ex);
                            Throwable throwable4 = ex;
                            if (throwable4 instanceof DottyBugAssumptionViolatedException) {
                                notifier.fireTestAssumptionFailed(failure);
                            } else {
                                notifier.fireTestFailure(failure);
                            }
                            break block16;
                        }
                        throw throwable;
                    }
                }
                finally {
                    notifier.fireTestFinished(description);
                    this.runAfterEach(notifier, test);
                }
            }
        }
    }

    public void runAll(RunNotifier notifier) {
        if (PlatformCompat$.MODULE$.isIgnoreSuite(this.cls())) {
            notifier.fireTestIgnored(this.suiteDescription);
            return;
        }
        try {
            boolean isContinue = this.runBeforeAll(notifier);
            if (isContinue) {
                this.suite().munitTests().foreach((Function1)(JProcedure1 & Serializable)test -> this.runTest(notifier, (GenericTest)test));
            }
        }
        finally {
            this.runAfterAll(notifier);
        }
    }

    private static Function0<Suite> MUnitRunner$superArg$1(Class<? extends Suite> cls) {
        return (Function0 & Serializable)() -> (Suite)cls.newInstance();
    }

    private static final /* synthetic */ String $anonfun$2(GenericTest test$2, int x$1) {
        String string;
        int n = x$1;
        if (0 == n) {
            string = test$2.name();
        } else {
            int n2 = n;
            string = "" + test$2.name() + "-" + n2;
        }
        return string;
    }

    private static final String $anonfun$adapted$1(GenericTest test$5, Object x$1) {
        return MUnitRunner.$anonfun$2(test$5, BoxesRunTime.unboxToInt((Object)x$1));
    }

    private final Description createTestDescription$$anonfun$1(GenericTest test$1) {
        String testName = (String)Option$.MODULE$.option2Iterable(Compat$.MODULE$.LazyList().from(0).map((Function1)((JFunction1 & Serializable)arg_0 -> MUnitRunner.$anonfun$adapted$1(test$1, arg_0))).find((Function1)(JFunction1 & Serializable)candidate -> !this.testNames().contains(candidate))).head();
        this.testNames().$plus$eq((Object)testName);
        return Description.createTestDescription(this.cls(), (String)testName, (Annotation[])new Annotation[]{test$1.location()});
    }

    private final Seq $anonfun$1() {
        return this.suite().munitTests();
    }

    private final void runBeforeAll$$anonfun$1() {
        this.suite().beforeAll();
    }

    private final void runAfterAll$$anonfun$1() {
        this.suite().afterAll();
    }

    private final void runBeforeEach$$anonfun$1(GenericTest test$3) {
        this.suite().beforeEach(new GenericBeforeEach(test$3));
    }

    private final void runAfterEach$$anonfun$1(GenericTest test$4) {
        this.suite().afterEach(new GenericAfterEach(test$4));
    }
}

