/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import munit.Clue;
import munit.Clues;
import munit.Location;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class Lines
implements Serializable {
    private final Map<Path, String[]> filecache = (Map)Map$.MODULE$.empty();

    public String formatLine(Location location, String message) {
        return this.formatLine(location, message, new Clues((List<Clue<?>>)package$.MODULE$.Nil()));
    }

    public String formatLine(Location location, String message, Clues clues) {
        String string;
        try {
            Path path = Paths.get(location.path(), new String[0]);
            Object[] lines = (String[])this.filecache.getOrElseUpdate((Object)path, () -> Lines.$anonfun$1(path));
            Object object = Predef$.MODULE$.refArrayOps(lines);
            String[] slice = (String[])ArrayOps$.MODULE$.slice$extension(object, location.line() - 2, location.line() + 1);
            StringBuilder out = new StringBuilder();
            if (slice.length == 3) {
                int width = ((Object)BoxesRunTime.boxToInteger((int)(location.line() + 1))).toString().length();
                boolean isMultilineMessage = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(message), '\n');
                out.append(location.path()).append(':').append(((Object)BoxesRunTime.boxToInteger((int)location.line())).toString());
                if (message.length() > 0 && !isMultilineMessage) {
                    out.append(" ").append(message);
                }
                out.append('\n').append(Lines.format$1(width, location.line() - 1)).append(slice[0]).append('\n').append(AnsiColors$.MODULE$.Reversed()).append(Lines.format$1(width, location.line())).append(slice[1]).append(AnsiColors$.MODULE$.Reset()).append('\n').append(Lines.format$1(width, location.line() + 1)).append(slice[2]);
                if (isMultilineMessage) {
                    out.append('\n').append(message);
                }
                if (clues.values().nonEmpty()) {
                    out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2()));
                }
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                string = clues.values().isEmpty() ? message : message + "\n" + Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2());
            }
            throw throwable;
        }
        return string;
    }

    private static final String[] $anonfun$1(Path path$1) {
        return (String[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path$1)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private static final String format$1(int width$1, int n) {
        String number = ((Object)BoxesRunTime.boxToInteger((int)n)).toString() + ":";
        String padding = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), width$1 - number.length() + 1);
        return number + padding;
    }
}

