/*
 * Decompiled with CFR 0.152.
 */
package munit;

import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.GenericAfterEach;
import munit.GenericBeforeEach;
import munit.GenericTest;
import munit.Location$;
import munit.MUnitRunner$;
import munit.Suite;
import munit.Tag;
import munit.TestValues;
import munit.TestValues$;
import munit.internal.Compat$;
import munit.internal.FutureCompat$;
import munit.internal.PlatformCompat$;
import munit.internal.console.StackTraces$;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class MUnitRunner
extends Runner
implements Filterable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(MUnitRunner.class, "bitmap$0");
    public long bitmap$0;
    private final Class cls;
    private final Suite suite;
    private final Description suiteDescription;
    private final ExecutionContext ec;
    private volatile Filter filter;
    private final Map descriptions;
    private final Set testNames;
    public Seq munitTests$lzy1;
    public Description getDescription$lzy1;

    public MUnitRunner(Class<? extends Suite> cls, Function0<Suite> newInstance) {
        this.cls = cls;
        this.suite = (Suite)newInstance.apply();
        this.suiteDescription = Description.createSuiteDescription(cls);
        this.ec = this.suite().munitExecutionContext();
        this.filter = Filter.ALL;
        this.descriptions = (Map)Map$.MODULE$.empty();
        this.testNames = (Set)Set$.MODULE$.empty();
    }

    public Class<? extends Suite> cls() {
        return this.cls;
    }

    public MUnitRunner(Class<? extends Suite> cls) {
        this(MUnitRunner$.MODULE$.munit$MUnitRunner$$$ensureEligibleConstructor(cls), MUnitRunner.MUnitRunner$superArg$1(cls));
    }

    public Suite suite() {
        return this.suite;
    }

    public Map<GenericTest<Object>, Description> descriptions() {
        return this.descriptions;
    }

    public Set<String> testNames() {
        return this.testNames;
    }

    public Seq<GenericTest<Object>> munitTests() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    Seq<GenericTest<Object>> seq;
                    this.munitTests$lzy1 = seq = this.suite().munitTests();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return seq;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.munitTests$lzy1;
    }

    public void filter(Filter filter) {
        this.filter = filter;
    }

    public Description createTestDescription(GenericTest test) {
        return (Description)this.descriptions().getOrElseUpdate((Object)test, () -> this.createTestDescription$$anonfun$1(test));
    }

    public Description getDescription() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    Description description;
                    this.liftedTree1$1();
                    this.getDescription$lzy1 = description = this.suiteDescription;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return description;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.getDescription$lzy1;
    }

    public void run(RunNotifier notifier) {
        Await$.MODULE$.result(this.runAsync(notifier), (Duration)Duration$.MODULE$.Inf());
    }

    public Future<BoxedUnit> runAsync(RunNotifier notifier) {
        Future future;
        notifier.fireTestSuiteStarted(this.suiteDescription);
        try {
            try {
                future = this.runAll(notifier);
            }
            catch (Throwable ex) {
                this.fireHiddenTest(notifier, "expected error running tests", ex);
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        finally {
            notifier.fireTestSuiteFinished(this.suiteDescription);
        }
        return future;
    }

    private Future<BoxedUnit> runAsyncTestsSynchronously(RunNotifier notifier) {
        return this.loop$1(notifier, this.munitTests().iterator());
    }

    private Future<BoxedUnit> runAll(RunNotifier notifier) {
        boolean isContinue;
        boolean bl;
        if (PlatformCompat$.MODULE$.isIgnoreSuite(this.cls())) {
            notifier.fireTestIgnored(this.suiteDescription);
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        BooleanRef isBeforeAllRun = BooleanRef.create((boolean)false);
        isBeforeAllRun.elem = bl = (isContinue = this.runBeforeAll(notifier));
        Future result = isContinue ? this.runAsyncTestsSynchronously(notifier) : Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        return FutureCompat$.MODULE$.ExtensionFuture(result).transformCompat((JFunction1 & Serializable)s -> {
            if (isBeforeAllRun$1.elem) {
                this.runAfterAll(notifier);
            }
            return s;
        }, this.ec);
    }

    private boolean runBeforeAll(RunNotifier notifier) {
        BooleanRef isContinue = BooleanRef.create((boolean)this.runHiddenTest(notifier, "beforeAll", (Function0)((JFunction0.mcV.sp & Serializable)this::$anonfun$1)));
        this.suite().munitFixtures().foreach((Function1)(JProcedure1 & Serializable)fixture -> {
            boolean bl;
            isContinue$1.elem = bl = isContinue$1.elem & this.runHiddenTest(notifier, "beforeAllFixture(" + fixture.fixtureName() + ")", (Function0)((JFunction0.mcV.sp & Serializable)() -> MUnitRunner.runBeforeAll$$anonfun$2$$anonfun$1(fixture)));
        });
        return isContinue.elem;
    }

    private void runAfterAll(RunNotifier notifier) {
        this.suite().munitFixtures().foreach((Function1)(JFunction1 & Serializable)fixture -> this.runHiddenTest(notifier, "afterAllFixture(" + fixture.fixtureName() + ")", (Function0)((JFunction0.mcV.sp & Serializable)() -> MUnitRunner.runAfterAll$$anonfun$3$$anonfun$1(fixture))));
        this.runHiddenTest(notifier, "afterAll", (Function0)((JFunction0.mcV.sp & Serializable)this::runAfterAll$$anonfun$2));
    }

    private BeforeEachResult runBeforeEach(GenericTest test) {
        GenericBeforeEach beforeEach = new GenericBeforeEach(test);
        ListBuffer fixtures = ListBuffer$.MODULE$.empty();
        Try<BoxedUnit> error = this.foreachUnsafe((Iterable<Function0<BoxedUnit>>)((Iterable)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> this.suite().beforeEach(beforeEach)}))).$plus$plus((IterableOnce)this.suite().munitFixtures().map((Function1)(JFunction1 & Serializable)fixture -> (JFunction0.mcV.sp & Serializable)() -> {
            fixture.beforeEach(beforeEach);
            fixtures.$plus$eq(fixture);
        }))));
        return new BeforeEachResult(this, (Option<Throwable>)error.failed().toOption(), fixtures.toList());
    }

    private void runAfterEach(GenericTest<Object> test, List<Suite.Fixture<?>> fixtures) {
        GenericAfterEach<Object> afterEach = new GenericAfterEach<Object>(test);
        Try<BoxedUnit> error = this.foreachUnsafe((Iterable<Function0<BoxedUnit>>)((Iterable)fixtures.map((Function1)(JFunction1 & Serializable)fixture -> (JFunction0.mcV.sp & Serializable)() -> fixture.afterEach(afterEach)).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> this.suite().afterEach(afterEach)})))));
        BoxedUnit cfr_ignored_0 = (BoxedUnit)error.get();
    }

    private Future<Object> runTest(RunNotifier notifier, GenericTest<Object> test) {
        Future future;
        Description description = this.createTestDescription(test);
        if (!this.filter.shouldRun(description)) {
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        notifier.fireTestStarted(description);
        Serializable onError = new Serializable(notifier, description){
            private final RunNotifier notifier$1;
            private final Description description$1;
            {
                this.notifier$1 = notifier$9;
                this.description$1 = description$3;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                boolean bl;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    bl = true;
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Object object;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    StackTraces$.MODULE$.trimStackTrace((Throwable)ex);
                    object = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    StackTraces$.MODULE$.trimStackTrace(ex);
                    Failure failure = new Failure(this.description$1, ex);
                    Throwable throwable3 = ex;
                    if (throwable3 instanceof AssumptionViolatedException) {
                        this.notifier$1.fireTestAssumptionFailed(failure);
                    } else {
                        this.notifier$1.fireTestFailure(failure);
                    }
                    object = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        };
        try {
            future = this.runTestBody(notifier, description, test).recoverWith((PartialFunction)onError, this.ec);
        }
        catch (Throwable ex$) {
            future = (Future)onError.apply(ex$);
        }
        Future result = future;
        return result.map((Function1)(JFunction1 & Serializable)_$2 -> {
            notifier.fireTestFinished(description);
            return true;
        }, this.ec);
    }

    private Future<BoxedUnit> runTestBody(RunNotifier notifier, Description description, GenericTest<Object> test) {
        Future future;
        Object result = StackTraces$.MODULE$.dropOutside(() -> this.$anonfun$6(test));
        Object t = result;
        if (t instanceof TestValues.FlakyFailure) {
            TestValues.FlakyFailure f = (TestValues.FlakyFailure)t;
            StackTraces$.MODULE$.trimStackTrace(f);
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)f));
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            Tag tag = TestValues$.MODULE$.Ignore();
            Object t2 = t;
            if (!(tag != null ? !((Object)tag).equals(t2) : t2 != null)) {
                notifier.fireTestIgnored(description);
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else if (t instanceof Future) {
                Future f = (Future)t;
                future = f.map((Function1)(JProcedure1 & Serializable)_$3 -> {}, this.ec);
            } else {
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        return future;
    }

    private Try<BoxedUnit> foreachUnsafe(Iterable<Function0<BoxedUnit>> thunks) {
        Success success;
        ObjectRef errors = ObjectRef.create((Object)ListBuffer$.MODULE$.empty());
        thunks.foreach((Function1)(JFunction1 & Serializable)thunk -> MUnitRunner.liftedTree2$1(errors, thunk));
        List list = ((ListBuffer)errors.elem).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            Throwable head = (Throwable)colon2.head();
            List tail = list2;
            tail.foreach((Function1)(JProcedure1 & Serializable)e -> {
                if (e != head) {
                    head.addSuppressed((Throwable)e);
                }
            });
            success = Failure$.MODULE$.apply(head);
        } else {
            success = Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }
        return success;
    }

    private boolean runHiddenTest(RunNotifier notifier, String name, Function0 thunk) {
        boolean bl;
        try {
            StackTraces$.MODULE$.dropOutside(thunk);
            bl = true;
        }
        catch (Throwable ex) {
            this.fireHiddenTest(notifier, name, ex);
            bl = false;
        }
        return bl;
    }

    private void fireHiddenTest(RunNotifier notifier, String name, Throwable ex) {
        GenericTest test = new GenericTest(name, (Function0 & Serializable)() -> {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }, (scala.collection.immutable.Set<Tag>)Predef$.MODULE$.Set().empty(), Location$.MODULE$.empty());
        Description description = this.createTestDescription(test);
        notifier.fireTestStarted(description);
        StackTraces$.MODULE$.trimStackTrace(ex);
        notifier.fireTestFailure(new Failure(description, ex));
        notifier.fireTestFinished(description);
    }

    private static Function0<Suite> MUnitRunner$superArg$1(Class<? extends Suite> cls) {
        return (Function0 & Serializable)() -> (Suite)cls.newInstance();
    }

    private static final /* synthetic */ String $anonfun$8(String escapedName$1, int x$1) {
        String string;
        int n = x$1;
        if (0 == n) {
            string = escapedName$1;
        } else {
            int n2 = n;
            string = "" + escapedName$1 + "-" + n2;
        }
        return string;
    }

    private static final String $anonfun$adapted$1(String escapedName$2, Object x$1) {
        return MUnitRunner.$anonfun$8(escapedName$2, BoxesRunTime.unboxToInt((Object)x$1));
    }

    private final Description createTestDescription$$anonfun$1(GenericTest test$1) {
        String escapedName = StringOps$.MODULE$.replaceAllLiterally$extension(Predef$.MODULE$.augmentString(test$1.name()), "\n", "\\n");
        String testName = (String)Option$.MODULE$.option2Iterable(Compat$.MODULE$.LazyList().from(0).map((Function1)((JFunction1 & Serializable)arg_0 -> MUnitRunner.$anonfun$adapted$1(escapedName, arg_0))).find((Function1)(JFunction1 & Serializable)candidate -> !this.testNames().contains(candidate))).head();
        this.testNames().$plus$eq((Object)testName);
        return Description.createTestDescription(this.cls(), (String)testName, (Annotation[])test$1.annotations());
    }

    private final Seq $anonfun$10() {
        return this.munitTests();
    }

    private final Serializable liftedTree1$1() {
        Nil$ nil$;
        try {
            Seq suiteTests = (Seq)StackTraces$.MODULE$.dropOutside(this::$anonfun$10);
            suiteTests.foreach((Function1)(JProcedure1 & Serializable)test -> {
                Description testDescription = this.createTestDescription((GenericTest)test);
                if (this.filter.shouldRun(testDescription)) {
                    this.suiteDescription.addChild(testDescription);
                }
            });
            nil$ = BoxedUnit.UNIT;
        }
        catch (Throwable ex) {
            StackTraces$.MODULE$.trimStackTrace(ex);
            ex.printStackTrace();
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    private final /* synthetic */ Future loop$2$$anonfun$1(RunNotifier notifier$2, Iterator it$1, boolean _$1) {
        return this.loop$1(notifier$2, it$1);
    }

    private final Future loop$3$$anonfun$adapted$1(RunNotifier notifier$8, Iterator it$2, Object _$1) {
        return this.loop$2$$anonfun$1(notifier$8, it$2, BoxesRunTime.unboxToBoolean((Object)_$1));
    }

    private final Future loop$1(RunNotifier notifier$1, Iterator it) {
        return !it.hasNext() ? Future$.MODULE$.successful((Object)BoxedUnit.UNIT) : this.runTest(notifier$1, (GenericTest)it.next()).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.loop$3$$anonfun$adapted$1(notifier$1, it, arg_0)), this.ec);
    }

    private final void $anonfun$1() {
        this.suite().beforeAll();
    }

    private static final void runBeforeAll$$anonfun$2$$anonfun$1(Suite.Fixture fixture$1) {
        fixture$1.beforeAll();
    }

    private static final void runAfterAll$$anonfun$3$$anonfun$1(Suite.Fixture fixture$2) {
        fixture$2.afterAll();
    }

    private final void runAfterAll$$anonfun$2() {
        this.suite().afterAll();
    }

    private final Object $anonfun$6(GenericTest test$2) {
        Object object;
        BeforeEachResult beforeEachResult = this.runBeforeEach(test$2);
        Option<Throwable> option = beforeEachResult.error();
        if (None$.MODULE$.equals(option)) {
            try {
                object = test$2.body().apply();
            }
            finally {
                this.runAfterEach(test$2, beforeEachResult.loadedFixtures());
            }
        } else {
            if (option instanceof Some) {
                Throwable error = (Throwable)((Some)option).value();
                try {
                    this.runAfterEach(test$2, beforeEachResult.loadedFixtures());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                finally {
                    throw error;
                }
            }
            throw new MatchError(option);
        }
        return object;
    }

    private static final Serializable liftedTree2$1(ObjectRef errors$1, Function0 thunk$1) {
        Serializable serializable;
        try {
            serializable = (Serializable)thunk$1.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                serializable = (ListBuffer)((ListBuffer)errors$1.elem).$plus$eq((Object)ex);
            }
            throw throwable;
        }
        return serializable;
    }

    public class BeforeEachResult {
        private final Option error;
        private final List loadedFixtures;
        private final MUnitRunner $outer;

        public BeforeEachResult(MUnitRunner $outer, Option<Throwable> error, List<Suite.Fixture<?>> loadedFixtures) {
            this.error = error;
            this.loadedFixtures = loadedFixtures;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Option<Throwable> error() {
            return this.error;
        }

        public List<Suite.Fixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        private MUnitRunner $outer() {
            return this.$outer;
        }

        public final MUnitRunner munit$MUnitRunner$BeforeEachResult$$$outer() {
            return this.$outer();
        }
    }
}

