/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.Location;
import munit.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.Statics;

public class GenericTest<T>
implements Serializable {
    private final String name;
    private final Function0 body;
    private final Set tags;
    private final Location location;

    public <T> GenericTest(String name, Function0<T> body, Set<Tag> tags, Location location) {
        this.name = name;
        this.body = body;
        this.tags = tags;
        this.location = location;
    }

    public String name() {
        return this.name;
    }

    public Function0<T> body() {
        return this.body;
    }

    public Set<Tag> tags() {
        return this.tags;
    }

    public Location location() {
        return this.location;
    }

    public <T> GenericTest(String name, Function0<T> body, Location loc) {
        this(name, body, (Set<Tag>)Predef$.MODULE$.Set().empty(), loc);
    }

    public GenericTest<T> withName(String newName) {
        return this.copy(newName, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public <A> GenericTest<A> withBody(Function0<A> newBody) {
        return this.copy(this.copy$default$1(), newBody, this.copy$default$3(), this.copy$default$4());
    }

    public GenericTest<T> withTags(Set<Tag> newTags) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), newTags, this.copy$default$4());
    }

    public GenericTest<T> tag(Tag newTag) {
        return this.withTags((Set<Tag>)((Set)this.tags().$plus((Object)newTag)));
    }

    public GenericTest<T> withLocation(Location newLocation) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newLocation);
    }

    public <A> GenericTest<A> withBodyMap(Function1<T, A> newBody) {
        return this.withBody((Function0 & Serializable)() -> newBody.apply(this.body().apply()));
    }

    private <A> GenericTest<A> copy(String name, Function0<A> body, Set<Tag> tags, Location location) {
        return new GenericTest<A>(name, body, tags, location);
    }

    private <A> String copy$default$1() {
        return this.name();
    }

    private <A> Function0<T> copy$default$2() {
        return this.body();
    }

    private <A> Set<Tag> copy$default$3() {
        return this.tags();
    }

    private <A> Location copy$default$4() {
        return this.location();
    }

    public String toString() {
        return "GenericTest(" + this.name() + ", " + this.tags() + ", " + this.location() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        Object object = obj;
        if (!(object instanceof GenericTest)) return false;
        GenericTest t = (GenericTest)object;
        String string = t.name();
        String string2 = this.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Set<Tag> set = t.tags();
        Set<Tag> set2 = this.tags();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        Location location = t.location();
        Location location2 = this.location();
        if (location == null) {
            if (location2 == null) return true;
            return false;
        } else {
            if (!((Object)location).equals(location2)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int acc = -889275714;
        acc = Statics.mix((int)acc, (int)Statics.anyHash((Object)this.name()));
        acc = Statics.mix((int)acc, (int)Statics.anyHash(this.tags()));
        acc = Statics.mix((int)acc, (int)Statics.anyHash((Object)this.location()));
        return (int)var1_1;
    }

    public Annotation[] annotations() {
        ArrayBuffer buf = new ArrayBuffer(this.tags().size() + 1);
        buf.$plus$plus$eq(this.tags());
        buf.$plus$eq((Object)this.location());
        return (Annotation[])buf.toArray(ClassTag$.MODULE$.apply(Annotation.class));
    }
}

