/*
 * Decompiled with CFR 0.152.
 */
package munit;

import difflib.DiffUtils;
import difflib.Patch;
import java.util.List;
import munit.AnsiColors$;
import munit.Assertions$;
import munit.Location;
import munit.Printers$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Diffs$ {
    public static Diffs$ MODULE$;

    static {
        new Diffs$();
    }

    public boolean assertNoDiff(String obtained, String expected, String title, boolean printObtainedAsStripMargin, Location loc) {
        if (obtained.isEmpty() && !expected.isEmpty()) {
            throw Assertions$.MODULE$.fail("Obtained empty output!", loc);
        }
        String result = this.unifiedDiff(obtained, expected);
        if (!result.isEmpty()) {
            throw Assertions$.MODULE$.fail(this.createDiff(obtained, expected, title, printObtainedAsStripMargin), loc);
        }
        return true;
    }

    public String assertNoDiff$default$3() {
        return "";
    }

    public boolean assertNoDiff$default$4() {
        return true;
    }

    public String createDiffOnly(String obtained, String expected) {
        StringBuilder out = new StringBuilder();
        this.createDiffOnly(obtained, expected, out);
        return out.toString();
    }

    private void createDiffOnly(String obtained, String expected, StringBuilder sb) {
        this.header("Diff", sb);
        sb.append(new java.lang.StringBuilder(25).append(" (").append(AnsiColors$.MODULE$.LightRed()).append("- obtained").append(AnsiColors$.MODULE$.Reset()).append(", ").append(AnsiColors$.MODULE$.LightGreen()).append("+ expected").append(AnsiColors$.MODULE$.Reset()).append(")").toString()).append("\n");
        sb.append(this.stripTrailingWhitespace(this.unifiedDiff(obtained, expected)));
    }

    public String createDiff(String obtained, String expected, String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty() ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (obtained.length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(obtained)) : sb.append(obtained);
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.createDiffOnly(obtained, expected, sb);
        return sb.toString();
    }

    public boolean createDiff$default$4() {
        return true;
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.apply(new java.lang.StringBuilder(3).append("=> ").append(t).toString(), AnsiColors$.MODULE$.Bold()));
    }

    private String asStripMargin(String obtained) {
        String string;
        if (!obtained.contains("\n")) {
            string = Printers$.MODULE$.print(obtained, Printers$.MODULE$.print$default$2());
        } else {
            StringBuilder out = new StringBuilder();
            Iterator lines = new StringOps(Predef$.MODULE$.augmentString(obtained.trim())).linesIterator();
            out.append(new java.lang.StringBuilder(9).append("    \"\"\"|").append(lines.next()).append("\n").toString());
            lines.foreach((Function1 & java.io.Serializable & Serializable)line -> out.append("       |").append(line).append("\n"));
            out.append("       |\"\"\".stripMargin");
            string = out.toString();
        }
        return string;
    }

    public String stripTrailingWhitespace(String str) {
        return str.replaceAll(" \n", "\u2219\n");
    }

    public Seq<String> splitIntoLines(String string) {
        return Predef$.MODULE$.wrapRefArray((Object[])string.trim().replace("\r\n", "\n").split("\n"));
    }

    public String unifiedDiff(String original, String revised) {
        return this.unifiedDiff(this.splitIntoLines(original), this.splitIntoLines(revised));
    }

    public String unifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch diff = DiffUtils.diff((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava()), (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava()));
        return diff.getDeltas().isEmpty() ? "" : ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils.generateUnifiedDiff((String)"obtained", (String)"expected", (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava()), (Patch)diff, (int)1)).asScala()).iterator().drop(2).filterNot((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("@@"))).map((Function1 & java.io.Serializable & Serializable)line -> line.startsWith("-") ? AnsiColors$.MODULE$.apply((String)line, AnsiColors$.MODULE$.LightRed()) : (line.startsWith("+") ? AnsiColors$.MODULE$.apply((String)line, AnsiColors$.MODULE$.LightGreen()) : line)).mkString("\n");
    }

    private Diffs$() {
        MODULE$ = this;
    }
}

